/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.dialect;

import net.sf.hibernate.dialect.Dialect;

public class PostgreSQLDialect
extends Dialect {
    public PostgreSQLDialect() {
        this.register(-7, "BOOL");
        this.register(-5, "INT8");
        this.register(5, "INT2");
        this.register(-6, "INT2");
        this.register(4, "INT4");
        this.register(1, "CHAR(1)");
        this.register(12, "VARCHAR($l)");
        this.register(6, "FLOAT4");
        this.register(8, "FLOAT8");
        this.register(91, "DATE");
        this.register(92, "TIME");
        this.register(93, "TIMESTAMP");
        this.register(-3, "BYTEA");
        this.register(2005, "TEXT");
        this.register(2004, "BYTEA");
        this.register(2, "NUMERIC");
        this.getDefaultProperties().setProperty("hibernate.use_outer_join", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
    }

    public String getAddColumnString() {
        return "add column";
    }

    public boolean dropConstraints() {
        return false;
    }

    public String getSequenceNextValString(String sequenceName) {
        return "select nextval ('" + sequenceName + "')";
    }

    public String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName;
    }

    public String getCascadeConstraintsString() {
        return "";
    }

    public boolean supportsSequences() {
        return true;
    }

    public boolean supportsLimit() {
        return true;
    }

    public String getLimitString(String sql) {
        StringBuffer pagingSelect = new StringBuffer(100);
        pagingSelect.append(sql);
        pagingSelect.append(" limit ? offset ?");
        return pagingSelect.toString();
    }

    public boolean reverseLimitParameterOrder() {
        return true;
    }

    public boolean preferLimit() {
        return true;
    }

    public boolean supportsForUpdateOf() {
        return true;
    }
}

