/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_nl extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Greenwich Mean Time",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "Acre-standaardtijd",
               "",
               "Acre-zomertijd",
               "",
               "Acre-tijd",
               "",
            };
        final String[] Apia = new String[] {
               "Apia-standaardtijd",
               "",
               "Apia-zomertijd",
               "",
               "Apia-tijd",
               "",
            };
        final String[] Cook = new String[] {
               "Cookeilandse standaardtijd",
               "",
               "Cookeilandse halve zomertijd",
               "",
               "Cookeilandse tijd",
               "",
            };
        final String[] Cuba = new String[] {
               "Cubaanse standaardtijd",
               "CST",
               "Cubaanse zomertijd",
               "CDT",
               "Cubaanse tijd",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Fijische standaardtijd",
               "",
               "Fijische zomertijd",
               "",
               "Fijische tijd",
               "",
            };
        final String[] Gulf = new String[] {
               "Golf-standaardtijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovd-standaardtijd",
               "",
               "Hovd-zomertijd",
               "",
               "Hovd-tijd",
               "",
            };
        final String[] Iran = new String[] {
               "Iraanse standaardtijd",
               "",
               "Iraanse zomertijd",
               "",
               "Iraanse tijd",
               "",
            };
        final String[] Niue = new String[] {
               "Niuese tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omsk-standaardtijd",
               "",
               "Omsk-zomertijd",
               "",
               "Omsk-tijd",
               "",
            };
        final String[] Peru = new String[] {
               "Peruaanse standaardtijd",
               "",
               "Peruaanse zomertijd",
               "",
               "Peruaanse tijd",
               "",
            };
        final String[] Truk = new String[] {
               "Chuukse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Wake-eilandse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Chileense standaardtijd",
               "",
               "Chileense zomertijd",
               "",
               "Chileense tijd",
               "",
            };
        final String[] China = new String[] {
               "Chinese standaardtijd",
               "CST",
               "Chinese zomertijd",
               "CDT",
               "Chinese tijd",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Cocoseilandse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Davis-tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Indiase tijd",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Japanse standaardtijd",
               "JST",
               "Japanse zomertijd",
               "JDT",
               "Japanse tijd",
               "JT",
            };
        final String[] Korea = new String[] {
               "Koreaanse standaardtijd",
               "KST",
               "Koreaanse zomertijd",
               "KST",
               "Koreaanse tijd",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Nauruaanse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepalese tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Belause tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoaanse standaardtijd",
               "SST",
               "Samoaanse zomertijd",
               "SST",
               "Samoaanse tijd",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Syowa-tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tongaanse standaardtijd",
               "",
               "Tongaanse zomertijd",
               "",
               "Tongaanse tijd",
               "",
            };
        final String[] Yukon = new String[] {
               "Yukon-tijd",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Alaska-standaardtijd",
               "AKST",
               "Alaska-zomertijd",
               "AKDT",
               "Alaska-tijd",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Amazone-standaardtijd",
               "",
               "Amazone-zomertijd",
               "",
               "Amazone-tijd",
               "",
            };
        final String[] Azores = new String[] {
               "Azoren-standaardtijd",
               "",
               "Azoren-zomertijd",
               "",
               "Azoren-tijd",
               "",
            };
        final String[] Bhutan = new String[] {
               "Bhutaanse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Bruneise tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Paaseilandse standaardtijd",
               "",
               "Paaseilandse zomertijd",
               "",
               "Paaseilandse tijd",
               "",
            };
        final String[] Guyana = new String[] {
               "Guyaanse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "Hawaii-Aleoetische standaardtijd",
               "HAST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "Israëlische standaardtijd",
               "IST",
               "Israëlische zomertijd",
               "IDT",
               "Israëlische tijd",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Kosraese tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Mawson-tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moskou-standaardtijd",
               "MSK",
               "Moskou-zomertijd",
               "MSK",
               "Moskou-tijd",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Pohnpei-tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Samara-standaardtijd",
               "",
               "Samara-zomertijd",
               "",
               "Samara-tijd",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahitiaanse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Taipei-standaardtijd",
               "CST",
               "Taipei-zomertijd",
               "CDT",
               "Taipei-tijd",
               "CT",
            };
        final String[] Turkey = new String[] {
               "Turkse standaardtijd",
               "",
               "Turkse zomertijd",
               "",
               "Turkse tijd",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Tuvaluaanse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Vostok-tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wallis en Futunase tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arabische standaardtijd",
               "",
               "Arabische zomertijd",
               "",
               "Arabische tijd",
               "",
            };
        final String[] Armenia = new String[] {
               "Armeense standaardtijd",
               "",
               "Armeense zomertijd",
               "",
               "Armeense tijd",
               "",
            };
        final String[] Bolivia = new String[] {
               "Boliviaanse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Chatham-standaardtijd",
               "",
               "Chatham-zomertijd",
               "",
               "Chatham-tijd",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "gecoördineerde wereldtijd",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ecuadoraanse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambiereilandse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Georgische standaardtijd",
               "",
               "Georgische zomertijd",
               "",
               "Georgische tijd",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkoetsk-standaardtijd",
               "",
               "Irkoetsk-zomertijd",
               "",
               "Irkoetsk-tijd",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadan-standaardtijd",
               "",
               "Magadan-zomertijd",
               "",
               "Magadan-tijd",
               "",
            };
        final String[] Myanmar = new String[] {
               "Myanmarese tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolkeilandse standaardtijd",
               "",
               "Norfolkeilandse zomertijd",
               "",
               "Norfolkeilandse tijd",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha-standaardtijd",
               "",
               "Fernando de Noronha-zomertijd",
               "",
               "Fernando de Noronha-tijd",
               "",
            };
        final String[] Reunion = new String[] {
               "Réunionse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rothera-tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Salomonseilandse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelau-eilandse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Uruguayaanse standaardtijd",
               "",
               "Uruguayaanse zomertijd",
               "",
               "Uruguayaanse tijd",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatuaanse standaardtijd",
               "",
               "Vanuatuaanse zomertijd",
               "",
               "Vanuatuaanse tijd",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Jakoetsk-standaardtijd",
               "",
               "Jakoetsk-zomertijd",
               "",
               "Jakoetsk-tijd",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlantic-standaardtijd",
               "AST",
               "Atlantic-zomertijd",
               "ADT",
               "Atlantic-tijd",
               "AT",
            };
        final String[] Brasilia = new String[] {
               "Braziliaanse standaardtijd",
               "",
               "Braziliaanse zomertijd",
               "",
               "Braziliaanse tijd",
               "",
            };
        final String[] Chamorro = new String[] {
               "Chamorro-tijd",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Colombiaanse standaardtijd",
               "",
               "Colombiaanse zomertijd",
               "",
               "Colombiaanse tijd",
               "",
            };
        final String[] Falkland = new String[] {
               "Falklandeilandse standaardtijd",
               "",
               "Falklandeilandse zomertijd",
               "",
               "Falklandeilandse tijd",
               "",
            };
        final String[] Malaysia = new String[] {
               "Maleisische tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Maldivische tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulaanbaatar-standaardtijd",
               "",
               "Ulaanbaatar-zomertijd",
               "",
               "Ulaanbaatar-tijd",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistaanse standaardtijd",
               "PKT",
               "Pakistaanse zomertijd",
               "PKST",
               "Pakistaanse tijd",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguayaanse standaardtijd",
               "",
               "Paraguayaanse zomertijd",
               "",
               "Paraguayaanse tijd",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairneilandse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "Surinaamse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentijnse standaardtijd",
               "",
               "Argentijnse zomertijd",
               "",
               "Argentijnse tijd",
               "",
            };
        final String[] Christmas = new String[] {
               "Christmaseilandse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagoseilandse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland = new String[] {
               "Groenlandse standaardtijd",
               "",
               "Groenlandse zomertijd",
               "",
               "Groenlandse tijd",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hongkongse standaardtijd",
               "HKT",
               "Hongkongse zomertijd",
               "HKST",
               "Hongkongse tijd",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Indochinese tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovsk-Kamtsjatski-standaardtijd",
               "",
               "Petropavlovsk-Kamtsjatski-zomertijd",
               "",
               "Petropavlovsk-Kamtsjatski-tijd",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgizische tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe-eilandse standaardtijd",
               "",
               "Lord Howe-eilandse zomertijd",
               "",
               "Lord Howe-eilandse tijd",
               "",
            };
        final String[] Marquesas = new String[] {
               "Marquesaseilandse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mauritiaanse standaardtijd",
               "",
               "Mauritiaanse zomertijd",
               "",
               "Mauritiaanse tijd",
               "",
            };
        final String[] Singapore = new String[] {
               "Singaporese standaardtijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venezolaanse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbeidzjaanse standaardtijd",
               "",
               "Azerbeidzjaanse zomertijd",
               "",
               "Azerbeidzjaanse tijd",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bengalese standaardtijd",
               "",
               "Bengalese zomertijd",
               "",
               "Bengalese tijd",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Kaapverdische standaardtijd",
               "",
               "Kaapverdische zomertijd",
               "",
               "Kaapverdische tijd",
               "",
            };
        final String[] East_Timor = new String[] {
               "Oost-Timorese tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Kazachse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seychelse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tadzjiekse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Oezbeekse standaardtijd",
               "",
               "Oezbeekse zomertijd",
               "",
               "Oezbeekse tijd",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afghaanse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarsk-standaardtijd",
               "",
               "Krasnojarsk-zomertijd",
               "",
               "Krasnojarsk-tijd",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Nieuw-Zeelandse standaardtijd",
               "NZST",
               "Nieuw-Zeelandse zomertijd",
               "NZDT",
               "Nieuw-Zeelandse tijd",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "Filipijnse standaardtijd",
               "PST",
               "Filipijnse zomertijd",
               "PDT",
               "Filipijnse tijd",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostok-standaardtijd",
               "",
               "Vladivostok-zomertijd",
               "",
               "Vladivostok-tijd",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Indische Oceaan-tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Line-eilandse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundland-standaardtijd",
               "NST",
               "Newfoundland-zomertijd",
               "NDT",
               "Newfoundland-tijd",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmeense standaardtijd",
               "",
               "Turkmeense zomertijd",
               "",
               "Turkmeense tijd",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Frans-Guyaanse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Nieuw-Caledonische standaardtijd",
               "",
               "Nieuw-Caledonische zomertijd",
               "",
               "Nieuw-Caledonische tijd",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Zuid-Georgische tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinenburg-standaardtijd",
               "",
               "Jekaterinenburg-zomertijd",
               "",
               "Jekaterinenburg-tijd",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Centraal-Afrikaanse tijd",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Oost-Afrikaanse tijd",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "West-Afrikaanse tijd",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d’Urville-tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Midden-Europese standaardtijd",
               "CET",
               "Midden-Europese zomertijd",
               "CEST",
               "Midden-Europese tijd",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Oost-Europese standaardtijd",
               "EET",
               "Oost-Europese zomertijd",
               "EEST",
               "Oost-Europese tijd",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "West-Europese standaardtijd",
               "WET",
               "West-Europese zomertijd",
               "WEST",
               "West-Europese tijd",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Mexicaanse Pacific-standaardtijd",
               "MST",
               "Mexicaanse Pacific-zomertijd",
               "MDT",
               "Mexicaanse Pacific-tijd",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Zuid-Afrikaanse tijd",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Central-standaardtijd",
               "CST",
               "Central-zomertijd",
               "CDT",
               "Central-tijd",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Eastern-standaardtijd",
               "EST",
               "Eastern-zomertijd",
               "EDT",
               "Eastern-tijd",
               "ET",
            };
        final String[] America_Pacific = new String[] {
               "Pacific-standaardtijd",
               "PST",
               "Pacific-zomertijd",
               "PDT",
               "Pacific-tijd",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Franse zuidelijke en Antarctische tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilberteilandse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-Aleoetische standaardtijd",
               "HAST",
               "Hawaii-Aleoetische zomertijd",
               "HADT",
               "Hawaii-Aleoetische tijd",
               "HAT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoenixeilandse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Saint Pierre en Miquelon-standaardtijd",
               "",
               "Saint Pierre en Miquelon-zomertijd",
               "",
               "Saint Pierre en Miquelon-tijd",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Mountain-standaardtijd",
               "MST",
               "Mountain-zomertijd",
               "MDT",
               "Mountain-tijd",
               "MT",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshalleilandse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papoea-Nieuw-Guineese tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Midden-Australische standaardtijd",
               "ACST",
               "Midden-Australische zomertijd",
               "ACDT",
               "Midden-Australische tijd",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Oost-Australische standaardtijd",
               "AEST",
               "Oost-Australische zomertijd",
               "AEDT",
               "Oost-Australische tijd",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "West-Australische standaardtijd",
               "AWST",
               "West-Australische zomertijd",
               "AWDT",
               "West-Australische tijd",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Centraal-Indonesische tijd",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Oost-Indonesische tijd",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "West-Indonesische tijd",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Midden-Australische westelijke standaardtijd",
               "",
               "Midden-Australische westelijke zomertijd",
               "",
               "Midden-Australische westelijke tijd",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Britse zomertijd",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "gecoördineerde wereldtijd",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Ierse standaardtijd",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "gecoördineerde wereldtijd",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "Turkey", Turkey },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "gecoördineerde wereldtijd",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Britse zomertijd",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "gecoördineerde wereldtijd",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "gecoördineerde wereldtijd",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Kamchatka },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "America/Nuuk", Greenland },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Istanbul", Turkey },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "gecoördineerde wereldtijd",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Ierse standaardtijd",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Britse zomertijd",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Britse zomertijd",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Britse zomertijd",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Saratov", Samara },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Godthab", Greenland },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Britse zomertijd",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Istanbul", Turkey },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Astrakhan", Samara },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Ulyanovsk", Samara },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Britse zomertijd",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Scoresbysund", Greenland },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Baku", "Bakoe" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Macau", "Macau" },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Almaty", "Alma-Ata" },
            { "timezone.excity.Asia/Aqtobe", "Aqtöbe" },
            { "timezone.excity.Asia/Atyrau", "Atıraw" },
            { "timezone.excity.Asia/Beirut", "Beiroet" },
            { "timezone.excity.Asia/Kuwait", "Koeweit" },
            { "timezone.excity.Asia/Manila", "Manilla" },
            { "timezone.excity.Asia/Riyadh", "Riyad" },
            { "timezone.excity.Asia/Saigon", "Ho Chi Minhstad" },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Etc/Unknown", "onbekende stad" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Cairo", "Caïro" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bahrain", "Bahrein" },
            { "timezone.excity.Asia/Bishkek", "Bisjkek" },
            { "timezone.excity.Asia/Irkutsk", "Irkoetsk" },
            { "timezone.excity.Asia/Rangoon", "Rangoon" },
            { "timezone.excity.Asia/Yakutsk", "Jakoetsk" },
            { "timezone.excity.Asia/Yerevan", "Jerevan" },
            { "timezone.excity.Europe/Paris", "Parijs" },
            { "timezone.excity.Indian/Cocos", "Cocoseilanden" },
            { "timezone.excity.Asia/Ashgabat", "Asjchabad" },
            { "timezone.excity.Asia/Calcutta", "Calcutta" },
            { "timezone.excity.Asia/Dushanbe", "Doesjanbe" },
            { "timezone.excity.Asia/Sakhalin", "Sachalin" },
            { "timezone.excity.Asia/Shanghai", "Sjanghai" },
            { "timezone.excity.Asia/Tashkent", "Tasjkent" },
            { "timezone.excity.Europe/Athens", "Athene" },
            { "timezone.excity.Europe/Berlin", "Berlijn" },
            { "timezone.excity.Europe/Lisbon", "Lissabon" },
            { "timezone.excity.Europe/London", "Londen" },
            { "timezone.excity.Europe/Moscow", "Moskou" },
            { "timezone.excity.Europe/Prague", "Praag" },
            { "timezone.excity.Europe/Vienna", "Wenen" },
            { "timezone.excity.Europe/Warsaw", "Warschau" },
            { "timezone.excity.Europe/Zurich", "Zürich" },
            { "timezone.excity.Indian/Chagos", "Chagosarchipel" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.America/Cancun", "Cancun" },
            { "timezone.excity.Asia/Hong_Kong", "Hongkong" },
            { "timezone.excity.Asia/Jerusalem", "Jeruzalem" },
            { "timezone.excity.Asia/Kamchatka", "Kamtsjatka" },
            { "timezone.excity.Europe/Vatican", "Vaticaanstad" },
            { "timezone.excity.Pacific/Easter", "Paaseiland" },
            { "timezone.excity.Africa/Khartoum", "Khartoem" },
            { "timezone.excity.Africa/Sao_Tome", "Sao Tomé" },
            { "timezone.excity.Atlantic/Azores", "Azoren" },
            { "timezone.excity.Atlantic/Canary", "Canarische Eilanden" },
            { "timezone.excity.Atlantic/Faeroe", "Faeröer" },
            { "timezone.excity.Europe/Belgrade", "Belgrado" },
            { "timezone.excity.Europe/Brussels", "Brussel" },
            { "timezone.excity.Europe/Budapest", "Boedapest" },
            { "timezone.excity.Europe/Istanbul", "Istanboel" },
            { "timezone.excity.Indian/Maldives", "Maldiven" },
            { "timezone.excity.Pacific/Gambier", "Îles Gambier" },
            { "timezone.excity.America/St_Johns", "Saint John’s" },
            { "timezone.excity.America/St_Kitts", "Saint Kitts" },
            { "timezone.excity.America/St_Lucia", "Saint Lucia" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "timezone.excity.Europe/Bucharest", "Boekarest" },
            { "timezone.excity.Europe/Volgograd", "Wolgograd" },
            { "timezone.excity.Indian/Christmas", "Christmaseiland" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.America/St_Thomas", "Saint Thomas" },
            { "timezone.excity.Europe/Copenhagen", "Kopenhagen" },
            { "timezone.excity.Europe/Luxembourg", "Luxemburg" },
            { "timezone.excity.Pacific/Enderbury", "Kanton" },
            { "timezone.excity.Pacific/Marquesas", "Marquesaseilanden" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.America/St_Vincent", "Saint Vincent" },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinenburg" },
            { "timezone.excity.Atlantic/St_Helena", "Sint-Helena" },
            { "timezone.excity.America/Mexico_City", "Mexico-Stad" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kaapverdië" },
            { "timezone.excity.America/Lower_Princes", "Beneden Prinsen Kwartier" },
            { "timezone.excity.America/St_Barthelemy", "Saint-Barthélemy" },
            { "timezone.excity.Atlantic/South_Georgia", "Zuid-Georgia" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Noord-Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Noord-Dakota" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Noord-Dakota" },
        };
        return data;
    }
}
