\page ExampleNeutronSource Example NeutronSource


   NeutronSource is an example of neutrons production. It illustrates the cooperative work
   of nuclear reactions and radioactive decay processes.
   It survey energy deposition and particle's flux.
   It uses PhysicsConstructor objects.

## MATERIALS AND GEOMETRY DEFINITION
 
   The geometry is a cylinder (absorber) of an homogenous material (default : Beryllium oxide).
   This absorber is within a container (default : stainless-steel).

   Five parameters define the geometry :
	- the material of the absorber
	- the radius and length of the absorber
	- the material of the container
	- the thickness of the container
	
   The default geometry is built in DetectorConstruction, but the above
   parameters can be changed interactively via commands defined in DetectorMessenger.
   
   The container is surrounded by a World volume (air)
   
   A function, and its associated UI command, allows to build a material
   directly from a single isotope.
   
   To be identified by the ThermalScattering module, the elements composing a
   material must have a specific name (see G4ParticleHPThermalScatteringNames.cc)
   Examples of such materials are build in DetectorConstruction of Hadr04,06,07.
 	
## PHYSICS LIST
   
  "Full" set of physics processes are registered, but via PhysicsConstructor
  objects rather than complete pre-defined G4 physics lists. This alternative 
  way may give more freedom to register physics.
  
  Physics constructors are either constructors provided in Geant4 (with G4 prefix)
  or 'local'. They include : HadronElastic, HadronInelastic, IonsInelastic, GammaNuclear,
  RadioactiveDecay and Electomagnetic.
  (see geant4/source/physics_lists/constructors)

  HadronElasticPhysicsHP include a model for thermalized neutrons, under the control of a command
  defined in NeutronHPMesseger.

  GammmaNuclearPhysics is a subset of G4BertiniElectroNuclearBuilder.

  ElectromagneticPhysics is a simplified version of G4EmStandardPhysics.
  
  RadioactiveDecayPhysics is G4RadioactiveDecayPhysics with SetARM(false).
  ARM (for Atomic Relaxation Mode also called Atomic Deexcitation) produce a large number of low energy e-
  which slow down the simulation while their contribution is negligible.

  In PhysicsList::ConstructProcess() we give an example of how to access hadronic models.

  Several hadronic physics options are controlled by environment variables.
  To select them, see NeutronSource.cc
 
## AN EVENT : THE PRIMARY GENERATOR
 
   The primary kinematic is a single particle uniformly shooted within the absorber.
   The type of the particle and its energy are set in PrimaryGeneratorAction (Am241, at rest),
   and can be changed via the G4 build-in commands of ParticleGun class 
   (see the macros provided with this example).

## PHYSICS

   The program computes and plots energy deposited in the interaction volume
   (absorber + container) and the flux of particles leaving this volume.
   Processes invoked and particles generated during hadronic cascade are listed.

## HISTOGRAMS
         
   The test contains 13 built-in 1D histograms, which are managed by
   G4AnalysisManager and its Messenger. The histos can be individually 
   activated with the command :
   /analysis/h1/set id nbBins  valMin valMax unit 
   where unit is the desired unit for the histo (MeV or keV, etc..)
   (see the macros xxxx.mac).
   ```
     1    "total energy deposit"
     2    "dummy"
     3    "total kinetic energy flow"
     4    "gamma flux (dN/dE) at exit"
     5    "e+- flux (dN/dE) at exit"
     6    "neutrons flux (dN/dE) at exit"
     7    "protons flux (dN/dE) at exit"
     8    "deuterons flux (dN/dE) at exit"
     9    "alphas flux (dN/dE) at exit"
     10   "all others ions flux (dN/dE) at exit"
     11   "all others baryons flux (dN/dE) at exit"
     12   "all others mesons flux (dN/dE) at exit"
     13   "all others leptons flux (dN/dE) at exit" 
   ```   
   The histograms are managed by the HistoManager class and its Messenger. 
   The histos can be individually activated with the command :
```
/analysis/h1/set id nbBins  valMin valMax unit 
```
   where unit is the desired unit for the histo (MeV or keV, deg or mrad, etc..)

   One can control the name of the histograms file with the command:
```
/analysis/setFileName  name  (default NeutronSource)
```
   It is possible to choose the format of the histogram file : root (default),
   xml, csv, by using namespace in HistoManager.hh
       
   It is also possible to print selected histograms on an ascii file:
```
/analysis/h1/setAscii id
```
   All selected histos will be written on a file name.ascii (default NeutronSource) 
 	 				
## VISUALIZATION
 
   The Visualization Manager is set in the main().
   The initialisation of the drawing is done via the commands
   /vis/... in the macro vis.mac. To get visualisation:
```
> /control/execute vis.mac
```

   The tracks are drawn at the end of event, and erased at the end of run.   
   gamma green   
   neutron yellow
   negative particles (e-, ...) red
   positive particles (e+, ions, ...) blue
 	
## HOW TO START ?
 
   Execute NeutronSource in 'batch' mode from macro files :
```
% NeutronSource  run1.mac
% NeutronSource  neutronSource.in > neutronSource.out
```
 		
   Execute NeutronSource in 'interactive mode' with visualization :
```
% NeutronSource
Idle> control/execute vis.mac
....
Idle> type your commands
....
Idle> exit
```
	
 Macros provided in this example:
  - run1.mac: Am-Be system (default configuration)
  
 Macros to be run interactively:
  - debug.mac: Am-Be
  - vis.mac: To activate visualization
