//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;
#[cfg(feature = "objc2-metal")]
#[cfg(not(target_os = "watchos"))]
use objc2_metal::*;

use crate::*;

/// Metal texture based image buffer
///
/// IMPORTANT NOTE: Clients should retain CVMetalTexture objects until they are done using the images in them.
/// Retaining a CVMetalTexture is your way to indicate that you're still using the image in the buffer, and that it should not be recycled yet.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corevideo/cvmetaltexture?language=objc)
#[doc(alias = "CVMetalTextureRef")]
#[cfg(all(feature = "CVBuffer", feature = "CVImageBuffer"))]
pub type CVMetalTexture = CVImageBuffer;

#[inline]
pub extern "C-unwind" fn CVMetalTextureGetTypeID() -> CFTypeID {
    extern "C-unwind" {
        fn CVMetalTextureGetTypeID() -> CFTypeID;
    }
    unsafe { CVMetalTextureGetTypeID() }
}

/// Returns the Metal MTLTexture object of the CVMetalTextureRef
///
/// Parameter `image`: Target CVMetalTexture
///
/// Returns: Metal texture
#[cfg(all(
    feature = "CVBuffer",
    feature = "CVImageBuffer",
    feature = "objc2",
    feature = "objc2-metal"
))]
#[cfg(not(target_os = "watchos"))]
#[inline]
pub extern "C-unwind" fn CVMetalTextureGetTexture(
    image: &CVMetalTexture,
) -> Option<Retained<ProtocolObject<dyn MTLTexture>>> {
    extern "C-unwind" {
        fn CVMetalTextureGetTexture(image: &CVMetalTexture) -> *mut ProtocolObject<dyn MTLTexture>;
    }
    let ret = unsafe { CVMetalTextureGetTexture(image) };
    unsafe { Retained::retain_autoreleased(ret) }
}

/// Returns whether the image is flipped vertically or not.
///
/// Parameter `image`: Target CVMetalTexture
///
/// Returns: True if 0,0 in the texture is upper left, false if 0,0 is lower left
#[cfg(all(feature = "CVBuffer", feature = "CVImageBuffer"))]
#[inline]
pub extern "C-unwind" fn CVMetalTextureIsFlipped(image: &CVMetalTexture) -> bool {
    extern "C-unwind" {
        fn CVMetalTextureIsFlipped(image: &CVMetalTexture) -> Boolean;
    }
    let ret = unsafe { CVMetalTextureIsFlipped(image) };
    ret != 0
}

extern "C" {
    /// kCVMetalTextureUsage is a property that can be placed on a CVMetalTextureCache to instruct the MTLTextureUsage of the created MTLTexture. Values for this can can be read from MTLTexture.h
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/corevideo/kcvmetaltextureusage?language=objc)
    pub static kCVMetalTextureUsage: &'static CFString;
}

extern "C" {
    /// kCVMetalTextureStorageMode is a property that can be placed on a CVMetalTextureCache to instruct the MTLTextureStorageMode of the created MTLTexture. Values for this can can be read from MTLTexture.h
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/corevideo/kcvmetaltexturestoragemode?language=objc)
    pub static kCVMetalTextureStorageMode: &'static CFString;
}
