﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/acm-pca/model/DeletePermissionRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::ACMPCA::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DeletePermissionRequest::SerializePayload() const {
  JsonValue payload;

  if (m_certificateAuthorityArnHasBeenSet) {
    payload.WithString("CertificateAuthorityArn", m_certificateAuthorityArn);
  }

  if (m_principalHasBeenSet) {
    payload.WithString("Principal", m_principal);
  }

  if (m_sourceAccountHasBeenSet) {
    payload.WithString("SourceAccount", m_sourceAccount);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DeletePermissionRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "ACMPrivateCA.DeletePermission"));
  return headers;
}
