/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.app;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPAdaptable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.impl.app.LocalWorkspaceSession;
import org.jkiss.dbeaver.model.impl.auth.SessionContextImpl;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.virtual.DBVModel;
import org.jkiss.dbeaver.runtime.DBInterruptedException;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.SecurityUtils;

public abstract class BaseWorkspaceImpl
implements DBPWorkspace {
    private static final Log log = Log.getLog(BaseWorkspaceImpl.class);
    public static final String DEFAULT_RESOURCES_ROOT = "Resources";
    protected static final String PROP_PROJECT_ACTIVE = "project.active";
    private static final String WORKSPACE_ID = "workspace-id";
    protected final DBPPlatform platform;
    private final Path workspacePath;
    private final SessionContextImpl workspaceAuthContext;
    protected DBPProject activeProject;

    protected BaseWorkspaceImpl(@NotNull DBPPlatform platform, @NotNull Path workspacePath) {
        this.platform = platform;
        this.workspacePath = workspacePath;
        this.workspaceAuthContext = new SessionContextImpl(null);
    }

    @NotNull
    protected SMSession acquireWorkspaceSession(@NotNull DBRProgressMonitor monitor) throws DBException {
        return new LocalWorkspaceSession(this);
    }

    @Override
    public abstract void initializeProjects();

    public void initializeWorkspaceSession() {
        try {
            this.getAuthContext().addSession(this.acquireWorkspaceSession(new VoidProgressMonitor()));
        }
        catch (DBException e) {
            if (!(e instanceof DBInterruptedException)) {
                log.debug(e);
                DBWorkbench.getPlatformUI().showMessageBox("Authentication error", "Error authenticating application user: \n" + e.getMessage(), true);
            }
            this.dispose();
            System.exit(101);
        }
    }

    public static Properties readWorkspaceInfo(Path metadataFolder) {
        Properties props = new Properties();
        Path versionFile = metadataFolder.resolve("dbeaver-workspace.properties");
        if (Files.exists(versionFile, new LinkOption[0])) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream is = Files.newInputStream(versionFile, new OpenOption[0]);){
                    props.load(is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.error(e);
            }
        }
        return props;
    }

    public static void writeWorkspaceInfo(Path metadataFolder, Properties props) {
        Path versionFile = metadataFolder.resolve("dbeaver-workspace.properties");
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (OutputStream os = Files.newOutputStream(versionFile, new OpenOption[0]);){
                props.store(os, "DBeaver workspace version");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    @Override
    public void dispose() {
        DBVModel.checkGlobalCacheIsEmpty();
    }

    @Override
    @Nullable
    public DBPImage getResourceIcon(DBPAdaptable resourceAdapter) {
        return null;
    }

    @Override
    @Nullable
    public DBPProject getActiveProject() {
        return this.activeProject;
    }

    @Override
    @Nullable
    public DBPProject getProjectById(@NotNull String projectId) {
        for (DBPProject dBPProject : this.getProjects()) {
            if (!dBPProject.getId().equals(projectId)) continue;
            return dBPProject;
        }
        return null;
    }

    @Override
    @NotNull
    public SMSessionContext getAuthContext() {
        return this.workspaceAuthContext;
    }

    @Override
    @NotNull
    public DBPPlatform getPlatform() {
        return this.platform;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    @NotNull
    public Path getAbsolutePath() {
        return this.workspacePath;
    }

    @Override
    @NotNull
    public Path getMetadataFolder() {
        return this.getAbsolutePath().resolve(".metadata");
    }

    @NotNull
    public static String readWorkspaceIdProperty() {
        Path metadataFolder = GeneralUtils.getMetadataFolder();
        return BaseWorkspaceImpl.readWorkspaceId(metadataFolder);
    }

    @NotNull
    public static String readWorkspaceId(Path metadataFolder) {
        Properties workspaceInfo = BaseWorkspaceImpl.readWorkspaceInfo(metadataFolder);
        Object workspaceId = workspaceInfo.getProperty(WORKSPACE_ID);
        if (CommonUtils.isEmpty((String)workspaceId)) {
            workspaceId = "D" + Long.toString(Math.abs(SecurityUtils.generateRandomLong()), 36).toUpperCase();
            workspaceInfo.setProperty(WORKSPACE_ID, (String)workspaceId);
            BaseWorkspaceImpl.writeWorkspaceInfo(metadataFolder, workspaceInfo);
        }
        return workspaceId;
    }

    public static String getLocalHostId() {
        NetworkInterface ni;
        block6: {
            InetAddress localHost = RuntimeUtils.getLocalHostOrLoopback();
            ni = NetworkInterface.getByInetAddress(localHost);
            if (ni == null || ni.getHardwareAddress() == null) {
                Enumeration<NetworkInterface> niEnum = NetworkInterface.getNetworkInterfaces();
                while (niEnum.hasMoreElements()) {
                    ni = niEnum.nextElement();
                    if (ni.getHardwareAddress() != null) break;
                }
            }
            if (ni != null) break block6;
            log.debug("Cannot detect local network interface");
            return "NOMACADDR";
        }
        try {
            byte[] hardwareAddress = ni.getHardwareAddress();
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(hardwareAddress);
            long lValue = 0L;
            int i = 0;
            while (i < messageDigest.length) {
                lValue += (long)messageDigest[i] << i * 8;
                ++i;
            }
            return Long.toString(Math.abs(lValue), 36).toUpperCase();
        }
        catch (Exception e) {
            log.debug(e);
            return "XXXXXXXXXX";
        }
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean hasRealmPermission(@NotNull String permission) {
        return true;
    }

    @Override
    public boolean supportsRealmFeature(@NotNull String feature) {
        return true;
    }
}

