/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.net;

import java.net.InetAddress;
import net.wimpi.modbus.Modbus;
import net.wimpi.modbus.io.ModbusTransport;
import net.wimpi.modbus.net.ModbusSlaveConnection;
import net.wimpi.modbus.net.UDPMasterTerminal;
import net.wimpi.modbus.net.UDPTerminal;

public class UDPMasterConnection
implements ModbusSlaveConnection {
    private static int LOCAL_PORT = 50000;
    private UDPMasterTerminal m_Terminal;
    private int m_Timeout = 3000;
    private boolean m_Connected;
    private InetAddress m_Address;
    private int m_Port = 502;

    public UDPMasterConnection(InetAddress adr) {
        this.m_Address = adr;
    }

    public UDPMasterConnection(InetAddress adr, int port) {
        this(adr);
        this.setPort(port);
    }

    @Override
    public synchronized boolean connect() throws Exception {
        if (!this.m_Connected) {
            this.m_Terminal = new UDPMasterTerminal();
            this.m_Terminal.setLocalAddress(InetAddress.getLocalHost());
            this.m_Terminal.setLocalPort(LOCAL_PORT);
            this.m_Terminal.setRemoteAddress(this.m_Address);
            this.m_Terminal.setRemotePort(this.m_Port);
            this.m_Terminal.setTimeout(this.m_Timeout);
            this.m_Terminal.activate();
            this.m_Connected = true;
        }
        return this.m_Connected;
    }

    public void close() {
        if (this.m_Connected) {
            block3: {
                try {
                    this.m_Terminal.deactivate();
                }
                catch (Exception ex) {
                    if (!Modbus.debug) break block3;
                    ex.printStackTrace();
                }
            }
            this.m_Connected = false;
        }
    }

    public ModbusTransport getModbusTransport() {
        return this.m_Terminal.getModbusTransport();
    }

    public UDPTerminal getTerminal() {
        return this.m_Terminal;
    }

    public int getTimeout() {
        return this.m_Timeout;
    }

    public void setTimeout(int timeout) {
        this.m_Timeout = timeout;
        this.m_Terminal.setTimeout(timeout);
    }

    public int getPort() {
        return this.m_Port;
    }

    public void setPort(int port) {
        this.m_Port = port;
    }

    public InetAddress getAddress() {
        return this.m_Address;
    }

    public void setAddress(InetAddress adr) {
        this.m_Address = adr;
    }

    @Override
    public boolean isConnected() {
        return this.m_Connected;
    }

    @Override
    public void resetConnection() {
        this.close();
    }

    public String toString() {
        return "UDPMasterConnection [m_Terminal=" + this.m_Terminal + ", m_Timeout=" + this.m_Timeout + ", m_Connected=" + this.m_Connected + ", m_Address=" + this.m_Address + ", m_Port=" + this.m_Port + "]";
    }
}

