/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.util;

import org.jupnp.util.SpecificationViolationReporter;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPid={"org.jupnp.util"}, property={"specificationViolationReporterEnabled:Boolean=true"})
@Designate(ocd=Config.class)
public class SpecificationViolationReporterConfig {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Activate
    public void activate(Config config) {
        this.reconfigure(config);
    }

    @Modified
    public void modified(Config config) {
        this.reconfigure(config);
    }

    private void reconfigure(Config config) {
        if (config.specificationViolationReporterEnabled()) {
            this.logger.info("Enabling jUPnP specification violation reporter");
            SpecificationViolationReporter.enableReporting();
        } else {
            this.logger.info("Disabling jUPnP specification violation reporter");
            SpecificationViolationReporter.disableReporting();
        }
    }

    @ObjectClassDefinition(id="org.jupnp.util", name="jUPnP specification violation reporting configuration", description="Configuration for jUPnP specification violation reporting")
    public static @interface Config {
        @AttributeDefinition(name="specificationViolationReporterEnabled", description="Enable specification violation reporting.")
        public boolean specificationViolationReporterEnabled() default true;
    }
}

