/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.eclipse.californium.elements.util.Bytes;

public final class PskPublicInformation
extends Bytes {
    public static final PskPublicInformation EMPTY = new PskPublicInformation("");
    private static final int MAX_LENGTH = 65535;
    private boolean compliantEncoding;
    private String publicInfo;

    private PskPublicInformation(byte[] publicInfoBytes) {
        this(new String(publicInfoBytes, StandardCharsets.UTF_8), publicInfoBytes);
    }

    public PskPublicInformation(String publicInfo) {
        super(publicInfo == null ? null : publicInfo.getBytes(StandardCharsets.UTF_8), 65535, false);
        this.publicInfo = publicInfo;
        this.compliantEncoding = true;
    }

    public PskPublicInformation(String publicInfo, byte[] publicInfoBytes) {
        super(publicInfoBytes, 65535, false);
        this.publicInfo = publicInfo;
        this.compliantEncoding = Arrays.equals(publicInfoBytes, publicInfo.getBytes(StandardCharsets.UTF_8));
    }

    public void normalize(String publicInfo) {
        if (publicInfo == null) {
            throw new NullPointerException("public information must not be null");
        }
        if (publicInfo.isEmpty()) {
            throw new IllegalArgumentException("public information must not be empty");
        }
        this.publicInfo = publicInfo;
        this.compliantEncoding = Arrays.equals(this.getBytes(), publicInfo.getBytes(StandardCharsets.UTF_8));
    }

    public boolean isCompliantEncoding() {
        return this.compliantEncoding;
    }

    public String getPublicInfoAsString() {
        return this.publicInfo;
    }

    public String toString() {
        if (this.compliantEncoding) {
            return this.publicInfo;
        }
        return this.publicInfo + "/" + this.getAsString();
    }

    public static PskPublicInformation fromByteArray(byte[] byteArray) {
        if (byteArray == null || byteArray.length == 0) {
            return EMPTY;
        }
        return new PskPublicInformation(byteArray);
    }
}

