/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.serial.internal.console;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.console.Console;
import org.openhab.core.io.console.extensions.AbstractConsoleCommandExtension;
import org.openhab.core.io.console.extensions.ConsoleCommandExtension;
import org.openhab.core.io.transport.serial.SerialPortIdentifier;
import org.openhab.core.io.transport.serial.SerialPortManager;
import org.openhab.core.io.transport.serial.internal.SerialPortRegistry;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ConsoleCommandExtension.class})
public class SerialCommandExtension
extends AbstractConsoleCommandExtension {
    private static final String CMD_SERIAL = "serial";
    private static final String SUBCMD_IDENTIFIER_ALL = "identifiers";
    private static final String SUBCMD_IDENTIFIER_NAME = "identifier";
    private static final String SUBCMD_PORT_CREATORS = "creators";
    private final SerialPortManager serialPortManager;
    private final SerialPortRegistry serialPortRegistry;

    @Activate
    public SerialCommandExtension(@Reference SerialPortManager serialPortManager, @Reference SerialPortRegistry serialPortRegistry) {
        super(CMD_SERIAL, "Access your serial port interfaces.");
        this.serialPortManager = serialPortManager;
        this.serialPortRegistry = serialPortRegistry;
    }

    public void execute(String[] args, Console console) {
        String subCmd;
        LinkedList<String> argList = new LinkedList<String>(Arrays.asList(args));
        if (argList.isEmpty()) {
            this.printUsage(console);
            return;
        }
        switch (subCmd = (String)argList.removeFirst()) {
            case "identifiers": {
                this.serialPortManager.getIdentifiers().forEach(id -> console.println(SerialCommandExtension.str(id)));
                return;
            }
            case "identifier": {
                if (argList.isEmpty()) {
                    console.println("Missing name");
                    return;
                }
                String name = (String)argList.removeFirst();
                console.println(SerialCommandExtension.str(this.serialPortManager.getIdentifier(name)));
                return;
            }
            case "creators": {
                this.serialPortRegistry.getPortCreators().forEach(provider -> console.printf("%s, accepted protocols: %s, port identifiers: %s%n", new Object[]{provider.getClass(), provider.getAcceptedProtocols().toList(), provider.getSerialPortIdentifiers().map(SerialCommandExtension::str).toList()}));
                return;
            }
        }
        console.printf("Unknown sub command: %s%n", new Object[]{subCmd});
    }

    public List<String> getUsages() {
        return List.of(this.buildCommandUsage(SUBCMD_IDENTIFIER_ALL, "lists all identifiers"), this.buildCommandUsage(SUBCMD_IDENTIFIER_NAME, "lists a specific identifier"), this.buildCommandUsage(SUBCMD_PORT_CREATORS, "gets details about the port creators"));
    }

    private static String str(@Nullable SerialPortIdentifier id) {
        if (id == null) {
            return "<null>";
        }
        return String.format("[name: %s, current owner: %s]", id.getName(), id.getCurrentOwner());
    }
}

