/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi.resource;

import aQute.bnd.osgi.Domain;
import aQute.bnd.osgi.resource.CapabilityBuilder;
import aQute.bnd.version.Version;
import aQute.lib.strings.Strings;
import org.osgi.framework.VersionRange;

public class MainClassNamespace {
    public static final String MAINCLASS_NAMESPACE = "bnd.mainclass";
    public static final String VERSION_ATTRIBUTE = "version";

    public static void build(CapabilityBuilder mc, Domain manifest) {
        String mainClass = manifest.get("Main-Class");
        if (mainClass == null) {
            return;
        }
        mainClass = Strings.trim(mainClass.replace('/', '.'));
        mc.addAttribute(MAINCLASS_NAMESPACE, mainClass);
        String versionString = Strings.trim(manifest.getBundleVersion());
        if (versionString != null && Version.isVersion(versionString)) {
            org.osgi.framework.Version version = org.osgi.framework.Version.parseVersion((String)versionString);
            mc.addAttribute(VERSION_ATTRIBUTE, version);
        }
    }

    public static String filter(String mainClass, VersionRange range) {
        StringBuilder sb = new StringBuilder();
        sb.append('(').append(MAINCLASS_NAMESPACE).append('=').append(mainClass).append(')');
        if (range != null) {
            sb.insert(0, "(&").append(range.toFilterString(VERSION_ATTRIBUTE)).append(')');
        }
        return sb.toString();
    }
}

