/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.config;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.config.DocumentedDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefinitionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefinitionUtils.class);

    public static <E extends Enum<?>> Class<E> getClass(E[] list) {
        if (list == null) {
            throw new NullPointerException("Enums must not be null!");
        }
        if (list.length == 0) {
            throw new IllegalArgumentException("Enums must not be empty!");
        }
        return list[0].getClass();
    }

    public static String toString(List<String> list, boolean brackets) {
        if (list == null) {
            throw new NullPointerException("List must not be null!");
        }
        StringBuilder message = new StringBuilder();
        if (brackets) {
            message.append('[');
        }
        for (String in : list) {
            message.append(in).append(", ");
        }
        message.setLength(message.length() - 2);
        if (brackets) {
            message.append(']');
        }
        return message.toString();
    }

    public static <E extends Enum<?>> String toNames(List<E> list, boolean brackets) {
        if (list == null) {
            throw new NullPointerException("List must not be null!");
        }
        StringBuilder message = new StringBuilder();
        if (brackets) {
            message.append('[');
        }
        for (Enum in : list) {
            message.append(in.name()).append(", ");
        }
        message.setLength(message.length() - 2);
        if (brackets) {
            message.append(']');
        }
        return message.toString();
    }

    public static <E extends Enum<?>> E toValue(String text, List<E> values) {
        if (text == null) {
            throw new NullPointerException("Text must not be null!");
        }
        if (values == null) {
            throw new NullPointerException("values must not be null!");
        }
        for (Enum in : values) {
            if (!in.name().equals(text)) continue;
            return (E)in;
        }
        return null;
    }

    public static void verify(Class<?> definitionClz, Configuration config) {
        Field[] declaredFields;
        for (Field field : declaredFields = definitionClz.getDeclaredFields()) {
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) continue;
            try {
                DocumentedDefinition definition;
                Object value = field.get(null);
                if (!(value instanceof DocumentedDefinition) || config.hasDefinition(definition = (DocumentedDefinition)value)) continue;
                LOGGER.warn("Missing definition {} in {}.", (Object)definition.getKey(), (Object)definitionClz.getSimpleName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }
}

