/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.internal.action;

import java.time.ZonedDateTime;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.module.script.action.ScriptExecution;
import org.openhab.core.automation.module.script.action.Timer;
import org.openhab.core.automation.module.script.internal.action.TimerImpl;
import org.openhab.core.scheduler.Scheduler;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ScriptExecution.class})
@NonNullByDefault
public class ScriptExecutionImpl
implements ScriptExecution {
    private final Scheduler scheduler;

    @Activate
    public ScriptExecutionImpl(@Reference Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public Timer createTimer(ZonedDateTime zonedDateTime, Runnable runnable) {
        return this.createTimer(null, zonedDateTime, runnable);
    }

    @Override
    public Timer createTimer(@Nullable String identifier, ZonedDateTime zonedDateTime, Runnable runnable) {
        return new TimerImpl(this.scheduler, zonedDateTime, runnable::run, identifier);
    }

    @Override
    public Timer createTimerWithArgument(ZonedDateTime zonedDateTime, Object arg1, Consumer<Object> consumer) {
        return this.createTimerWithArgument(null, zonedDateTime, arg1, consumer);
    }

    @Override
    public Timer createTimerWithArgument(@Nullable String identifier, ZonedDateTime zonedDateTime, Object arg1, Consumer<Object> consumer) {
        return new TimerImpl(this.scheduler, zonedDateTime, () -> consumer.accept(arg1), identifier);
    }
}

