/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.whiteboard.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.aries.component.dsl.OSGi;
import org.apache.aries.component.dsl.OSGiResult;
import org.apache.aries.jax.rs.whiteboard.internal.FilteredPublisher;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public class Registry<T>
implements AutoCloseable {
    private final HashSet<FilteredPublisher<T>> _publishers = new HashSet();
    private final List<ServiceWithProperties<T>> _servicesWithPropertiesList = new ArrayList<ServiceWithProperties<T>>();

    @Override
    public void close() {
        for (FilteredPublisher<T> publisher : new HashSet<FilteredPublisher<T>>(this._publishers)) {
            publisher.close();
        }
    }

    public OSGi<T> waitForService(String filterString) {
        Filter filter;
        try {
            filter = FrameworkUtil.createFilter((String)filterString);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException();
        }
        return OSGi.fromOsgiRunnable((bc, p) -> {
            Registry registry = this;
            synchronized (registry) {
                FilteredPublisher ep = new FilteredPublisher(p, filter);
                this._publishers.add(ep);
                for (ServiceWithProperties<T> serviceWithProperties : new ArrayList<ServiceWithProperties<T>>(this._servicesWithPropertiesList)) {
                    ep.publishIfMatched(serviceWithProperties.service, serviceWithProperties.properties);
                }
                return () -> {
                    Registry registry = this;
                    synchronized (registry) {
                        this._publishers.remove(ep);
                        for (ServiceWithProperties<T> serviceWithProperties : new ArrayList<ServiceWithProperties<T>>(this._servicesWithPropertiesList)) {
                            ep.retract(serviceWithProperties.service);
                        }
                    }
                };
            }
        });
    }

    public OSGi<T> registerService(T service, Map<String, ?> properties) {
        return (bc, p) -> {
            Registry registry = this;
            synchronized (registry) {
                ServiceWithProperties<Object> serviceWithProperties = new ServiceWithProperties<Object>(service, properties);
                this._servicesWithPropertiesList.add(serviceWithProperties);
                OSGiResult result = p.publish(service);
                for (FilteredPublisher<Object> filteredPublisher : new HashSet<FilteredPublisher<T>>(this._publishers)) {
                    filteredPublisher.publishIfMatched(service, properties);
                }
                return () -> {
                    Registry registry = this;
                    synchronized (registry) {
                        for (FilteredPublisher<Object> filteredPublisher : new HashSet<FilteredPublisher<T>>(this._publishers)) {
                            filteredPublisher.retract(service);
                        }
                        result.close();
                        this._servicesWithPropertiesList.remove(serviceWithProperties);
                    }
                };
            }
        };
    }

    private static class ServiceWithProperties<T> {
        final T service;
        final Map<String, ?> properties;
        final Long serviceId;

        ServiceWithProperties(T service, Map<String, ?> properties) {
            this.service = Objects.requireNonNull(service);
            this.properties = Objects.requireNonNull(properties);
            this.serviceId = Objects.requireNonNull((Long)properties.get("service.id"));
        }

        public int hashCode() {
            return Objects.hashCode(this.serviceId);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ServiceWithProperties other = (ServiceWithProperties)obj;
            return Objects.equals(other.serviceId, this.serviceId);
        }
    }
}

