/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.persistence;

import java.time.ZonedDateTime;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.types.State;

@NonNullByDefault
public class FilterCriteria {
    private @Nullable String itemName;
    private @Nullable ZonedDateTime beginDate;
    private @Nullable ZonedDateTime endDate;
    private int pageNumber = 0;
    private int pageSize = Integer.MAX_VALUE;
    private Operator operator = Operator.EQ;
    private Ordering ordering = Ordering.DESCENDING;
    private @Nullable State state;

    public FilterCriteria() {
    }

    public FilterCriteria(FilterCriteria filter) {
        this.itemName = filter.itemName;
        this.beginDate = filter.beginDate;
        this.endDate = filter.endDate;
        this.pageNumber = filter.pageNumber;
        this.pageSize = filter.pageSize;
        this.operator = filter.operator;
        this.ordering = filter.ordering;
        this.state = filter.state;
    }

    public @Nullable String getItemName() {
        return this.itemName;
    }

    public @Nullable ZonedDateTime getBeginDate() {
        return this.beginDate;
    }

    public @Nullable ZonedDateTime getEndDate() {
        return this.endDate;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Ordering getOrdering() {
        return this.ordering;
    }

    public @Nullable State getState() {
        return this.state;
    }

    public FilterCriteria setItemName(String itemName) {
        this.itemName = itemName;
        return this;
    }

    public FilterCriteria setBeginDate(ZonedDateTime beginDate) {
        this.beginDate = beginDate;
        return this;
    }

    public FilterCriteria setEndDate(ZonedDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    public FilterCriteria setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    public FilterCriteria setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public FilterCriteria setOperator(Operator operator) {
        this.operator = operator;
        return this;
    }

    public FilterCriteria setOrdering(Ordering ordering) {
        this.ordering = ordering;
        return this;
    }

    public FilterCriteria setState(State state) {
        this.state = state;
        return this;
    }

    public String toString() {
        return "FilterCriteria [itemName=" + this.itemName + ", beginDate=" + String.valueOf(this.beginDate) + ", endDate=" + String.valueOf(this.endDate) + ", pageNumber=" + this.pageNumber + ", pageSize=" + this.pageSize + ", operator=" + String.valueOf((Object)this.operator) + ", ordering=" + String.valueOf((Object)this.ordering) + ", state=" + String.valueOf(this.state) + "]";
    }

    public static enum Operator {
        EQ("="),
        NEQ("!="),
        GT(">"),
        LT("<"),
        GTE(">="),
        LTE("<=");

        private final String symbol;

        private Operator(String symbol) {
            this.symbol = symbol;
        }

        String getSymbol() {
            return this.symbol;
        }
    }

    public static enum Ordering {
        ASCENDING,
        DESCENDING;

    }
}

