/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.persistence;

import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.persistence.FilterCriteria;
import org.openhab.core.persistence.HistoricItem;
import org.openhab.core.persistence.PersistedItem;
import org.openhab.core.persistence.PersistenceItemInfo;
import org.openhab.core.persistence.PersistenceService;
import org.openhab.core.types.State;
import org.openhab.core.types.UnDefType;

@NonNullByDefault
public interface QueryablePersistenceService
extends PersistenceService {
    public Iterable<HistoricItem> query(FilterCriteria var1);

    default public Iterable<HistoricItem> query(FilterCriteria filter, @Nullable String alias) {
        String itemName = filter.getItemName();
        if (itemName != null && alias != null) {
            FilterCriteria aliasFilter = new FilterCriteria(filter).setItemName(alias);
            return StreamSupport.stream(this.query(aliasFilter).spliterator(), false).map(hi -> new HistoricItem((HistoricItem)hi, itemName){
                private final /* synthetic */ HistoricItem val$hi;
                private final /* synthetic */ String val$itemName;
                {
                    this.val$hi = historicItem;
                    this.val$itemName = string;
                }

                @Override
                public ZonedDateTime getTimestamp() {
                    return this.val$hi.getTimestamp();
                }

                @Override
                public State getState() {
                    return this.val$hi.getState();
                }

                @Override
                public String getName() {
                    return this.val$itemName;
                }
            }).collect(Collectors.toList());
        }
        return this.query(filter);
    }

    public Set<PersistenceItemInfo> getItemInfo();

    default public @Nullable PersistedItem persistedItem(String itemName, @Nullable String alias) {
        UnDefType currentState = UnDefType.NULL;
        ZonedDateTime lastUpdate = null;
        FilterCriteria filter = new FilterCriteria().setItemName(itemName).setEndDate(ZonedDateTime.now()).setOrdering(FilterCriteria.Ordering.DESCENDING).setPageSize(1).setPageNumber(0);
        Iterator<HistoricItem> it = this.query(filter, alias).iterator();
        if (!it.hasNext()) {
            return null;
        }
        HistoricItem historicItem = it.next();
        currentState = historicItem.getState();
        lastUpdate = historicItem.getTimestamp();
        UnDefType state = currentState;
        final ZonedDateTime lastStateUpdate = lastUpdate;
        return new PersistedItem((State)state, itemName){
            private final /* synthetic */ State val$state;
            private final /* synthetic */ String val$itemName;
            {
                this.val$state = state;
                this.val$itemName = string;
            }

            @Override
            public ZonedDateTime getTimestamp() {
                return lastStateUpdate;
            }

            @Override
            public State getState() {
                return this.val$state;
            }

            @Override
            public String getName() {
                return this.val$itemName;
            }

            @Override
            public @Nullable ZonedDateTime getLastStateChange() {
                return null;
            }

            @Override
            public @Nullable State getLastState() {
                return null;
            }
        };
    }
}

