/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.script;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.openhab.core.events.EventPublisher;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.model.core.ModelRepository;
import org.openhab.core.model.script.engine.ScriptEngine;
import org.openhab.core.model.script.engine.action.ActionService;
import org.openhab.core.scheduler.Scheduler;
import org.openhab.core.thing.ThingRegistry;
import org.openhab.core.thing.binding.ThingActions;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ScriptServiceUtil.class})
public class ScriptServiceUtil {
    private final Logger logger = LoggerFactory.getLogger(ScriptServiceUtil.class);
    private static ScriptServiceUtil instance;
    private final ItemRegistry itemRegistry;
    private final ThingRegistry thingRegistry;
    private final EventPublisher eventPublisher;
    private final ModelRepository modelRepository;
    private final Scheduler scheduler;
    private final AtomicReference<ScriptEngine> scriptEngine = new AtomicReference();
    public final List<ActionService> actionServices = new CopyOnWriteArrayList<ActionService>();
    public final List<ThingActions> thingActions = new CopyOnWriteArrayList<ThingActions>();

    @Activate
    public ScriptServiceUtil(@Reference ItemRegistry itemRegistry, @Reference ThingRegistry thingRegistry, @Reference EventPublisher eventPublisher, @Reference ModelRepository modelRepository, @Reference Scheduler scheduler) {
        this.itemRegistry = itemRegistry;
        this.thingRegistry = thingRegistry;
        this.eventPublisher = eventPublisher;
        this.modelRepository = modelRepository;
        this.scheduler = scheduler;
        if (instance != null) {
            throw new IllegalStateException("ScriptServiceUtil should only be activated once!");
        }
        instance = this;
        this.logger.debug("ScriptServiceUtil started");
    }

    @Deactivate
    public void deactivate() {
        this.logger.debug("ScriptServiceUtil stopped");
        instance = null;
    }

    private static ScriptServiceUtil getInstance() {
        return instance;
    }

    public static ItemRegistry getItemRegistry() {
        return ScriptServiceUtil.getInstance().itemRegistry;
    }

    public ItemRegistry getItemRegistryInstance() {
        return this.itemRegistry;
    }

    public ThingRegistry getThingRegistryInstance() {
        return this.thingRegistry;
    }

    public static EventPublisher getEventPublisher() {
        return ScriptServiceUtil.getInstance().eventPublisher;
    }

    public static ModelRepository getModelRepository() {
        return ScriptServiceUtil.getInstance().modelRepository;
    }

    public ModelRepository getModelRepositoryInstance() {
        return this.modelRepository;
    }

    public static Scheduler getScheduler() {
        return ScriptServiceUtil.getInstance().scheduler;
    }

    public Scheduler getSchedulerInstance() {
        return this.scheduler;
    }

    public static ScriptEngine getScriptEngine() {
        return ScriptServiceUtil.getInstance().scriptEngine.get();
    }

    public static List<ActionService> getActionServices() {
        return ScriptServiceUtil.getInstance().actionServices;
    }

    public static List<ThingActions> getThingActions() {
        return ScriptServiceUtil.getInstance().thingActions;
    }

    public List<ActionService> getActionServiceInstances() {
        return this.actionServices;
    }

    public List<ThingActions> getThingActionsInstances() {
        return this.thingActions;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addActionService(ActionService actionService) {
        this.actionServices.add(actionService);
    }

    public void removeActionService(ActionService actionService) {
        this.actionServices.remove(actionService);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addThingActions(ThingActions thingActions) {
        this.thingActions.add(thingActions);
    }

    public void removeThingActions(ThingActions thingActions) {
        this.thingActions.remove(thingActions);
    }

    public void setScriptEngine(ScriptEngine scriptEngine) {
        this.scriptEngine.set(scriptEngine);
    }

    public void unsetScriptEngine(ScriptEngine scriptEngine) {
        this.scriptEngine.compareAndSet(scriptEngine, null);
    }
}

