/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.common;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class NamedThreadFactory
implements ThreadFactory {
    private final boolean daemonize;
    private final int priority;
    private final @Nullable ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;

    public NamedThreadFactory(String id) {
        this(id, false);
    }

    public NamedThreadFactory(String id, boolean daemonize) {
        this(id, daemonize, 5);
    }

    public NamedThreadFactory(String id, boolean daemonize, int priority) {
        this.daemonize = daemonize;
        this.priority = priority;
        this.namePrefix = "OH-" + id + "-";
        this.group = Thread.currentThread().getThreadGroup();
    }

    @Override
    public Thread newThread(@Nullable Runnable runnable) {
        Thread thread = new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        if (thread.isDaemon() != this.daemonize) {
            thread.setDaemon(this.daemonize);
        }
        if (thread.getPriority() != this.priority) {
            thread.setPriority(this.priority);
        }
        return thread;
    }
}

