import type { Root } from 'mdast';
export declare const transformToBlockQuote: (content: string, type: string, customTitle?: string | null) => string;
/** Options for {@link transformMarkdownAst} */
interface TransformMarkdownAstOptions {
    /**
     * Used to indicate the original/source file.
     */
    originalFilename: string;
    /** If `true`, add a warning that the file is autogenerated */
    addAutogeneratedWarning?: boolean;
    /**
     * If `true`, remove the YAML metadata from the Markdown input.
     * Generally, YAML metadata is only used for Vitepress.
     */
    removeYAML?: boolean;
}
/**
 * Remark plugin that transforms mermaid repo markdown to Vitepress/GFM markdown.
 *
 * For any AST node that is a code block: transform it as needed:
 * - blocks marked as MERMAID_DIAGRAM_ONLY will be set to a 'mermaid' code block so it will be rendered as (only) a diagram
 * - blocks marked as MERMAID_EXAMPLE_KEYWORDS will be copied and the original node will be a code only block and the copy with be rendered as the diagram
 * - blocks marked as BLOCK_QUOTE_KEYWORDS will be transformed into block quotes
 *
 * If `addAutogeneratedWarning` is `true`, generates a header stating that this file is autogenerated.
 *
 * @returns plugin function for Remark
 */
export declare function transformMarkdownAst({ originalFilename, addAutogeneratedWarning, removeYAML, }: TransformMarkdownAstOptions): (tree: Root, _file?: any) => Root;
export {};
