/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_eo extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "araba";
        final String metaValue_hy = "armena";
        final String metaValue_bn = "bengala";
        final String metaValue_ccp = "ĉakma";
        final String metaValue_chr = "ĉeroka";
        final String metaValue_ka = "kartvela";
        final String metaValue_el = "greka";
        final String metaValue_gu = "guĝarata";
        final String metaValue_zh = "ĉina";
        final String metaValue_he = "hebrea";
        final String metaValue_jv = "java";
        final String metaValue_ja = "japana";
        final String metaValue_km = "kmera";
        final String metaValue_kn = "kanara";
        final String metaValue_ko = "korea";
        final String metaValue_lo = "laŭa";
        final String metaValue_ml = "malajalama";
        final String metaValue_mn = "mongola";
        final String metaValue_mni = "manipura";
        final String metaValue_my = "birma";
        final String metaValue_nqo = "N’Ko";
        final String metaValue_si = "sinhala";
        final String metaValue_su = "sunda";
        final String metaValue_syr = "siria";
        final String metaValue_ta = "tamila";
        final String metaValue_te = "telugua";
        final String metaValue_dv = "maldiva";
        final String metaValue_th = "taja";
        final String metaValue_bo = "tibeta";
        final String metaValue_vai = "vaja";
        final String metaValue_ii = "jia";
        final Object[][] data = new Object[][] {
            { "001", "mondo" },
            { "002", "Afriko" },
            { "003", "Nordameriko" },
            { "005", "Sudameriko" },
            { "009", "Oceanio" },
            { "011", "Okcidenta Afriko" },
            { "013", "Centra Ameriko" },
            { "014", "Orienta Afriko" },
            { "015", "Norda Afriko" },
            { "017", "Centra Afriko" },
            { "018", "Suda Afriko" },
            { "019", "Amerikoj" },
            { "021", "Norda Ameriko" },
            { "029", "Kariba regiono" },
            { "030", "Orienta Azio" },
            { "034", "Suda Azio" },
            { "035", "Sud-orienta Azio" },
            { "039", "Suda Eŭropo" },
            { "053", "Aŭstralazio" },
            { "054", "Melanezio" },
            { "057", "Mikronezia regiono" },
            { "061", "Polinezio" },
            { "142", "Azio" },
            { "143", "Centra Azio" },
            { "145", "Okcidenta Azio" },
            { "150", "Eŭropo" },
            { "151", "Orienta Eŭropo" },
            { "154", "Norda Eŭropo" },
            { "155", "Okcidenta Eŭropo" },
            { "202", "Subsahara Afriko" },
            { "419", "Latinameriko" },
            { "AC", "Ascension" },
            { "AD", "Andoro" },
            { "AE", "Unuiĝintaj Arabaj Emirlandoj" },
            { "AF", "Afganujo" },
            { "AG", "Antigvo kaj Barbudo" },
            { "AI", "Angvilo" },
            { "AL", "Albanujo" },
            { "AM", "Armenujo" },
            { "AO", "Angolo" },
            { "AQ", "Antarkto" },
            { "AR", "Argentino" },
            { "AS", "Usona Samoo" },
            { "AT", "Aŭstrujo" },
            { "AU", "Aŭstralio" },
            { "AW", "Arubo" },
            { "AX", "Alando" },
            { "AZ", "Azerbajĝano" },
            { "BA", "Bosnujo kaj Hercegovino" },
            { "BB", "Barbado" },
            { "BD", "Bangladeŝo" },
            { "BE", "Belgujo" },
            { "BF", "Burkino" },
            { "BG", "Bulgarujo" },
            { "BH", "Barejno" },
            { "BI", "Burundo" },
            { "BJ", "Benino" },
            { "BL", "Sankta Bartolomeo" },
            { "BM", "Bermudoj" },
            { "BN", "Brunejo" },
            { "BO", "Bolivio" },
            { "BQ", "Kariba Nederlando" },
            { "BR", "Brazilo" },
            { "BS", "Bahamoj" },
            { "BT", "Butano" },
            { "BV", "Buvetinsulo" },
            { "BW", "Bocvano" },
            { "BY", "Belorusujo" },
            { "BZ", "Belizo" },
            { "CA", "Kanado" },
            { "CC", "Kokosinsuloj" },
            { "CD", "Kongo Kinŝasa" },
            { "CF", "Centr-Afriko" },
            { "CG", "Kongo Brazavila" },
            { "CH", "Svisujo" },
            { "CI", "Ebur-Bordo" },
            { "CK", "Kukinsuloj" },
            { "CL", "Ĉilio" },
            { "CM", "Kameruno" },
            { "CN", "Ĉinujo" },
            { "CO", "Kolombio" },
            { "CP", "Klipertono" },
            { "CQ", "Sark" },
            { "CR", "Kostariko" },
            { "CU", "Kubo" },
            { "CV", "Kaboverdo" },
            { "CW", "Kuracao" },
            { "CX", "Kristnaskinsulo" },
            { "CY", "Kipro" },
            { "CZ", "Ĉeĥujo" },
            { "DE", "Germanujo" },
            { "DG", "Diego Garcia" },
            { "DJ", "Ĝibutio" },
            { "DK", "Danujo" },
            { "DM", "Dominiko" },
            { "DO", "Dominika Respubliko" },
            { "DZ", "Alĝerio" },
            { "EA", "Ceŭto kaj Melilo" },
            { "EC", "Ekvadoro" },
            { "EE", "Estonujo" },
            { "EG", "Egiptujo" },
            { "EH", "Okcidenta Saharo" },
            { "ER", "Eritreo" },
            { "ES", "Hispanujo" },
            { "ET", "Etiopujo" },
            { "EU", "Eŭropa Unio" },
            { "EZ", "Eŭrozono" },
            { "FI", "Finnlando" },
            { "FJ", "Fiĝio" },
            { "FK", "Falklandoj" },
            { "FM", "Mikronezio" },
            { "FO", "Ferooj" },
            { "FR", "Francujo" },
            { "GA", "Gabono" },
            { "GB", "Unuiĝinta Reĝlando" },
            { "GD", "Grenado" },
            { "GE", "Kartvelujo" },
            { "GF", "Franca Gujano" },
            { "GG", "Gernezejo" },
            { "GH", "Ganao" },
            { "GI", "Ĝibraltaro" },
            { "GL", "Gronlando" },
            { "GM", "Gambio" },
            { "GN", "Gvineo" },
            { "GP", "Gvadelupo" },
            { "GQ", "Ekvatora Gvineo" },
            { "GR", "Grekujo" },
            { "GS", "Sud-Georgio kaj Sud-Sandviĉinsuloj" },
            { "GT", "Gvatemalo" },
            { "GU", "Gvamo" },
            { "GW", "Gvineo-Bisaŭo" },
            { "GY", "Gujano" },
            { "HK", "Honkongo (SAR de Ĉinujo)" },
            { "HM", "Herda kaj Makdonaldaj Insuloj" },
            { "HN", "Honduro" },
            { "HR", "Kroatujo" },
            { "HT", "Haitio" },
            { "HU", "Hungarujo" },
            { "IC", "Kanarioj" },
            { "ID", "Indonezio" },
            { "IE", "Irlando" },
            { "IL", "Israelo" },
            { "IM", "Manksinsulo" },
            { "IN", "Hindujo" },
            { "IO", "Brita Hindoceana Teritorio" },
            { "IQ", "Irako" },
            { "IR", "Irano" },
            { "IS", "Islando" },
            { "IT", "Italujo" },
            { "JE", "Ĵerzejo" },
            { "JM", "Jamajko" },
            { "JO", "Jordanio" },
            { "JP", "Japanujo" },
            { "KE", "Kenjo" },
            { "KG", "Kirgizujo" },
            { "KH", "Kamboĝo" },
            { "KI", "Kiribato" },
            { "KM", "Komoroj" },
            { "KN", "Sankta Kristoforo kaj Neviso" },
            { "KP", "Nord-Koreujo" },
            { "KR", "Sud-Koreujo" },
            { "KW", "Kuvajto" },
            { "KY", "Kajmana Insularo" },
            { "KZ", "Kazaĥujo" },
            { "LA", "Laoso" },
            { "LB", "Libano" },
            { "LC", "Sankta Lucio" },
            { "LI", "Liĥtenŝtejno" },
            { "LK", "Srilanko" },
            { "LR", "Liberio" },
            { "LS", "Lesoto" },
            { "LT", "Litovujo" },
            { "LU", "Luksemburgo" },
            { "LV", "Latvujo" },
            { "LY", "Libio" },
            { "MA", "Maroko" },
            { "MC", "Monako" },
            { "MD", "Moldavujo" },
            { "ME", "Montenegro" },
            { "MF", "Saint-Martin" },
            { "MG", "Madagaskaro" },
            { "MH", "Marŝaloj" },
            { "MK", "Nord-Makedonujo" },
            { "ML", "Malio" },
            { "MM", "Birmo" },
            { "MN", "Mongolujo" },
            { "MO", "Makao (SAR de Ĉinujo)" },
            { "MP", "Nord-Marianoj" },
            { "MQ", "Martiniko" },
            { "MR", "Maŭritanio" },
            { "MS", "Moncerato" },
            { "MT", "Malto" },
            { "MU", "Maŭricio" },
            { "MV", "Maldivoj" },
            { "MW", "Malavio" },
            { "MX", "Meksiko" },
            { "MY", "Malajzio" },
            { "MZ", "Mozambiko" },
            { "NA", "Namibio" },
            { "NC", "Nov-Kaledonio" },
            { "NE", "Niĝero" },
            { "NF", "Norfolkinsulo" },
            { "NG", "Niĝerio" },
            { "NI", "Nikaragvo" },
            { "NL", "Nederlando" },
            { "NO", "Norvegujo" },
            { "NP", "Nepalo" },
            { "NR", "Nauro" },
            { "NU", "Niuo" },
            { "NZ", "Nov-Zelando" },
            { "OM", "Omano" },
            { "PA", "Panamo" },
            { "PE", "Peruo" },
            { "PF", "Franca Polinezio" },
            { "PG", "Papuo-Nov-Gvineo" },
            { "PH", "Filipinoj" },
            { "PK", "Pakistano" },
            { "PL", "Pollando" },
            { "PM", "Sankta Piero kaj Mikelono" },
            { "PN", "Pitkarna Insulo" },
            { "PR", "Puertoriko" },
            { "PS", "Palestinaj teritorioj" },
            { "PT", "Portugalujo" },
            { "PW", "Palaŭo" },
            { "PY", "Paragvajo" },
            { "QA", "Kataro" },
            { "QO", "malproksimaj insuletoj de Oceanio" },
            { "RE", "Reunio" },
            { "RO", "Rumanujo" },
            { "RS", "Serbujo" },
            { "RU", "Rusujo" },
            { "RW", "Ruando" },
            { "SA", "Sauda Arabujo" },
            { "SB", "Salomonoj" },
            { "SC", "Sejŝeloj" },
            { "SD", "Sudano" },
            { "SE", "Svedujo" },
            { "SG", "Singapuro" },
            { "SH", "Sankta Heleno" },
            { "SI", "Slovenujo" },
            { "SJ", "Svalbardo kaj Janmajeno" },
            { "SK", "Slovakujo" },
            { "SL", "Sieraleono" },
            { "SM", "Sanmarino" },
            { "SN", "Senegalo" },
            { "SO", "Somalujo" },
            { "SR", "Surinamo" },
            { "SS", "Sud-Sudano" },
            { "ST", "Santomeo kaj Principeo" },
            { "SV", "Salvadoro" },
            { "SX", "Sint-Maarten" },
            { "SY", "Sirio" },
            { "SZ", "Svazilando" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turkoj kaj Kajkoj" },
            { "TD", "Ĉado" },
            { "TF", "Francaj Sudaj Teritorioj" },
            { "TG", "Togolando" },
            { "TH", "Tajlando" },
            { "TJ", "Taĝikujo" },
            { "TK", "Tokelao" },
            { "TL", "Orienta Timoro" },
            { "TM", "Turkmenujo" },
            { "TN", "Tunizio" },
            { "TO", "Tongo" },
            { "TR", "Turkujo" },
            { "TT", "Trinidado kaj Tobago" },
            { "TV", "Tuvalo" },
            { "TW", "Tajvano" },
            { "TZ", "Tanzanio" },
            { "UA", "Ukrainujo" },
            { "UG", "Ugando" },
            { "UM", "Usonaj malgrandaj insuloj" },
            { "UN", "Unuiĝintaj Nacioj" },
            { "US", "Usono" },
            { "UY", "Urugvajo" },
            { "UZ", "Uzbekujo" },
            { "VA", "Vatikano" },
            { "VC", "Sankta Vincento kaj Grenadinoj" },
            { "VE", "Venezuelo" },
            { "VG", "Britaj Virgulininsuloj" },
            { "VI", "Usonaj Virgulininsuloj" },
            { "VN", "Vjetnamujo" },
            { "VU", "Vanuatuo" },
            { "WF", "Valiso kaj Futuno" },
            { "WS", "Samoo" },
            { "XA", "pseŭdo-supersignoj" },
            { "XB", "pseŭdo-inversdirekta" },
            { "XK", "Kosovo" },
            { "YE", "Jemeno" },
            { "YT", "Majoto" },
            { "ZA", "Sud-Afriko" },
            { "ZM", "Zambio" },
            { "ZW", "Zimbabvo" },
            { "ZZ", "nekonata regiono" },
            { "aa", "afara" },
            { "ab", "abĥaza" },
            { "af", "afrikansa" },
            { "ak", "akana" },
            { "am", "amhara" },
            { "an", "aragona" },
            { "ar", metaValue_ar },
            { "as", "asama" },
            { "av", "avara" },
            { "ay", "ajmara" },
            { "az", "azerbajĝana" },
            { "ba", "baŝkira" },
            { "be", "belorusa" },
            { "bg", "bulgara" },
            { "bi", "Bislamo" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "bretona" },
            { "bs", "bosna" },
            { "ca", "kataluna" },
            { "ce", "ĉeĉena" },
            { "ch", "ĉamora" },
            { "co", "korsika" },
            { "cs", "ĉeĥa" },
            { "cu", "malnovslava" },
            { "cv", "ĉuvaŝa" },
            { "cy", "kimra" },
            { "da", "dana" },
            { "de", "germana" },
            { "dv", metaValue_dv },
            { "dz", "Dzonko" },
            { "ee", "evea" },
            { "el", metaValue_el },
            { "en", "angla" },
            { "eo", "Esperanto" },
            { "es", "hispana" },
            { "et", "estona" },
            { "eu", "eŭska" },
            { "fa", "persa" },
            { "ff", "fula" },
            { "fi", "finna" },
            { "fj", "fiĝia" },
            { "fo", "feroa" },
            { "fr", "franca" },
            { "fy", "okcident-frisa" },
            { "ga", "irlanda" },
            { "gd", "skot-gaela" },
            { "gl", "galega" },
            { "gn", "gvarania" },
            { "gu", metaValue_gu },
            { "gv", "manksa" },
            { "ha", "haŭsa" },
            { "he", metaValue_he },
            { "hi", "hindia" },
            { "hr", "kroata" },
            { "ht", "haitia kreola" },
            { "hu", "hungara" },
            { "hy", metaValue_hy },
            { "hz", "herera" },
            { "ia", "Interlingvao" },
            { "id", "indonezia" },
            { "ie", "Interlingveo" },
            { "ig", "igba" },
            { "ii", metaValue_ii },
            { "ik", "injupiaka" },
            { "io", "Ido" },
            { "is", "islanda" },
            { "it", "itala" },
            { "iu", "inuktituta" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "ki", "kikuja" },
            { "kj", "kuanjama" },
            { "kk", "kazaĥa" },
            { "kl", "gronlanda" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanura" },
            { "ks", "kaŝmira" },
            { "ku", "kurmanĉa" },
            { "kv", "komia" },
            { "kw", "kornvala" },
            { "ky", "kirgiza" },
            { "la", "Latino" },
            { "lb", "luksemburga" },
            { "lg", "ganda" },
            { "li", "limburga" },
            { "ln", "lingala" },
            { "lo", metaValue_lo },
            { "lt", "litova" },
            { "lu", "katanga-luba" },
            { "lv", "latva" },
            { "mg", "malagasa" },
            { "mh", "marŝala" },
            { "mi", "maoria" },
            { "mk", "makedona" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marata" },
            { "ms", "malaja" },
            { "mt", "malta" },
            { "my", metaValue_my },
            { "na", "naura" },
            { "nb", "dannorvega" },
            { "nd", "nord-matabela" },
            { "ne", "nepala" },
            { "ng", "ndonga" },
            { "nl", "nederlanda" },
            { "nn", "novnorvega" },
            { "no", "norvega" },
            { "nr", "sud-matabela" },
            { "nv", "navaha" },
            { "ny", "njanĝa" },
            { "oc", "okcitana" },
            { "om", "oroma" },
            { "or", "Orijo" },
            { "os", "oseta" },
            { "pa", "panĝaba" },
            { "pi", "palia" },
            { "pl", "pola" },
            { "ps", "paŝtua" },
            { "pt", "portugala" },
            { "qu", "keĉua" },
            { "rm", "romanĉa" },
            { "rn", "burunda" },
            { "ro", "rumana" },
            { "ru", "rusa" },
            { "rw", "ruanda" },
            { "sa", "Sanskrito" },
            { "sc", "sarda" },
            { "sd", "sinda" },
            { "se", "nord-samea" },
            { "sg", "sangoa" },
            { "sh", "serbokroata" },
            { "si", metaValue_si },
            { "sk", "slovaka" },
            { "sl", "slovena" },
            { "sm", "samoa" },
            { "sn", "ŝona" },
            { "so", "somala" },
            { "sq", "albana" },
            { "sr", "serba" },
            { "ss", "svazia" },
            { "st", "sota" },
            { "su", metaValue_su },
            { "sv", "sveda" },
            { "sw", "svahila" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "taĝika" },
            { "th", metaValue_th },
            { "ti", "tigraja" },
            { "tk", "turkmena" },
            { "tl", "tagaloga" },
            { "tn", "cvana" },
            { "to", "tonga" },
            { "tr", "turka" },
            { "ts", "conga" },
            { "tt", "tatara" },
            { "ty", "tahitia" },
            { "ug", "ujgura" },
            { "uk", "ukraina" },
            { "ur", "Urduo" },
            { "uz", "uzbeka" },
            { "ve", "vendaa" },
            { "vi", "vjetnama" },
            { "vo", "Volapuko" },
            { "wa", "valona" },
            { "wo", "volofa" },
            { "xh", "ksosa" },
            { "yi", "judgermana" },
            { "yo", "joruba" },
            { "za", "ĝuanga" },
            { "zh", metaValue_zh },
            { "zu", "zulua" },
            { "ace", "aĉea" },
            { "ada", "dangba" },
            { "ady", "adigea" },
            { "ain", "ajnua" },
            { "ale", "aleuta" },
            { "alt", "sud-altaja" },
            { "anp", "angika" },
            { "apc", "araba levantenia" },
            { "arn", "mapuĉa" },
            { "arp", "arapaha" },
            { "ars", "araba naĝda" },
            { "ast", "astura" },
            { "atj", "atikameka" },
            { "awa", "avadhia" },
            { "bal", "baluĉa" },
            { "ban", "balia" },
            { "bas", "basaa" },
            { "bem", "bemba" },
            { "bew", "batavia" },
            { "bez", "benaa" },
            { "bgc", "harjana" },
            { "bho", "boĝpura" },
            { "bin", "edoa" },
            { "bla", "nigrapieda" },
            { "blo", "aniia" },
            { "bqi", "baĥtiara" },
            { "brx", "bodoa" },
            { "bua", "burjata" },
            { "bug", "buĝia" },
            { "byn", "bilena" },
            { "cay", "kajuga" },
            { "ccp", metaValue_ccp },
            { "ceb", "cebua" },
            { "cgg", "kigaa" },
            { "chk", "ĉuuka" },
            { "chm", "maria" },
            { "cho", "ĉaktaa" },
            { "chp", "ĉipevajana" },
            { "chr", metaValue_chr },
            { "chy", "ĉejena" },
            { "ckb", "kurda centra" },
            { "clc", "ĉilkotina" },
            { "cop", "kopta" },
            { "crg", "miĉifa" },
            { "crj", "kria jakob-golfa suda" },
            { "crk", "kria preria" },
            { "crl", "kria jakob-golfa norda" },
            { "crm", "kria alka" },
            { "crr", "algonkena (Norda Karolino)" },
            { "csw", "kria marĉa" },
            { "dak", "dakota" },
            { "dar", "dargva" },
            { "dav", "taitaa" },
            { "dgr", "dogriba" },
            { "dje", "zarmaa" },
            { "doi", "dogra" },
            { "dsb", "malsuprasoraba" },
            { "dua", "dualaa" },
            { "dyo", "djola" },
            { "dzg", "dazaa" },
            { "ebu", "embua" },
            { "efi", "efika" },
            { "eka", "ekaĝuka" },
            { "ewo", "eunda" },
            { "fil", "filipina" },
            { "fon", "fonua" },
            { "frc", "kaĵun-franca" },
            { "frr", "nord-frisa" },
            { "fur", "friula" },
            { "gez", "geeza" },
            { "gil", "kiribata" },
            { "gor", "gorontala" },
            { "gsw", "svisgermana" },
            { "guz", "gusia" },
            { "gwi", "gviĉina" },
            { "hai", "haida" },
            { "haw", "havaja" },
            { "hax", "sud-haida" },
            { "hil", "hiligajnona" },
            { "hmn", "hmonga" },
            { "hnj", "verd-hmonga" },
            { "hsb", "suprasoraba" },
            { "hup", "hupa" },
            { "hur", "halkomelema" },
            { "iba", "ibana" },
            { "ibb", "ibibia" },
            { "ikt", "inuvialuktuna" },
            { "ilo", "iloka" },
            { "inh", "inguŝa" },
            { "jbo", "Loĵbano" },
            { "jmc", "ĉaga (Kimaĉame)" },
            { "kaa", "karakalpaka" },
            { "kab", "kabila" },
            { "kac", "kaĉina" },
            { "kam", "kambaa" },
            { "kbd", "kabarda" },
            { "kde", "makonda" },
            { "kea", "kaboverda kreola" },
            { "kek", "kekĉia" },
            { "kfo", "malinka (Koro)" },
            { "kgp", "kainganga" },
            { "kln", "kalenĝina" },
            { "kmb", "kimbunda" },
            { "kok", "konkana" },
            { "kpe", "kpelea" },
            { "krc", "karaĉaj-balkara" },
            { "krl", "karela" },
            { "kru", "kuruksa" },
            { "ksb", "ŝambaa" },
            { "ksh", "kolonja" },
            { "kum", "kumika" },
            { "lad", "judhispana" },
            { "lag", "rangia" },
            { "lez", "lezga" },
            { "lij", "ligura" },
            { "lil", "lilueta" },
            { "lkt", "lakota" },
            { "lld", "ladina" },
            { "lmo", "lombarda" },
            { "lou", "luiziana kreola" },
            { "loz", "lozia" },
            { "lrc", "nord-lura" },
            { "ltg", "latgala" },
            { "lua", "kasaja-luba" },
            { "lun", "lundaa" },
            { "luo", "lua" },
            { "luy", "luhia" },
            { "lzz", "laza" },
            { "mad", "madura" },
            { "mag", "magaha" },
            { "mai", "majtila" },
            { "mak", "makasara" },
            { "mas", "masaja" },
            { "mdf", "mokŝa" },
            { "men", "mendea" },
            { "mer", "merua" },
            { "mfe", "maŭricia kreola" },
            { "mgh", "makua (Meetto)" },
            { "mic", "mikmaka" },
            { "min", "minankabaŭa" },
            { "mni", metaValue_mni },
            { "moe", "inua" },
            { "moh", "mohoka" },
            { "mos", "mosia" },
            { "mua", "mundanga" },
            { "mul", "pluraj lingvoj" },
            { "mus", "krika" },
            { "mwl", "miranda" },
            { "mww", "blank-hmonga" },
            { "myv", "erzja" },
            { "mzn", "mazandarana" },
            { "nap", "napola" },
            { "naq", "nama" },
            { "nds", "platgermana" },
            { "new", "nevara" },
            { "nia", "niasa" },
            { "niu", "niua" },
            { "nog", "nogaja" },
            { "nqo", metaValue_nqo },
            { "nso", "nord-sota" },
            { "nus", "nuera" },
            { "nyn", "njankora" },
            { "ojb", "oĝibva nordokcidenta" },
            { "ojc", "oĝibva centra" },
            { "ojw", "oĝibva okcidenta" },
            { "oka", "okanagana" },
            { "pag", "pangasina" },
            { "pam", "pampanga" },
            { "pap", "Papiamento" },
            { "pau", "palaŭa" },
            { "pcm", "niĝeria piĝino" },
            { "pis", "Piĵino" },
            { "pms", "piemonta" },
            { "prg", "prusa" },
            { "quc", "kiĉea" },
            { "raj", "raĝastana" },
            { "rap", "rapanuia" },
            { "rar", "maoria kukinsula" },
            { "rhg", "rohinĝa" },
            { "rif", "rifa" },
            { "rof", "ĉaga (Kirombo)" },
            { "rup", "arumana" },
            { "rwk", "ĉaga (Rwa)" },
            { "sad", "sandavea" },
            { "sah", "jakuta" },
            { "saq", "samburua" },
            { "sat", "santala" },
            { "sba", "gambaja" },
            { "sbp", "sangua" },
            { "scn", "sicilia" },
            { "sco", "skota" },
            { "sdh", "sud-kurda" },
            { "sgs", "ĵemajtia" },
            { "shi", "ŝelha" },
            { "shn", "ŝana" },
            { "sid", "sidama" },
            { "skr", "saraika" },
            { "slh", "sud-laŝucida" },
            { "sma", "sud-samea" },
            { "smj", "lule-samea" },
            { "smn", "anar-samea" },
            { "sms", "skolt-samea" },
            { "snk", "soninka" },
            { "srn", "surinama" },
            { "ssy", "saha" },
            { "str", "saliŝa nord-markola" },
            { "suk", "sukuma" },
            { "swb", "komora" },
            { "syr", metaValue_syr },
            { "szl", "silezi-pola" },
            { "tce", "sud-tuĉona" },
            { "tem", "temna" },
            { "teo", "tesa" },
            { "tet", "tetuna" },
            { "tgx", "tagiŝa" },
            { "tht", "taltana" },
            { "tig", "tigrea" },
            { "tlh", "klingona" },
            { "tli", "tlingita" },
            { "tok", "Tokipono" },
            { "tpi", "Tokpisino" },
            { "trv", "sedeka" },
            { "trw", "torvalia" },
            { "ttm", "nord-tuĉona" },
            { "tum", "tumbuka" },
            { "tvl", "tuvala" },
            { "tyv", "tuva" },
            { "tzm", "tamaziĥta mez-atlasa" },
            { "udm", "udmurta" },
            { "umb", "ovimbunda" },
            { "und", "nekonata lingvo" },
            { "vai", metaValue_vai },
            { "vec", "venecia" },
            { "vmw", "makua" },
            { "vun", "ĉaga (Kivunjo)" },
            { "wae", "germana valza" },
            { "wal", "velajtaa" },
            { "war", "varaja" },
            { "wuu", "vua" },
            { "xal", "kalmuka" },
            { "xnr", "kangra" },
            { "yrl", "nengatua" },
            { "yue", "kantona" },
            { "zgh", "tamaziĥta maroka norma" },
            { "zun", "zunjia" },
            { "zxx", "nelingvaĵo" },
            { "zza", "zazaa" },
            { "Adlm", "adlam" },
            { "Arab", metaValue_ar },
            { "Aran", "nastalika" },
            { "Armn", metaValue_hy },
            { "Beng", metaValue_bn },
            { "Bopo", "bopomofo" },
            { "Brai", "brajlo" },
            { "Cakm", metaValue_ccp },
            { "Cans", "unuecigita indiĝen-kanadana silabaro" },
            { "Cher", metaValue_chr },
            { "Cyrl", "cirila" },
            { "Deva", "devanagara" },
            { "Ethi", "etiopa" },
            { "Geor", metaValue_ka },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmuka" },
            { "Hanb", "ĉina kun bopomofo" },
            { "Hang", "hangulo" },
            { "Hani", metaValue_zh },
            { "Hans", "simpligita" },
            { "Hant", "tradicia" },
            { "Hebr", metaValue_he },
            { "Hira", "rondaj kanaoj" },
            { "Hrkt", "japanaj silabaroj" },
            { "Jamo", "jamo" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Kana", "strekaj kanaoj" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latn", "latina" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Mtei", metaValue_mni },
            { "Mymr", metaValue_my },
            { "Nkoo", metaValue_nqo },
            { "Orya", "orija" },
            { "Rohg", "hanifi" },
            { "Sinh", metaValue_si },
            { "Sund", metaValue_su },
            { "Syrc", metaValue_syr },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Thaa", metaValue_dv },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Vaii", metaValue_vai },
            { "Yiii", metaValue_ii },
            { "Zmth", "matematika notacio" },
            { "Zsye", "miensimboloj" },
            { "Zsym", "simboloj" },
            { "Zxxx", "neskribata" },
            { "Zyyy", "nedifinita" },
            { "Zzzz", "nekonata skribsistemo" },
            { "de_AT", "germana aŭstra" },
            { "de_CH", "germana svisa" },
            { "en_AU", "angla aŭstralia" },
            { "en_CA", "angla kanada" },
            { "en_GB", "angla brita" },
            { "en_US", "angla usona" },
            { "es_ES", "hispana eŭropa" },
            { "es_MX", "hispana meksika" },
            { "fr_CA", "franca kanada" },
            { "fr_CH", "franca svisa" },
            { "nl_BE", "flandra" },
            { "pt_BR", "portugala brazila" },
            { "pt_PT", "portugala eŭropa" },
            { "ro_MD", "moldava" },
            { "ar_001", "araba moderna norma" },
            { "es_419", "hispana amerika" },
            { "key.ca", "kalendaro" },
            { "key.cf", "formo de valuto" },
            { "key.co", "ordigo" },
            { "key.cu", "valuto" },
            { "key.em", "vidigo de miensimboloj" },
            { "key.hc", "horloĝa sistemo (12- aŭ 24-hora)" },
            { "key.lb", "stilo de linisalto" },
            { "key.lw", "linisalto ene vortoj" },
            { "key.ms", "mezur-sistemo" },
            { "key.nu", "ciferoj" },
            { "key.ss", "frazfino post mallongigo" },
            { "hi_Latn", "hindia (latina)" },
            { "zh_Hans", "ĉina simpligita" },
            { "zh_Hant", "ĉina tradicia" },
            { "%%ARKAIKA", "Arkaika" },
            { "%%HSISTEMO", "h-sistemo" },
            { "%%XSISTEMO", "x-sistemo" },
            { "type.ca.roc", "kalendaro de Respubliko Ĉinujo" },
            { "type.hc.h11", "12-hora sistemo (0–11)" },
            { "type.hc.h12", "12-hora sistemo (1–12)" },
            { "type.hc.h23", "24-hora sistemo (0–23)" },
            { "type.hc.h24", "24-hora sistemo (1–24)" },
            { "type.nu.arab", "hind-arabaj ciferoj" },
            { "type.nu.armn", "armenaj ciferoj" },
            { "type.nu.beng", "bengalaj ciferoj" },
            { "type.nu.cakm", "ĉakmaj ciferoj" },
            { "type.nu.deva", "devanagaraj ciferoj" },
            { "type.nu.ethi", "etiopaj ciferoj" },
            { "type.nu.geor", "kartvelaj ciferoj" },
            { "type.nu.grek", "grekaj ciferoj" },
            { "type.nu.gujr", "guĝarataj ciferoj" },
            { "type.nu.guru", "gurmukaj ciferoj" },
            { "type.nu.hans", "simpligit-ĉinaj ciferoj" },
            { "type.nu.hant", "tradici-ĉinaj ciferoj" },
            { "type.nu.hebr", "hebreaj ciferoj" },
            { "type.nu.java", "javaj ciferoj" },
            { "type.nu.jpan", "japanaj ciferoj" },
            { "type.nu.khmr", "kmeraj ciferoj" },
            { "type.nu.knda", "kanaraj ciferoj" },
            { "type.nu.laoo", "laŭaj ciferoj" },
            { "type.nu.latn", "eŭropaj ciferoj" },
            { "type.nu.mlym", "malajalamaj ciferoj" },
            { "type.nu.mtei", "manipuraj ciferoj" },
            { "type.nu.mymr", "birmaj ciferoj" },
            { "type.nu.orya", "orijaj ciferoj" },
            { "type.nu.taml", "tamilaj tradiciaj ciferoj" },
            { "type.nu.telu", "teluguaj ciferoj" },
            { "type.nu.thai", "tajaj ciferoj" },
            { "type.nu.tibt", "tibetaj ciferoj" },
            { "type.nu.vaii", "vajaj ciferoj" },
            { "type.ca.dangi", "korea kalendaro" },
            { "type.co.ducet", "norma ordigo laŭ Unikodo" },
            { "type.lb.loose", "milda stilo de linisalto" },
            { "type.nu.roman", "romaj ciferoj" },
            { "type.ca.coptic", "kopta kalendaro" },
            { "type.ca.hebrew", "juda kalendaro" },
            { "type.co.search", "ĝeneral-uza serĉo" },
            { "type.lb.normal", "norma stilo de linisalto" },
            { "type.lb.strict", "malmilda stilo de linisalto" },
            { "type.ms.metric", "metra sistemo" },
            { "type.ca.chinese", "ĉina kalendaro" },
            { "type.ca.islamic", "islama kalendaro" },
            { "type.ca.iso8601", "gregoria kalendaro (jaro unue)" },
            { "type.ca.persian", "persa kalendaro" },
            { "type.cf.account", "kontista formo de valuto" },
            { "type.nu.arabext", "hind-arabaj ciferoj etenditaj" },
            { "type.nu.armnlow", "armenaj ciferoj minusklaj" },
            { "type.nu.greklow", "grekaj ciferoj minusklaj" },
            { "type.nu.hanidec", "ĉinaj dekumaj ciferoj" },
            { "type.nu.hansfin", "simpligit-ĉinaj financaj ciferoj" },
            { "type.nu.hantfin", "tradic-ĉinaj financaj ciferoj" },
            { "type.nu.jpanfin", "japanaj financaj ciferoj" },
            { "type.nu.tamldec", "tamilaj ciferoj" },
            { "type.ca.buddhist", "budaisma kalendaro" },
            { "type.ca.ethiopic", "etiopa kalendaro" },
            { "type.ca.japanese", "japana kalendaro" },
            { "type.cf.standard", "norma formo de valuto" },
            { "type.co.standard", "norma ordigo" },
            { "type.ms.uksystem", "brita mezur-sistemo" },
            { "type.ms.ussystem", "usona mezur-sistemo" },
            { "type.nu.fullwide", "ciferoj plenlarĝaj" },
            { "type.nu.romanlow", "romaj ciferoj minusklaj" },
            { "type.ca.gregorian", "gregoria kalendaro" },
            { "type.ca.islamic-civil", "tabela islama kalendaro" },
            { "type.ca.islamic-umalqura", "islama kalendaro (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "etiopa kalendaro (Amete Alem)" },
        };
        return data;
    }
}
