// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package controlcatalog

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opListCommonControls = "ListCommonControls"

// ListCommonControlsRequest generates a "aws/request.Request" representing the
// client's request for the ListCommonControls operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCommonControls for more information on using the ListCommonControls
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCommonControlsRequest method.
//	req, resp := client.ListCommonControlsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/controlcatalog-2018-05-10/ListCommonControls
func (c *ControlCatalog) ListCommonControlsRequest(input *ListCommonControlsInput) (req *request.Request, output *ListCommonControlsOutput) {
	op := &request.Operation{
		Name:       opListCommonControls,
		HTTPMethod: "POST",
		HTTPPath:   "/common-controls",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCommonControlsInput{}
	}

	output = &ListCommonControlsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCommonControls API operation for AWS Control Catalog.
//
// Returns a paginated list of common controls from the Amazon Web Services
// Control Catalog.
//
// You can apply an optional filter to see common controls that have a specific
// objective. If you don’t provide a filter, the operation returns all common
// controls.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Control Catalog's
// API operation ListCommonControls for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     An internal service error occurred during the processing of your request.
//     Try again later.
//
//   - ValidationException
//     The request has invalid or missing parameters.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/controlcatalog-2018-05-10/ListCommonControls
func (c *ControlCatalog) ListCommonControls(input *ListCommonControlsInput) (*ListCommonControlsOutput, error) {
	req, out := c.ListCommonControlsRequest(input)
	return out, req.Send()
}

// ListCommonControlsWithContext is the same as ListCommonControls with the addition of
// the ability to pass a context and additional request options.
//
// See ListCommonControls for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ControlCatalog) ListCommonControlsWithContext(ctx aws.Context, input *ListCommonControlsInput, opts ...request.Option) (*ListCommonControlsOutput, error) {
	req, out := c.ListCommonControlsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCommonControlsPages iterates over the pages of a ListCommonControls operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCommonControls method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCommonControls operation.
//	pageNum := 0
//	err := client.ListCommonControlsPages(params,
//	    func(page *controlcatalog.ListCommonControlsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ControlCatalog) ListCommonControlsPages(input *ListCommonControlsInput, fn func(*ListCommonControlsOutput, bool) bool) error {
	return c.ListCommonControlsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCommonControlsPagesWithContext same as ListCommonControlsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ControlCatalog) ListCommonControlsPagesWithContext(ctx aws.Context, input *ListCommonControlsInput, fn func(*ListCommonControlsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCommonControlsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCommonControlsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCommonControlsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDomains = "ListDomains"

// ListDomainsRequest generates a "aws/request.Request" representing the
// client's request for the ListDomains operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDomains for more information on using the ListDomains
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDomainsRequest method.
//	req, resp := client.ListDomainsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/controlcatalog-2018-05-10/ListDomains
func (c *ControlCatalog) ListDomainsRequest(input *ListDomainsInput) (req *request.Request, output *ListDomainsOutput) {
	op := &request.Operation{
		Name:       opListDomains,
		HTTPMethod: "POST",
		HTTPPath:   "/domains",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDomainsInput{}
	}

	output = &ListDomainsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDomains API operation for AWS Control Catalog.
//
// Returns a paginated list of domains from the Amazon Web Services Control
// Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Control Catalog's
// API operation ListDomains for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     An internal service error occurred during the processing of your request.
//     Try again later.
//
//   - ValidationException
//     The request has invalid or missing parameters.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/controlcatalog-2018-05-10/ListDomains
func (c *ControlCatalog) ListDomains(input *ListDomainsInput) (*ListDomainsOutput, error) {
	req, out := c.ListDomainsRequest(input)
	return out, req.Send()
}

// ListDomainsWithContext is the same as ListDomains with the addition of
// the ability to pass a context and additional request options.
//
// See ListDomains for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ControlCatalog) ListDomainsWithContext(ctx aws.Context, input *ListDomainsInput, opts ...request.Option) (*ListDomainsOutput, error) {
	req, out := c.ListDomainsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDomainsPages iterates over the pages of a ListDomains operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDomains method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDomains operation.
//	pageNum := 0
//	err := client.ListDomainsPages(params,
//	    func(page *controlcatalog.ListDomainsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ControlCatalog) ListDomainsPages(input *ListDomainsInput, fn func(*ListDomainsOutput, bool) bool) error {
	return c.ListDomainsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDomainsPagesWithContext same as ListDomainsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ControlCatalog) ListDomainsPagesWithContext(ctx aws.Context, input *ListDomainsInput, fn func(*ListDomainsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDomainsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDomainsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDomainsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListObjectives = "ListObjectives"

// ListObjectivesRequest generates a "aws/request.Request" representing the
// client's request for the ListObjectives operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListObjectives for more information on using the ListObjectives
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListObjectivesRequest method.
//	req, resp := client.ListObjectivesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/controlcatalog-2018-05-10/ListObjectives
func (c *ControlCatalog) ListObjectivesRequest(input *ListObjectivesInput) (req *request.Request, output *ListObjectivesOutput) {
	op := &request.Operation{
		Name:       opListObjectives,
		HTTPMethod: "POST",
		HTTPPath:   "/objectives",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListObjectivesInput{}
	}

	output = &ListObjectivesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListObjectives API operation for AWS Control Catalog.
//
// Returns a paginated list of objectives from the Amazon Web Services Control
// Catalog.
//
// You can apply an optional filter to see the objectives that belong to a specific
// domain. If you don’t provide a filter, the operation returns all objectives.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Control Catalog's
// API operation ListObjectives for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - InternalServerException
//     An internal service error occurred during the processing of your request.
//     Try again later.
//
//   - ValidationException
//     The request has invalid or missing parameters.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/controlcatalog-2018-05-10/ListObjectives
func (c *ControlCatalog) ListObjectives(input *ListObjectivesInput) (*ListObjectivesOutput, error) {
	req, out := c.ListObjectivesRequest(input)
	return out, req.Send()
}

// ListObjectivesWithContext is the same as ListObjectives with the addition of
// the ability to pass a context and additional request options.
//
// See ListObjectives for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ControlCatalog) ListObjectivesWithContext(ctx aws.Context, input *ListObjectivesInput, opts ...request.Option) (*ListObjectivesOutput, error) {
	req, out := c.ListObjectivesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListObjectivesPages iterates over the pages of a ListObjectives operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListObjectives method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListObjectives operation.
//	pageNum := 0
//	err := client.ListObjectivesPages(params,
//	    func(page *controlcatalog.ListObjectivesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ControlCatalog) ListObjectivesPages(input *ListObjectivesInput, fn func(*ListObjectivesOutput, bool) bool) error {
	return c.ListObjectivesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListObjectivesPagesWithContext same as ListObjectivesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ControlCatalog) ListObjectivesPagesWithContext(ctx aws.Context, input *ListObjectivesInput, fn func(*ListObjectivesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListObjectivesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListObjectivesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListObjectivesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A summary of the domain that a common control or an objective belongs to.
type AssociatedDomainSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the related domain.
	Arn *string `min:"33" type:"string"`

	// The name of the related domain.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatedDomainSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatedDomainSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AssociatedDomainSummary) SetArn(v string) *AssociatedDomainSummary {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssociatedDomainSummary) SetName(v string) *AssociatedDomainSummary {
	s.Name = &v
	return s
}

// A summary of the objective that a common control supports.
type AssociatedObjectiveSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the related objective.
	Arn *string `min:"36" type:"string"`

	// The name of the related objective.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatedObjectiveSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatedObjectiveSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AssociatedObjectiveSummary) SetArn(v string) *AssociatedObjectiveSummary {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssociatedObjectiveSummary) SetName(v string) *AssociatedObjectiveSummary {
	s.Name = &v
	return s
}

// An optional filter that narrows the results to a specific objective.
type CommonControlFilter struct {
	_ struct{} `type:"structure"`

	// The objective that's used as filter criteria.
	//
	// You can use this parameter to specify one objective ARN at a time. Passing
	// multiple ARNs in the CommonControlFilter isn’t currently supported.
	Objectives []*ObjectiveResourceFilter `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CommonControlFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CommonControlFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CommonControlFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CommonControlFilter"}
	if s.Objectives != nil {
		for i, v := range s.Objectives {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Objectives", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObjectives sets the Objectives field's value.
func (s *CommonControlFilter) SetObjectives(v []*ObjectiveResourceFilter) *CommonControlFilter {
	s.Objectives = v
	return s
}

// A summary of metadata for a common control.
type CommonControlSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the common control.
	//
	// Arn is a required field
	Arn *string `min:"41" type:"string" required:"true"`

	// The time when the common control was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" required:"true"`

	// The description of the common control.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The domain that the common control belongs to.
	//
	// Domain is a required field
	Domain *AssociatedDomainSummary `type:"structure" required:"true"`

	// The time when the common control was most recently updated.
	//
	// LastUpdateTime is a required field
	LastUpdateTime *time.Time `type:"timestamp" required:"true"`

	// The name of the common control.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The objective that the common control belongs to.
	//
	// Objective is a required field
	Objective *AssociatedObjectiveSummary `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CommonControlSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CommonControlSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CommonControlSummary) SetArn(v string) *CommonControlSummary {
	s.Arn = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *CommonControlSummary) SetCreateTime(v time.Time) *CommonControlSummary {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CommonControlSummary) SetDescription(v string) *CommonControlSummary {
	s.Description = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *CommonControlSummary) SetDomain(v *AssociatedDomainSummary) *CommonControlSummary {
	s.Domain = v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *CommonControlSummary) SetLastUpdateTime(v time.Time) *CommonControlSummary {
	s.LastUpdateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *CommonControlSummary) SetName(v string) *CommonControlSummary {
	s.Name = &v
	return s
}

// SetObjective sets the Objective field's value.
func (s *CommonControlSummary) SetObjective(v *AssociatedObjectiveSummary) *CommonControlSummary {
	s.Objective = v
	return s
}

// The domain resource that's being used as a filter.
type DomainResourceFilter struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the domain.
	Arn *string `min:"33" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainResourceFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainResourceFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DomainResourceFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DomainResourceFilter"}
	if s.Arn != nil && len(*s.Arn) < 33 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 33))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DomainResourceFilter) SetArn(v string) *DomainResourceFilter {
	s.Arn = &v
	return s
}

// A summary of metadata for a domain.
type DomainSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the domain.
	//
	// Arn is a required field
	Arn *string `min:"33" type:"string" required:"true"`

	// The time when the domain was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" required:"true"`

	// The description of the domain.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The time when the domain was most recently updated.
	//
	// LastUpdateTime is a required field
	LastUpdateTime *time.Time `type:"timestamp" required:"true"`

	// The name of the domain.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DomainSummary) SetArn(v string) *DomainSummary {
	s.Arn = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *DomainSummary) SetCreateTime(v time.Time) *DomainSummary {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DomainSummary) SetDescription(v string) *DomainSummary {
	s.Description = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *DomainSummary) SetLastUpdateTime(v time.Time) *DomainSummary {
	s.LastUpdateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DomainSummary) SetName(v string) *DomainSummary {
	s.Name = &v
	return s
}

// An internal service error occurred during the processing of your request.
// Try again later.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListCommonControlsInput struct {
	_ struct{} `type:"structure"`

	// An optional filter that narrows the results to a specific objective.
	//
	// This filter allows you to specify one objective ARN at a time. Passing multiple
	// ARNs in the CommonControlFilter isn’t currently supported.
	CommonControlFilter *CommonControlFilter `type:"structure"`

	// The maximum number of results on a page or for an API request call.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCommonControlsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCommonControlsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCommonControlsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCommonControlsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.CommonControlFilter != nil {
		if err := s.CommonControlFilter.Validate(); err != nil {
			invalidParams.AddNested("CommonControlFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommonControlFilter sets the CommonControlFilter field's value.
func (s *ListCommonControlsInput) SetCommonControlFilter(v *CommonControlFilter) *ListCommonControlsInput {
	s.CommonControlFilter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCommonControlsInput) SetMaxResults(v int64) *ListCommonControlsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCommonControlsInput) SetNextToken(v string) *ListCommonControlsInput {
	s.NextToken = &v
	return s
}

type ListCommonControlsOutput struct {
	_ struct{} `type:"structure"`

	// The list of common controls that the ListCommonControls API returns.
	//
	// CommonControls is a required field
	CommonControls []*CommonControlSummary `type:"list" required:"true"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCommonControlsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCommonControlsOutput) GoString() string {
	return s.String()
}

// SetCommonControls sets the CommonControls field's value.
func (s *ListCommonControlsOutput) SetCommonControls(v []*CommonControlSummary) *ListCommonControlsOutput {
	s.CommonControls = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCommonControlsOutput) SetNextToken(v string) *ListCommonControlsOutput {
	s.NextToken = &v
	return s
}

type ListDomainsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results on a page or for an API request call.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDomainsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDomainsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDomainsInput) SetMaxResults(v int64) *ListDomainsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDomainsInput) SetNextToken(v string) *ListDomainsInput {
	s.NextToken = &v
	return s
}

type ListDomainsOutput struct {
	_ struct{} `type:"structure"`

	// The list of domains that the ListDomains API returns.
	//
	// Domains is a required field
	Domains []*DomainSummary `type:"list" required:"true"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDomainsOutput) GoString() string {
	return s.String()
}

// SetDomains sets the Domains field's value.
func (s *ListDomainsOutput) SetDomains(v []*DomainSummary) *ListDomainsOutput {
	s.Domains = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDomainsOutput) SetNextToken(v string) *ListDomainsOutput {
	s.NextToken = &v
	return s
}

type ListObjectivesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results on a page or for an API request call.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// An optional filter that narrows the results to a specific domain.
	//
	// This filter allows you to specify one domain ARN at a time. Passing multiple
	// ARNs in the ObjectiveFilter isn’t currently supported.
	ObjectiveFilter *ObjectiveFilter `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListObjectivesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListObjectivesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListObjectivesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListObjectivesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ObjectiveFilter != nil {
		if err := s.ObjectiveFilter.Validate(); err != nil {
			invalidParams.AddNested("ObjectiveFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListObjectivesInput) SetMaxResults(v int64) *ListObjectivesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListObjectivesInput) SetNextToken(v string) *ListObjectivesInput {
	s.NextToken = &v
	return s
}

// SetObjectiveFilter sets the ObjectiveFilter field's value.
func (s *ListObjectivesInput) SetObjectiveFilter(v *ObjectiveFilter) *ListObjectivesInput {
	s.ObjectiveFilter = v
	return s
}

type ListObjectivesOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token that's used to fetch the next set of results.
	NextToken *string `type:"string"`

	// The list of objectives that the ListObjectives API returns.
	//
	// Objectives is a required field
	Objectives []*ObjectiveSummary `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListObjectivesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListObjectivesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListObjectivesOutput) SetNextToken(v string) *ListObjectivesOutput {
	s.NextToken = &v
	return s
}

// SetObjectives sets the Objectives field's value.
func (s *ListObjectivesOutput) SetObjectives(v []*ObjectiveSummary) *ListObjectivesOutput {
	s.Objectives = v
	return s
}

// An optional filter that narrows the list of objectives to a specific domain.
type ObjectiveFilter struct {
	_ struct{} `type:"structure"`

	// The domain that's used as filter criteria.
	//
	// You can use this parameter to specify one domain ARN at a time. Passing multiple
	// ARNs in the ObjectiveFilter isn’t currently supported.
	Domains []*DomainResourceFilter `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ObjectiveFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ObjectiveFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ObjectiveFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ObjectiveFilter"}
	if s.Domains != nil {
		for i, v := range s.Domains {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Domains", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomains sets the Domains field's value.
func (s *ObjectiveFilter) SetDomains(v []*DomainResourceFilter) *ObjectiveFilter {
	s.Domains = v
	return s
}

// The objective resource that's being used as a filter.
type ObjectiveResourceFilter struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the objective.
	Arn *string `min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ObjectiveResourceFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ObjectiveResourceFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ObjectiveResourceFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ObjectiveResourceFilter"}
	if s.Arn != nil && len(*s.Arn) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ObjectiveResourceFilter) SetArn(v string) *ObjectiveResourceFilter {
	s.Arn = &v
	return s
}

// A summary of metadata for an objective.
type ObjectiveSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the objective.
	//
	// Arn is a required field
	Arn *string `min:"36" type:"string" required:"true"`

	// The time when the objective was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" required:"true"`

	// The description of the objective.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The domain that the objective belongs to.
	//
	// Domain is a required field
	Domain *AssociatedDomainSummary `type:"structure" required:"true"`

	// The time when the objective was most recently updated.
	//
	// LastUpdateTime is a required field
	LastUpdateTime *time.Time `type:"timestamp" required:"true"`

	// The name of the objective.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ObjectiveSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ObjectiveSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ObjectiveSummary) SetArn(v string) *ObjectiveSummary {
	s.Arn = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *ObjectiveSummary) SetCreateTime(v time.Time) *ObjectiveSummary {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ObjectiveSummary) SetDescription(v string) *ObjectiveSummary {
	s.Description = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *ObjectiveSummary) SetDomain(v *AssociatedDomainSummary) *ObjectiveSummary {
	s.Domain = v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *ObjectiveSummary) SetLastUpdateTime(v time.Time) *ObjectiveSummary {
	s.LastUpdateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ObjectiveSummary) SetName(v string) *ObjectiveSummary {
	s.Name = &v
	return s
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request has invalid or missing parameters.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}
