// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package taxsettings

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opBatchDeleteTaxRegistration = "BatchDeleteTaxRegistration"

// BatchDeleteTaxRegistrationRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeleteTaxRegistration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDeleteTaxRegistration for more information on using the BatchDeleteTaxRegistration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchDeleteTaxRegistrationRequest method.
//	req, resp := client.BatchDeleteTaxRegistrationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/BatchDeleteTaxRegistration
func (c *TaxSettings) BatchDeleteTaxRegistrationRequest(input *BatchDeleteTaxRegistrationInput) (req *request.Request, output *BatchDeleteTaxRegistrationOutput) {
	op := &request.Operation{
		Name:       opBatchDeleteTaxRegistration,
		HTTPMethod: "POST",
		HTTPPath:   "/BatchDeleteTaxRegistration",
	}

	if input == nil {
		input = &BatchDeleteTaxRegistrationInput{}
	}

	output = &BatchDeleteTaxRegistrationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDeleteTaxRegistration API operation for Tax Settings.
//
// Deletes tax registration for multiple accounts in batch. This can be used
// to delete tax registrations for up to five accounts in one batch.
//
// This API operation can't be used to delete your tax registration in Brazil.
// Use the Payment preferences (https://console.aws.amazon.com/billing/home#/paymentpreferences/paymentmethods)
// page in the Billing and Cost Management console instead.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Tax Settings's
// API operation BatchDeleteTaxRegistration for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The exception when the input doesn't pass validation for at least one of
//     the input parameters.
//
//   - ConflictException
//     The exception when the input is creating conflict with the given state.
//
//   - InternalServerException
//     The exception thrown when an unexpected error occurs when processing a request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/BatchDeleteTaxRegistration
func (c *TaxSettings) BatchDeleteTaxRegistration(input *BatchDeleteTaxRegistrationInput) (*BatchDeleteTaxRegistrationOutput, error) {
	req, out := c.BatchDeleteTaxRegistrationRequest(input)
	return out, req.Send()
}

// BatchDeleteTaxRegistrationWithContext is the same as BatchDeleteTaxRegistration with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeleteTaxRegistration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TaxSettings) BatchDeleteTaxRegistrationWithContext(ctx aws.Context, input *BatchDeleteTaxRegistrationInput, opts ...request.Option) (*BatchDeleteTaxRegistrationOutput, error) {
	req, out := c.BatchDeleteTaxRegistrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchPutTaxRegistration = "BatchPutTaxRegistration"

// BatchPutTaxRegistrationRequest generates a "aws/request.Request" representing the
// client's request for the BatchPutTaxRegistration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchPutTaxRegistration for more information on using the BatchPutTaxRegistration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchPutTaxRegistrationRequest method.
//	req, resp := client.BatchPutTaxRegistrationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/BatchPutTaxRegistration
func (c *TaxSettings) BatchPutTaxRegistrationRequest(input *BatchPutTaxRegistrationInput) (req *request.Request, output *BatchPutTaxRegistrationOutput) {
	op := &request.Operation{
		Name:       opBatchPutTaxRegistration,
		HTTPMethod: "POST",
		HTTPPath:   "/BatchPutTaxRegistration",
	}

	if input == nil {
		input = &BatchPutTaxRegistrationInput{}
	}

	output = &BatchPutTaxRegistrationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchPutTaxRegistration API operation for Tax Settings.
//
// Adds or updates tax registration for multiple accounts in batch. This can
// be used to add or update tax registrations for up to five accounts in one
// batch. You can't set a TRN if there's a pending TRN. You'll need to delete
// the pending TRN first.
//
// To call this API operation for specific countries, see the following country-specific
// requirements.
//
// Bangladesh
//
//   - You must specify the tax registration certificate document in the taxRegistrationDocuments
//     field of the VerificationDetails object.
//
// Brazil
//
//   - You must complete the tax registration process in the Payment preferences
//     (https://console.aws.amazon.com/billing/home#/paymentpreferences/paymentmethods)
//     page in the Billing and Cost Management console. After your TRN and billing
//     address are verified, you can call this API operation.
//
//   - For Amazon Web Services accounts created through Organizations, you
//     can call this API operation when you don't have a billing address.
//
// Georgia
//
//   - The valid personType values are Physical Person and Business.
//
// Kenya
//
//   - You must specify the personType in the kenyaAdditionalInfo field of
//     the additionalTaxInformation object.
//
//   - If the personType is Physical Person, you must specify the tax registration
//     certificate document in the taxRegistrationDocuments field of the VerificationDetails
//     object.
//
// Malaysia
//
//   - If you use this operation to set a tax registration number (TRN) in
//     Malaysia, only resellers with a valid sales and service tax (SST) number
//     are required to provide tax registration information.
//
//   - By using this API operation to set a TRN in Malaysia, Amazon Web Services
//     will regard you as self-declaring that you're an authorized business reseller
//     registered with the Royal Malaysia Customs Department (RMCD) and have
//     a valid SST number.
//
//   - Amazon Web Services reserves the right to seek additional information
//     and/or take other actions to support your self-declaration as appropriate.
//
//   - If you're not a reseller of Amazon Web Services, we don't recommend
//     that you use this operation to set the TRN in Malaysia.
//
//   - Only use this API operation to upload the TRNs for accounts through
//     which you're reselling Amazon Web Services.
//
//   - Amazon Web Services is currently registered under the following service
//     tax codes. You must include at least one of the service tax codes in the
//     service tax code strings to declare yourself as an authorized registered
//     business reseller. Taxable service and service tax codes: Consultancy
//
//   - 9907061674 Training or coaching service - 9907071685 IT service - 9907101676
//     Digital services and electronic medium - 9907121690
//
// Nepal
//
//   - The sector valid values are Business and Individual.
//
// Saudi Arabia
//
//   - For address, you must specify addressLine3.
//
// South Korea
//
//   - You must specify the certifiedEmailId and legalName in the TaxRegistrationEntry
//     object. Use Korean characters for legalName.
//
//   - You must specify the businessRepresentativeName, itemOfBusiness, and
//     lineOfBusiness in the southKoreaAdditionalInfo field of the additionalTaxInformation
//     object. Use Korean characters for these fields.
//
//   - You must specify the tax registration certificate document in the taxRegistrationDocuments
//     field of the VerificationDetails object.
//
//   - For the address object, use Korean characters for addressLine1, addressLine2
//     city, postalCode, and stateOrRegion.
//
// Spain
//
//   - You must specify the registrationType in the spainAdditionalInfo field
//     of the additionalTaxInformation object.
//
//   - If the registrationType is Local, you must specify the tax registration
//     certificate document in the taxRegistrationDocuments field of the VerificationDetails
//     object.
//
// Turkey
//
//   - You must specify the sector in the taxRegistrationEntry object.
//
//   - If your sector is Business, Individual, or Government: Specify the taxOffice.
//     If your sector is Individual, don't enter this value. (Optional) Specify
//     the kepEmailId. If your sector is Individual, don't enter this value.
//     Note: In the Tax Settings page of the Billing console, Government appears
//     as Public institutions
//
//   - If your sector is Business and you're subject to KDV tax, you must specify
//     your industry in the industries field.
//
//   - For address, you must specify districtOrCounty.
//
// Ukraine
//
//   - The sector valid values are Business and Individual.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Tax Settings's
// API operation BatchPutTaxRegistration for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The exception when the input doesn't pass validation for at least one of
//     the input parameters.
//
//   - ConflictException
//     The exception when the input is creating conflict with the given state.
//
//   - InternalServerException
//     The exception thrown when an unexpected error occurs when processing a request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/BatchPutTaxRegistration
func (c *TaxSettings) BatchPutTaxRegistration(input *BatchPutTaxRegistrationInput) (*BatchPutTaxRegistrationOutput, error) {
	req, out := c.BatchPutTaxRegistrationRequest(input)
	return out, req.Send()
}

// BatchPutTaxRegistrationWithContext is the same as BatchPutTaxRegistration with the addition of
// the ability to pass a context and additional request options.
//
// See BatchPutTaxRegistration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TaxSettings) BatchPutTaxRegistrationWithContext(ctx aws.Context, input *BatchPutTaxRegistrationInput, opts ...request.Option) (*BatchPutTaxRegistrationOutput, error) {
	req, out := c.BatchPutTaxRegistrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTaxRegistration = "DeleteTaxRegistration"

// DeleteTaxRegistrationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTaxRegistration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTaxRegistration for more information on using the DeleteTaxRegistration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTaxRegistrationRequest method.
//	req, resp := client.DeleteTaxRegistrationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/DeleteTaxRegistration
func (c *TaxSettings) DeleteTaxRegistrationRequest(input *DeleteTaxRegistrationInput) (req *request.Request, output *DeleteTaxRegistrationOutput) {
	op := &request.Operation{
		Name:       opDeleteTaxRegistration,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteTaxRegistration",
	}

	if input == nil {
		input = &DeleteTaxRegistrationInput{}
	}

	output = &DeleteTaxRegistrationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTaxRegistration API operation for Tax Settings.
//
// Deletes tax registration for a single account.
//
// This API operation can't be used to delete your tax registration in Brazil.
// Use the Payment preferences (https://console.aws.amazon.com/billing/home#/paymentpreferences/paymentmethods)
// page in the Billing and Cost Management console instead.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Tax Settings's
// API operation DeleteTaxRegistration for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The exception when the input doesn't pass validation for at least one of
//     the input parameters.
//
//   - ConflictException
//     The exception when the input is creating conflict with the given state.
//
//   - ResourceNotFoundException
//     The exception thrown when the input doesn't have a resource associated to
//     it.
//
//   - InternalServerException
//     The exception thrown when an unexpected error occurs when processing a request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/DeleteTaxRegistration
func (c *TaxSettings) DeleteTaxRegistration(input *DeleteTaxRegistrationInput) (*DeleteTaxRegistrationOutput, error) {
	req, out := c.DeleteTaxRegistrationRequest(input)
	return out, req.Send()
}

// DeleteTaxRegistrationWithContext is the same as DeleteTaxRegistration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTaxRegistration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TaxSettings) DeleteTaxRegistrationWithContext(ctx aws.Context, input *DeleteTaxRegistrationInput, opts ...request.Option) (*DeleteTaxRegistrationOutput, error) {
	req, out := c.DeleteTaxRegistrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTaxRegistration = "GetTaxRegistration"

// GetTaxRegistrationRequest generates a "aws/request.Request" representing the
// client's request for the GetTaxRegistration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTaxRegistration for more information on using the GetTaxRegistration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTaxRegistrationRequest method.
//	req, resp := client.GetTaxRegistrationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/GetTaxRegistration
func (c *TaxSettings) GetTaxRegistrationRequest(input *GetTaxRegistrationInput) (req *request.Request, output *GetTaxRegistrationOutput) {
	op := &request.Operation{
		Name:       opGetTaxRegistration,
		HTTPMethod: "POST",
		HTTPPath:   "/GetTaxRegistration",
	}

	if input == nil {
		input = &GetTaxRegistrationInput{}
	}

	output = &GetTaxRegistrationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTaxRegistration API operation for Tax Settings.
//
// Retrieves tax registration for a single account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Tax Settings's
// API operation GetTaxRegistration for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The exception when the input doesn't pass validation for at least one of
//     the input parameters.
//
//   - ResourceNotFoundException
//     The exception thrown when the input doesn't have a resource associated to
//     it.
//
//   - InternalServerException
//     The exception thrown when an unexpected error occurs when processing a request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/GetTaxRegistration
func (c *TaxSettings) GetTaxRegistration(input *GetTaxRegistrationInput) (*GetTaxRegistrationOutput, error) {
	req, out := c.GetTaxRegistrationRequest(input)
	return out, req.Send()
}

// GetTaxRegistrationWithContext is the same as GetTaxRegistration with the addition of
// the ability to pass a context and additional request options.
//
// See GetTaxRegistration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TaxSettings) GetTaxRegistrationWithContext(ctx aws.Context, input *GetTaxRegistrationInput, opts ...request.Option) (*GetTaxRegistrationOutput, error) {
	req, out := c.GetTaxRegistrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTaxRegistrationDocument = "GetTaxRegistrationDocument"

// GetTaxRegistrationDocumentRequest generates a "aws/request.Request" representing the
// client's request for the GetTaxRegistrationDocument operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTaxRegistrationDocument for more information on using the GetTaxRegistrationDocument
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTaxRegistrationDocumentRequest method.
//	req, resp := client.GetTaxRegistrationDocumentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/GetTaxRegistrationDocument
func (c *TaxSettings) GetTaxRegistrationDocumentRequest(input *GetTaxRegistrationDocumentInput) (req *request.Request, output *GetTaxRegistrationDocumentOutput) {
	op := &request.Operation{
		Name:       opGetTaxRegistrationDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/GetTaxRegistrationDocument",
	}

	if input == nil {
		input = &GetTaxRegistrationDocumentInput{}
	}

	output = &GetTaxRegistrationDocumentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTaxRegistrationDocument API operation for Tax Settings.
//
// Downloads your tax documents to the Amazon S3 bucket that you specify in
// your request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Tax Settings's
// API operation GetTaxRegistrationDocument for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The exception when the input doesn't pass validation for at least one of
//     the input parameters.
//
//   - InternalServerException
//     The exception thrown when an unexpected error occurs when processing a request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/GetTaxRegistrationDocument
func (c *TaxSettings) GetTaxRegistrationDocument(input *GetTaxRegistrationDocumentInput) (*GetTaxRegistrationDocumentOutput, error) {
	req, out := c.GetTaxRegistrationDocumentRequest(input)
	return out, req.Send()
}

// GetTaxRegistrationDocumentWithContext is the same as GetTaxRegistrationDocument with the addition of
// the ability to pass a context and additional request options.
//
// See GetTaxRegistrationDocument for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TaxSettings) GetTaxRegistrationDocumentWithContext(ctx aws.Context, input *GetTaxRegistrationDocumentInput, opts ...request.Option) (*GetTaxRegistrationDocumentOutput, error) {
	req, out := c.GetTaxRegistrationDocumentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTaxRegistrations = "ListTaxRegistrations"

// ListTaxRegistrationsRequest generates a "aws/request.Request" representing the
// client's request for the ListTaxRegistrations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTaxRegistrations for more information on using the ListTaxRegistrations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTaxRegistrationsRequest method.
//	req, resp := client.ListTaxRegistrationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/ListTaxRegistrations
func (c *TaxSettings) ListTaxRegistrationsRequest(input *ListTaxRegistrationsInput) (req *request.Request, output *ListTaxRegistrationsOutput) {
	op := &request.Operation{
		Name:       opListTaxRegistrations,
		HTTPMethod: "POST",
		HTTPPath:   "/ListTaxRegistrations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTaxRegistrationsInput{}
	}

	output = &ListTaxRegistrationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTaxRegistrations API operation for Tax Settings.
//
// Retrieves the tax registration of accounts listed in a consolidated billing
// family. This can be used to retrieve up to 100 accounts' tax registrations
// in one call (default 50).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Tax Settings's
// API operation ListTaxRegistrations for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The exception when the input doesn't pass validation for at least one of
//     the input parameters.
//
//   - ResourceNotFoundException
//     The exception thrown when the input doesn't have a resource associated to
//     it.
//
//   - InternalServerException
//     The exception thrown when an unexpected error occurs when processing a request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/ListTaxRegistrations
func (c *TaxSettings) ListTaxRegistrations(input *ListTaxRegistrationsInput) (*ListTaxRegistrationsOutput, error) {
	req, out := c.ListTaxRegistrationsRequest(input)
	return out, req.Send()
}

// ListTaxRegistrationsWithContext is the same as ListTaxRegistrations with the addition of
// the ability to pass a context and additional request options.
//
// See ListTaxRegistrations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TaxSettings) ListTaxRegistrationsWithContext(ctx aws.Context, input *ListTaxRegistrationsInput, opts ...request.Option) (*ListTaxRegistrationsOutput, error) {
	req, out := c.ListTaxRegistrationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTaxRegistrationsPages iterates over the pages of a ListTaxRegistrations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTaxRegistrations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTaxRegistrations operation.
//	pageNum := 0
//	err := client.ListTaxRegistrationsPages(params,
//	    func(page *taxsettings.ListTaxRegistrationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *TaxSettings) ListTaxRegistrationsPages(input *ListTaxRegistrationsInput, fn func(*ListTaxRegistrationsOutput, bool) bool) error {
	return c.ListTaxRegistrationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTaxRegistrationsPagesWithContext same as ListTaxRegistrationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TaxSettings) ListTaxRegistrationsPagesWithContext(ctx aws.Context, input *ListTaxRegistrationsInput, fn func(*ListTaxRegistrationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTaxRegistrationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTaxRegistrationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTaxRegistrationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutTaxRegistration = "PutTaxRegistration"

// PutTaxRegistrationRequest generates a "aws/request.Request" representing the
// client's request for the PutTaxRegistration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutTaxRegistration for more information on using the PutTaxRegistration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutTaxRegistrationRequest method.
//	req, resp := client.PutTaxRegistrationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/PutTaxRegistration
func (c *TaxSettings) PutTaxRegistrationRequest(input *PutTaxRegistrationInput) (req *request.Request, output *PutTaxRegistrationOutput) {
	op := &request.Operation{
		Name:       opPutTaxRegistration,
		HTTPMethod: "POST",
		HTTPPath:   "/PutTaxRegistration",
	}

	if input == nil {
		input = &PutTaxRegistrationInput{}
	}

	output = &PutTaxRegistrationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutTaxRegistration API operation for Tax Settings.
//
// Adds or updates tax registration for a single account. You can't set a TRN
// if there's a pending TRN. You'll need to delete the pending TRN first.
//
// To call this API operation for specific countries, see the following country-specific
// requirements.
//
// Bangladesh
//
//   - You must specify the tax registration certificate document in the taxRegistrationDocuments
//     field of the VerificationDetails object.
//
// Brazil
//
//   - You must complete the tax registration process in the Payment preferences
//     (https://console.aws.amazon.com/billing/home#/paymentpreferences/paymentmethods)
//     page in the Billing and Cost Management console. After your TRN and billing
//     address are verified, you can call this API operation.
//
//   - For Amazon Web Services accounts created through Organizations, you
//     can call this API operation when you don't have a billing address.
//
// Georgia
//
//   - The valid personType values are Physical Person and Business.
//
// Kenya
//
//   - You must specify the personType in the kenyaAdditionalInfo field of
//     the additionalTaxInformation object.
//
//   - If the personType is Physical Person, you must specify the tax registration
//     certificate document in the taxRegistrationDocuments field of the VerificationDetails
//     object.
//
// Malaysia
//
//   - If you use this operation to set a tax registration number (TRN) in
//     Malaysia, only resellers with a valid sales and service tax (SST) number
//     are required to provide tax registration information.
//
//   - By using this API operation to set a TRN in Malaysia, Amazon Web Services
//     will regard you as self-declaring that you're an authorized business reseller
//     registered with the Royal Malaysia Customs Department (RMCD) and have
//     a valid SST number.
//
//   - Amazon Web Services reserves the right to seek additional information
//     and/or take other actions to support your self-declaration as appropriate.
//
//   - If you're not a reseller of Amazon Web Services, we don't recommend
//     that you use this operation to set the TRN in Malaysia.
//
//   - Only use this API operation to upload the TRNs for accounts through
//     which you're reselling Amazon Web Services.
//
//   - Amazon Web Services is currently registered under the following service
//     tax codes. You must include at least one of the service tax codes in the
//     service tax code strings to declare yourself as an authorized registered
//     business reseller. Taxable service and service tax codes: Consultancy
//
//   - 9907061674 Training or coaching service - 9907071685 IT service - 9907101676
//     Digital services and electronic medium - 9907121690
//
// Nepal
//
//   - The sector valid values are Business and Individual.
//
// Saudi Arabia
//
//   - For address, you must specify addressLine3.
//
// South Korea
//
//   - You must specify the certifiedEmailId and legalName in the TaxRegistrationEntry
//     object. Use Korean characters for legalName.
//
//   - You must specify the businessRepresentativeName, itemOfBusiness, and
//     lineOfBusiness in the southKoreaAdditionalInfo field of the additionalTaxInformation
//     object. Use Korean characters for these fields.
//
//   - You must specify the tax registration certificate document in the taxRegistrationDocuments
//     field of the VerificationDetails object.
//
//   - For the address object, use Korean characters for addressLine1, addressLine2
//     city, postalCode, and stateOrRegion.
//
// Spain
//
//   - You must specify the registrationType in the spainAdditionalInfo field
//     of the additionalTaxInformation object.
//
//   - If the registrationType is Local, you must specify the tax registration
//     certificate document in the taxRegistrationDocuments field of the VerificationDetails
//     object.
//
// Turkey
//
//   - You must specify the sector in the taxRegistrationEntry object.
//
//   - If your sector is Business, Individual, or Government: Specify the taxOffice.
//     If your sector is Individual, don't enter this value. (Optional) Specify
//     the kepEmailId. If your sector is Individual, don't enter this value.
//     Note: In the Tax Settings page of the Billing console, Government appears
//     as Public institutions
//
//   - If your sector is Business and you're subject to KDV tax, you must specify
//     your industry in the industries field.
//
//   - For address, you must specify districtOrCounty.
//
// Ukraine
//
//   - The sector valid values are Business and Individual.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Tax Settings's
// API operation PutTaxRegistration for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The exception when the input doesn't pass validation for at least one of
//     the input parameters.
//
//   - ConflictException
//     The exception when the input is creating conflict with the given state.
//
//   - InternalServerException
//     The exception thrown when an unexpected error occurs when processing a request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/PutTaxRegistration
func (c *TaxSettings) PutTaxRegistration(input *PutTaxRegistrationInput) (*PutTaxRegistrationOutput, error) {
	req, out := c.PutTaxRegistrationRequest(input)
	return out, req.Send()
}

// PutTaxRegistrationWithContext is the same as PutTaxRegistration with the addition of
// the ability to pass a context and additional request options.
//
// See PutTaxRegistration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TaxSettings) PutTaxRegistrationWithContext(ctx aws.Context, input *PutTaxRegistrationInput, opts ...request.Option) (*PutTaxRegistrationOutput, error) {
	req, out := c.PutTaxRegistrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An object with your accountId and TRN information.
type AccountDetails struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// List of unique account identifiers.
	AccountId *string `locationName:"accountId" min:"12" type:"string"`

	// The meta data information associated with the account.
	//
	// AccountMetaData is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AccountDetails's
	// String and GoString methods.
	AccountMetaData *AccountMetaData `locationName:"accountMetaData" type:"structure" sensitive:"true"`

	// Tax inheritance information associated with the account.
	TaxInheritanceDetails *TaxInheritanceDetails `locationName:"taxInheritanceDetails" type:"structure"`

	// Your TRN information. Instead of having full legal address, here TRN information
	// will have jurisdiction details (for example, country code and state/region/province
	// if applicable).
	//
	// TaxRegistration is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AccountDetails's
	// String and GoString methods.
	TaxRegistration *TaxRegistrationWithJurisdiction `locationName:"taxRegistration" type:"structure" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountDetails) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AccountDetails) SetAccountId(v string) *AccountDetails {
	s.AccountId = &v
	return s
}

// SetAccountMetaData sets the AccountMetaData field's value.
func (s *AccountDetails) SetAccountMetaData(v *AccountMetaData) *AccountDetails {
	s.AccountMetaData = v
	return s
}

// SetTaxInheritanceDetails sets the TaxInheritanceDetails field's value.
func (s *AccountDetails) SetTaxInheritanceDetails(v *TaxInheritanceDetails) *AccountDetails {
	s.TaxInheritanceDetails = v
	return s
}

// SetTaxRegistration sets the TaxRegistration field's value.
func (s *AccountDetails) SetTaxRegistration(v *TaxRegistrationWithJurisdiction) *AccountDetails {
	s.TaxRegistration = v
	return s
}

// The meta data information associated with the account.
type AccountMetaData struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The Amazon Web Services accounts name.
	AccountName *string `locationName:"accountName" type:"string"`

	// The details of the address associated with the TRN information.
	Address *Address `locationName:"address" type:"structure"`

	// Address roles associated with the account containing country code information.
	AddressRoleMap map[string]*Jurisdiction `locationName:"addressRoleMap" type:"map"`

	// The type of address associated with the legal profile.
	AddressType *string `locationName:"addressType" type:"string" enum:"AddressRoleType"`

	// Seller information associated with the account.
	Seller *string `locationName:"seller" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountMetaData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountMetaData) GoString() string {
	return s.String()
}

// SetAccountName sets the AccountName field's value.
func (s *AccountMetaData) SetAccountName(v string) *AccountMetaData {
	s.AccountName = &v
	return s
}

// SetAddress sets the Address field's value.
func (s *AccountMetaData) SetAddress(v *Address) *AccountMetaData {
	s.Address = v
	return s
}

// SetAddressRoleMap sets the AddressRoleMap field's value.
func (s *AccountMetaData) SetAddressRoleMap(v map[string]*Jurisdiction) *AccountMetaData {
	s.AddressRoleMap = v
	return s
}

// SetAddressType sets the AddressType field's value.
func (s *AccountMetaData) SetAddressType(v string) *AccountMetaData {
	s.AddressType = &v
	return s
}

// SetSeller sets the Seller field's value.
func (s *AccountMetaData) SetSeller(v string) *AccountMetaData {
	s.Seller = &v
	return s
}

// Additional tax information associated with your tax registration number (TRN).
// Depending on the TRN for a specific country, you might need to specify this
// information when you set your TRN.
//
// You can only specify one of the following parameters and the value can't
// be empty.
//
// The parameter that you specify must match the country for the TRN, if available.
// For example, if you set a TRN in Canada for specific provinces, you must
// also specify the canadaAdditionalInfo parameter.
type AdditionalInfoRequest struct {
	_ struct{} `type:"structure"`

	// Additional tax information associated with your TRN in Canada.
	CanadaAdditionalInfo *CanadaAdditionalInfo `locationName:"canadaAdditionalInfo" type:"structure"`

	// Additional tax information to specify for a TRN in Estonia.
	EstoniaAdditionalInfo *EstoniaAdditionalInfo `locationName:"estoniaAdditionalInfo" type:"structure"`

	// Additional tax information to specify for a TRN in Georgia.
	GeorgiaAdditionalInfo *GeorgiaAdditionalInfo `locationName:"georgiaAdditionalInfo" type:"structure"`

	// Additional tax information to specify for a TRN in Israel.
	IsraelAdditionalInfo *IsraelAdditionalInfo `locationName:"israelAdditionalInfo" type:"structure"`

	// Additional tax information to specify for a TRN in Italy.
	ItalyAdditionalInfo *ItalyAdditionalInfo `locationName:"italyAdditionalInfo" type:"structure"`

	// Additional tax information to specify for a TRN in Kenya.
	KenyaAdditionalInfo *KenyaAdditionalInfo `locationName:"kenyaAdditionalInfo" type:"structure"`

	// Additional tax information to specify for a TRN in Malaysia.
	MalaysiaAdditionalInfo *MalaysiaAdditionalInfo `locationName:"malaysiaAdditionalInfo" type:"structure"`

	// Additional tax information associated with your TRN in Poland.
	PolandAdditionalInfo *PolandAdditionalInfo `locationName:"polandAdditionalInfo" type:"structure"`

	// Additional tax information to specify for a TRN in Romania.
	RomaniaAdditionalInfo *RomaniaAdditionalInfo `locationName:"romaniaAdditionalInfo" type:"structure"`

	// Additional tax information associated with your TRN in Saudi Arabia.
	SaudiArabiaAdditionalInfo *SaudiArabiaAdditionalInfo `locationName:"saudiArabiaAdditionalInfo" type:"structure"`

	// Additional tax information to specify for a TRN in South Korea.
	SouthKoreaAdditionalInfo *SouthKoreaAdditionalInfo `locationName:"southKoreaAdditionalInfo" type:"structure"`

	// Additional tax information to specify for a TRN in Spain.
	SpainAdditionalInfo *SpainAdditionalInfo `locationName:"spainAdditionalInfo" type:"structure"`

	// Additional tax information to specify for a TRN in Turkey.
	TurkeyAdditionalInfo *TurkeyAdditionalInfo `locationName:"turkeyAdditionalInfo" type:"structure"`

	// Additional tax information associated with your TRN in Ukraine.
	UkraineAdditionalInfo *UkraineAdditionalInfo `locationName:"ukraineAdditionalInfo" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdditionalInfoRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdditionalInfoRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdditionalInfoRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdditionalInfoRequest"}
	if s.CanadaAdditionalInfo != nil {
		if err := s.CanadaAdditionalInfo.Validate(); err != nil {
			invalidParams.AddNested("CanadaAdditionalInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.EstoniaAdditionalInfo != nil {
		if err := s.EstoniaAdditionalInfo.Validate(); err != nil {
			invalidParams.AddNested("EstoniaAdditionalInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.GeorgiaAdditionalInfo != nil {
		if err := s.GeorgiaAdditionalInfo.Validate(); err != nil {
			invalidParams.AddNested("GeorgiaAdditionalInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.IsraelAdditionalInfo != nil {
		if err := s.IsraelAdditionalInfo.Validate(); err != nil {
			invalidParams.AddNested("IsraelAdditionalInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.KenyaAdditionalInfo != nil {
		if err := s.KenyaAdditionalInfo.Validate(); err != nil {
			invalidParams.AddNested("KenyaAdditionalInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.MalaysiaAdditionalInfo != nil {
		if err := s.MalaysiaAdditionalInfo.Validate(); err != nil {
			invalidParams.AddNested("MalaysiaAdditionalInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.RomaniaAdditionalInfo != nil {
		if err := s.RomaniaAdditionalInfo.Validate(); err != nil {
			invalidParams.AddNested("RomaniaAdditionalInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.SouthKoreaAdditionalInfo != nil {
		if err := s.SouthKoreaAdditionalInfo.Validate(); err != nil {
			invalidParams.AddNested("SouthKoreaAdditionalInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.SpainAdditionalInfo != nil {
		if err := s.SpainAdditionalInfo.Validate(); err != nil {
			invalidParams.AddNested("SpainAdditionalInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.UkraineAdditionalInfo != nil {
		if err := s.UkraineAdditionalInfo.Validate(); err != nil {
			invalidParams.AddNested("UkraineAdditionalInfo", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCanadaAdditionalInfo sets the CanadaAdditionalInfo field's value.
func (s *AdditionalInfoRequest) SetCanadaAdditionalInfo(v *CanadaAdditionalInfo) *AdditionalInfoRequest {
	s.CanadaAdditionalInfo = v
	return s
}

// SetEstoniaAdditionalInfo sets the EstoniaAdditionalInfo field's value.
func (s *AdditionalInfoRequest) SetEstoniaAdditionalInfo(v *EstoniaAdditionalInfo) *AdditionalInfoRequest {
	s.EstoniaAdditionalInfo = v
	return s
}

// SetGeorgiaAdditionalInfo sets the GeorgiaAdditionalInfo field's value.
func (s *AdditionalInfoRequest) SetGeorgiaAdditionalInfo(v *GeorgiaAdditionalInfo) *AdditionalInfoRequest {
	s.GeorgiaAdditionalInfo = v
	return s
}

// SetIsraelAdditionalInfo sets the IsraelAdditionalInfo field's value.
func (s *AdditionalInfoRequest) SetIsraelAdditionalInfo(v *IsraelAdditionalInfo) *AdditionalInfoRequest {
	s.IsraelAdditionalInfo = v
	return s
}

// SetItalyAdditionalInfo sets the ItalyAdditionalInfo field's value.
func (s *AdditionalInfoRequest) SetItalyAdditionalInfo(v *ItalyAdditionalInfo) *AdditionalInfoRequest {
	s.ItalyAdditionalInfo = v
	return s
}

// SetKenyaAdditionalInfo sets the KenyaAdditionalInfo field's value.
func (s *AdditionalInfoRequest) SetKenyaAdditionalInfo(v *KenyaAdditionalInfo) *AdditionalInfoRequest {
	s.KenyaAdditionalInfo = v
	return s
}

// SetMalaysiaAdditionalInfo sets the MalaysiaAdditionalInfo field's value.
func (s *AdditionalInfoRequest) SetMalaysiaAdditionalInfo(v *MalaysiaAdditionalInfo) *AdditionalInfoRequest {
	s.MalaysiaAdditionalInfo = v
	return s
}

// SetPolandAdditionalInfo sets the PolandAdditionalInfo field's value.
func (s *AdditionalInfoRequest) SetPolandAdditionalInfo(v *PolandAdditionalInfo) *AdditionalInfoRequest {
	s.PolandAdditionalInfo = v
	return s
}

// SetRomaniaAdditionalInfo sets the RomaniaAdditionalInfo field's value.
func (s *AdditionalInfoRequest) SetRomaniaAdditionalInfo(v *RomaniaAdditionalInfo) *AdditionalInfoRequest {
	s.RomaniaAdditionalInfo = v
	return s
}

// SetSaudiArabiaAdditionalInfo sets the SaudiArabiaAdditionalInfo field's value.
func (s *AdditionalInfoRequest) SetSaudiArabiaAdditionalInfo(v *SaudiArabiaAdditionalInfo) *AdditionalInfoRequest {
	s.SaudiArabiaAdditionalInfo = v
	return s
}

// SetSouthKoreaAdditionalInfo sets the SouthKoreaAdditionalInfo field's value.
func (s *AdditionalInfoRequest) SetSouthKoreaAdditionalInfo(v *SouthKoreaAdditionalInfo) *AdditionalInfoRequest {
	s.SouthKoreaAdditionalInfo = v
	return s
}

// SetSpainAdditionalInfo sets the SpainAdditionalInfo field's value.
func (s *AdditionalInfoRequest) SetSpainAdditionalInfo(v *SpainAdditionalInfo) *AdditionalInfoRequest {
	s.SpainAdditionalInfo = v
	return s
}

// SetTurkeyAdditionalInfo sets the TurkeyAdditionalInfo field's value.
func (s *AdditionalInfoRequest) SetTurkeyAdditionalInfo(v *TurkeyAdditionalInfo) *AdditionalInfoRequest {
	s.TurkeyAdditionalInfo = v
	return s
}

// SetUkraineAdditionalInfo sets the UkraineAdditionalInfo field's value.
func (s *AdditionalInfoRequest) SetUkraineAdditionalInfo(v *UkraineAdditionalInfo) *AdditionalInfoRequest {
	s.UkraineAdditionalInfo = v
	return s
}

// Additional tax information associated with your TRN. The Tax Settings API
// returns country-specific information in the response when any additional
// information is present with your TRN for the following countries.
type AdditionalInfoResponse struct {
	_ struct{} `type:"structure"`

	// Additional tax information associated with your TRN in Brazil. The Tax Settings
	// API returns this information in your response when any additional information
	// is present with your TRN in Brazil.
	BrazilAdditionalInfo *BrazilAdditionalInfo `locationName:"brazilAdditionalInfo" type:"structure"`

	// Additional tax information associated with your TRN in Canada.
	CanadaAdditionalInfo *CanadaAdditionalInfo `locationName:"canadaAdditionalInfo" type:"structure"`

	// Additional tax information associated with your TRN in Estonia.
	EstoniaAdditionalInfo *EstoniaAdditionalInfo `locationName:"estoniaAdditionalInfo" type:"structure"`

	// Additional tax information associated with your TRN in Georgia.
	GeorgiaAdditionalInfo *GeorgiaAdditionalInfo `locationName:"georgiaAdditionalInfo" type:"structure"`

	// Additional tax information in India.
	IndiaAdditionalInfo *IndiaAdditionalInfo `locationName:"indiaAdditionalInfo" type:"structure"`

	// Additional tax information associated with your TRN in Israel.
	IsraelAdditionalInfo *IsraelAdditionalInfo `locationName:"israelAdditionalInfo" type:"structure"`

	// Additional tax information associated with your TRN in Italy.
	ItalyAdditionalInfo *ItalyAdditionalInfo `locationName:"italyAdditionalInfo" type:"structure"`

	// Additional tax information associated with your TRN in Kenya.
	KenyaAdditionalInfo *KenyaAdditionalInfo `locationName:"kenyaAdditionalInfo" type:"structure"`

	// Additional tax information associated with your TRN in Malaysia.
	MalaysiaAdditionalInfo *MalaysiaAdditionalInfo `locationName:"malaysiaAdditionalInfo" type:"structure"`

	// Additional tax information associated with your TRN in Poland.
	PolandAdditionalInfo *PolandAdditionalInfo `locationName:"polandAdditionalInfo" type:"structure"`

	// Additional tax information to specify for a TRN in Romania.
	RomaniaAdditionalInfo *RomaniaAdditionalInfo `locationName:"romaniaAdditionalInfo" type:"structure"`

	// Additional tax information associated with your TRN in Saudi Arabia.
	SaudiArabiaAdditionalInfo *SaudiArabiaAdditionalInfo `locationName:"saudiArabiaAdditionalInfo" type:"structure"`

	// Additional tax information associated with your TRN in South Korea.
	SouthKoreaAdditionalInfo *SouthKoreaAdditionalInfo `locationName:"southKoreaAdditionalInfo" type:"structure"`

	// Additional tax information associated with your TRN in Spain.
	SpainAdditionalInfo *SpainAdditionalInfo `locationName:"spainAdditionalInfo" type:"structure"`

	// Additional tax information associated with your TRN in Turkey.
	TurkeyAdditionalInfo *TurkeyAdditionalInfo `locationName:"turkeyAdditionalInfo" type:"structure"`

	// Additional tax information associated with your TRN in Ukraine.
	UkraineAdditionalInfo *UkraineAdditionalInfo `locationName:"ukraineAdditionalInfo" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdditionalInfoResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdditionalInfoResponse) GoString() string {
	return s.String()
}

// SetBrazilAdditionalInfo sets the BrazilAdditionalInfo field's value.
func (s *AdditionalInfoResponse) SetBrazilAdditionalInfo(v *BrazilAdditionalInfo) *AdditionalInfoResponse {
	s.BrazilAdditionalInfo = v
	return s
}

// SetCanadaAdditionalInfo sets the CanadaAdditionalInfo field's value.
func (s *AdditionalInfoResponse) SetCanadaAdditionalInfo(v *CanadaAdditionalInfo) *AdditionalInfoResponse {
	s.CanadaAdditionalInfo = v
	return s
}

// SetEstoniaAdditionalInfo sets the EstoniaAdditionalInfo field's value.
func (s *AdditionalInfoResponse) SetEstoniaAdditionalInfo(v *EstoniaAdditionalInfo) *AdditionalInfoResponse {
	s.EstoniaAdditionalInfo = v
	return s
}

// SetGeorgiaAdditionalInfo sets the GeorgiaAdditionalInfo field's value.
func (s *AdditionalInfoResponse) SetGeorgiaAdditionalInfo(v *GeorgiaAdditionalInfo) *AdditionalInfoResponse {
	s.GeorgiaAdditionalInfo = v
	return s
}

// SetIndiaAdditionalInfo sets the IndiaAdditionalInfo field's value.
func (s *AdditionalInfoResponse) SetIndiaAdditionalInfo(v *IndiaAdditionalInfo) *AdditionalInfoResponse {
	s.IndiaAdditionalInfo = v
	return s
}

// SetIsraelAdditionalInfo sets the IsraelAdditionalInfo field's value.
func (s *AdditionalInfoResponse) SetIsraelAdditionalInfo(v *IsraelAdditionalInfo) *AdditionalInfoResponse {
	s.IsraelAdditionalInfo = v
	return s
}

// SetItalyAdditionalInfo sets the ItalyAdditionalInfo field's value.
func (s *AdditionalInfoResponse) SetItalyAdditionalInfo(v *ItalyAdditionalInfo) *AdditionalInfoResponse {
	s.ItalyAdditionalInfo = v
	return s
}

// SetKenyaAdditionalInfo sets the KenyaAdditionalInfo field's value.
func (s *AdditionalInfoResponse) SetKenyaAdditionalInfo(v *KenyaAdditionalInfo) *AdditionalInfoResponse {
	s.KenyaAdditionalInfo = v
	return s
}

// SetMalaysiaAdditionalInfo sets the MalaysiaAdditionalInfo field's value.
func (s *AdditionalInfoResponse) SetMalaysiaAdditionalInfo(v *MalaysiaAdditionalInfo) *AdditionalInfoResponse {
	s.MalaysiaAdditionalInfo = v
	return s
}

// SetPolandAdditionalInfo sets the PolandAdditionalInfo field's value.
func (s *AdditionalInfoResponse) SetPolandAdditionalInfo(v *PolandAdditionalInfo) *AdditionalInfoResponse {
	s.PolandAdditionalInfo = v
	return s
}

// SetRomaniaAdditionalInfo sets the RomaniaAdditionalInfo field's value.
func (s *AdditionalInfoResponse) SetRomaniaAdditionalInfo(v *RomaniaAdditionalInfo) *AdditionalInfoResponse {
	s.RomaniaAdditionalInfo = v
	return s
}

// SetSaudiArabiaAdditionalInfo sets the SaudiArabiaAdditionalInfo field's value.
func (s *AdditionalInfoResponse) SetSaudiArabiaAdditionalInfo(v *SaudiArabiaAdditionalInfo) *AdditionalInfoResponse {
	s.SaudiArabiaAdditionalInfo = v
	return s
}

// SetSouthKoreaAdditionalInfo sets the SouthKoreaAdditionalInfo field's value.
func (s *AdditionalInfoResponse) SetSouthKoreaAdditionalInfo(v *SouthKoreaAdditionalInfo) *AdditionalInfoResponse {
	s.SouthKoreaAdditionalInfo = v
	return s
}

// SetSpainAdditionalInfo sets the SpainAdditionalInfo field's value.
func (s *AdditionalInfoResponse) SetSpainAdditionalInfo(v *SpainAdditionalInfo) *AdditionalInfoResponse {
	s.SpainAdditionalInfo = v
	return s
}

// SetTurkeyAdditionalInfo sets the TurkeyAdditionalInfo field's value.
func (s *AdditionalInfoResponse) SetTurkeyAdditionalInfo(v *TurkeyAdditionalInfo) *AdditionalInfoResponse {
	s.TurkeyAdditionalInfo = v
	return s
}

// SetUkraineAdditionalInfo sets the UkraineAdditionalInfo field's value.
func (s *AdditionalInfoResponse) SetUkraineAdditionalInfo(v *UkraineAdditionalInfo) *AdditionalInfoResponse {
	s.UkraineAdditionalInfo = v
	return s
}

// The details of the address associated with the TRN information.
type Address struct {
	_ struct{} `type:"structure"`

	// The first line of the address.
	//
	// AddressLine1 is a required field
	AddressLine1 *string `locationName:"addressLine1" min:"1" type:"string" required:"true"`

	// The second line of the address, if applicable.
	AddressLine2 *string `locationName:"addressLine2" min:"1" type:"string"`

	// The third line of the address, if applicable. Currently, the Tax Settings
	// API accepts the addressLine3 parameter only for Saudi Arabia. When you specify
	// a TRN in Saudi Arabia, you must enter the addressLine3 and specify the building
	// number for the address. For example, you might enter 1234.
	AddressLine3 *string `locationName:"addressLine3" min:"1" type:"string"`

	// The city that the address is in.
	//
	// City is a required field
	City *string `locationName:"city" min:"1" type:"string" required:"true"`

	// The country code for the country that the address is in.
	//
	// CountryCode is a required field
	CountryCode *string `locationName:"countryCode" min:"2" type:"string" required:"true"`

	// The district or county the address is located.
	//
	// For addresses in Brazil, this parameter uses the name of the neighborhood.
	// When you set a TRN in Brazil, use districtOrCounty for the neighborhood name.
	DistrictOrCounty *string `locationName:"districtOrCounty" min:"1" type:"string"`

	// The postal code associated with the address.
	//
	// PostalCode is a required field
	PostalCode *string `locationName:"postalCode" min:"1" type:"string" required:"true"`

	// The state, region, or province that the address is located.
	//
	// If this is required for tax settings, use the same name as shown on the Tax
	// Settings page.
	StateOrRegion *string `locationName:"stateOrRegion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Address) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Address) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Address) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Address"}
	if s.AddressLine1 == nil {
		invalidParams.Add(request.NewErrParamRequired("AddressLine1"))
	}
	if s.AddressLine1 != nil && len(*s.AddressLine1) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AddressLine1", 1))
	}
	if s.AddressLine2 != nil && len(*s.AddressLine2) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AddressLine2", 1))
	}
	if s.AddressLine3 != nil && len(*s.AddressLine3) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AddressLine3", 1))
	}
	if s.City == nil {
		invalidParams.Add(request.NewErrParamRequired("City"))
	}
	if s.City != nil && len(*s.City) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("City", 1))
	}
	if s.CountryCode == nil {
		invalidParams.Add(request.NewErrParamRequired("CountryCode"))
	}
	if s.CountryCode != nil && len(*s.CountryCode) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("CountryCode", 2))
	}
	if s.DistrictOrCounty != nil && len(*s.DistrictOrCounty) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DistrictOrCounty", 1))
	}
	if s.PostalCode == nil {
		invalidParams.Add(request.NewErrParamRequired("PostalCode"))
	}
	if s.PostalCode != nil && len(*s.PostalCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PostalCode", 1))
	}
	if s.StateOrRegion != nil && len(*s.StateOrRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StateOrRegion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressLine1 sets the AddressLine1 field's value.
func (s *Address) SetAddressLine1(v string) *Address {
	s.AddressLine1 = &v
	return s
}

// SetAddressLine2 sets the AddressLine2 field's value.
func (s *Address) SetAddressLine2(v string) *Address {
	s.AddressLine2 = &v
	return s
}

// SetAddressLine3 sets the AddressLine3 field's value.
func (s *Address) SetAddressLine3(v string) *Address {
	s.AddressLine3 = &v
	return s
}

// SetCity sets the City field's value.
func (s *Address) SetCity(v string) *Address {
	s.City = &v
	return s
}

// SetCountryCode sets the CountryCode field's value.
func (s *Address) SetCountryCode(v string) *Address {
	s.CountryCode = &v
	return s
}

// SetDistrictOrCounty sets the DistrictOrCounty field's value.
func (s *Address) SetDistrictOrCounty(v string) *Address {
	s.DistrictOrCounty = &v
	return s
}

// SetPostalCode sets the PostalCode field's value.
func (s *Address) SetPostalCode(v string) *Address {
	s.PostalCode = &v
	return s
}

// SetStateOrRegion sets the StateOrRegion field's value.
func (s *Address) SetStateOrRegion(v string) *Address {
	s.StateOrRegion = &v
	return s
}

// The error object for representing failures in the BatchDeleteTaxRegistration
// operation.
type BatchDeleteTaxRegistrationError struct {
	_ struct{} `type:"structure"`

	// The unique account identifier for the account whose tax registration couldn't
	// be deleted during the BatchDeleteTaxRegistration operation.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" min:"12" type:"string" required:"true"`

	// The error code for an individual failure in BatchDeleteTaxRegistration operation.
	Code *string `locationName:"code" type:"string"`

	// The error message for an individual failure in the BatchDeleteTaxRegistration
	// operation.
	//
	// Message is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by BatchDeleteTaxRegistrationError's
	// String and GoString methods.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteTaxRegistrationError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteTaxRegistrationError) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *BatchDeleteTaxRegistrationError) SetAccountId(v string) *BatchDeleteTaxRegistrationError {
	s.AccountId = &v
	return s
}

// SetCode sets the Code field's value.
func (s *BatchDeleteTaxRegistrationError) SetCode(v string) *BatchDeleteTaxRegistrationError {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *BatchDeleteTaxRegistrationError) SetMessage(v string) *BatchDeleteTaxRegistrationError {
	s.Message = &v
	return s
}

type BatchDeleteTaxRegistrationInput struct {
	_ struct{} `type:"structure"`

	// List of unique account identifiers.
	//
	// AccountIds is a required field
	AccountIds []*string `locationName:"accountIds" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteTaxRegistrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteTaxRegistrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteTaxRegistrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeleteTaxRegistrationInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}
	if s.AccountIds != nil && len(s.AccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *BatchDeleteTaxRegistrationInput) SetAccountIds(v []*string) *BatchDeleteTaxRegistrationInput {
	s.AccountIds = v
	return s
}

type BatchDeleteTaxRegistrationOutput struct {
	_ struct{} `type:"structure"`

	// The list of errors for the accounts the TRN information could not be deleted
	// for.
	//
	// Errors is a required field
	Errors []*BatchDeleteTaxRegistrationError `locationName:"errors" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteTaxRegistrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteTaxRegistrationOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchDeleteTaxRegistrationOutput) SetErrors(v []*BatchDeleteTaxRegistrationError) *BatchDeleteTaxRegistrationOutput {
	s.Errors = v
	return s
}

// The error object for representing failures in the BatchPutTaxRegistration
// operation.
type BatchPutTaxRegistrationError struct {
	_ struct{} `type:"structure"`

	// The unique account identifier for the account that the tax registration couldn't
	// be added, or updated during the BatchPutTaxRegistration operation.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" min:"12" type:"string" required:"true"`

	// The error code for an individual failure in the BatchPutTaxRegistration operation.
	Code *string `locationName:"code" type:"string"`

	// The error message for an individual failure in the BatchPutTaxRegistration
	// operation.
	//
	// Message is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by BatchPutTaxRegistrationError's
	// String and GoString methods.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutTaxRegistrationError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutTaxRegistrationError) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *BatchPutTaxRegistrationError) SetAccountId(v string) *BatchPutTaxRegistrationError {
	s.AccountId = &v
	return s
}

// SetCode sets the Code field's value.
func (s *BatchPutTaxRegistrationError) SetCode(v string) *BatchPutTaxRegistrationError {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *BatchPutTaxRegistrationError) SetMessage(v string) *BatchPutTaxRegistrationError {
	s.Message = &v
	return s
}

type BatchPutTaxRegistrationInput struct {
	_ struct{} `type:"structure"`

	// List of unique account identifiers.
	//
	// AccountIds is a required field
	AccountIds []*string `locationName:"accountIds" min:"1" type:"list" required:"true"`

	// Your TRN information that will be stored to the accounts mentioned in putEntries.
	//
	// TaxRegistrationEntry is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by BatchPutTaxRegistrationInput's
	// String and GoString methods.
	//
	// TaxRegistrationEntry is a required field
	TaxRegistrationEntry *TaxRegistrationEntry `locationName:"taxRegistrationEntry" type:"structure" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutTaxRegistrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutTaxRegistrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchPutTaxRegistrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchPutTaxRegistrationInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}
	if s.AccountIds != nil && len(s.AccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIds", 1))
	}
	if s.TaxRegistrationEntry == nil {
		invalidParams.Add(request.NewErrParamRequired("TaxRegistrationEntry"))
	}
	if s.TaxRegistrationEntry != nil {
		if err := s.TaxRegistrationEntry.Validate(); err != nil {
			invalidParams.AddNested("TaxRegistrationEntry", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *BatchPutTaxRegistrationInput) SetAccountIds(v []*string) *BatchPutTaxRegistrationInput {
	s.AccountIds = v
	return s
}

// SetTaxRegistrationEntry sets the TaxRegistrationEntry field's value.
func (s *BatchPutTaxRegistrationInput) SetTaxRegistrationEntry(v *TaxRegistrationEntry) *BatchPutTaxRegistrationInput {
	s.TaxRegistrationEntry = v
	return s
}

type BatchPutTaxRegistrationOutput struct {
	_ struct{} `type:"structure"`

	// List of errors for the accounts the TRN information could not be added or
	// updated to.
	//
	// Errors is a required field
	Errors []*BatchPutTaxRegistrationError `locationName:"errors" type:"list" required:"true"`

	// The status of your TRN stored in the system after processing. Based on the
	// validation occurring on the TRN, the status can be Verified, Pending or Rejected.
	Status *string `locationName:"status" type:"string" enum:"TaxRegistrationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutTaxRegistrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutTaxRegistrationOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchPutTaxRegistrationOutput) SetErrors(v []*BatchPutTaxRegistrationError) *BatchPutTaxRegistrationOutput {
	s.Errors = v
	return s
}

// SetStatus sets the Status field's value.
func (s *BatchPutTaxRegistrationOutput) SetStatus(v string) *BatchPutTaxRegistrationOutput {
	s.Status = &v
	return s
}

// Additional tax information associated with your TRN in Brazil.
type BrazilAdditionalInfo struct {
	_ struct{} `type:"structure"`

	// The Cadastro de Contribuintes Mobiliários (CCM) code for your TRN in Brazil.
	// This only applies for a CNPJ tax type for the São Paulo municipality.
	CcmCode *string `locationName:"ccmCode" type:"string"`

	// Legal nature of business, based on your TRN in Brazil. This only applies
	// for a CNPJ tax type.
	LegalNatureCode *string `locationName:"legalNatureCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BrazilAdditionalInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BrazilAdditionalInfo) GoString() string {
	return s.String()
}

// SetCcmCode sets the CcmCode field's value.
func (s *BrazilAdditionalInfo) SetCcmCode(v string) *BrazilAdditionalInfo {
	s.CcmCode = &v
	return s
}

// SetLegalNatureCode sets the LegalNatureCode field's value.
func (s *BrazilAdditionalInfo) SetLegalNatureCode(v string) *BrazilAdditionalInfo {
	s.LegalNatureCode = &v
	return s
}

// Additional tax information associated with your TRN in Canada .
type CanadaAdditionalInfo struct {
	_ struct{} `type:"structure"`

	// The Quebec Sales Tax ID number. Leave blank if you do not have a Quebec Sales
	// Tax ID number.
	CanadaQuebecSalesTaxNumber *string `locationName:"canadaQuebecSalesTaxNumber" type:"string"`

	// Manitoba Retail Sales Tax ID number. Customers purchasing Amazon Web Services
	// for resale in Manitoba must provide a valid Retail Sales Tax ID number for
	// Manitoba. Leave this blank if you do not have a Retail Sales Tax ID number
	// in Manitoba or are not purchasing Amazon Web Services for resale.
	CanadaRetailSalesTaxNumber *string `locationName:"canadaRetailSalesTaxNumber" type:"string"`

	// The value for this parameter must be true if the provincialSalesTaxId value
	// is provided for a TRN in British Columbia, Saskatchewan, or Manitoba provinces.
	//
	// To claim a provincial sales tax (PST) and retail sales tax (RST) reseller
	// exemption, you must confirm that purchases from this account were made for
	// resale. Otherwise, remove the PST or RST number from the provincialSalesTaxId
	// parameter from your request.
	IsResellerAccount *bool `locationName:"isResellerAccount" type:"boolean"`

	// The provincial sales tax ID for your TRN in Canada. This parameter can represent
	// the following:
	//
	//    * Provincial sales tax ID number for British Columbia and Saskatchewan
	//    provinces
	//
	//    * Manitoba retail sales tax ID number for Manitoba province
	//
	//    * Quebec sales tax ID number for Quebec province
	//
	// The Tax Setting API only accepts this parameter if the TRN is specified for
	// the previous provinces. For other provinces, the Tax Settings API doesn't
	// accept this parameter.
	ProvincialSalesTaxId *string `locationName:"provincialSalesTaxId" min:"7" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CanadaAdditionalInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CanadaAdditionalInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CanadaAdditionalInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CanadaAdditionalInfo"}
	if s.ProvincialSalesTaxId != nil && len(*s.ProvincialSalesTaxId) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("ProvincialSalesTaxId", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCanadaQuebecSalesTaxNumber sets the CanadaQuebecSalesTaxNumber field's value.
func (s *CanadaAdditionalInfo) SetCanadaQuebecSalesTaxNumber(v string) *CanadaAdditionalInfo {
	s.CanadaQuebecSalesTaxNumber = &v
	return s
}

// SetCanadaRetailSalesTaxNumber sets the CanadaRetailSalesTaxNumber field's value.
func (s *CanadaAdditionalInfo) SetCanadaRetailSalesTaxNumber(v string) *CanadaAdditionalInfo {
	s.CanadaRetailSalesTaxNumber = &v
	return s
}

// SetIsResellerAccount sets the IsResellerAccount field's value.
func (s *CanadaAdditionalInfo) SetIsResellerAccount(v bool) *CanadaAdditionalInfo {
	s.IsResellerAccount = &v
	return s
}

// SetProvincialSalesTaxId sets the ProvincialSalesTaxId field's value.
func (s *CanadaAdditionalInfo) SetProvincialSalesTaxId(v string) *CanadaAdditionalInfo {
	s.ProvincialSalesTaxId = &v
	return s
}

// The exception when the input is creating conflict with the given state.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// 409
	//
	// ErrorCode is a required field
	ErrorCode *string `locationName:"errorCode" type:"string" required:"true"`

	// Message_ is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ConflictException's
	// String and GoString methods.
	Message_ *string `locationName:"message" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type DeleteTaxRegistrationInput struct {
	_ struct{} `type:"structure"`

	// Unique account identifier for the TRN information that needs to be deleted.
	// If this isn't passed, the account ID corresponding to the credentials of
	// the API caller will be used for this parameter.
	AccountId *string `locationName:"accountId" min:"12" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTaxRegistrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTaxRegistrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTaxRegistrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTaxRegistrationInput"}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteTaxRegistrationInput) SetAccountId(v string) *DeleteTaxRegistrationInput {
	s.AccountId = &v
	return s
}

type DeleteTaxRegistrationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTaxRegistrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTaxRegistrationOutput) GoString() string {
	return s.String()
}

// The location of the Amazon S3 bucket that you specify to download your tax
// documents to.
type DestinationS3Location struct {
	_ struct{} `type:"structure"`

	// The name of your Amazon S3 bucket that you specify to download your tax documents
	// to.
	//
	// Bucket is a required field
	Bucket *string `locationName:"bucket" min:"3" type:"string" required:"true"`

	// The Amazon S3 object prefix that you specify for your tax document file.
	Prefix *string `locationName:"prefix" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationS3Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationS3Location) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DestinationS3Location) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DestinationS3Location"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DestinationS3Location) SetBucket(v string) *DestinationS3Location {
	s.Bucket = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *DestinationS3Location) SetPrefix(v string) *DestinationS3Location {
	s.Prefix = &v
	return s
}

// Additional tax information associated with your TRN in Estonia.
type EstoniaAdditionalInfo struct {
	_ struct{} `type:"structure"`

	// Registry commercial code (RCC) for your TRN in Estonia. This value is an
	// eight-numeric string, such as 12345678.
	//
	// RegistryCommercialCode is a required field
	RegistryCommercialCode *string `locationName:"registryCommercialCode" min:"8" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EstoniaAdditionalInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EstoniaAdditionalInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EstoniaAdditionalInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EstoniaAdditionalInfo"}
	if s.RegistryCommercialCode == nil {
		invalidParams.Add(request.NewErrParamRequired("RegistryCommercialCode"))
	}
	if s.RegistryCommercialCode != nil && len(*s.RegistryCommercialCode) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("RegistryCommercialCode", 8))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRegistryCommercialCode sets the RegistryCommercialCode field's value.
func (s *EstoniaAdditionalInfo) SetRegistryCommercialCode(v string) *EstoniaAdditionalInfo {
	s.RegistryCommercialCode = &v
	return s
}

// Additional tax information associated with your TRN in Georgia.
type GeorgiaAdditionalInfo struct {
	_ struct{} `type:"structure"`

	// The legal person or physical person assigned to this TRN in Georgia.
	//
	// PersonType is a required field
	PersonType *string `locationName:"personType" type:"string" required:"true" enum:"PersonType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeorgiaAdditionalInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeorgiaAdditionalInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GeorgiaAdditionalInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GeorgiaAdditionalInfo"}
	if s.PersonType == nil {
		invalidParams.Add(request.NewErrParamRequired("PersonType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPersonType sets the PersonType field's value.
func (s *GeorgiaAdditionalInfo) SetPersonType(v string) *GeorgiaAdditionalInfo {
	s.PersonType = &v
	return s
}

type GetTaxRegistrationDocumentInput struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket that you specify to download your tax documents to.
	//
	// DestinationS3Location is a required field
	DestinationS3Location *DestinationS3Location `locationName:"destinationS3Location" type:"structure" required:"true"`

	// The metadata for your tax document.
	//
	// TaxDocumentMetadata is a required field
	TaxDocumentMetadata *TaxDocumentMetadata `locationName:"taxDocumentMetadata" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTaxRegistrationDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTaxRegistrationDocumentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTaxRegistrationDocumentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTaxRegistrationDocumentInput"}
	if s.DestinationS3Location == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationS3Location"))
	}
	if s.TaxDocumentMetadata == nil {
		invalidParams.Add(request.NewErrParamRequired("TaxDocumentMetadata"))
	}
	if s.DestinationS3Location != nil {
		if err := s.DestinationS3Location.Validate(); err != nil {
			invalidParams.AddNested("DestinationS3Location", err.(request.ErrInvalidParams))
		}
	}
	if s.TaxDocumentMetadata != nil {
		if err := s.TaxDocumentMetadata.Validate(); err != nil {
			invalidParams.AddNested("TaxDocumentMetadata", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationS3Location sets the DestinationS3Location field's value.
func (s *GetTaxRegistrationDocumentInput) SetDestinationS3Location(v *DestinationS3Location) *GetTaxRegistrationDocumentInput {
	s.DestinationS3Location = v
	return s
}

// SetTaxDocumentMetadata sets the TaxDocumentMetadata field's value.
func (s *GetTaxRegistrationDocumentInput) SetTaxDocumentMetadata(v *TaxDocumentMetadata) *GetTaxRegistrationDocumentInput {
	s.TaxDocumentMetadata = v
	return s
}

type GetTaxRegistrationDocumentOutput struct {
	_ struct{} `type:"structure"`

	// The file path of the Amazon S3 bucket where you want to download your tax
	// document to.
	DestinationFilePath *string `locationName:"destinationFilePath" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTaxRegistrationDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTaxRegistrationDocumentOutput) GoString() string {
	return s.String()
}

// SetDestinationFilePath sets the DestinationFilePath field's value.
func (s *GetTaxRegistrationDocumentOutput) SetDestinationFilePath(v string) *GetTaxRegistrationDocumentOutput {
	s.DestinationFilePath = &v
	return s
}

type GetTaxRegistrationInput struct {
	_ struct{} `type:"structure"`

	// Your unique account identifier.
	AccountId *string `locationName:"accountId" min:"12" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTaxRegistrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTaxRegistrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTaxRegistrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTaxRegistrationInput"}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetTaxRegistrationInput) SetAccountId(v string) *GetTaxRegistrationInput {
	s.AccountId = &v
	return s
}

type GetTaxRegistrationOutput struct {
	_ struct{} `type:"structure"`

	// TRN information of the account mentioned in the request.
	//
	// TaxRegistration is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetTaxRegistrationOutput's
	// String and GoString methods.
	TaxRegistration *TaxRegistration `locationName:"taxRegistration" type:"structure" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTaxRegistrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTaxRegistrationOutput) GoString() string {
	return s.String()
}

// SetTaxRegistration sets the TaxRegistration field's value.
func (s *GetTaxRegistrationOutput) SetTaxRegistration(v *TaxRegistration) *GetTaxRegistrationOutput {
	s.TaxRegistration = v
	return s
}

// Additional tax information in India.
type IndiaAdditionalInfo struct {
	_ struct{} `type:"structure"`

	// India pan information associated with the account.
	Pan *string `locationName:"pan" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IndiaAdditionalInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IndiaAdditionalInfo) GoString() string {
	return s.String()
}

// SetPan sets the Pan field's value.
func (s *IndiaAdditionalInfo) SetPan(v string) *IndiaAdditionalInfo {
	s.Pan = &v
	return s
}

// The exception thrown when an unexpected error occurs when processing a request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// 500
	//
	// ErrorCode is a required field
	ErrorCode *string `locationName:"errorCode" type:"string" required:"true"`

	// Message_ is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by InternalServerException's
	// String and GoString methods.
	Message_ *string `locationName:"message" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Additional tax information associated with your TRN in Israel.
type IsraelAdditionalInfo struct {
	_ struct{} `type:"structure"`

	// Customer type for your TRN in Israel. The value can be Business or Individual.
	// Use Businessfor entities such as not-for-profit and financial institutions.
	//
	// CustomerType is a required field
	CustomerType *string `locationName:"customerType" type:"string" required:"true" enum:"IsraelCustomerType"`

	// Dealer type for your TRN in Israel. If you're not a local authorized dealer
	// with an Israeli VAT ID, specify your tax identification number so that Amazon
	// Web Services can send you a compliant tax invoice.
	//
	// DealerType is a required field
	DealerType *string `locationName:"dealerType" type:"string" required:"true" enum:"IsraelDealerType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IsraelAdditionalInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IsraelAdditionalInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IsraelAdditionalInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IsraelAdditionalInfo"}
	if s.CustomerType == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomerType"))
	}
	if s.DealerType == nil {
		invalidParams.Add(request.NewErrParamRequired("DealerType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomerType sets the CustomerType field's value.
func (s *IsraelAdditionalInfo) SetCustomerType(v string) *IsraelAdditionalInfo {
	s.CustomerType = &v
	return s
}

// SetDealerType sets the DealerType field's value.
func (s *IsraelAdditionalInfo) SetDealerType(v string) *IsraelAdditionalInfo {
	s.DealerType = &v
	return s
}

// Additional tax information associated with your TRN in Italy.
type ItalyAdditionalInfo struct {
	_ struct{} `type:"structure"`

	// The tender procedure identification code.
	CigNumber *string `locationName:"cigNumber" type:"string"`

	// Additional tax information to specify for a TRN in Italy. This is managed
	// by the Interministerial Committee for Economic Planning (CIPE) which characterizes
	// every public investment project (Individual Project Code).
	CupNumber *string `locationName:"cupNumber" type:"string"`

	// Additional tax information to specify for a TRN in Italy. Use CodiceDestinatario
	// to receive your invoices via web service (API) or FTP.
	SdiAccountId *string `locationName:"sdiAccountId" type:"string"`

	// List of service tax codes for your TRN in Italy. You can use your customer
	// tax code as part of a VAT Group.
	TaxCode *string `locationName:"taxCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ItalyAdditionalInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ItalyAdditionalInfo) GoString() string {
	return s.String()
}

// SetCigNumber sets the CigNumber field's value.
func (s *ItalyAdditionalInfo) SetCigNumber(v string) *ItalyAdditionalInfo {
	s.CigNumber = &v
	return s
}

// SetCupNumber sets the CupNumber field's value.
func (s *ItalyAdditionalInfo) SetCupNumber(v string) *ItalyAdditionalInfo {
	s.CupNumber = &v
	return s
}

// SetSdiAccountId sets the SdiAccountId field's value.
func (s *ItalyAdditionalInfo) SetSdiAccountId(v string) *ItalyAdditionalInfo {
	s.SdiAccountId = &v
	return s
}

// SetTaxCode sets the TaxCode field's value.
func (s *ItalyAdditionalInfo) SetTaxCode(v string) *ItalyAdditionalInfo {
	s.TaxCode = &v
	return s
}

// The jurisdiction details of the TRN information of the customers. This doesn't
// contain full legal address, and contains only country code and state/region/province.
type Jurisdiction struct {
	_ struct{} `type:"structure"`

	// The country code of the jurisdiction.
	//
	// CountryCode is a required field
	CountryCode *string `locationName:"countryCode" min:"2" type:"string" required:"true"`

	// The state, region, or province associated with the country of the jurisdiction,
	// if applicable.
	StateOrRegion *string `locationName:"stateOrRegion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Jurisdiction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Jurisdiction) GoString() string {
	return s.String()
}

// SetCountryCode sets the CountryCode field's value.
func (s *Jurisdiction) SetCountryCode(v string) *Jurisdiction {
	s.CountryCode = &v
	return s
}

// SetStateOrRegion sets the StateOrRegion field's value.
func (s *Jurisdiction) SetStateOrRegion(v string) *Jurisdiction {
	s.StateOrRegion = &v
	return s
}

// Additional tax information associated with your TRN in Kenya.
type KenyaAdditionalInfo struct {
	_ struct{} `type:"structure"`

	// The legal person or physical person assigned to this TRN in Kenya.
	//
	// PersonType is a required field
	PersonType *string `locationName:"personType" type:"string" required:"true" enum:"PersonType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KenyaAdditionalInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KenyaAdditionalInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KenyaAdditionalInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KenyaAdditionalInfo"}
	if s.PersonType == nil {
		invalidParams.Add(request.NewErrParamRequired("PersonType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPersonType sets the PersonType field's value.
func (s *KenyaAdditionalInfo) SetPersonType(v string) *KenyaAdditionalInfo {
	s.PersonType = &v
	return s
}

type ListTaxRegistrationsInput struct {
	_ struct{} `type:"structure"`

	// Number of accountDetails results you want in one response.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token to retrieve the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTaxRegistrationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTaxRegistrationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTaxRegistrationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTaxRegistrationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTaxRegistrationsInput) SetMaxResults(v int64) *ListTaxRegistrationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTaxRegistrationsInput) SetNextToken(v string) *ListTaxRegistrationsInput {
	s.NextToken = &v
	return s
}

type ListTaxRegistrationsOutput struct {
	_ struct{} `type:"structure"`

	// The list of account details. This contains account Ids and TRN Information
	// for each of the linked accounts.
	//
	// AccountDetails is a required field
	AccountDetails []*AccountDetails `locationName:"accountDetails" type:"list" required:"true"`

	// The token to retrieve the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTaxRegistrationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTaxRegistrationsOutput) GoString() string {
	return s.String()
}

// SetAccountDetails sets the AccountDetails field's value.
func (s *ListTaxRegistrationsOutput) SetAccountDetails(v []*AccountDetails) *ListTaxRegistrationsOutput {
	s.AccountDetails = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTaxRegistrationsOutput) SetNextToken(v string) *ListTaxRegistrationsOutput {
	s.NextToken = &v
	return s
}

// Additional tax information associated with your TRN in Malaysia.
type MalaysiaAdditionalInfo struct {
	_ struct{} `type:"structure"`

	// List of service tax codes for your TRN in Malaysia.
	//
	// ServiceTaxCodes is a required field
	ServiceTaxCodes []*string `locationName:"serviceTaxCodes" min:"1" type:"list" required:"true" enum:"MalaysiaServiceTaxCode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MalaysiaAdditionalInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MalaysiaAdditionalInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MalaysiaAdditionalInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MalaysiaAdditionalInfo"}
	if s.ServiceTaxCodes == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceTaxCodes"))
	}
	if s.ServiceTaxCodes != nil && len(s.ServiceTaxCodes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceTaxCodes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceTaxCodes sets the ServiceTaxCodes field's value.
func (s *MalaysiaAdditionalInfo) SetServiceTaxCodes(v []*string) *MalaysiaAdditionalInfo {
	s.ServiceTaxCodes = v
	return s
}

// Additional tax information associated with your TRN in Poland.
type PolandAdditionalInfo struct {
	_ struct{} `type:"structure"`

	// The individual tax registration number (NIP). Individual NIP is valid for
	// other taxes excluding VAT purposes.
	IndividualRegistrationNumber *string `locationName:"individualRegistrationNumber" type:"string"`

	// True if your business is a member of a VAT group with a NIP active for VAT
	// purposes. Otherwise, this is false.
	IsGroupVatEnabled *bool `locationName:"isGroupVatEnabled" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolandAdditionalInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolandAdditionalInfo) GoString() string {
	return s.String()
}

// SetIndividualRegistrationNumber sets the IndividualRegistrationNumber field's value.
func (s *PolandAdditionalInfo) SetIndividualRegistrationNumber(v string) *PolandAdditionalInfo {
	s.IndividualRegistrationNumber = &v
	return s
}

// SetIsGroupVatEnabled sets the IsGroupVatEnabled field's value.
func (s *PolandAdditionalInfo) SetIsGroupVatEnabled(v bool) *PolandAdditionalInfo {
	s.IsGroupVatEnabled = &v
	return s
}

type PutTaxRegistrationInput struct {
	_ struct{} `type:"structure"`

	// Your unique account identifier.
	AccountId *string `locationName:"accountId" min:"12" type:"string"`

	// Your TRN information that will be stored to the account mentioned in accountId.
	//
	// TaxRegistrationEntry is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PutTaxRegistrationInput's
	// String and GoString methods.
	//
	// TaxRegistrationEntry is a required field
	TaxRegistrationEntry *TaxRegistrationEntry `locationName:"taxRegistrationEntry" type:"structure" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutTaxRegistrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutTaxRegistrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutTaxRegistrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutTaxRegistrationInput"}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.TaxRegistrationEntry == nil {
		invalidParams.Add(request.NewErrParamRequired("TaxRegistrationEntry"))
	}
	if s.TaxRegistrationEntry != nil {
		if err := s.TaxRegistrationEntry.Validate(); err != nil {
			invalidParams.AddNested("TaxRegistrationEntry", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *PutTaxRegistrationInput) SetAccountId(v string) *PutTaxRegistrationInput {
	s.AccountId = &v
	return s
}

// SetTaxRegistrationEntry sets the TaxRegistrationEntry field's value.
func (s *PutTaxRegistrationInput) SetTaxRegistrationEntry(v *TaxRegistrationEntry) *PutTaxRegistrationInput {
	s.TaxRegistrationEntry = v
	return s
}

type PutTaxRegistrationOutput struct {
	_ struct{} `type:"structure"`

	// The status of your TRN stored in the system after processing. Based on the
	// validation occurring on the TRN, the status can be Verified, Pending or Rejected.
	Status *string `locationName:"status" type:"string" enum:"TaxRegistrationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutTaxRegistrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutTaxRegistrationOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *PutTaxRegistrationOutput) SetStatus(v string) *PutTaxRegistrationOutput {
	s.Status = &v
	return s
}

// The exception thrown when the input doesn't have a resource associated to
// it.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// 404
	//
	// ErrorCode is a required field
	ErrorCode *string `locationName:"errorCode" type:"string" required:"true"`

	// Message_ is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ResourceNotFoundException's
	// String and GoString methods.
	Message_ *string `locationName:"message" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Additional tax information to specify for a TRN in Romania.
type RomaniaAdditionalInfo struct {
	_ struct{} `type:"structure"`

	// The tax registration number type. The value can be TaxRegistrationNumber
	// or LocalRegistrationNumber.
	//
	// TaxRegistrationNumberType is a required field
	TaxRegistrationNumberType *string `locationName:"taxRegistrationNumberType" type:"string" required:"true" enum:"TaxRegistrationNumberType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RomaniaAdditionalInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RomaniaAdditionalInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RomaniaAdditionalInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RomaniaAdditionalInfo"}
	if s.TaxRegistrationNumberType == nil {
		invalidParams.Add(request.NewErrParamRequired("TaxRegistrationNumberType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTaxRegistrationNumberType sets the TaxRegistrationNumberType field's value.
func (s *RomaniaAdditionalInfo) SetTaxRegistrationNumberType(v string) *RomaniaAdditionalInfo {
	s.TaxRegistrationNumberType = &v
	return s
}

// Additional tax information associated with your TRN in Saudi Arabia.
type SaudiArabiaAdditionalInfo struct {
	_ struct{} `type:"structure"`

	// The tax registration number type.
	TaxRegistrationNumberType *string `locationName:"taxRegistrationNumberType" type:"string" enum:"SaudiArabiaTaxRegistrationNumberType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SaudiArabiaAdditionalInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SaudiArabiaAdditionalInfo) GoString() string {
	return s.String()
}

// SetTaxRegistrationNumberType sets the TaxRegistrationNumberType field's value.
func (s *SaudiArabiaAdditionalInfo) SetTaxRegistrationNumberType(v string) *SaudiArabiaAdditionalInfo {
	s.TaxRegistrationNumberType = &v
	return s
}

// The Amazon S3 bucket in your account where your tax document is located.
type SourceS3Location struct {
	_ struct{} `type:"structure"`

	// The name of your Amazon S3 bucket that your tax document is located.
	//
	// Bucket is a required field
	Bucket *string `locationName:"bucket" min:"3" type:"string" required:"true"`

	// The object key of your tax document object in Amazon S3.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceS3Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceS3Location) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceS3Location) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SourceS3Location"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *SourceS3Location) SetBucket(v string) *SourceS3Location {
	s.Bucket = &v
	return s
}

// SetKey sets the Key field's value.
func (s *SourceS3Location) SetKey(v string) *SourceS3Location {
	s.Key = &v
	return s
}

// Additional tax information associated with your TRN in South Korea.
type SouthKoreaAdditionalInfo struct {
	_ struct{} `type:"structure"`

	// The business legal name based on the most recently uploaded tax registration
	// certificate.
	//
	// BusinessRepresentativeName is a required field
	BusinessRepresentativeName *string `locationName:"businessRepresentativeName" min:"1" type:"string" required:"true"`

	// Item of business based on the most recently uploaded tax registration certificate.
	//
	// ItemOfBusiness is a required field
	ItemOfBusiness *string `locationName:"itemOfBusiness" min:"1" type:"string" required:"true"`

	// Line of business based on the most recently uploaded tax registration certificate.
	//
	// LineOfBusiness is a required field
	LineOfBusiness *string `locationName:"lineOfBusiness" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SouthKoreaAdditionalInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SouthKoreaAdditionalInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SouthKoreaAdditionalInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SouthKoreaAdditionalInfo"}
	if s.BusinessRepresentativeName == nil {
		invalidParams.Add(request.NewErrParamRequired("BusinessRepresentativeName"))
	}
	if s.BusinessRepresentativeName != nil && len(*s.BusinessRepresentativeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BusinessRepresentativeName", 1))
	}
	if s.ItemOfBusiness == nil {
		invalidParams.Add(request.NewErrParamRequired("ItemOfBusiness"))
	}
	if s.ItemOfBusiness != nil && len(*s.ItemOfBusiness) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ItemOfBusiness", 1))
	}
	if s.LineOfBusiness == nil {
		invalidParams.Add(request.NewErrParamRequired("LineOfBusiness"))
	}
	if s.LineOfBusiness != nil && len(*s.LineOfBusiness) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LineOfBusiness", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBusinessRepresentativeName sets the BusinessRepresentativeName field's value.
func (s *SouthKoreaAdditionalInfo) SetBusinessRepresentativeName(v string) *SouthKoreaAdditionalInfo {
	s.BusinessRepresentativeName = &v
	return s
}

// SetItemOfBusiness sets the ItemOfBusiness field's value.
func (s *SouthKoreaAdditionalInfo) SetItemOfBusiness(v string) *SouthKoreaAdditionalInfo {
	s.ItemOfBusiness = &v
	return s
}

// SetLineOfBusiness sets the LineOfBusiness field's value.
func (s *SouthKoreaAdditionalInfo) SetLineOfBusiness(v string) *SouthKoreaAdditionalInfo {
	s.LineOfBusiness = &v
	return s
}

// Additional tax information associated with your TRN in Spain.
type SpainAdditionalInfo struct {
	_ struct{} `type:"structure"`

	// The registration type in Spain.
	//
	// RegistrationType is a required field
	RegistrationType *string `locationName:"registrationType" type:"string" required:"true" enum:"RegistrationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SpainAdditionalInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SpainAdditionalInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SpainAdditionalInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SpainAdditionalInfo"}
	if s.RegistrationType == nil {
		invalidParams.Add(request.NewErrParamRequired("RegistrationType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRegistrationType sets the RegistrationType field's value.
func (s *SpainAdditionalInfo) SetRegistrationType(v string) *SpainAdditionalInfo {
	s.RegistrationType = &v
	return s
}

// The metadata for your tax document.
type TaxDocumentMetadata struct {
	_ struct{} `type:"structure"`

	// The tax document access token, which contains information that the Tax Settings
	// API uses to locate the tax document.
	//
	// If you update your tax registration, the existing taxDocumentAccessToken
	// won't be valid. To get the latest token, call the GetTaxRegistration or ListTaxRegistrations
	// API operation. This token is valid for 24 hours.
	//
	// TaxDocumentAccessToken is a required field
	TaxDocumentAccessToken *string `locationName:"taxDocumentAccessToken" type:"string" required:"true"`

	// The name of your tax document.
	//
	// TaxDocumentName is a required field
	TaxDocumentName *string `locationName:"taxDocumentName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaxDocumentMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaxDocumentMetadata) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TaxDocumentMetadata) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TaxDocumentMetadata"}
	if s.TaxDocumentAccessToken == nil {
		invalidParams.Add(request.NewErrParamRequired("TaxDocumentAccessToken"))
	}
	if s.TaxDocumentName == nil {
		invalidParams.Add(request.NewErrParamRequired("TaxDocumentName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTaxDocumentAccessToken sets the TaxDocumentAccessToken field's value.
func (s *TaxDocumentMetadata) SetTaxDocumentAccessToken(v string) *TaxDocumentMetadata {
	s.TaxDocumentAccessToken = &v
	return s
}

// SetTaxDocumentName sets the TaxDocumentName field's value.
func (s *TaxDocumentMetadata) SetTaxDocumentName(v string) *TaxDocumentMetadata {
	s.TaxDocumentName = &v
	return s
}

// Tax inheritance information associated with the account.
type TaxInheritanceDetails struct {
	_ struct{} `type:"structure"`

	// Tax inheritance reason information associated with the account.
	InheritanceObtainedReason *string `locationName:"inheritanceObtainedReason" type:"string"`

	// Tax inheritance parent account information associated with the account.
	ParentEntityId *string `locationName:"parentEntityId" min:"12" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaxInheritanceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaxInheritanceDetails) GoString() string {
	return s.String()
}

// SetInheritanceObtainedReason sets the InheritanceObtainedReason field's value.
func (s *TaxInheritanceDetails) SetInheritanceObtainedReason(v string) *TaxInheritanceDetails {
	s.InheritanceObtainedReason = &v
	return s
}

// SetParentEntityId sets the ParentEntityId field's value.
func (s *TaxInheritanceDetails) SetParentEntityId(v string) *TaxInheritanceDetails {
	s.ParentEntityId = &v
	return s
}

// Your TRN information.
type TaxRegistration struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Additional tax information associated with your TRN.
	AdditionalTaxInformation *AdditionalInfoResponse `locationName:"additionalTaxInformation" type:"structure"`

	// The email address to receive VAT invoices.
	CertifiedEmailId *string `locationName:"certifiedEmailId" type:"string"`

	// The legal address associated with your TRN registration.
	//
	// LegalAddress is a required field
	LegalAddress *Address `locationName:"legalAddress" type:"structure" required:"true"`

	// The legal name associated with your TRN registration.
	//
	// LegalName is a required field
	LegalName *string `locationName:"legalName" min:"1" type:"string" required:"true"`

	// Your tax registration unique identifier.
	//
	// RegistrationId is a required field
	RegistrationId *string `locationName:"registrationId" min:"1" type:"string" required:"true"`

	// Type of your tax registration. This can be either VAT or GST.
	//
	// RegistrationType is a required field
	RegistrationType *string `locationName:"registrationType" type:"string" required:"true" enum:"TaxRegistrationType"`

	// The industry that describes your business. For business-to-business (B2B)
	// customers, specify Business. For business-to-consumer (B2C) customers, specify
	// Individual. For business-to-government (B2G), specify Government. Note that
	// certain values may not applicable for the request country. Please refer to
	// country specific information in API document.
	Sector *string `locationName:"sector" type:"string" enum:"Sector"`

	// The status of your TRN. This can be either Verified, Pending, Deleted, or
	// Rejected.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"TaxRegistrationStatus"`

	// The metadata for your tax document.
	TaxDocumentMetadatas []*TaxDocumentMetadata `locationName:"taxDocumentMetadatas" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaxRegistration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaxRegistration) GoString() string {
	return s.String()
}

// SetAdditionalTaxInformation sets the AdditionalTaxInformation field's value.
func (s *TaxRegistration) SetAdditionalTaxInformation(v *AdditionalInfoResponse) *TaxRegistration {
	s.AdditionalTaxInformation = v
	return s
}

// SetCertifiedEmailId sets the CertifiedEmailId field's value.
func (s *TaxRegistration) SetCertifiedEmailId(v string) *TaxRegistration {
	s.CertifiedEmailId = &v
	return s
}

// SetLegalAddress sets the LegalAddress field's value.
func (s *TaxRegistration) SetLegalAddress(v *Address) *TaxRegistration {
	s.LegalAddress = v
	return s
}

// SetLegalName sets the LegalName field's value.
func (s *TaxRegistration) SetLegalName(v string) *TaxRegistration {
	s.LegalName = &v
	return s
}

// SetRegistrationId sets the RegistrationId field's value.
func (s *TaxRegistration) SetRegistrationId(v string) *TaxRegistration {
	s.RegistrationId = &v
	return s
}

// SetRegistrationType sets the RegistrationType field's value.
func (s *TaxRegistration) SetRegistrationType(v string) *TaxRegistration {
	s.RegistrationType = &v
	return s
}

// SetSector sets the Sector field's value.
func (s *TaxRegistration) SetSector(v string) *TaxRegistration {
	s.Sector = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TaxRegistration) SetStatus(v string) *TaxRegistration {
	s.Status = &v
	return s
}

// SetTaxDocumentMetadatas sets the TaxDocumentMetadatas field's value.
func (s *TaxRegistration) SetTaxDocumentMetadatas(v []*TaxDocumentMetadata) *TaxRegistration {
	s.TaxDocumentMetadatas = v
	return s
}

// Tax registration document information.
type TaxRegistrationDocument struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 location where your tax registration document is stored.
	//
	// S3Location is a required field
	S3Location *SourceS3Location `locationName:"s3Location" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaxRegistrationDocument) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaxRegistrationDocument) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TaxRegistrationDocument) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TaxRegistrationDocument"}
	if s.S3Location == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Location"))
	}
	if s.S3Location != nil {
		if err := s.S3Location.Validate(); err != nil {
			invalidParams.AddNested("S3Location", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Location sets the S3Location field's value.
func (s *TaxRegistrationDocument) SetS3Location(v *SourceS3Location) *TaxRegistrationDocument {
	s.S3Location = v
	return s
}

// The TRN information you provide when you add a new TRN, or update.
type TaxRegistrationEntry struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Additional tax information associated with your TRN. You only need to specify
	// this parameter if Amazon Web Services collects any additional information
	// for your country within AdditionalInfoRequest.
	AdditionalTaxInformation *AdditionalInfoRequest `locationName:"additionalTaxInformation" type:"structure"`

	// The email address to receive VAT invoices.
	CertifiedEmailId *string `locationName:"certifiedEmailId" type:"string"`

	// The legal address associated with your TRN.
	//
	// If you're setting a TRN in Brazil for the CNPJ tax type, you don't need to
	// specify the legal address.
	//
	// For TRNs in other countries and for CPF tax types Brazil, you must specify
	// the legal address.
	LegalAddress *Address `locationName:"legalAddress" type:"structure"`

	// The legal name associated with your TRN.
	//
	// If you're setting a TRN in Brazil, you don't need to specify the legal name.
	// For TRNs in other countries, you must specify the legal name.
	LegalName *string `locationName:"legalName" min:"1" type:"string"`

	// Your tax registration unique identifier.
	//
	// RegistrationId is a required field
	RegistrationId *string `locationName:"registrationId" min:"1" type:"string" required:"true"`

	// Your tax registration type. This can be either VAT or GST.
	//
	// RegistrationType is a required field
	RegistrationType *string `locationName:"registrationType" type:"string" required:"true" enum:"TaxRegistrationType"`

	// The industry that describes your business. For business-to-business (B2B)
	// customers, specify Business. For business-to-consumer (B2C) customers, specify
	// Individual. For business-to-government (B2G), specify Government.Note that
	// certain values may not applicable for the request country. Please refer to
	// country specific information in API document.
	Sector *string `locationName:"sector" type:"string" enum:"Sector"`

	// Additional details needed to verify your TRN information in Brazil. You only
	// need to specify this parameter when you set a TRN in Brazil that is the CPF
	// tax type.
	//
	// Don't specify this parameter to set a TRN in Brazil of the CNPJ tax type
	// or to set a TRN for another country.
	VerificationDetails *VerificationDetails `locationName:"verificationDetails" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaxRegistrationEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaxRegistrationEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TaxRegistrationEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TaxRegistrationEntry"}
	if s.LegalName != nil && len(*s.LegalName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LegalName", 1))
	}
	if s.RegistrationId == nil {
		invalidParams.Add(request.NewErrParamRequired("RegistrationId"))
	}
	if s.RegistrationId != nil && len(*s.RegistrationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegistrationId", 1))
	}
	if s.RegistrationType == nil {
		invalidParams.Add(request.NewErrParamRequired("RegistrationType"))
	}
	if s.AdditionalTaxInformation != nil {
		if err := s.AdditionalTaxInformation.Validate(); err != nil {
			invalidParams.AddNested("AdditionalTaxInformation", err.(request.ErrInvalidParams))
		}
	}
	if s.LegalAddress != nil {
		if err := s.LegalAddress.Validate(); err != nil {
			invalidParams.AddNested("LegalAddress", err.(request.ErrInvalidParams))
		}
	}
	if s.VerificationDetails != nil {
		if err := s.VerificationDetails.Validate(); err != nil {
			invalidParams.AddNested("VerificationDetails", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalTaxInformation sets the AdditionalTaxInformation field's value.
func (s *TaxRegistrationEntry) SetAdditionalTaxInformation(v *AdditionalInfoRequest) *TaxRegistrationEntry {
	s.AdditionalTaxInformation = v
	return s
}

// SetCertifiedEmailId sets the CertifiedEmailId field's value.
func (s *TaxRegistrationEntry) SetCertifiedEmailId(v string) *TaxRegistrationEntry {
	s.CertifiedEmailId = &v
	return s
}

// SetLegalAddress sets the LegalAddress field's value.
func (s *TaxRegistrationEntry) SetLegalAddress(v *Address) *TaxRegistrationEntry {
	s.LegalAddress = v
	return s
}

// SetLegalName sets the LegalName field's value.
func (s *TaxRegistrationEntry) SetLegalName(v string) *TaxRegistrationEntry {
	s.LegalName = &v
	return s
}

// SetRegistrationId sets the RegistrationId field's value.
func (s *TaxRegistrationEntry) SetRegistrationId(v string) *TaxRegistrationEntry {
	s.RegistrationId = &v
	return s
}

// SetRegistrationType sets the RegistrationType field's value.
func (s *TaxRegistrationEntry) SetRegistrationType(v string) *TaxRegistrationEntry {
	s.RegistrationType = &v
	return s
}

// SetSector sets the Sector field's value.
func (s *TaxRegistrationEntry) SetSector(v string) *TaxRegistrationEntry {
	s.Sector = &v
	return s
}

// SetVerificationDetails sets the VerificationDetails field's value.
func (s *TaxRegistrationEntry) SetVerificationDetails(v *VerificationDetails) *TaxRegistrationEntry {
	s.VerificationDetails = v
	return s
}

// Your TRN information with jurisdiction details. This doesn't contain the
// full legal address associated with the TRN information.
type TaxRegistrationWithJurisdiction struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Additional tax information associated with your TRN.
	AdditionalTaxInformation *AdditionalInfoResponse `locationName:"additionalTaxInformation" type:"structure"`

	// The email address to receive VAT invoices.
	CertifiedEmailId *string `locationName:"certifiedEmailId" type:"string"`

	// The jurisdiction associated with your TRN information.
	//
	// Jurisdiction is a required field
	Jurisdiction *Jurisdiction `locationName:"jurisdiction" type:"structure" required:"true"`

	// The legal name associated with your TRN information.
	//
	// LegalName is a required field
	LegalName *string `locationName:"legalName" min:"1" type:"string" required:"true"`

	// Your tax registration unique identifier.
	//
	// RegistrationId is a required field
	RegistrationId *string `locationName:"registrationId" min:"1" type:"string" required:"true"`

	// The type of your tax registration. This can be either VAT or GST.
	//
	// RegistrationType is a required field
	RegistrationType *string `locationName:"registrationType" type:"string" required:"true" enum:"TaxRegistrationType"`

	// The industry that describes your business. For business-to-business (B2B)
	// customers, specify Business. For business-to-consumer (B2C) customers, specify
	// Individual. For business-to-government (B2G), specify Government.Note that
	// certain values may not applicable for the request country. Please refer to
	// country specific information in API document.
	Sector *string `locationName:"sector" type:"string" enum:"Sector"`

	// The status of your TRN. This can be either Verified, Pending, Deleted, or
	// Rejected.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"TaxRegistrationStatus"`

	// The metadata for your tax document.
	TaxDocumentMetadatas []*TaxDocumentMetadata `locationName:"taxDocumentMetadatas" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaxRegistrationWithJurisdiction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TaxRegistrationWithJurisdiction) GoString() string {
	return s.String()
}

// SetAdditionalTaxInformation sets the AdditionalTaxInformation field's value.
func (s *TaxRegistrationWithJurisdiction) SetAdditionalTaxInformation(v *AdditionalInfoResponse) *TaxRegistrationWithJurisdiction {
	s.AdditionalTaxInformation = v
	return s
}

// SetCertifiedEmailId sets the CertifiedEmailId field's value.
func (s *TaxRegistrationWithJurisdiction) SetCertifiedEmailId(v string) *TaxRegistrationWithJurisdiction {
	s.CertifiedEmailId = &v
	return s
}

// SetJurisdiction sets the Jurisdiction field's value.
func (s *TaxRegistrationWithJurisdiction) SetJurisdiction(v *Jurisdiction) *TaxRegistrationWithJurisdiction {
	s.Jurisdiction = v
	return s
}

// SetLegalName sets the LegalName field's value.
func (s *TaxRegistrationWithJurisdiction) SetLegalName(v string) *TaxRegistrationWithJurisdiction {
	s.LegalName = &v
	return s
}

// SetRegistrationId sets the RegistrationId field's value.
func (s *TaxRegistrationWithJurisdiction) SetRegistrationId(v string) *TaxRegistrationWithJurisdiction {
	s.RegistrationId = &v
	return s
}

// SetRegistrationType sets the RegistrationType field's value.
func (s *TaxRegistrationWithJurisdiction) SetRegistrationType(v string) *TaxRegistrationWithJurisdiction {
	s.RegistrationType = &v
	return s
}

// SetSector sets the Sector field's value.
func (s *TaxRegistrationWithJurisdiction) SetSector(v string) *TaxRegistrationWithJurisdiction {
	s.Sector = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TaxRegistrationWithJurisdiction) SetStatus(v string) *TaxRegistrationWithJurisdiction {
	s.Status = &v
	return s
}

// SetTaxDocumentMetadatas sets the TaxDocumentMetadatas field's value.
func (s *TaxRegistrationWithJurisdiction) SetTaxDocumentMetadatas(v []*TaxDocumentMetadata) *TaxRegistrationWithJurisdiction {
	s.TaxDocumentMetadatas = v
	return s
}

// Additional tax information associated with your TRN in Turkey.
type TurkeyAdditionalInfo struct {
	_ struct{} `type:"structure"`

	// The industry information that tells the Tax Settings API if you're subject
	// to additional withholding taxes. This information required for business-to-business
	// (B2B) customers. This information is conditionally mandatory for B2B customers
	// who are subject to KDV tax.
	Industries *string `locationName:"industries" type:"string" enum:"Industries"`

	// The Registered Electronic Mail (REM) that is used to send notarized communication.
	// This parameter is optional for business-to-business (B2B) and business-to-government
	// (B2G) customers. It's not required for business-to-consumer (B2C) customers.
	KepEmailId *string `locationName:"kepEmailId" type:"string"`

	// Secondary tax ID (“harcama birimi VKN”si”). If one isn't provided,
	// we will use your VKN as the secondary ID.
	SecondaryTaxId *string `locationName:"secondaryTaxId" type:"string"`

	// The tax office where you're registered. You can enter this information as
	// a string. The Tax Settings API will add this information to your invoice.
	// This parameter is required for business-to-business (B2B) and business-to-government
	// customers. It's not required for business-to-consumer (B2C) customers.
	TaxOffice *string `locationName:"taxOffice" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TurkeyAdditionalInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TurkeyAdditionalInfo) GoString() string {
	return s.String()
}

// SetIndustries sets the Industries field's value.
func (s *TurkeyAdditionalInfo) SetIndustries(v string) *TurkeyAdditionalInfo {
	s.Industries = &v
	return s
}

// SetKepEmailId sets the KepEmailId field's value.
func (s *TurkeyAdditionalInfo) SetKepEmailId(v string) *TurkeyAdditionalInfo {
	s.KepEmailId = &v
	return s
}

// SetSecondaryTaxId sets the SecondaryTaxId field's value.
func (s *TurkeyAdditionalInfo) SetSecondaryTaxId(v string) *TurkeyAdditionalInfo {
	s.SecondaryTaxId = &v
	return s
}

// SetTaxOffice sets the TaxOffice field's value.
func (s *TurkeyAdditionalInfo) SetTaxOffice(v string) *TurkeyAdditionalInfo {
	s.TaxOffice = &v
	return s
}

// Additional tax information associated with your TRN in Ukraine.
type UkraineAdditionalInfo struct {
	_ struct{} `type:"structure"`

	// The tax registration type.
	//
	// UkraineTrnType is a required field
	UkraineTrnType *string `locationName:"ukraineTrnType" type:"string" required:"true" enum:"UkraineTrnType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UkraineAdditionalInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UkraineAdditionalInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UkraineAdditionalInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UkraineAdditionalInfo"}
	if s.UkraineTrnType == nil {
		invalidParams.Add(request.NewErrParamRequired("UkraineTrnType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUkraineTrnType sets the UkraineTrnType field's value.
func (s *UkraineAdditionalInfo) SetUkraineTrnType(v string) *UkraineAdditionalInfo {
	s.UkraineTrnType = &v
	return s
}

// The exception when the input doesn't pass validation for at least one of
// the input parameters.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// 400
	//
	// ErrorCode is a required field
	ErrorCode *string `locationName:"errorCode" type:"string" required:"true" enum:"ValidationExceptionErrorCode"`

	// 400
	FieldList []*ValidationExceptionField `locationName:"fieldList" type:"list"`

	// Message_ is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ValidationException's
	// String and GoString methods.
	Message_ *string `locationName:"message" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The information about the specified parameter in the request that caused
// an error.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// The name of the parameter that caused a ValidationException error.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

// Required information to verify your TRN.
type VerificationDetails struct {
	_ struct{} `type:"structure"`

	// Date of birth to verify your submitted TRN. Use the YYYY-MM-DD format.
	DateOfBirth *string `locationName:"dateOfBirth" min:"10" type:"string"`

	// The tax registration document, which is required for specific countries such
	// as Bangladesh, Kenya, South Korea and Spain.
	TaxRegistrationDocuments []*TaxRegistrationDocument `locationName:"taxRegistrationDocuments" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerificationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerificationDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VerificationDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VerificationDetails"}
	if s.DateOfBirth != nil && len(*s.DateOfBirth) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("DateOfBirth", 10))
	}
	if s.TaxRegistrationDocuments != nil && len(s.TaxRegistrationDocuments) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaxRegistrationDocuments", 1))
	}
	if s.TaxRegistrationDocuments != nil {
		for i, v := range s.TaxRegistrationDocuments {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TaxRegistrationDocuments", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDateOfBirth sets the DateOfBirth field's value.
func (s *VerificationDetails) SetDateOfBirth(v string) *VerificationDetails {
	s.DateOfBirth = &v
	return s
}

// SetTaxRegistrationDocuments sets the TaxRegistrationDocuments field's value.
func (s *VerificationDetails) SetTaxRegistrationDocuments(v []*TaxRegistrationDocument) *VerificationDetails {
	s.TaxRegistrationDocuments = v
	return s
}

const (
	// AddressRoleTypeTaxAddress is a AddressRoleType enum value
	AddressRoleTypeTaxAddress = "TaxAddress"

	// AddressRoleTypeBillingAddress is a AddressRoleType enum value
	AddressRoleTypeBillingAddress = "BillingAddress"

	// AddressRoleTypeContactAddress is a AddressRoleType enum value
	AddressRoleTypeContactAddress = "ContactAddress"
)

// AddressRoleType_Values returns all elements of the AddressRoleType enum
func AddressRoleType_Values() []string {
	return []string{
		AddressRoleTypeTaxAddress,
		AddressRoleTypeBillingAddress,
		AddressRoleTypeContactAddress,
	}
}

const (
	// IndustriesCirculatingOrg is a Industries enum value
	IndustriesCirculatingOrg = "CirculatingOrg"

	// IndustriesProfessionalOrg is a Industries enum value
	IndustriesProfessionalOrg = "ProfessionalOrg"

	// IndustriesBanks is a Industries enum value
	IndustriesBanks = "Banks"

	// IndustriesInsurance is a Industries enum value
	IndustriesInsurance = "Insurance"

	// IndustriesPensionAndBenefitFunds is a Industries enum value
	IndustriesPensionAndBenefitFunds = "PensionAndBenefitFunds"

	// IndustriesDevelopmentAgencies is a Industries enum value
	IndustriesDevelopmentAgencies = "DevelopmentAgencies"
)

// Industries_Values returns all elements of the Industries enum
func Industries_Values() []string {
	return []string{
		IndustriesCirculatingOrg,
		IndustriesProfessionalOrg,
		IndustriesBanks,
		IndustriesInsurance,
		IndustriesPensionAndBenefitFunds,
		IndustriesDevelopmentAgencies,
	}
}

const (
	// IsraelCustomerTypeBusiness is a IsraelCustomerType enum value
	IsraelCustomerTypeBusiness = "Business"

	// IsraelCustomerTypeIndividual is a IsraelCustomerType enum value
	IsraelCustomerTypeIndividual = "Individual"
)

// IsraelCustomerType_Values returns all elements of the IsraelCustomerType enum
func IsraelCustomerType_Values() []string {
	return []string{
		IsraelCustomerTypeBusiness,
		IsraelCustomerTypeIndividual,
	}
}

const (
	// IsraelDealerTypeAuthorized is a IsraelDealerType enum value
	IsraelDealerTypeAuthorized = "Authorized"

	// IsraelDealerTypeNonAuthorized is a IsraelDealerType enum value
	IsraelDealerTypeNonAuthorized = "Non-authorized"
)

// IsraelDealerType_Values returns all elements of the IsraelDealerType enum
func IsraelDealerType_Values() []string {
	return []string{
		IsraelDealerTypeAuthorized,
		IsraelDealerTypeNonAuthorized,
	}
}

const (
	// MalaysiaServiceTaxCodeConsultancy is a MalaysiaServiceTaxCode enum value
	MalaysiaServiceTaxCodeConsultancy = "Consultancy"

	// MalaysiaServiceTaxCodeDigitalServiceAndElectronicMedium is a MalaysiaServiceTaxCode enum value
	MalaysiaServiceTaxCodeDigitalServiceAndElectronicMedium = "Digital Service And Electronic Medium"

	// MalaysiaServiceTaxCodeItservices is a MalaysiaServiceTaxCode enum value
	MalaysiaServiceTaxCodeItservices = "IT Services"

	// MalaysiaServiceTaxCodeTrainingOrCoaching is a MalaysiaServiceTaxCode enum value
	MalaysiaServiceTaxCodeTrainingOrCoaching = "Training Or Coaching"
)

// MalaysiaServiceTaxCode_Values returns all elements of the MalaysiaServiceTaxCode enum
func MalaysiaServiceTaxCode_Values() []string {
	return []string{
		MalaysiaServiceTaxCodeConsultancy,
		MalaysiaServiceTaxCodeDigitalServiceAndElectronicMedium,
		MalaysiaServiceTaxCodeItservices,
		MalaysiaServiceTaxCodeTrainingOrCoaching,
	}
}

const (
	// PersonTypeLegalPerson is a PersonType enum value
	PersonTypeLegalPerson = "Legal Person"

	// PersonTypePhysicalPerson is a PersonType enum value
	PersonTypePhysicalPerson = "Physical Person"

	// PersonTypeBusiness is a PersonType enum value
	PersonTypeBusiness = "Business"
)

// PersonType_Values returns all elements of the PersonType enum
func PersonType_Values() []string {
	return []string{
		PersonTypeLegalPerson,
		PersonTypePhysicalPerson,
		PersonTypeBusiness,
	}
}

const (
	// RegistrationTypeIntraEu is a RegistrationType enum value
	RegistrationTypeIntraEu = "Intra-EU"

	// RegistrationTypeLocal is a RegistrationType enum value
	RegistrationTypeLocal = "Local"
)

// RegistrationType_Values returns all elements of the RegistrationType enum
func RegistrationType_Values() []string {
	return []string{
		RegistrationTypeIntraEu,
		RegistrationTypeLocal,
	}
}

const (
	// SaudiArabiaTaxRegistrationNumberTypeTaxRegistrationNumber is a SaudiArabiaTaxRegistrationNumberType enum value
	SaudiArabiaTaxRegistrationNumberTypeTaxRegistrationNumber = "TaxRegistrationNumber"

	// SaudiArabiaTaxRegistrationNumberTypeTaxIdentificationNumber is a SaudiArabiaTaxRegistrationNumberType enum value
	SaudiArabiaTaxRegistrationNumberTypeTaxIdentificationNumber = "TaxIdentificationNumber"

	// SaudiArabiaTaxRegistrationNumberTypeCommercialRegistrationNumber is a SaudiArabiaTaxRegistrationNumberType enum value
	SaudiArabiaTaxRegistrationNumberTypeCommercialRegistrationNumber = "CommercialRegistrationNumber"
)

// SaudiArabiaTaxRegistrationNumberType_Values returns all elements of the SaudiArabiaTaxRegistrationNumberType enum
func SaudiArabiaTaxRegistrationNumberType_Values() []string {
	return []string{
		SaudiArabiaTaxRegistrationNumberTypeTaxRegistrationNumber,
		SaudiArabiaTaxRegistrationNumberTypeTaxIdentificationNumber,
		SaudiArabiaTaxRegistrationNumberTypeCommercialRegistrationNumber,
	}
}

const (
	// SectorBusiness is a Sector enum value
	SectorBusiness = "Business"

	// SectorIndividual is a Sector enum value
	SectorIndividual = "Individual"

	// SectorGovernment is a Sector enum value
	SectorGovernment = "Government"
)

// Sector_Values returns all elements of the Sector enum
func Sector_Values() []string {
	return []string{
		SectorBusiness,
		SectorIndividual,
		SectorGovernment,
	}
}

const (
	// TaxRegistrationNumberTypeTaxRegistrationNumber is a TaxRegistrationNumberType enum value
	TaxRegistrationNumberTypeTaxRegistrationNumber = "TaxRegistrationNumber"

	// TaxRegistrationNumberTypeLocalRegistrationNumber is a TaxRegistrationNumberType enum value
	TaxRegistrationNumberTypeLocalRegistrationNumber = "LocalRegistrationNumber"
)

// TaxRegistrationNumberType_Values returns all elements of the TaxRegistrationNumberType enum
func TaxRegistrationNumberType_Values() []string {
	return []string{
		TaxRegistrationNumberTypeTaxRegistrationNumber,
		TaxRegistrationNumberTypeLocalRegistrationNumber,
	}
}

const (
	// TaxRegistrationStatusVerified is a TaxRegistrationStatus enum value
	TaxRegistrationStatusVerified = "Verified"

	// TaxRegistrationStatusPending is a TaxRegistrationStatus enum value
	TaxRegistrationStatusPending = "Pending"

	// TaxRegistrationStatusDeleted is a TaxRegistrationStatus enum value
	TaxRegistrationStatusDeleted = "Deleted"

	// TaxRegistrationStatusRejected is a TaxRegistrationStatus enum value
	TaxRegistrationStatusRejected = "Rejected"
)

// TaxRegistrationStatus_Values returns all elements of the TaxRegistrationStatus enum
func TaxRegistrationStatus_Values() []string {
	return []string{
		TaxRegistrationStatusVerified,
		TaxRegistrationStatusPending,
		TaxRegistrationStatusDeleted,
		TaxRegistrationStatusRejected,
	}
}

const (
	// TaxRegistrationTypeVat is a TaxRegistrationType enum value
	TaxRegistrationTypeVat = "VAT"

	// TaxRegistrationTypeGst is a TaxRegistrationType enum value
	TaxRegistrationTypeGst = "GST"

	// TaxRegistrationTypeCpf is a TaxRegistrationType enum value
	TaxRegistrationTypeCpf = "CPF"

	// TaxRegistrationTypeCnpj is a TaxRegistrationType enum value
	TaxRegistrationTypeCnpj = "CNPJ"

	// TaxRegistrationTypeSst is a TaxRegistrationType enum value
	TaxRegistrationTypeSst = "SST"
)

// TaxRegistrationType_Values returns all elements of the TaxRegistrationType enum
func TaxRegistrationType_Values() []string {
	return []string{
		TaxRegistrationTypeVat,
		TaxRegistrationTypeGst,
		TaxRegistrationTypeCpf,
		TaxRegistrationTypeCnpj,
		TaxRegistrationTypeSst,
	}
}

const (
	// UkraineTrnTypeBusiness is a UkraineTrnType enum value
	UkraineTrnTypeBusiness = "Business"

	// UkraineTrnTypeIndividual is a UkraineTrnType enum value
	UkraineTrnTypeIndividual = "Individual"
)

// UkraineTrnType_Values returns all elements of the UkraineTrnType enum
func UkraineTrnType_Values() []string {
	return []string{
		UkraineTrnTypeBusiness,
		UkraineTrnTypeIndividual,
	}
}

const (
	// ValidationExceptionErrorCodeMalformedToken is a ValidationExceptionErrorCode enum value
	ValidationExceptionErrorCodeMalformedToken = "MalformedToken"

	// ValidationExceptionErrorCodeExpiredToken is a ValidationExceptionErrorCode enum value
	ValidationExceptionErrorCodeExpiredToken = "ExpiredToken"

	// ValidationExceptionErrorCodeInvalidToken is a ValidationExceptionErrorCode enum value
	ValidationExceptionErrorCodeInvalidToken = "InvalidToken"

	// ValidationExceptionErrorCodeFieldValidationFailed is a ValidationExceptionErrorCode enum value
	ValidationExceptionErrorCodeFieldValidationFailed = "FieldValidationFailed"

	// ValidationExceptionErrorCodeMissingInput is a ValidationExceptionErrorCode enum value
	ValidationExceptionErrorCodeMissingInput = "MissingInput"
)

// ValidationExceptionErrorCode_Values returns all elements of the ValidationExceptionErrorCode enum
func ValidationExceptionErrorCode_Values() []string {
	return []string{
		ValidationExceptionErrorCodeMalformedToken,
		ValidationExceptionErrorCodeExpiredToken,
		ValidationExceptionErrorCodeInvalidToken,
		ValidationExceptionErrorCodeFieldValidationFailed,
		ValidationExceptionErrorCodeMissingInput,
	}
}
