local state = {}
state.width = canvas:screenWidth()
state.height = canvas:screenHeight()
state.overlay = canvas:newLayer(state.width, state.height)
state.painter = image.newPainter(state.overlay.image)
state.painter:loadFont(script.dir .. "/SourceSans3-Regular.otf")
state.painter:setFontSize(9)
state.painter:setFill(true)
state.painter:setStrokeColor(0xFF000000)
state.painter:setBlend(true)

state.painter:setStrokeWidth(1)
state.painter:setFillColor(0xFFFFFFFF)
state.painter:drawText("Top\nleft", 0, 0, C.ALIGN.TOP | C.ALIGN.LEFT)
state.painter:setStrokeWidth(2)
state.painter:setFillColor(0xFF00FFFF)
state.painter:drawText("Top\ncenter", state.width / 2, 0, C.ALIGN.TOP | C.ALIGN.HCENTER)
state.painter:setStrokeWidth(1)
state.painter:setFillColor(0xFFFF00FF)
state.painter:drawText("Top\nright", state.width, 0, C.ALIGN.TOP | C.ALIGN.RIGHT)

state.painter:setStrokeWidth(2)
state.painter:setFillColor(0xFFFFFF00)
state.painter:drawText("Center\nleft", 0, state.height / 2, C.ALIGN.VCENTER | C.ALIGN.LEFT)
state.painter:setStrokeWidth(3)
state.painter:setFillColor(0xFFFF0000)
state.painter:drawText("Center\ncenter", state.width / 2, state.height / 2, C.ALIGN.VCENTER | C.ALIGN.HCENTER)
state.painter:setStrokeWidth(2)
state.painter:setFillColor(0xFF00FF00)
state.painter:drawText("Center\nright", state.width, state.height / 2, C.ALIGN.VCENTER | C.ALIGN.RIGHT)

state.painter:setStrokeWidth(1)
state.painter:setFillColor(0xFF0000FF)
state.painter:drawText("Bottom\nleft", 0, state.height, C.ALIGN.BOTTOM | C.ALIGN.LEFT)
state.painter:setStrokeWidth(2)
state.painter:setFillColor(0xFF808080)
state.painter:drawText("Bottom\ncenter", state.width / 2, state.height, C.ALIGN.BOTTOM | C.ALIGN.HCENTER)
state.painter:setStrokeWidth(1)
state.painter:setStrokeColor(0xFFFFFFFF)
state.painter:setFillColor(0xFF000000)
state.painter:drawText("Bottom\nright", state.width, state.height, C.ALIGN.BOTTOM | C.ALIGN.RIGHT)
state.overlay:update()
