/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cz;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CzechAnalyzer
extends Analyzer {
    public static final String[] CZECH_STOP_WORDS = new String[]{"a", "s", "k", "o", "i", "u", "v", "z", "dnes", "cz", "t\u00edmto", "bude\u0161", "budem", "byli", "jse\u0161", "m\u016fj", "sv\u00fdm", "ta", "tomto", "tohle", "tuto", "tyto", "jej", "zda", "pro\u010d", "m\u00e1te", "tato", "kam", "tohoto", "kdo", "kte\u0159\u00ed", "mi", "n\u00e1m", "tom", "tomuto", "m\u00edt", "nic", "proto", "kterou", "byla", "toho", "proto\u017ee", "asi", "ho", "na\u0161i", "napi\u0161te", "re", "co\u017e", "t\u00edm", "tak\u017ee", "sv\u00fdch", "jej\u00ed", "sv\u00fdmi", "jste", "aj", "tu", "tedy", "teto", "bylo", "kde", "ke", "prav\u00e9", "ji", "nad", "nejsou", "\u010di", "pod", "t\u00e9ma", "mezi", "p\u0159es", "ty", "pak", "v\u00e1m", "ani", "kdy\u017e", "v\u0161ak", "neg", "jsem", "tento", "\u010dl\u00e1nku", "\u010dl\u00e1nky", "aby", "jsme", "p\u0159ed", "pta", "jejich", "byl", "je\u0161t\u011b", "a\u017e", "bez", "tak\u00e9", "pouze", "prvn\u00ed", "va\u0161e", "kter\u00e1", "n\u00e1s", "nov\u00fd", "tipy", "pokud", "m\u016f\u017ee", "strana", "jeho", "sv\u00e9", "jin\u00e9", "zpr\u00e1vy", "nov\u00e9", "nen\u00ed", "v\u00e1s", "jen", "podle", "zde", "u\u017e", "b\u00fdt", "v\u00edce", "bude", "ji\u017e", "ne\u017e", "kter\u00fd", "by", "kter\u00e9", "co", "nebo", "ten", "tak", "m\u00e1", "p\u0159i", "od", "po", "jsou", "jak", "dal\u0161\u00ed", "ale", "si", "se", "ve", "to", "jako", "za", "zp\u011bt", "ze", "do", "pro", "je", "na", "atd", "atp", "jakmile", "p\u0159i\u010dem\u017e", "j\u00e1", "on", "ona", "ono", "oni", "ony", "my", "vy", "j\u00ed", "ji", "m\u011b", "mne", "jemu", "tomu", "t\u011bm", "t\u011bmu", "n\u011bmu", "n\u011bmu\u017e", "jeho\u017e", "j\u00ed\u017e", "jeliko\u017e", "je\u017e", "jako\u017e", "na\u010de\u017e"};
    private Set<?> stoptable;
    private final Version matchVersion;

    public static final Set<?> getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_SET;
    }

    public CzechAnalyzer(Version matchVersion) {
        this(matchVersion, DefaultSetHolder.DEFAULT_SET);
    }

    public CzechAnalyzer(Version matchVersion, Set<?> stopwords) {
        this.matchVersion = matchVersion;
        this.stoptable = CharArraySet.unmodifiableSet((CharArraySet)CharArraySet.copy(stopwords));
    }

    public CzechAnalyzer(Version matchVersion, String ... stopwords) {
        this(matchVersion, StopFilter.makeStopSet((String[])stopwords));
    }

    public CzechAnalyzer(Version matchVersion, HashSet<?> stopwords) {
        this(matchVersion, (Set<?>)stopwords);
    }

    public CzechAnalyzer(Version matchVersion, File stopwords) throws IOException {
        this(matchVersion, WordlistLoader.getWordSet((File)stopwords));
    }

    public void loadStopWords(InputStream wordfile, String encoding) {
        this.setPreviousTokenStream(null);
        if (wordfile == null) {
            this.stoptable = Collections.emptySet();
            return;
        }
        try {
            this.stoptable = Collections.emptySet();
            InputStreamReader isr = encoding == null ? new InputStreamReader(wordfile) : new InputStreamReader(wordfile, encoding);
            this.stoptable = WordlistLoader.getWordSet((Reader)isr);
        }
        catch (IOException e) {
            this.stoptable = Collections.emptySet();
        }
    }

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        StandardTokenizer result = new StandardTokenizer(this.matchVersion, reader);
        result = new StandardFilter((TokenStream)result);
        result = new LowerCaseFilter((TokenStream)result);
        result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault((Version)this.matchVersion), (TokenStream)result, this.stoptable);
        return result;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            streams.source = new StandardTokenizer(this.matchVersion, reader);
            streams.result = new StandardFilter((TokenStream)streams.source);
            streams.result = new LowerCaseFilter(streams.result);
            streams.result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault((Version)this.matchVersion), streams.result, this.stoptable);
            this.setPreviousTokenStream(streams);
        } else {
            streams.source.reset(reader);
        }
        return streams.result;
    }

    private class SavedStreams {
        Tokenizer source;
        TokenStream result;

        private SavedStreams() {
        }
    }

    private static class DefaultSetHolder {
        private static final Set<?> DEFAULT_SET = CharArraySet.unmodifiableSet((CharArraySet)new CharArraySet(Arrays.asList(CZECH_STOP_WORDS), false));

        private DefaultSetHolder() {
        }
    }
}

