/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.calculatrice;

import java.text.DecimalFormat;
import java.text.NumberFormat;

public class CalculatorEngine {
    private StringBuffer display = new StringBuffer(64);
    private DecimalFormat df = (DecimalFormat)NumberFormat.getInstance();
    private boolean newOp = true;
    private boolean inDecimals = false;
    private double value;
    private double keep;
    private int toDo;
    private int decimalCount;

    public CalculatorEngine() {
        this.df.setMaximumFractionDigits(12);
    }

    public void digit(int n) {
        char c;
        if (this.newOp) {
            this.display.delete(0, this.display.length());
            this.newOp = false;
        }
        if ((c = (char)n) == '.') {
            this.display.append('.');
            this.inDecimals = true;
        } else if (!this.inDecimals) {
            this.display.append(n);
        } else if (this.decimalCount < 16) {
            this.display.append(n);
            ++this.decimalCount;
        }
        try {
            this.value = Double.parseDouble(this.display.toString());
        }
        catch (NumberFormatException e) {
            this.value = Double.parseDouble("0.0");
        }
    }

    public void add() {
        this.binaryOperation("+");
    }

    public void subtract() {
        this.binaryOperation("-");
    }

    public void multiply() {
        this.binaryOperation("x");
    }

    public void divide() {
        this.binaryOperation("/");
    }

    public void equals() {
        this.compute();
        this.toDo = 0;
        this.newOp = true;
    }

    private void binaryOperation(String op) {
        if (this.toDo == 0) {
            this.keep = this.value;
        } else {
            this.compute();
        }
        this.toDo = op.hashCode();
        this.resetDecimals();
        this.setDisplay();
        this.newOp = true;
    }

    private void compute() {
        switch (this.toDo) {
            case 43: {
                this.value = this.keep + this.value;
                break;
            }
            case 45: {
                this.value = this.keep - this.value;
                break;
            }
            case 120: {
                this.value = this.keep * this.value;
                break;
            }
            case 47: {
                if (this.value == 0.0) break;
                this.value = this.keep / this.value;
                break;
            }
            case 38: {
                this.value = (int)this.keep & (int)this.value;
                break;
            }
            case 124: {
                this.value = (int)this.keep | (int)this.value;
                break;
            }
            case 94: {
                this.value = (int)this.keep ^ (int)this.value;
                break;
            }
            case 60: {
                this.value = (int)this.keep << (int)this.value;
                break;
            }
            case 62: {
                this.value = (int)this.keep >> (int)this.value;
                break;
            }
            case 109: {
                this.value = this.keep % this.value;
                break;
            }
            case 112: {
                this.value = Math.pow(this.keep, this.value);
            }
        }
        this.keep = this.value;
        this.setDisplay();
    }

    private void setDisplay() {
        if (this.value == 0.0) {
            this.display.delete(0, this.display.length());
            this.display.append("0");
        } else {
            this.display.replace(0, this.display.length(), this.df.format(this.value));
        }
    }

    public void sign() {
        this.value *= -1.0;
        this.unaryOperation();
    }

    public void percent() {
        this.value /= 100.0;
        this.unaryOperation();
    }

    public void reciprocal() {
        if (this.value != 0.0) {
            this.value = 1.0 / this.value;
        }
        this.unaryOperation();
    }

    private void unaryOperation() {
        this.newOp = true;
        this.setDisplay();
    }

    public void backspace() {
        if (this.display.length() > 0) {
            this.display.deleteCharAt(this.display.length() - 1);
        }
        if (this.display.length() == 0) {
            this.clearEntry();
            this.newOp = true;
        } else {
            this.value = Double.parseDouble(this.display.toString().replaceAll("\\u00a0", "").replaceAll(",", "."));
            this.setDisplay();
        }
    }

    public void clear() {
        this.display.delete(0, this.display.length());
        this.value = 0.0;
        this.keep = 0.0;
        this.toDo = 0;
        this.resetDecimals();
        this.setDisplay();
        this.newOp = true;
    }

    public void clearEntry() {
        this.display.delete(0, this.display.length());
        this.value = 0.0;
        this.resetDecimals();
        this.setDisplay();
        this.newOp = true;
    }

    private void resetDecimals() {
        this.inDecimals = false;
        this.decimalCount = 0;
    }

    public String display() {
        return this.display.toString();
    }

    public void sqrt() {
        this.value = Math.sqrt(this.value);
        this.unaryOperation();
    }

    public void sin() {
        this.value = Math.sin(this.value);
        this.unaryOperation();
    }

    public void cos() {
        this.value = Math.cos(this.value);
        this.unaryOperation();
    }

    public void tan() {
        this.value = Math.tan(this.value);
        this.unaryOperation();
    }

    public void asin() {
        this.value = Math.asin(this.value);
        this.unaryOperation();
    }

    public void acos() {
        this.value = Math.acos(this.value);
        this.unaryOperation();
    }

    public void atan() {
        this.value = Math.atan(this.value);
        this.unaryOperation();
    }

    public void log() {
        this.value = Math.log(this.value);
        this.unaryOperation();
    }

    public void degrees() {
        this.value = Math.toDegrees(this.value);
        this.unaryOperation();
    }

    public void radians() {
        this.value = Math.toRadians(this.value);
        this.unaryOperation();
    }

    public void and() {
        this.binaryOperation("&");
    }

    public void or() {
        this.binaryOperation("|");
    }

    public void xor() {
        this.binaryOperation("^");
    }

    public void leftShift() {
        this.binaryOperation("<");
    }

    public void rightShift() {
        this.binaryOperation(">");
    }

    public void mod() {
        this.binaryOperation("m");
    }

    public void pow() {
        this.binaryOperation("p");
    }
}

