/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.list;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.oxbow.swingbits.list.ICheckListModel;

public class CheckListRenderer
extends JCheckBox
implements ListCellRenderer,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Border NO_FOCUS_BORDER;
    private static final Border SAFE_NO_FOCUS_BORDER;

    public CheckListRenderer() {
        this.setOpaque(true);
        this.setBorder(CheckListRenderer.getNoFocusBorder());
    }

    private static Border getNoFocusBorder() {
        if (System.getSecurityManager() != null) {
            return SAFE_NO_FOCUS_BORDER;
        }
        return NO_FOCUS_BORDER;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this.setComponentOrientation(jList.getComponentOrientation());
        Color color = null;
        Color color2 = null;
        JList.DropLocation dropLocation = jList.getDropLocation();
        if (dropLocation != null && !dropLocation.isInsert() && dropLocation.getIndex() == n) {
            color = UIManager.getColor("List.dropCellBackground");
            color2 = UIManager.getColor("List.dropCellForeground");
            bl = true;
        }
        if (bl) {
            this.setBackground(color == null ? jList.getSelectionBackground() : color);
            this.setForeground(color2 == null ? jList.getSelectionForeground() : color2);
        } else {
            this.setBackground(jList.getBackground());
            this.setForeground(jList.getForeground());
        }
        if (object instanceof Icon) {
            this.setIcon((Icon)object);
            this.setText("");
        } else {
            this.setIcon(null);
            this.setText(this.getObjectAsText(object));
        }
        this.setSelected(this.isChecked(jList, n));
        this.setEnabled(jList.isEnabled());
        this.setFont(jList.getFont());
        Border border = null;
        if (bl2) {
            if (bl) {
                border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
        } else {
            border = CheckListRenderer.getNoFocusBorder();
        }
        this.setBorder(border);
        return this;
    }

    protected String getObjectAsText(Object object) {
        return object == null ? "" : object.toString();
    }

    private boolean isChecked(JList jList, int n) {
        if (jList.getModel() instanceof ICheckListModel) {
            return ((ICheckListModel)jList.getModel()).isCheckedIndex(n);
        }
        return false;
    }

    public boolean isOpaque() {
        Color color = this.getBackground();
        Container container = this.getParent();
        if (container != null) {
            container = container.getParent();
        }
        boolean bl = color != null && container != null && color.equals(container.getBackground()) && container.isOpaque();
        return !bl && super.isOpaque();
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if ("text".equals(string) || ("font".equals(string) || "foreground".equals(string)) && object != object2 && this.getClientProperty("html") != null) {
            super.firePropertyChange(string, object, object2);
        }
    }

    public void validate() {
    }

    public void invalidate() {
    }

    public void repaint() {
    }

    public void revalidate() {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    public void repaint(Rectangle rectangle) {
    }

    public void firePropertyChange(String string, byte by, byte by2) {
    }

    public void firePropertyChange(String string, char c, char c2) {
    }

    public void firePropertyChange(String string, short s, short s2) {
    }

    public void firePropertyChange(String string, int n, int n2) {
    }

    public void firePropertyChange(String string, long l, long l2) {
    }

    public void firePropertyChange(String string, float f, float f2) {
    }

    public void firePropertyChange(String string, double d, double d2) {
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    static {
        SAFE_NO_FOCUS_BORDER = NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    }

    public static class UIResource
    extends DefaultListCellRenderer
    implements javax.swing.plaf.UIResource {
    }
}

