/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.util;

import java.awt.Color;
import java.awt.Font;

public final class Markup {
    private static final String HTML_START = "<html>";
    private static final String HTML_END = "</html>";
    private static final String HTML_BREAK = "<br>";

    private Markup() {
    }

    public static final String toHex(Color color) {
        color = color == null ? Color.BLACK : color;
        String string = Integer.toHexString(color.getRGB());
        return string.substring(2, string.length());
    }

    public static final String toHTML(String string, boolean bl) {
        string = string == null ? "" : string.replaceAll("\n", HTML_BREAK);
        String string2 = string.trim().toLowerCase();
        StringBuilder stringBuilder = new StringBuilder(string);
        if (bl) {
            if (!string2.startsWith(HTML_START)) {
                stringBuilder.insert(0, HTML_START);
            }
            if (!string2.endsWith(HTML_END)) {
                stringBuilder.append(HTML_END);
            }
        }
        return stringBuilder.toString();
    }

    public static final String toHTML(String string) {
        return Markup.toHTML(string, true);
    }

    public static final String toCSS(Font font) {
        return String.format("font-family: \"%s\"; %s; %s;", font.getFamily(), Markup.toSizeCSS(font), Markup.toStyleCSS(font));
    }

    public static final String toSizeCSS(Font font) {
        return String.format("font-size: %fpx", (double)font.getSize() * 0.75);
    }

    public static final String toStyleCSS(Font font) {
        switch (font.getStyle()) {
            case 2: {
                return "font-style : italic";
            }
            case 1: {
                return "font-weight: bold";
            }
        }
        return "font-weight: normal";
    }

    public static final String toCSS(Color color) {
        return String.format("color: #%s;", Markup.toHex(color));
    }
}

