/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OperatingSystem {
    WINDOWS("windows"),
    MACOS("mac"),
    LINUX("linux"),
    UNIX("nix"),
    SOLARIS("solaris"),
    UNKNOWN("unknown"){

        protected boolean isReal() {
            return false;
        }
    };

    private String tag;

    private OperatingSystem(String string2) {
        this.tag = string2;
    }

    public boolean isCurrent() {
        return this.isReal() && OperatingSystem.getName().toLowerCase().indexOf(this.tag) >= 0;
    }

    public static final String getName() {
        return System.getProperty("os.name");
    }

    public static final String getVersion() {
        return System.getProperty("os.version");
    }

    public static final String getArchitecture() {
        return System.getProperty("os.arch");
    }

    public final String toString() {
        return String.format("%s v%s (%s)", OperatingSystem.getName(), OperatingSystem.getVersion(), OperatingSystem.getArchitecture());
    }

    protected boolean isReal() {
        return true;
    }

    public static final OperatingSystem getCurrent() {
        for (OperatingSystem operatingSystem : OperatingSystem.values()) {
            if (!operatingSystem.isCurrent()) continue;
            return operatingSystem;
        }
        return UNKNOWN;
    }
}

