/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm;

import java.util.stream.Stream;
import org.graphstream.algorithm.SpanningTree;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;

public abstract class AbstractSpanningTree
implements SpanningTree {
    protected Graph graph = null;
    protected String flagAttribute;
    protected Object flagOn;
    protected Object flagOff;

    public AbstractSpanningTree() {
        this(null, null, null);
    }

    public AbstractSpanningTree(String flagAttribute) {
        this(flagAttribute, true, false);
    }

    public AbstractSpanningTree(String flagAttribute, Object flagOn, Object flagOff) {
        this.flagAttribute = flagAttribute;
        this.flagOn = flagOn;
        this.flagOff = flagOff;
    }

    @Override
    public String getFlagAttribute() {
        return this.flagAttribute;
    }

    @Override
    public void setFlagAttribute(String flagAttribute) {
        if (this.graph != null) {
            throw new IllegalStateException("Flag attribute can be set only before the algorithm is initialized");
        }
        this.flagAttribute = flagAttribute;
    }

    @Override
    public Object getFlagOn() {
        return this.flagOn;
    }

    @Override
    public void setFlagOn(Object flagOn) {
        if (this.graph != null) {
            throw new IllegalStateException("Flag values can be set only before the algorithm is initialized");
        }
        this.flagOn = flagOn;
    }

    @Override
    public Object getFlagOff() {
        return this.flagOff;
    }

    @Override
    public void setFlagOff(Object flagOff) {
        if (this.graph != null) {
            throw new IllegalStateException("Flag values can be set only before the algorithm is initialized");
        }
        this.flagOff = flagOff;
    }

    protected void edgeOn(Edge e) {
        if (this.flagAttribute != null) {
            if (this.flagOn != null) {
                e.setAttribute(this.flagAttribute, new Object[]{this.flagOn});
            } else {
                e.removeAttribute(this.flagAttribute);
            }
        }
    }

    protected void edgeOff(Edge e) {
        if (this.flagAttribute != null) {
            if (this.flagOff != null) {
                e.setAttribute(this.flagAttribute, new Object[]{this.flagOff});
            } else {
                e.removeAttribute(this.flagAttribute);
            }
        }
    }

    protected void resetFlags() {
        this.graph.edges().forEach(edge -> this.edgeOff((Edge)edge));
    }

    protected abstract void makeTree();

    @Override
    public abstract Stream<Edge> getTreeEdgesStream();

    public Iterable<Edge> getTreeEdges() {
        return () -> this.getTreeEdgesStream().iterator();
    }

    @Override
    public void clear() {
        if (this.flagAttribute != null) {
            this.graph.edges().forEach(edge -> edge.removeAttribute(this.flagAttribute));
        }
    }

    @Override
    public void init(Graph graph) {
        this.graph = graph;
    }

    @Override
    public void compute() {
        if (this.graph == null) {
            return;
        }
        this.resetFlags();
        this.makeTree();
    }
}

