/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.editor;

import ancestris.modules.releve.editor.Bean;
import ancestris.modules.releve.model.Field;
import ancestris.modules.releve.utils.Java2sAutoComboBox;
import genj.gedcom.Gedcom;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeListener;

public class BeanEventTag
extends Bean {
    public static final List<String> TAG_EVENTS = Arrays.asList("CHR", "BURI", "CREM", "ADOP", "BAPM", "BARM", "BASM", "BLES", "CHRA", "CONF", "FCOM", "ORDN", "NATU", "EMIG", "IMMI", "CENS", "PROB", "WILL", "GRAD", "RETI", "ANUL", "DIV", "DIVF", "ENGA", "MARR", "MARB", "MARC", "MARL", "MARS", "CAST", "DSCR", "EDUC", "IDNO", "NATI", "PROP", "RELI", "SSN", "TITL", "FACT", "EVEN");
    private final Java2sAutoComboBox cListEventType;

    public BeanEventTag() {
        this.setLayout(new BorderLayout());
        this.cListEventType = new Java2sAutoComboBox(this.getEvenTagsValues());
        this.cListEventType.setStrict(false);
        this.cListEventType.addChangeListener((ChangeListener)this.changeSupport);
        this.add((Component)this.cListEventType, "Center");
        this.defaultFocus = this.cListEventType;
    }

    @Override
    public void setFieldImpl() {
        Field field = this.getField();
        if (field == null) {
            return;
        }
        final String value = field.toString();
        this.cListEventType.getEditor().setItem(value);
        this.resetKeyboardActions();
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0);
        this.getInputMap(1).put(escape, this);
        this.getActionMap().put(this, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BeanEventTag.this.cListEventType.getEditor().setItem(value);
            }
        });
    }

    @Override
    protected void replaceValueImpl(Field field) {
        if (field == null) {
            this.cListEventType.getEditor().setItem("");
        } else {
            this.cListEventType.getEditor().setItem(field.toString());
        }
    }

    @Override
    protected void commitImpl() {
        String value = this.cListEventType.getEditor().getItem().toString().trim();
        this.setFieldValue(BeanEventTag.valueToTag(value));
        this.cListEventType.getEditor().setItem(value);
    }

    private List<String> getEvenTagsValues() {
        ArrayList<String> ret = new ArrayList<String>();
        for (String tag : TAG_EVENTS) {
            ret.add(Gedcom.getName((String)tag));
        }
        Collections.sort(ret);
        return ret;
    }

    public static String valueToTag(String typeOfDocument) {
        String input = typeOfDocument.toLowerCase();
        for (String tag : TAG_EVENTS) {
            if (!Gedcom.getName((String)tag).toLowerCase().contains(input)) continue;
            return tag;
        }
        return null;
    }
}

