/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.file;

import ancestris.modules.releve.file.FileBuffer;
import ancestris.modules.releve.file.FileManager;
import ancestris.modules.releve.model.AbstractRecord;
import ancestris.modules.releve.model.RecordBirth;
import ancestris.modules.releve.model.RecordDeath;
import ancestris.modules.releve.model.RecordMarriage;
import ancestris.modules.releve.model.RecordMisc;
import ancestris.modules.releve.model.RecordModelAbstract;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.openide.util.Exceptions;

public class ReleveFileAncestrisV7 {
    private static final String FILESIGNATURE = "ANCESTRISV7";
    private static final char FIELDSEPARATOR = ';';
    private static final int NBFIELDS = 105;

    public static boolean isValidFile(File inputFile, StringBuilder sb) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(ReleveFileAncestrisV7.checkUtf8Bom(new FileInputStream(inputFile)), "UTF-8"));
            String[] fields = ReleveFileAncestrisV7.splitLine(br);
            if (fields == null) {
                sb.append("ANCESTRISV7 ").append(String.format(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.EmptyFile"), inputFile.getName()));
                return false;
            }
        }
        catch (Exception ex) {
            sb.append("ANCESTRISV7 ").append(ex.getMessage());
            return false;
        }
        return true;
    }

    private static InputStream checkUtf8Bom(InputStream is) throws IOException {
        byte[] utf8Bom = new byte[]{-17, -69, -65};
        PushbackInputStream pis = new PushbackInputStream(is, utf8Bom.length);
        byte[] bomRead = new byte[utf8Bom.length];
        if (pis.read(bomRead, 0, utf8Bom.length) == -1) {
            return is;
        }
        if (!Arrays.equals(bomRead, utf8Bom)) {
            pis.unread(bomRead);
        }
        return pis;
    }

    private static String[] splitLine(BufferedReader br) throws Exception {
        List<String> fieldList = FileManager.Line.splitCSV(br, ';');
        if (fieldList != null) {
            String[] fields = fieldList.toArray(new String[0]);
            if (fields.length == 105) {
                if (fields[0].equals(FILESIGNATURE)) {
                    return fields;
                }
                throw new Exception(String.format(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.LineBegin"), FILESIGNATURE, fields[0]));
            }
            throw new Exception(String.format(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.FieldNb"), fields.length, 105));
        }
        return null;
    }

    public static FileBuffer loadFile(File inputFile) {
        FileBuffer fileBuffer = new FileBuffer();
        try {
            fileBuffer = ReleveFileAncestrisV7.loadFile(ReleveFileAncestrisV7.checkUtf8Bom(new FileInputStream(inputFile)));
            return fileBuffer;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            fileBuffer.append(ex.toString()).append("\n");
            return fileBuffer;
        }
    }

    public static FileBuffer loadFile(InputStream inputStream) {
        FileBuffer fileBuffer = new FileBuffer();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            int lineNumber = 0;
            block4: while (true) {
                try {
                    while (true) {
                        AbstractRecord record;
                        ++lineNumber;
                        String[] fields = ReleveFileAncestrisV7.splitLine(br);
                        if (fields == null) break block4;
                        if (fields[Field.recordTypeLetter.ordinal()].equals("N/M/D/V")) {
                            --lineNumber;
                            continue;
                        }
                        if (fields[Field.recordTypeLetter.ordinal()].length() != 1) {
                            fileBuffer.append(String.format(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.LineNo"), lineNumber));
                            fileBuffer.append("\n");
                            fileBuffer.append(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.UnknownEventType")).append(" ");
                            fileBuffer.append(fields[Field.recordTypeLetter.ordinal()]);
                            fileBuffer.append("\n");
                            continue;
                        }
                        if (fields[Field.recordTypeLetter.ordinal()].equals("N")) {
                            record = new RecordBirth();
                        } else if (fields[Field.recordTypeLetter.ordinal()].equals("M")) {
                            record = new RecordMarriage();
                        } else if (fields[Field.recordTypeLetter.ordinal()].equals("D")) {
                            record = new RecordDeath();
                        } else if (fields[Field.recordTypeLetter.ordinal()].equals("V")) {
                            record = new RecordMisc();
                        } else {
                            fileBuffer.append(String.format(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.LineNo"), lineNumber));
                            fileBuffer.append("\n");
                            fileBuffer.append(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.UnknownEventType")).append(" ");
                            fileBuffer.append(fields[Field.recordTypeLetter.ordinal()]);
                            fileBuffer.append("\n");
                            continue;
                        }
                        record.setPlace(fields[Field.nomCommune.ordinal()], fields[Field.codeCommune.ordinal()], fields[Field.nomDepartement.ordinal()], fields[Field.stateName.ordinal()], fields[Field.countryName.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.eventTag, fields[Field.eventTag.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.eventType, fields[Field.eventType.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.notary, fields[Field.notary.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.parish, fields[Field.parish.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.eventDate, fields[Field.eventDate.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.secondDate, fields[Field.secondDate.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.cote, fields[Field.cote.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.freeComment, fields[Field.freeComment.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiFirstName, fields[Field.indiFirstName.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiLastName, fields[Field.indiLastName.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiSex, fields[Field.indiSex.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiAge, fields[Field.indiAge.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiBirthDate, fields[Field.indiBirthDate.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiBirthPlace, fields[Field.indiBirthPlace.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiBirthAddress, fields[Field.indiBirthAddress.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiOccupation, fields[Field.indiOccupation.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiResidence, fields[Field.indiResidence.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiAddress, fields[Field.indiAddress.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiDeathDate, fields[Field.indiDeathDate.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiDeathPlace, fields[Field.indiDeathPlace.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiDeathAddress, fields[Field.indiDeathAddress.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiComment, fields[Field.indiComment.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiMarriedFirstName, fields[Field.indiMarriedFirstName.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiMarriedLastName, fields[Field.indiMarriedLastName.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiMarriedOccupation, fields[Field.indiMarriedOccupation.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiMarriedResidence, fields[Field.indiMarriedResidence.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiMarriedAddress, fields[Field.indiMarriedAddress.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiMarriedComment, fields[Field.indiMarriedComment.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiMarriedDead, fields[Field.indiMarriedDead.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiFatherFirstName, fields[Field.indiFatherFirstName.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiFatherLastName, fields[Field.indiFatherLastName.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiFatherOccupation, fields[Field.indiFatherOccupation.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiFatherResidence, fields[Field.indiFatherResidence.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiFatherAddress, fields[Field.indiFatherAddress.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiFatherComment, fields[Field.indiFatherComment.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiFatherDead, fields[Field.indiFatherDead.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiFatherAge, fields[Field.indiFatherAge.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiMotherFirstName, fields[Field.indiMotherFirstName.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiMotherLastName, fields[Field.indiMotherLastName.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiMotherOccupation, fields[Field.indiMotherOccupation.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiMotherResidence, fields[Field.indiMotherResidence.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiMotherAddress, fields[Field.indiMotherAddress.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiMotherComment, fields[Field.indiMotherComment.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiMotherDead, fields[Field.indiMotherDead.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.indiMotherAge, fields[Field.indiMotherAge.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeFirstName, fields[Field.wifeFirstName.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeLastName, fields[Field.wifeLastName.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeSex, fields[Field.wifeSex.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeAge, fields[Field.wifeAge.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeBirthDate, fields[Field.wifeBirthDate.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeBirthPlace, fields[Field.wifeBirthPlace.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeBirthAddress, fields[Field.wifeBirthAddress.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeOccupation, fields[Field.wifeOccupation.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeResidence, fields[Field.wifeResidence.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeAddress, fields[Field.wifeAddress.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeComment, fields[Field.wifeComment.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeMarriedFirstName, fields[Field.wifeMarriedFirstName.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeMarriedLastName, fields[Field.wifeMarriedLastName.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeMarriedOccupation, fields[Field.wifeMarriedOccupation.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeMarriedResidence, fields[Field.wifeMarriedResidence.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeMarriedAddress, fields[Field.wifeMarriedAddress.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeMarriedComment, fields[Field.wifeMarriedComment.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeMarriedDead, fields[Field.wifeMarriedDead.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeFatherFirstName, fields[Field.wifeFatherFirstName.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeFatherLastName, fields[Field.wifeFatherLastName.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeFatherOccupation, fields[Field.wifeFatherOccupation.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeFatherResidence, fields[Field.wifeFatherResidence.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeFatherAddress, fields[Field.wifeFatherAddress.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeFatherComment, fields[Field.wifeFatherComment.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeFatherDead, fields[Field.wifeFatherDead.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeFatherAge, fields[Field.wifeFatherAge.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeMotherFirstName, fields[Field.wifeMotherFirstName.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeMotherLastName, fields[Field.wifeMotherLastName.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeMotherOccupation, fields[Field.wifeMotherOccupation.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeMotherResidence, fields[Field.wifeMotherResidence.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeMotherAddress, fields[Field.wifeMotherAddress.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeMotherComment, fields[Field.wifeMotherComment.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeMotherDead, fields[Field.wifeMotherDead.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.wifeMotherAge, fields[Field.wifeMotherAge.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.witness1FirstName, fields[Field.witness1FirstName.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.witness1LastName, fields[Field.witness1LastName.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.witness1Occupation, fields[Field.witness1Occupation.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.witness1Comment, fields[Field.witness1Comment.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.witness2FirstName, fields[Field.witness2FirstName.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.witness2LastName, fields[Field.witness2LastName.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.witness2Occupation, fields[Field.witness2Occupation.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.witness2Comment, fields[Field.witness2Comment.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.witness3FirstName, fields[Field.witness3FirstName.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.witness3LastName, fields[Field.witness3LastName.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.witness3Occupation, fields[Field.witness3Occupation.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.witness3Comment, fields[Field.witness3Comment.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.witness4FirstName, fields[Field.witness4FirstName.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.witness4LastName, fields[Field.witness4LastName.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.witness4Occupation, fields[Field.witness4Occupation.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.witness4Comment, fields[Field.witness4Comment.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.generalComment, fields[Field.generalComment.ordinal()].replaceAll("\\\\n", "\n"));
                        record.setFieldValue(AbstractRecord.FieldType.deedText, fields[Field.deedText.ordinal()].replaceAll("\\\\n", "\n"));
                        record.setFieldValue(AbstractRecord.FieldType.eventMedia, fields[Field.eventMedia.ordinal()]);
                        fileBuffer.addRecord(record);
                    }
                }
                catch (Exception e) {
                    fileBuffer.append(String.format(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.LineNo"), lineNumber));
                    fileBuffer.append("\n");
                    fileBuffer.append(e.toString()).append("\n");
                    continue;
                }
                break;
            }
            br.close();
        }
        catch (IOException e) {
            fileBuffer.append(e.toString()).append("\n");
        }
        return fileBuffer;
    }

    public static StringBuilder saveFile(RecordModelAbstract recordModel, AbstractRecord.RecordType recordType, File fileName, boolean append) {
        StringBuilder sb = new StringBuilder();
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName, append), "UTF-8");
            if (!append) {
                writer.write(ReleveFileAncestrisV7.getHeader().toString());
            }
            for (int index = 0; index < recordModel.getRowCount(); ++index) {
                AbstractRecord record = recordModel.getRecord(index);
                if (recordType != null && recordType != record.getType()) continue;
                String recordTypeString = switch (record.getType()) {
                    case AbstractRecord.RecordType.BIRTH -> "N";
                    case AbstractRecord.RecordType.MARRIAGE -> "M";
                    case AbstractRecord.RecordType.DEATH -> "D";
                    default -> "V";
                };
                FileManager.Line line = new FileManager.Line(';');
                try {
                    line.appendCsvFn(FILESIGNATURE, new String[0]);
                    line.appendCsvFn(record.getPlace().getCityName(), new String[0]);
                    line.appendCsvFn(record.getPlace().getCityCode(), new String[0]);
                    line.appendCsvFn(record.getPlace().getCountyName(), new String[0]);
                    line.appendCsvFn(record.getPlace().getStateName(), new String[0]);
                    line.appendCsvFn(record.getPlace().getCountryName(), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.parish), new String[0]);
                    line.appendCsvFn(recordTypeString, new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.eventTag), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.eventType), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.eventDate), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.secondDate), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.cote), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.freeComment), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.notary), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiLastName), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFirstName), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiSex), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiBirthPlace), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiBirthAddress), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiBirthDate), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiAge), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiOccupation), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiResidence), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiAddress), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiDeathDate), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiDeathPlace), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiDeathAddress), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiComment), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedLastName), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedFirstName), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedDead), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedOccupation), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedResidence), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedAddress), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedComment), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherLastName), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherFirstName), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherAge), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherDead), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherOccupation), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherResidence), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherAddress), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherComment), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherLastName), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherFirstName), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherAge), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherDead), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherOccupation), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherResidence), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherAddress), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherComment), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeLastName), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFirstName), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeSex), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeBirthPlace), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeBirthAddress), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeBirthDate), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeAge), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeOccupation), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeResidence), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeAddress), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeComment), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedLastName), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedFirstName), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedDead), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedOccupation), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedResidence), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedAddress), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedComment), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherLastName), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherFirstName), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherAge), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherDead), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherOccupation), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherResidence), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherAddress), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherComment), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherLastName), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherFirstName), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherAge), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherDead), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherOccupation), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherResidence), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherAddress), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherComment), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1LastName), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1FirstName), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1Occupation), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness1Comment), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2LastName), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2FirstName), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2Occupation), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness2Comment), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3LastName), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3FirstName), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3Occupation), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness3Comment), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4LastName), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4FirstName), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4Occupation), new String[0]);
                    line.appendCsvFn(record.getFieldValue(AbstractRecord.FieldType.witness4Comment), new String[0]);
                    line.appendCsvFn("\"" + record.getFieldValue(AbstractRecord.FieldType.generalComment) + "\"", new String[0]);
                    line.appendCsvFn("\"" + record.getFieldValue(AbstractRecord.FieldType.deedText) + "\"", new String[0]);
                    line.appendCsv("\"" + record.getFieldValue(AbstractRecord.FieldType.eventMedia) + "\"", new String[0]);
                    line.appendCsv("\n", new String[0]);
                    writer.write(line.toString());
                    continue;
                }
                catch (IOException e) {
                    sb.append("Line ").append(" ").append(e).append("\n");
                    sb.append("   ").append(line).append("\n");
                }
            }
            writer.close();
        }
        catch (IOException e) {
            sb.append(e).append("\n");
        }
        return sb;
    }

    private static FileManager.Line getHeader() {
        FileManager.Line line = new FileManager.Line(';');
        line.appendCsvFn(FILESIGNATURE, new String[0]);
        line.appendCsvFn("CityName", new String[0]);
        line.appendCsvFn("CityCode", new String[0]);
        line.appendCsvFn("County", new String[0]);
        line.appendCsvFn("State", new String[0]);
        line.appendCsvFn("Country", new String[0]);
        line.appendCsvFn("Parish", new String[0]);
        line.appendCsvFn("N/M/D/V", new String[0]);
        line.appendCsvFn("EventTag", new String[0]);
        line.appendCsvFn("EventType", new String[0]);
        line.appendCsvFn("EventDate", new String[0]);
        line.appendCsvFn("SecondDate", new String[0]);
        line.appendCsvFn("Cote", new String[0]);
        line.appendCsvFn("FreeComment", new String[0]);
        line.appendCsvFn("Notary", new String[0]);
        line.appendCsvFn("IndiLastName", new String[0]);
        line.appendCsvFn("IndiFirstName", new String[0]);
        line.appendCsvFn("IndiSex", new String[0]);
        line.appendCsvFn("IndiBirthPlace", new String[0]);
        line.appendCsvFn("IndiBirthAddress", new String[0]);
        line.appendCsvFn("IndiBirthDate", new String[0]);
        line.appendCsvFn("IndiAge", new String[0]);
        line.appendCsvFn("IndiOccupation", new String[0]);
        line.appendCsvFn("IndiResidence", new String[0]);
        line.appendCsvFn("IndiAddress", new String[0]);
        line.appendCsvFn("IndiDeathDate", new String[0]);
        line.appendCsvFn("IndiDeathPlace", new String[0]);
        line.appendCsvFn("IndiDeathAddress", new String[0]);
        line.appendCsvFn("IndiComment", new String[0]);
        line.appendCsvFn("IndiMarriedLastName", new String[0]);
        line.appendCsvFn("IndiMarriedFirstName", new String[0]);
        line.appendCsvFn("IndiMarriedDead", new String[0]);
        line.appendCsvFn("IndiMarriedOccupation", new String[0]);
        line.appendCsvFn("IndiMarriedResidence", new String[0]);
        line.appendCsvFn("IndiMarriedAddress", new String[0]);
        line.appendCsvFn("IndiMarriedComment", new String[0]);
        line.appendCsvFn("IndiFatherLastName", new String[0]);
        line.appendCsvFn("IndiFatherFirstName", new String[0]);
        line.appendCsvFn("IndiFatherAge", new String[0]);
        line.appendCsvFn("IndiFatherDead", new String[0]);
        line.appendCsvFn("IndiFatherOccupation", new String[0]);
        line.appendCsvFn("IndiFatherResidence", new String[0]);
        line.appendCsvFn("IndiFatherAddress", new String[0]);
        line.appendCsvFn("IndiFatherComment", new String[0]);
        line.appendCsvFn("IndiMotherLastName", new String[0]);
        line.appendCsvFn("indiMotherfirstName", new String[0]);
        line.appendCsvFn("IndiMotherAge", new String[0]);
        line.appendCsvFn("IndiMotherDead", new String[0]);
        line.appendCsvFn("IndiMotherOccupation", new String[0]);
        line.appendCsvFn("IndiMotherResidence", new String[0]);
        line.appendCsvFn("IndiMotherAddress", new String[0]);
        line.appendCsvFn("IndiMotherComment", new String[0]);
        line.appendCsvFn("WifeLastName", new String[0]);
        line.appendCsvFn("WifeFirstName", new String[0]);
        line.appendCsvFn("WifeSex", new String[0]);
        line.appendCsvFn("WifeBirthPlace", new String[0]);
        line.appendCsvFn("WifeBirthAddress", new String[0]);
        line.appendCsvFn("WifeBirthDate", new String[0]);
        line.appendCsvFn("WifeAge", new String[0]);
        line.appendCsvFn("WifeOccupation", new String[0]);
        line.appendCsvFn("WifeResidence", new String[0]);
        line.appendCsvFn("WifeAddress", new String[0]);
        line.appendCsvFn("WifeComment", new String[0]);
        line.appendCsvFn("WifeMarriedLastName", new String[0]);
        line.appendCsvFn("WifeMarriedFirstName", new String[0]);
        line.appendCsvFn("WifeMarriedDead", new String[0]);
        line.appendCsvFn("WifeMarriedOccupation", new String[0]);
        line.appendCsvFn("WifeMarriedResidence", new String[0]);
        line.appendCsvFn("WifeMarriedAddress", new String[0]);
        line.appendCsvFn("WifeMarriedComment", new String[0]);
        line.appendCsvFn("WifeFatherLastName", new String[0]);
        line.appendCsvFn("WifeFatherFirstName", new String[0]);
        line.appendCsvFn("WifeFatherAge", new String[0]);
        line.appendCsvFn("WifeFatherDead", new String[0]);
        line.appendCsvFn("WifeFatherOccupation", new String[0]);
        line.appendCsvFn("WifeFatherResidence", new String[0]);
        line.appendCsvFn("WifeFatherAddress", new String[0]);
        line.appendCsvFn("WifeFatherComment", new String[0]);
        line.appendCsvFn("WifeMotherLastName", new String[0]);
        line.appendCsvFn("WifeMotherFirstName", new String[0]);
        line.appendCsvFn("WifeMotherAge", new String[0]);
        line.appendCsvFn("WifeMotherDead", new String[0]);
        line.appendCsvFn("WifeMotherOccupation", new String[0]);
        line.appendCsvFn("WifeMotherResidence", new String[0]);
        line.appendCsvFn("WifeMotherAddress", new String[0]);
        line.appendCsvFn("WifeMotherComment", new String[0]);
        line.appendCsvFn("Witness1LastName", new String[0]);
        line.appendCsvFn("Witness1FirstName", new String[0]);
        line.appendCsvFn("Witness1Occupation", new String[0]);
        line.appendCsvFn("Witness1Comment", new String[0]);
        line.appendCsvFn("Witness2LastName", new String[0]);
        line.appendCsvFn("Witness2FirstName", new String[0]);
        line.appendCsvFn("Witness2Occupation", new String[0]);
        line.appendCsvFn("Witness2Comment", new String[0]);
        line.appendCsvFn("Witness3LastName", new String[0]);
        line.appendCsvFn("Witness3FirstName", new String[0]);
        line.appendCsvFn("Witness3Occupation", new String[0]);
        line.appendCsvFn("Witness3Comment", new String[0]);
        line.appendCsvFn("Witness4LastName", new String[0]);
        line.appendCsvFn("Witness4FirstName", new String[0]);
        line.appendCsvFn("Witness4Occupation", new String[0]);
        line.appendCsvFn("Witness4Comment", new String[0]);
        line.appendCsvFn("GeneralComment", new String[0]);
        line.appendCsvFn("DeedText", new String[0]);
        line.appendCsv("EventMedia", new String[0]);
        line.appendCsv("\n", new String[0]);
        return line;
    }

    static {
        System.setProperty("java.util.logging.ConsoleHandler.level", "SEVERE");
    }

    static enum Field {
        ancetris,
        nomCommune,
        codeCommune,
        nomDepartement,
        stateName,
        countryName,
        parish,
        recordTypeLetter,
        eventTag,
        eventType,
        eventDate,
        secondDate,
        cote,
        freeComment,
        notary,
        indiLastName,
        indiFirstName,
        indiSex,
        indiBirthPlace,
        indiBirthAddress,
        indiBirthDate,
        indiAge,
        indiOccupation,
        indiResidence,
        indiAddress,
        indiDeathDate,
        indiDeathPlace,
        indiDeathAddress,
        indiComment,
        indiMarriedLastName,
        indiMarriedFirstName,
        indiMarriedDead,
        indiMarriedOccupation,
        indiMarriedResidence,
        indiMarriedAddress,
        indiMarriedComment,
        indiFatherLastName,
        indiFatherFirstName,
        indiFatherAge,
        indiFatherDead,
        indiFatherOccupation,
        indiFatherResidence,
        indiFatherAddress,
        indiFatherComment,
        indiMotherLastName,
        indiMotherFirstName,
        indiMotherAge,
        indiMotherDead,
        indiMotherOccupation,
        indiMotherResidence,
        indiMotherAddress,
        indiMotherComment,
        wifeLastName,
        wifeFirstName,
        wifeSex,
        wifeBirthPlace,
        wifeBirthAddress,
        wifeBirthDate,
        wifeAge,
        wifeOccupation,
        wifeResidence,
        wifeAddress,
        wifeComment,
        wifeMarriedLastName,
        wifeMarriedFirstName,
        wifeMarriedDead,
        wifeMarriedOccupation,
        wifeMarriedResidence,
        wifeMarriedAddress,
        wifeMarriedComment,
        wifeFatherLastName,
        wifeFatherFirstName,
        wifeFatherAge,
        wifeFatherDead,
        wifeFatherOccupation,
        wifeFatherResidence,
        wifeFatherAddress,
        wifeFatherComment,
        wifeMotherLastName,
        wifeMotherFirstName,
        wifeMotherAge,
        wifeMotherDead,
        wifeMotherOccupation,
        wifeMotherResidence,
        wifeMotherAddress,
        wifeMotherComment,
        witness1LastName,
        witness1FirstName,
        witness1Occupation,
        witness1Comment,
        witness2LastName,
        witness2FirstName,
        witness2Occupation,
        witness2Comment,
        witness3LastName,
        witness3FirstName,
        witness3Occupation,
        witness3Comment,
        witness4LastName,
        witness4FirstName,
        witness4Occupation,
        witness4Comment,
        generalComment,
        deedText,
        eventMedia;

    }
}

