/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.file;

import ancestris.modules.releve.file.FileBuffer;
import ancestris.modules.releve.file.FileManager;
import ancestris.modules.releve.model.AbstractRecord;
import ancestris.modules.releve.model.RecordBirth;
import ancestris.modules.releve.model.RecordDeath;
import ancestris.modules.releve.model.RecordMarriage;
import ancestris.modules.releve.model.RecordMisc;
import ancestris.modules.releve.model.RecordModelAbstract;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ResourceBundle;

public class ReleveFileNimegue {
    private static final char fieldSeparator = ';';
    private static final String fileSignature = "NIMEGUEV3";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidFile(File inputFile, StringBuilder sb) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(inputFile));
            String strLine = br.readLine();
            int lineNo = 1;
            String[] fields = ReleveFileNimegue.splitLine(strLine, lineNo);
            if (fields == null) {
                sb.append(fileSignature);
                sb.append(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString(" ")).append(String.format(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.EmptyFile"), inputFile.getName()));
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception ex) {
            sb.append("NIMEGUEV3 ").append(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    private static String[] splitLine(String strLine, int lineNo) throws Exception {
        String[] fields;
        if (!((String)strLine).endsWith(";")) {
            strLine = (String)strLine + ";";
        }
        if ((fields = ((String)strLine).split(String.valueOf(';'), 100)).length >= BirthField.typeActe.ordinal()) {
            if (fields[BirthField.typeActe.ordinal()].equals("N") || fields[MarrField.typeActe.ordinal()].equals("M") || fields[DeathField.typeActe.ordinal()].equals("D") || fields[MiscField.typeActe.ordinal()].equals("V")) {
                if (fields.length == 31 && fields[BirthField.typeActe.ordinal()].equals("N") || fields.length == 61 && fields[MarrField.typeActe.ordinal()].equals("M") || fields.length == 39 && fields[DeathField.typeActe.ordinal()].equals("D") || fields.length == 65 && fields[MiscField.typeActe.ordinal()].equals("V")) {
                    if (fields[0].equals(fileSignature)) {
                        return fields;
                    }
                    throw new Exception(String.format("Line %d: signature=%s, Must be %s", lineNo, fields[0], fileSignature));
                }
                throw new Exception(String.format("Line %d: fields=%d, Must be 30, 38, 60 or 65", lineNo, fields.length));
            }
            throw new Exception(String.format("Line %d: eventType=%s, Must be N, M, D or V", lineNo, fields[BirthField.typeActe.ordinal()]));
        }
        throw new Exception(String.format("Line %d: fields=%d, Must be 30, 38, 60 or 65", lineNo, fields.length));
    }

    public static FileBuffer loadFile(File inputFile) {
        FileBuffer fileBuffer = new FileBuffer();
        try {
            String strLine;
            BufferedReader br = new BufferedReader(new FileReader(inputFile));
            int lineNumber = 0;
            while ((strLine = br.readLine()) != null) {
                ++lineNumber;
                try {
                    AbstractRecord record;
                    String[] fields = ReleveFileNimegue.splitLine(strLine, lineNumber);
                    if (fields == null) continue;
                    if (fields[BirthField.typeActe.ordinal()].equals("N")) {
                        record = new RecordBirth();
                        record.setPlace(fields[BirthField.nomCommune.ordinal()], fields[BirthField.codeCommune.ordinal()], fields[BirthField.nomDepartement.ordinal()].isEmpty() ? fields[BirthField.codeDepartement.ordinal()] : fields[BirthField.nomDepartement.ordinal()], "", "");
                        record.setFieldValue(AbstractRecord.FieldType.eventDate, fields[BirthField.dateNaissance.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.cote, fields[BirthField.cote.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.freeComment, fields[BirthField.photo.ordinal()]);
                        record.setIndi(fields[BirthField.indiFirstName.ordinal()], fields[BirthField.indiLastName.ordinal()], fields[BirthField.indiSex.ordinal()], "", "", "", "", "", "", "", "", "", "", fields[BirthField.indiComment.ordinal()]);
                        record.setIndiFather(fields[BirthField.indiFatherFirstName.ordinal()], fields[BirthField.indiFatherLastName.ordinal()], fields[BirthField.indiFatherOccupation.ordinal()], "", "", fields[BirthField.indiFatherComment.ordinal()], "", "");
                        record.setIndiMother(fields[BirthField.indiMotherFirstName.ordinal()], fields[BirthField.indiMotherLastName.ordinal()], fields[BirthField.indiMotherOccupation.ordinal()], "", "", fields[BirthField.indiMotherComment.ordinal()], "", "");
                        record.setWitness1(fields[BirthField.witness1FirstName.ordinal()], fields[BirthField.witness1LastName.ordinal()], "", fields[BirthField.witness1Comment.ordinal()]);
                        record.setWitness2(fields[BirthField.witness2FirstName.ordinal()], fields[BirthField.witness2LastName.ordinal()], "", fields[BirthField.witness2Comment.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.generalComment, fields[BirthField.generalComment.ordinal()]);
                        fileBuffer.addRecord(record);
                        continue;
                    }
                    if (fields[MarrField.typeActe.ordinal()].equals("M")) {
                        record = new RecordMarriage();
                        record.setPlace(fields[BirthField.nomCommune.ordinal()], fields[MarrField.codeCommune.ordinal()], fields[MarrField.nomDepartement.ordinal()].isEmpty() ? fields[MarrField.codeDepartement.ordinal()] : fields[MarrField.nomDepartement.ordinal()], "", "");
                        record.setFieldValue(AbstractRecord.FieldType.eventDate, fields[MarrField.eventDate.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.cote, fields[MarrField.cote.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.freeComment, fields[MarrField.libre.ordinal()]);
                        record.setIndi(fields[MarrField.indiFirstName.ordinal()], fields[MarrField.indiLastName.ordinal()], "M", fields[MarrField.indiAge.ordinal()], fields[MarrField.indiBirthDate.ordinal()], fields[MarrField.indiBirthPlace.ordinal()], "", fields[MarrField.indiOccupation.ordinal()], "", "", "", "", "", fields[MarrField.indiComment.ordinal()]);
                        record.setIndiMarried(fields[MarrField.indiMarriedFirstName.ordinal()], fields[MarrField.indiMarriedLastName.ordinal()], "", "", "", fields[MarrField.indiMarriedComment.ordinal()], "");
                        record.setIndiFather(fields[MarrField.indiFatherFirstName.ordinal()], fields[MarrField.indiFatherLastName.ordinal()], fields[MarrField.indiFatherOccupation.ordinal()], "", "", fields[MarrField.indiFatherComment.ordinal()], "", "");
                        record.setIndiMother(fields[MarrField.indiMotherFirstName.ordinal()], fields[MarrField.indiMotherLastName.ordinal()], fields[MarrField.indiMotherOccupation.ordinal()], "", "", fields[MarrField.indiMotherComment.ordinal()], "", "");
                        record.setWife(fields[MarrField.wifeFirstName.ordinal()], fields[MarrField.wifeLastName.ordinal()], "F", fields[MarrField.wifeAge.ordinal()], fields[MarrField.wifeBirthDate.ordinal()], fields[MarrField.wifeBirthPlace.ordinal()], "", fields[MarrField.wifeOccupation.ordinal()], "", "", fields[MarrField.wifeComment.ordinal()]);
                        record.setWifeMarried(fields[MarrField.wifeMarriedFirstName.ordinal()], fields[MarrField.wifeMarriedLastName.ordinal()], "", "", "", fields[MarrField.wifeMarriedComment.ordinal()], "");
                        record.setWifeFather(fields[MarrField.wifeFatherFirstName.ordinal()], fields[MarrField.wifeFatherLastName.ordinal()], fields[MarrField.wifeFatherOccupation.ordinal()], "", "", fields[MarrField.wifeFatherComment.ordinal()], "", "");
                        record.setWifeMother(fields[MarrField.wifeMotherFirstName.ordinal()], fields[MarrField.wifeMotherLastName.ordinal()], fields[MarrField.wifeMotherOccupation.ordinal()], "", "", fields[MarrField.wifeMotherComment.ordinal()], "", "");
                        record.setWitness1(fields[MarrField.witness1FirstName.ordinal()], fields[MarrField.witness1LastName.ordinal()], "", fields[MarrField.witness1Comment.ordinal()]);
                        record.setWitness2(fields[MarrField.witness2FirstName.ordinal()], fields[MarrField.witness2LastName.ordinal()], "", fields[MarrField.witness2Comment.ordinal()]);
                        record.setWitness3(fields[MarrField.witness3FirstName.ordinal()], fields[MarrField.witness3LastName.ordinal()], "", fields[MarrField.witness3Comment.ordinal()]);
                        record.setWitness4(fields[MarrField.witness4FirstName.ordinal()], fields[MarrField.witness4LastName.ordinal()], "", fields[MarrField.witness4Comment.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.generalComment, fields[MarrField.generalComment.ordinal()]);
                        fileBuffer.addRecord(record);
                        continue;
                    }
                    if (fields[DeathField.typeActe.ordinal()].equals("D")) {
                        record = new RecordDeath();
                        record.setPlace(fields[DeathField.nomCommune.ordinal()], fields[DeathField.codeCommune.ordinal()], fields[DeathField.nomDepartement.ordinal()].isEmpty() ? fields[DeathField.codeDepartement.ordinal()] : fields[DeathField.nomDepartement.ordinal()], "", "");
                        record.setFieldValue(AbstractRecord.FieldType.eventDate, fields[DeathField.eventDate.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.cote, fields[DeathField.cote.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.freeComment, fields[DeathField.libre.ordinal()]);
                        record.setIndi(fields[DeathField.indiFirstName.ordinal()], fields[DeathField.indiLastName.ordinal()], fields[DeathField.indiSex.ordinal()], fields[DeathField.indiAge.ordinal()], fields[DeathField.indiBirthDate.ordinal()], fields[DeathField.indiBirthPlace.ordinal()], "", fields[DeathField.indiOccupation.ordinal()], "", "", "", "", "", fields[DeathField.indiComment.ordinal()]);
                        record.setIndiMarried(fields[DeathField.wifeFirstName.ordinal()], fields[DeathField.wifeLastName.ordinal()], fields[DeathField.wifeOccupation.ordinal()], "", "", fields[DeathField.wifeComment.ordinal()], "");
                        record.setIndiFather(fields[DeathField.indiFatherFirstName.ordinal()], fields[DeathField.indiFatherLastName.ordinal()], fields[DeathField.indiFatherOccupation.ordinal()], "", "", fields[DeathField.indiFatherComment.ordinal()], "", "");
                        record.setIndiMother(fields[DeathField.indiMotherFirstName.ordinal()], fields[DeathField.indiMotherLastName.ordinal()], fields[DeathField.indiMotherOccupation.ordinal()], "", "", fields[DeathField.indiMotherComment.ordinal()], "", "");
                        record.setWitness1(fields[DeathField.witness1FirstName.ordinal()], fields[DeathField.witness1LastName.ordinal()], "", fields[DeathField.witness1Comment.ordinal()]);
                        record.setWitness2(fields[DeathField.witness2FirstName.ordinal()], fields[DeathField.witness2LastName.ordinal()], "", fields[DeathField.witness2Comment.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.generalComment, fields[DeathField.generalComment.ordinal()]);
                        fileBuffer.addRecord(record);
                        continue;
                    }
                    if (fields[MiscField.typeActe.ordinal()].equals("V")) {
                        record = new RecordMisc();
                        record.setPlace(fields[MiscField.nomCommune.ordinal()], fields[MiscField.codeCommune.ordinal()], fields[MiscField.nomDepartement.ordinal()].isEmpty() ? fields[MiscField.codeDepartement.ordinal()] : fields[MiscField.nomDepartement.ordinal()], "", "");
                        record.setFieldValue(AbstractRecord.FieldType.eventDate, fields[MiscField.eventDate.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.eventType, fields[MiscField.eventTypeName.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.cote, fields[MiscField.cote.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.freeComment, fields[MiscField.libre.ordinal()]);
                        record.setIndi(fields[MiscField.indiFirstName.ordinal()], fields[MiscField.indiLastName.ordinal()], fields[MiscField.indiSex.ordinal()], fields[MiscField.indiAge.ordinal()], fields[MiscField.indiBirthDate.ordinal()], fields[MiscField.indiBirthPlace.ordinal()], "", fields[MiscField.indiOccupation.ordinal()], "", "", "", "", "", fields[MiscField.indiComment.ordinal()]);
                        record.setIndiMarried(fields[MiscField.indiMarriedFirstName.ordinal()], fields[MiscField.indiMarriedLastName.ordinal()], "", "", "", fields[MiscField.indiMarriedComment.ordinal()], "");
                        record.setIndiFather(fields[MiscField.indiFatherFirstName.ordinal()], fields[MiscField.indiFatherLastName.ordinal()], fields[MiscField.indiFatherOccupation.ordinal()], "", "", fields[MiscField.indiFatherComment.ordinal()], "", "");
                        record.setIndiMother(fields[MiscField.indiMotherFirstName.ordinal()], fields[MiscField.indiMotherLastName.ordinal()], fields[MiscField.indiMotherOccupation.ordinal()], "", "", fields[MiscField.indiMotherComment.ordinal()], "", "");
                        record.setWife(fields[MiscField.wifeFirstName.ordinal()], fields[MiscField.wifeLastName.ordinal()], fields[MiscField.wifeSex.ordinal()], fields[MiscField.wifeAge.ordinal()], fields[MiscField.wifeBirthDate.ordinal()], fields[MiscField.wifeBirthPlace.ordinal()], "", fields[MiscField.wifeOccupation.ordinal()], "", "", fields[MiscField.wifeComment.ordinal()]);
                        record.setWifeMarried(fields[MiscField.wifeMarriedFirstName.ordinal()], fields[MiscField.wifeMarriedLastName.ordinal()], "", "", "", fields[MiscField.wifeMarriedComment.ordinal()], "");
                        record.setWifeFather(fields[MiscField.wifeFatherFirstName.ordinal()], fields[MiscField.wifeFatherLastName.ordinal()], fields[MiscField.wifeFatherOccupation.ordinal()], "", "", fields[MiscField.wifeFatherComment.ordinal()], "", "");
                        record.setWifeMother(fields[MiscField.wifeMotherFirstName.ordinal()], fields[MiscField.wifeMotherLastName.ordinal()], fields[MiscField.wifeMotherOccupation.ordinal()], "", "", fields[MiscField.wifeMotherComment.ordinal()], "", "");
                        record.setWitness1(fields[MiscField.witness1FirstName.ordinal()], fields[MiscField.witness1LastName.ordinal()], "", fields[MiscField.witness1Comment.ordinal()]);
                        record.setWitness2(fields[MiscField.witness2FirstName.ordinal()], fields[MiscField.witness2LastName.ordinal()], "", fields[MiscField.witness2Comment.ordinal()]);
                        record.setWitness3(fields[MiscField.witness3FirstName.ordinal()], fields[MiscField.witness3LastName.ordinal()], "", fields[MiscField.witness3Comment.ordinal()]);
                        record.setWitness4(fields[MiscField.witness4FirstName.ordinal()], fields[MiscField.witness4LastName.ordinal()], "", fields[MiscField.witness4Comment.ordinal()]);
                        record.setFieldValue(AbstractRecord.FieldType.generalComment, fields[MiscField.generalComment.ordinal()]);
                        fileBuffer.addRecord(record);
                        continue;
                    }
                    fileBuffer.append(String.format(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.LineNo"), lineNumber));
                    fileBuffer.append("\n");
                    fileBuffer.append(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.UnknownEventType")).append(" ");
                    fileBuffer.append(fields[BirthField.typeActe.ordinal()]).append("\n");
                }
                catch (Exception e) {
                    fileBuffer.append(String.format(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.LineNo"), lineNumber));
                    fileBuffer.append("\n");
                    fileBuffer.append(strLine).append("\n");
                }
            }
            br.close();
        }
        catch (IOException e) {
            fileBuffer.append(e.toString()).append("\n");
        }
        return fileBuffer;
    }

    public static StringBuilder saveFile(RecordModelAbstract recordModel, AbstractRecord.RecordType recordType, File fileName, boolean append) {
        StringBuilder sb = new StringBuilder();
        try {
            FileWriter writer = new FileWriter(fileName, append);
            for (int index = 0; index < recordModel.getRowCount(); ++index) {
                AbstractRecord record = recordModel.getRecord(index);
                if (recordType != null && recordType != record.getType()) continue;
                FileManager.Line line = new FileManager.Line(';');
                try {
                    if (record instanceof RecordBirth) {
                        line.appendNimegueFn(fileSignature, new String[0]);
                        line.appendNimegueFn(record.getPlace().getCityCode(), new String[0]);
                        line.appendNimegueFn(record.getPlace().getCityName(), new String[0]);
                        line.appendNimegueFn(record.getPlace().getCountryName(), new String[0]);
                        line.appendNimegueFn(record.getPlace().getCountyName(), new String[0]);
                        line.appendNimegueFn("N", new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.eventDate), new String[0]);
                        line.appendNimegueFn("", new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.cote), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.freeComment), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiLastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiFirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiSex), new String[0]);
                        Object birthPlace = "";
                        if (!record.getFieldValue(AbstractRecord.FieldType.indiBirthPlace).isEmpty()) {
                            birthPlace = "Lieu: " + record.getFieldValue(AbstractRecord.FieldType.indiBirthPlace);
                        }
                        line.appendNimegueFn((String)birthPlace, record.getFieldValue(AbstractRecord.FieldType.indiComment));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherLastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherFirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherAge), record.getFieldString(AbstractRecord.FieldType.indiFatherDead), record.getFieldValue(AbstractRecord.FieldType.indiFatherResidence), record.getFieldValue(AbstractRecord.FieldType.indiFatherComment));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherOccupation), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherLastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherFirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherAge), record.getFieldString(AbstractRecord.FieldType.indiMotherDead), record.getFieldValue(AbstractRecord.FieldType.indiMotherResidence), record.getFieldValue(AbstractRecord.FieldType.indiMotherComment));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherOccupation), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness1LastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness1FirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness1Comment), record.getFieldValue(AbstractRecord.FieldType.witness1Occupation));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness2LastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness2FirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness2Comment), record.getFieldValue(AbstractRecord.FieldType.witness2Occupation));
                        if (record.getFieldValue(AbstractRecord.FieldType.witness3LastName).isEmpty() && record.getFieldValue(AbstractRecord.FieldType.witness4LastName).isEmpty()) {
                            line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.generalComment), new String[0]);
                        } else {
                            line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.generalComment), "t\u00e9moin: " + record.getFieldValue(AbstractRecord.FieldType.witness3FirstName) + " " + record.getFieldValue(AbstractRecord.FieldType.witness3LastName), record.getFieldValue(AbstractRecord.FieldType.witness3Occupation), record.getFieldValue(AbstractRecord.FieldType.witness3Comment), record.getFieldValue(AbstractRecord.FieldType.witness4FirstName) + " " + record.getFieldValue(AbstractRecord.FieldType.witness4LastName), record.getFieldValue(AbstractRecord.FieldType.witness4Occupation), record.getFieldValue(AbstractRecord.FieldType.witness4Comment));
                        }
                        line.appendNimegueFn(String.valueOf(index), new String[0]);
                    }
                    if (record instanceof RecordMarriage) {
                        line.appendNimegueFn(fileSignature, new String[0]);
                        line.appendNimegueFn(record.getPlace().getCityCode(), new String[0]);
                        line.appendNimegueFn(record.getPlace().getCityName(), new String[0]);
                        line.appendNimegueFn(record.getPlace().getCountryName(), new String[0]);
                        line.appendNimegueFn(record.getPlace().getCountyName(), new String[0]);
                        line.appendNimegueFn("M", new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.eventDate), new String[0]);
                        line.appendNimegueFn("", new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.cote), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.freeComment), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiLastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiFirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiBirthPlace), new String[0]);
                        if (record.getFieldValue(AbstractRecord.FieldType.indiBirthDate).trim().equals("")) {
                            line.appendNimegueFn("          ", new String[0]);
                        } else {
                            line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiBirthDate), new String[0]);
                        }
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiAge), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiComment), record.getFieldValue(AbstractRecord.FieldType.indiResidence));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiOccupation), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedLastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedFirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldString(AbstractRecord.FieldType.indiMarriedDead), record.getFieldValue(AbstractRecord.FieldType.indiMarriedOccupation), record.getFieldValue(AbstractRecord.FieldType.indiMarriedResidence), record.getFieldValue(AbstractRecord.FieldType.indiMarriedComment));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherLastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherFirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherAge), record.getFieldString(AbstractRecord.FieldType.indiFatherDead), record.getFieldValue(AbstractRecord.FieldType.indiFatherResidence), record.getFieldValue(AbstractRecord.FieldType.indiFatherComment));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherOccupation), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherLastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherFirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherAge), record.getFieldString(AbstractRecord.FieldType.indiMotherDead), record.getFieldValue(AbstractRecord.FieldType.indiMotherResidence), record.getFieldValue(AbstractRecord.FieldType.indiMotherComment));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherOccupation), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeLastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeFirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeBirthPlace), new String[0]);
                        if (record.getFieldValue(AbstractRecord.FieldType.wifeBirthDate).equals("")) {
                            line.appendNimegueFn("          ", new String[0]);
                        } else {
                            line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeBirthDate), new String[0]);
                        }
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeAge), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeResidence), record.getFieldValue(AbstractRecord.FieldType.wifeComment));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeOccupation), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedLastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedFirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldString(AbstractRecord.FieldType.wifeMarriedDead), record.getFieldValue(AbstractRecord.FieldType.wifeMarriedOccupation), record.getFieldValue(AbstractRecord.FieldType.wifeMarriedResidence), record.getFieldValue(AbstractRecord.FieldType.wifeMarriedComment));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherLastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherFirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherAge), record.getFieldString(AbstractRecord.FieldType.wifeFatherDead), record.getFieldValue(AbstractRecord.FieldType.wifeFatherResidence), record.getFieldValue(AbstractRecord.FieldType.wifeFatherComment));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherOccupation), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherLastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherFirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherAge), record.getFieldString(AbstractRecord.FieldType.wifeMotherDead), record.getFieldValue(AbstractRecord.FieldType.wifeMotherResidence), record.getFieldValue(AbstractRecord.FieldType.wifeMotherComment));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherOccupation), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness1LastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness1FirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness1Comment), record.getFieldValue(AbstractRecord.FieldType.witness1Occupation));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness2LastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness2FirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness2Comment), record.getFieldValue(AbstractRecord.FieldType.witness2Occupation));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness3LastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness3FirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness3Comment), record.getFieldValue(AbstractRecord.FieldType.witness3Occupation));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness4LastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness4FirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness4Comment), record.getFieldValue(AbstractRecord.FieldType.witness4Occupation));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.generalComment), new String[0]);
                        line.appendNimegueFn(String.valueOf(index), new String[0]);
                    } else if (record instanceof RecordDeath) {
                        line.appendNimegueFn(fileSignature, new String[0]);
                        line.appendNimegueFn(record.getPlace().getCityCode(), new String[0]);
                        line.appendNimegueFn(record.getPlace().getCityName(), new String[0]);
                        line.appendNimegueFn(record.getPlace().getCountryName(), new String[0]);
                        line.appendNimegueFn(record.getPlace().getCountyName(), new String[0]);
                        line.appendNimegueFn("D", new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.eventDate), new String[0]);
                        line.appendNimegueFn("", new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.cote), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.freeComment), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiLastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiFirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiBirthPlace), new String[0]);
                        if (record.getFieldValue(AbstractRecord.FieldType.indiBirthDate).trim().equals("")) {
                            line.appendNimegueFn("          ", new String[0]);
                        } else {
                            line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiBirthDate), new String[0]);
                        }
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiSex), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiAge), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiResidence), record.getFieldValue(AbstractRecord.FieldType.indiComment));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiOccupation), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedLastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedFirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldString(AbstractRecord.FieldType.indiMarriedDead), record.getFieldValue(AbstractRecord.FieldType.indiMarriedResidence), record.getFieldValue(AbstractRecord.FieldType.indiMarriedComment));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedOccupation), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherLastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherFirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherAge), record.getFieldString(AbstractRecord.FieldType.indiFatherDead), record.getFieldValue(AbstractRecord.FieldType.indiFatherResidence), record.getFieldValue(AbstractRecord.FieldType.indiFatherComment));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherOccupation), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherLastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherFirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherAge), record.getFieldString(AbstractRecord.FieldType.indiMotherDead), record.getFieldValue(AbstractRecord.FieldType.indiMotherResidence), record.getFieldValue(AbstractRecord.FieldType.indiMotherComment));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherOccupation), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness1LastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness1FirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness1Comment), record.getFieldValue(AbstractRecord.FieldType.witness1Occupation));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness2LastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness2FirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness2Comment), record.getFieldValue(AbstractRecord.FieldType.witness2Occupation));
                        if (record.getFieldValue(AbstractRecord.FieldType.witness3LastName).isEmpty() && record.getFieldValue(AbstractRecord.FieldType.witness4LastName).isEmpty()) {
                            line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.generalComment), new String[0]);
                        } else {
                            line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.generalComment), "t\u00e9moin: " + record.getFieldValue(AbstractRecord.FieldType.witness3FirstName) + " " + record.getFieldValue(AbstractRecord.FieldType.witness3LastName), record.getFieldValue(AbstractRecord.FieldType.witness3Occupation), record.getFieldValue(AbstractRecord.FieldType.witness3Comment), record.getFieldValue(AbstractRecord.FieldType.witness4FirstName) + " " + record.getFieldValue(AbstractRecord.FieldType.witness4LastName), record.getFieldValue(AbstractRecord.FieldType.witness4Occupation), record.getFieldValue(AbstractRecord.FieldType.witness4Comment));
                        }
                        line.appendNimegueFn(String.valueOf(index), new String[0]);
                    } else if (record instanceof RecordMisc) {
                        line.appendNimegueFn(fileSignature, new String[0]);
                        line.appendNimegueFn(record.getPlace().getCityCode(), new String[0]);
                        line.appendNimegueFn(record.getPlace().getCityName(), new String[0]);
                        line.appendNimegueFn(record.getPlace().getCountryName(), new String[0]);
                        line.appendNimegueFn(record.getPlace().getCountyName(), new String[0]);
                        line.appendNimegueFn("V", new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.eventDate), new String[0]);
                        line.appendNimegueFn("", new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.cote), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.freeComment), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.eventType), new String[0]);
                        line.appendNimegueFn("", new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiLastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiFirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiSex), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiBirthPlace), new String[0]);
                        if (record.getFieldValue(AbstractRecord.FieldType.indiBirthDate).trim().equals("")) {
                            line.appendNimegueFn("          ", new String[0]);
                        } else {
                            line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiBirthDate), new String[0]);
                        }
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiAge), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiResidence), record.getFieldValue(AbstractRecord.FieldType.indiComment));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiOccupation), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedLastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiMarriedFirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldString(AbstractRecord.FieldType.indiMarriedDead), record.getFieldValue(AbstractRecord.FieldType.indiMarriedOccupation), record.getFieldValue(AbstractRecord.FieldType.indiMarriedResidence), record.getFieldValue(AbstractRecord.FieldType.indiMarriedComment));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherLastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherFirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherAge), record.getFieldString(AbstractRecord.FieldType.indiFatherDead), record.getFieldValue(AbstractRecord.FieldType.indiFatherResidence), record.getFieldValue(AbstractRecord.FieldType.indiFatherComment));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiFatherOccupation), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherLastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherFirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherAge), record.getFieldString(AbstractRecord.FieldType.indiMotherDead), record.getFieldValue(AbstractRecord.FieldType.indiMotherResidence), record.getFieldValue(AbstractRecord.FieldType.indiMotherComment));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.indiMotherOccupation), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeLastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeFirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeSex), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeBirthPlace), new String[0]);
                        if (record.getFieldValue(AbstractRecord.FieldType.wifeBirthDate).equals("")) {
                            line.appendNimegueFn("          ", new String[0]);
                        } else {
                            line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeBirthDate), new String[0]);
                        }
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeAge), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeResidence), record.getFieldValue(AbstractRecord.FieldType.wifeComment));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeOccupation), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedLastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeMarriedFirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldString(AbstractRecord.FieldType.wifeMarriedDead), record.getFieldValue(AbstractRecord.FieldType.wifeMarriedOccupation), record.getFieldValue(AbstractRecord.FieldType.wifeMarriedResidence), record.getFieldValue(AbstractRecord.FieldType.wifeMarriedComment));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherLastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherFirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherAge), record.getFieldString(AbstractRecord.FieldType.wifeFatherDead), record.getFieldValue(AbstractRecord.FieldType.wifeFatherResidence), record.getFieldValue(AbstractRecord.FieldType.wifeFatherComment));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeFatherOccupation), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherLastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherFirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherAge), record.getFieldString(AbstractRecord.FieldType.wifeMotherDead), record.getFieldValue(AbstractRecord.FieldType.wifeMotherResidence), record.getFieldValue(AbstractRecord.FieldType.wifeMotherComment));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.wifeMotherOccupation), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness1LastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness1FirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness1Comment), record.getFieldValue(AbstractRecord.FieldType.witness1Occupation));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness2LastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness2FirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness2Comment), record.getFieldValue(AbstractRecord.FieldType.witness2Occupation));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness3LastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness3FirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness3Comment), record.getFieldValue(AbstractRecord.FieldType.witness3Occupation));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness4LastName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness4FirstName), new String[0]);
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.witness4Comment), record.getFieldValue(AbstractRecord.FieldType.witness4Occupation));
                        line.appendNimegueFn(record.getFieldValue(AbstractRecord.FieldType.generalComment), new String[0]);
                        line.appendNimegueFn(String.valueOf(index), new String[0]);
                    }
                    line.appendNimegue("\r\n", new String[0]);
                    writer.write(line.toString());
                    continue;
                }
                catch (IOException e) {
                    sb.append(String.format(ResourceBundle.getBundle("ancestris/modules/releve/file/Bundle").getString("file.LineNo"), index));
                    sb.append("\n");
                    sb.append(line).append("\n   ");
                    sb.append(e.getMessage()).append("\n");
                    e.printStackTrace(System.err);
                }
            }
            writer.close();
        }
        catch (IOException e) {
            sb.append(e.getMessage()).append("\n");
            e.printStackTrace(System.err);
        }
        return sb;
    }

    static enum BirthField {
        nimegue3,
        codeCommune,
        nomCommune,
        codeDepartement,
        nomDepartement,
        typeActe,
        dateNaissance,
        dateIncomplete,
        cote,
        photo,
        indiLastName,
        indiFirstName,
        indiSex,
        indiComment,
        indiFatherLastName,
        indiFatherFirstName,
        indiFatherComment,
        indiFatherOccupation,
        indiMotherLastName,
        indiMotherFirstName,
        indiMotherComment,
        indiMotherOccupation,
        witness1LastName,
        witness1FirstName,
        witness1Comment,
        witness2LastName,
        witness2FirstName,
        witness2Comment,
        generalComment,
        recordNo;

    }

    static enum MarrField {
        nimegue3,
        codeCommune,
        nomCommune,
        codeDepartement,
        nomDepartement,
        typeActe,
        eventDate,
        dateIncomplete,
        cote,
        libre,
        indiLastName,
        indiFirstName,
        indiBirthPlace,
        indiBirthDate,
        indiAge,
        indiComment,
        indiOccupation,
        indiMarriedLastName,
        indiMarriedFirstName,
        indiMarriedComment,
        indiFatherLastName,
        indiFatherFirstName,
        indiFatherComment,
        indiFatherOccupation,
        indiMotherLastName,
        indiMotherFirstName,
        indiMotherComment,
        indiMotherOccupation,
        wifeLastName,
        wifeFirstName,
        wifeBirthPlace,
        wifeBirthDate,
        wifeAge,
        wifeComment,
        wifeOccupation,
        wifeMarriedLastName,
        wifeMarriedFirstName,
        wifeMarriedComment,
        wifeFatherLastName,
        wifeFatherFirstName,
        wifeFatherComment,
        wifeFatherOccupation,
        wifeMotherLastName,
        wifeMotherFirstName,
        wifeMotherComment,
        wifeMotherOccupation,
        witness1LastName,
        witness1FirstName,
        witness1Comment,
        witness2LastName,
        witness2FirstName,
        witness2Comment,
        witness3LastName,
        witness3FirstName,
        witness3Comment,
        witness4LastName,
        witness4FirstName,
        witness4Comment,
        generalComment,
        recordNo;

    }

    static enum DeathField {
        nimegue3,
        codeCommune,
        nomCommune,
        codeDepartement,
        nomDepartement,
        typeActe,
        eventDate,
        dateIncomplete,
        cote,
        libre,
        indiLastName,
        indiFirstName,
        indiBirthPlace,
        indiBirthDate,
        indiSex,
        indiAge,
        indiComment,
        indiOccupation,
        wifeLastName,
        wifeFirstName,
        wifeComment,
        wifeOccupation,
        indiFatherLastName,
        indiFatherFirstName,
        indiFatherComment,
        indiFatherOccupation,
        indiMotherLastName,
        indiMotherFirstName,
        indiMotherComment,
        indiMotherOccupation,
        witness1LastName,
        witness1FirstName,
        witness1Comment,
        witness2LastName,
        witness2FirstName,
        witness2Comment,
        generalComment,
        recordNo;

    }

    static enum MiscField {
        nimegue3,
        codeCommune,
        nomCommune,
        codeDepartement,
        nomDepartement,
        typeActe,
        eventDate,
        dateIncomplete,
        cote,
        libre,
        eventTypeName,
        eventTypeTag,
        indiLastName,
        indiFirstName,
        indiSex,
        indiBirthPlace,
        indiBirthDate,
        indiAge,
        indiComment,
        indiOccupation,
        indiMarriedLastName,
        indiMarriedFirstName,
        indiMarriedComment,
        indiFatherLastName,
        indiFatherFirstName,
        indiFatherComment,
        indiFatherOccupation,
        indiMotherLastName,
        indiMotherFirstName,
        indiMotherComment,
        indiMotherOccupation,
        wifeLastName,
        wifeFirstName,
        wifeSex,
        wifeBirthPlace,
        wifeBirthDate,
        wifeAge,
        wifeComment,
        wifeOccupation,
        wifeMarriedLastName,
        wifeMarriedFirstName,
        wifeMarriedComment,
        wifeFatherLastName,
        wifeFatherFirstName,
        wifeFatherComment,
        wifeFatherOccupation,
        wifeMotherLastName,
        wifeMotherFirstName,
        wifeMotherComment,
        wifeMotherOccupation,
        witness1LastName,
        witness1FirstName,
        witness1Comment,
        witness2LastName,
        witness2FirstName,
        witness2Comment,
        witness3LastName,
        witness3FirstName,
        witness3Comment,
        witness4LastName,
        witness4FirstName,
        witness4Comment,
        generalComment,
        recordNo;

    }
}

