/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.file;

import ancestris.modules.releve.file.FileBuffer;
import ancestris.modules.releve.model.AbstractRecord;
import ancestris.modules.releve.model.BeanField;
import ancestris.modules.releve.model.BeanGroup;
import ancestris.modules.releve.model.RecordModelAbstract;
import ancestris.modules.releve.model.Synthesis;
import genj.fo.Document;
import genj.fo.HTMLFormat;
import genj.fo.PDFFormat;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ReleveFilePdf {
    private static Document doc;

    public static FileBuffer loadFile(File inputFile) {
        return null;
    }

    public static FileBuffer loadFile(InputStream inputStream) {
        return null;
    }

    public static StringBuilder saveFileHtml(RecordModelAbstract recordModel, AbstractRecord.RecordType recordType, File fileName, boolean append) {
        StringBuilder sb = new StringBuilder();
        try {
            doc = new Document("");
            ReleveFilePdf.writeDocument(recordModel, recordType, append);
            FileOutputStream fileOutputStream = new FileOutputStream(fileName, append);
            HTMLFormat format = new HTMLFormat();
            format.format(doc, (OutputStream)fileOutputStream);
        }
        catch (IOException e) {
            sb.append(e).append("\n");
        }
        return sb;
    }

    public static StringBuilder saveFile(RecordModelAbstract recordModel, AbstractRecord.RecordType recordType, File fileName, boolean append) {
        StringBuilder sb = new StringBuilder();
        try {
            doc = new Document("");
            ReleveFilePdf.writeDocument(recordModel, recordType, append);
            FileOutputStream fileOutputStream = new FileOutputStream(fileName, append);
            PDFFormat format = new PDFFormat();
            format.format(doc, (OutputStream)fileOutputStream);
        }
        catch (IOException e) {
            sb.append(e).append("\n");
        }
        return sb;
    }

    public static void writeDocument(RecordModelAbstract recordModel, AbstractRecord.RecordType recordType, boolean append) {
        boolean showFrenchCalendarDate = true;
        for (int index = 0; index < recordModel.getRowCount(); ++index) {
            AbstractRecord record = recordModel.getRecord(index);
            if (recordType != null && recordType != record.getType()) continue;
            try {
                ReleveFilePdf.writeTitle(1, ReleveFilePdf.getSynthesisTitle(record), record.getCity(), record.getFieldValue(AbstractRecord.FieldType.notary), record.getFieldValue(AbstractRecord.FieldType.cote), record.getFieldValue(AbstractRecord.FieldType.freeComment));
                ReleveFilePdf.writeValue(1, BeanField.getLabel(AbstractRecord.FieldType.parish), record.getFieldString(AbstractRecord.FieldType.parish));
                ReleveFilePdf.writeValue(1, BeanField.getLabel(AbstractRecord.FieldType.secondDate), record.getFieldString(AbstractRecord.FieldType.secondDate));
                ReleveFilePdf.writeValue(1, BeanGroup.getGroups(record.getType())[BeanGroup.GroupId.indi.ordinal()].getTitle(), ReleveFilePdf.appendValue(" ", record.getFieldValue(AbstractRecord.FieldType.indiFirstName), record.getFieldValue(AbstractRecord.FieldType.indiLastName)), record.getFieldString(AbstractRecord.FieldType.indiAge).isEmpty() ? "" : record.getFieldString(AbstractRecord.FieldType.indiAge), Synthesis.makeEventComment(NbBundle.getMessage(Synthesis.class, (String)"synthesis.born"), record.getField(AbstractRecord.FieldType.indiBirthDate), record.getFieldString(AbstractRecord.FieldType.indiBirthAddress), record.getFieldString(AbstractRecord.FieldType.indiBirthPlace), showFrenchCalendarDate));
                ReleveFilePdf.writeValue(2, BeanField.getLabel(AbstractRecord.FieldType.indiOccupation) + " ", record.getFieldValue(AbstractRecord.FieldType.indiOccupation));
                ReleveFilePdf.writeValue(2, BeanField.getLabel(AbstractRecord.FieldType.indiResidence) + " ", record.getFieldString(AbstractRecord.FieldType.indiAddress), record.getFieldValue(AbstractRecord.FieldType.indiResidence));
                ReleveFilePdf.writeValue(2, BeanField.getLabel(AbstractRecord.FieldType.indiDeathDate) + " ", Synthesis.makeEventComment(NbBundle.getMessage(Synthesis.class, (String)"synthesis.died"), record.getField(AbstractRecord.FieldType.indiDeathDate), record.getFieldString(AbstractRecord.FieldType.indiDeathAddress), record.getFieldString(AbstractRecord.FieldType.indiDeathPlace), showFrenchCalendarDate));
                ReleveFilePdf.writeValue(2, BeanField.getLabel(AbstractRecord.FieldType.indiComment) + " ", record.getFieldValue(AbstractRecord.FieldType.indiComment));
                ReleveFilePdf.writeValue(2, BeanGroup.getGroups(record.getType())[BeanGroup.GroupId.indiMarried.ordinal()].getTitle(), ReleveFilePdf.appendValue(", ", record.getFieldString(AbstractRecord.FieldType.indiMarriedFirstName) + " " + record.getFieldString(AbstractRecord.FieldType.indiMarriedLastName), record.getFieldString(AbstractRecord.FieldType.indiMarriedDead), record.getFieldString(AbstractRecord.FieldType.indiMarriedOccupation), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.indiMarriedResidence) + ": ", record.getFieldString(AbstractRecord.FieldType.indiMarriedAddress), record.getFieldString(AbstractRecord.FieldType.indiMarriedResidence)), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.indiMarriedComment) + ": ", record.getFieldString(AbstractRecord.FieldType.indiMarriedComment))));
                ReleveFilePdf.writeValue(2, BeanGroup.getGroups(record.getType())[BeanGroup.GroupId.indiFather.ordinal()].getTitle(), ReleveFilePdf.appendValue(", ", record.getFieldString(AbstractRecord.FieldType.indiFatherFirstName) + " " + record.getFieldString(AbstractRecord.FieldType.indiFatherLastName), record.getFieldString(AbstractRecord.FieldType.indiFatherAge).isEmpty() ? "" : record.getFieldString(AbstractRecord.FieldType.indiFatherAge), record.getFieldString(AbstractRecord.FieldType.indiFatherOccupation), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.indiFatherResidence) + ": ", record.getFieldString(AbstractRecord.FieldType.indiFatherAddress), record.getFieldString(AbstractRecord.FieldType.indiFatherResidence)), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.indiFatherComment) + ": ", record.getFieldString(AbstractRecord.FieldType.indiFatherComment))));
                ReleveFilePdf.writeValue(2, BeanGroup.getGroups(record.getType())[BeanGroup.GroupId.indiMother.ordinal()].getTitle(), ReleveFilePdf.appendValue(", ", record.getFieldString(AbstractRecord.FieldType.indiMotherFirstName) + " " + record.getFieldString(AbstractRecord.FieldType.indiMotherLastName), record.getFieldString(AbstractRecord.FieldType.indiMotherAge).isEmpty() ? "" : record.getFieldString(AbstractRecord.FieldType.indiMotherAge), record.getFieldString(AbstractRecord.FieldType.indiMotherDead), record.getFieldString(AbstractRecord.FieldType.indiMotherOccupation), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.indiMotherResidence) + ": ", record.getFieldString(AbstractRecord.FieldType.indiMotherAddress), record.getFieldString(AbstractRecord.FieldType.indiMotherResidence)), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.indiMotherComment) + ": ", record.getFieldString(AbstractRecord.FieldType.indiMotherComment))));
                ReleveFilePdf.writeValue(1, BeanGroup.getGroups(record.getType())[BeanGroup.GroupId.wife.ordinal()].getTitle(), ReleveFilePdf.appendValue(" ", record.getFieldValue(AbstractRecord.FieldType.wifeFirstName), record.getFieldValue(AbstractRecord.FieldType.wifeLastName)), record.getFieldString(AbstractRecord.FieldType.wifeAge).isEmpty() ? "" : record.getFieldString(AbstractRecord.FieldType.wifeAge), Synthesis.makeEventComment(NbBundle.getMessage(Synthesis.class, (String)"synthesis.born"), record.getField(AbstractRecord.FieldType.wifeBirthDate), record.getFieldString(AbstractRecord.FieldType.wifeBirthAddress), record.getFieldString(AbstractRecord.FieldType.wifeBirthPlace), showFrenchCalendarDate));
                ReleveFilePdf.writeValue(2, BeanField.getLabel(AbstractRecord.FieldType.wifeOccupation) + " ", record.getFieldValue(AbstractRecord.FieldType.wifeOccupation));
                ReleveFilePdf.writeValue(2, BeanField.getLabel(AbstractRecord.FieldType.wifeResidence) + " ", record.getFieldString(AbstractRecord.FieldType.wifeAddress), record.getFieldValue(AbstractRecord.FieldType.wifeResidence));
                ReleveFilePdf.writeValue(2, BeanField.getLabel(AbstractRecord.FieldType.wifeComment) + " ", record.getFieldValue(AbstractRecord.FieldType.wifeComment));
                ReleveFilePdf.writeValue(2, BeanGroup.getGroups(record.getType())[BeanGroup.GroupId.wifeMarried.ordinal()].getTitle(), ReleveFilePdf.appendValue(", ", record.getFieldString(AbstractRecord.FieldType.wifeMarriedFirstName) + " " + record.getFieldString(AbstractRecord.FieldType.wifeMarriedLastName), record.getFieldString(AbstractRecord.FieldType.wifeMarriedDead), record.getFieldString(AbstractRecord.FieldType.wifeMarriedOccupation), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.wifeMarriedResidence) + ": ", record.getFieldString(AbstractRecord.FieldType.wifeMarriedAddress), record.getFieldString(AbstractRecord.FieldType.wifeMarriedResidence)), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.wifeMarriedComment) + ": ", record.getFieldString(AbstractRecord.FieldType.wifeMarriedComment))));
                ReleveFilePdf.writeValue(2, BeanGroup.getGroups(record.getType())[BeanGroup.GroupId.wifeFather.ordinal()].getTitle(), ReleveFilePdf.appendValue(", ", record.getFieldString(AbstractRecord.FieldType.wifeFatherFirstName) + " " + record.getFieldString(AbstractRecord.FieldType.wifeFatherLastName), record.getFieldString(AbstractRecord.FieldType.wifeFatherAge).isEmpty() ? "" : record.getFieldString(AbstractRecord.FieldType.wifeFatherAge), record.getFieldString(AbstractRecord.FieldType.wifeFatherOccupation), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.wifeFatherResidence) + ": ", record.getFieldString(AbstractRecord.FieldType.wifeFatherAddress), record.getFieldString(AbstractRecord.FieldType.wifeFatherResidence)), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.wifeFatherComment) + ": ", record.getFieldString(AbstractRecord.FieldType.wifeFatherComment))));
                ReleveFilePdf.writeValue(2, BeanGroup.getGroups(record.getType())[BeanGroup.GroupId.wifeMother.ordinal()].getTitle(), ReleveFilePdf.appendValue(", ", record.getFieldString(AbstractRecord.FieldType.wifeMotherFirstName) + " " + record.getFieldString(AbstractRecord.FieldType.wifeMotherLastName), record.getFieldString(AbstractRecord.FieldType.wifeMotherAge).isEmpty() ? "" : record.getFieldString(AbstractRecord.FieldType.wifeMotherAge), record.getFieldString(AbstractRecord.FieldType.wifeMotherDead), record.getFieldString(AbstractRecord.FieldType.wifeMotherOccupation), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.wifeMotherResidence) + ": ", record.getFieldString(AbstractRecord.FieldType.wifeMotherAddress), record.getFieldString(AbstractRecord.FieldType.wifeMotherResidence)), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.wifeMotherComment) + ": ", record.getFieldString(AbstractRecord.FieldType.wifeMotherComment))));
                ReleveFilePdf.writeValue(1, BeanGroup.getGroups(record.getType())[BeanGroup.GroupId.witness1.ordinal()].getTitle(), ReleveFilePdf.appendValue(", ", ReleveFilePdf.appendValue(" ", record.getFieldString(AbstractRecord.FieldType.witness1FirstName), record.getFieldString(AbstractRecord.FieldType.witness1LastName)), record.getFieldString(AbstractRecord.FieldType.witness1Occupation), record.getFieldString(AbstractRecord.FieldType.witness1Comment)));
                ReleveFilePdf.writeValue(1, BeanGroup.getGroups(record.getType())[BeanGroup.GroupId.witness2.ordinal()].getTitle(), ReleveFilePdf.appendValue(", ", ReleveFilePdf.appendValue(" ", record.getFieldString(AbstractRecord.FieldType.witness2FirstName), record.getFieldString(AbstractRecord.FieldType.witness2LastName)), record.getFieldString(AbstractRecord.FieldType.witness2Occupation), record.getFieldString(AbstractRecord.FieldType.witness2Comment)));
                ReleveFilePdf.writeValue(1, BeanGroup.getGroups(record.getType())[BeanGroup.GroupId.witness3.ordinal()].getTitle(), ReleveFilePdf.appendValue(", ", ReleveFilePdf.appendValue(" ", record.getFieldString(AbstractRecord.FieldType.witness3FirstName), record.getFieldString(AbstractRecord.FieldType.witness3LastName)), record.getFieldString(AbstractRecord.FieldType.witness3Occupation), record.getFieldString(AbstractRecord.FieldType.witness3Comment)));
                ReleveFilePdf.writeValue(1, BeanGroup.getGroups(record.getType())[BeanGroup.GroupId.witness4.ordinal()].getTitle(), ReleveFilePdf.appendValue(", ", ReleveFilePdf.appendValue(" ", record.getFieldString(AbstractRecord.FieldType.witness4FirstName), record.getFieldString(AbstractRecord.FieldType.witness4LastName)), record.getFieldString(AbstractRecord.FieldType.witness4Occupation), record.getFieldString(AbstractRecord.FieldType.witness4Comment)));
                continue;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static void writeTitle(int indent, String ... otherValues) throws IOException {
        int i;
        indent = 4;
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        for (i = 0; i < otherValues.length - indent; ++i) {
            if (otherValues[i].trim().isEmpty()) continue;
            if (sb1.length() > 0) {
                sb1.append(" ");
            }
            sb1.append(otherValues[i].trim());
        }
        for (i = otherValues.length - indent; i < otherValues.length; ++i) {
            if (otherValues[i].trim().isEmpty()) continue;
            if (sb2.length() > 0) {
                sb2.append(" ");
            }
            sb2.append(otherValues[i].trim());
        }
        int percent = 50;
        if (sb1.length() + sb2.length() != 0) {
            percent = 12 * Math.abs(sb1.length() * 100 / (sb1.length() * 12 + sb2.length() * 10));
        }
        if (sb1.length() > 0) {
            doc.nextParagraph("start-indent=0pt,space-before=10pt");
            doc.addText(" ");
            doc.startTable("width=100%");
            doc.addTableColumn(String.format("column-width=%d%%", percent));
            doc.addTableColumn(String.format("column-width=%d%%", 100 - percent));
            doc.nextTableRow("text-align=left");
            doc.addText(sb1.toString(), "font-size=11pt,font-weight=bold");
            doc.nextTableCell("text-align=right");
            doc.addText(sb2.toString(), "font-size=10pt");
            doc.endTable();
        }
    }

    private static void writeValue(int indent, String label, String ... otherValues) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (String otherValue : otherValues) {
            if (otherValue.trim().isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(otherValue.trim());
        }
        if (sb.length() > 0) {
            doc.nextParagraph("start-indent=" + 20 * indent + "pt");
            if (!label.trim().isEmpty()) {
                doc.addText(label.trim() + ": ", "font-size=10pt,font-weight=bold");
            }
            doc.addText(sb.toString(), "font-size=10pt");
        }
    }

    protected static String appendValue(String separator, String ... otherValues) {
        StringBuilder sb = new StringBuilder();
        for (String otherValue : otherValues) {
            if (otherValue.trim().isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(otherValue.trim());
        }
        return sb.toString();
    }

    public static String getSynthesisTitle(AbstractRecord record) {
        if (record == null) {
            return "";
        }
        switch (record.getType()) {
            case BIRTH: 
            case DEATH: {
                return ReleveFilePdf.appendValue(" ", record.getFieldString(AbstractRecord.FieldType.eventDate), record.getEventTagLabel(), record.getFieldString(AbstractRecord.FieldType.indiFirstName), record.getFieldString(AbstractRecord.FieldType.indiLastName));
            }
            case MARRIAGE: {
                return ReleveFilePdf.appendValue(" ", record.getFieldString(AbstractRecord.FieldType.eventDate), record.getEventTagLabel(), record.getFieldString(AbstractRecord.FieldType.indiFirstName) + " " + record.getFieldString(AbstractRecord.FieldType.indiLastName), "x", record.getFieldString(AbstractRecord.FieldType.wifeFirstName) + " " + record.getFieldString(AbstractRecord.FieldType.wifeLastName));
            }
        }
        return ReleveFilePdf.appendValue(" ", record.getFieldString(AbstractRecord.FieldType.eventDate), record.getEventTagLabel(), record.getFieldString(AbstractRecord.FieldType.indiFirstName) + " " + record.getFieldString(AbstractRecord.FieldType.indiLastName), "-", record.getFieldString(AbstractRecord.FieldType.wifeFirstName) + " " + record.getFieldString(AbstractRecord.FieldType.wifeLastName));
    }

    public static class RecordComparator
    implements Comparator<AbstractRecord> {
        @Override
        public int compare(AbstractRecord record1, AbstractRecord record2) {
            if (record1.getField(AbstractRecord.FieldType.eventDate) == null) {
                if (record2.getField(AbstractRecord.FieldType.eventDate) == null) {
                    return 0;
                }
                return 1;
            }
            if (record2.getField(AbstractRecord.FieldType.eventDate) == null) {
                return -1;
            }
            return record1.getField(AbstractRecord.FieldType.eventDate).compareTo(record2.getField(AbstractRecord.FieldType.eventDate));
        }
    }
}

