/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.merge;

import ancestris.modules.releve.merge.SimilarNameSet;
import ancestris.modules.releve.utils.Java2sAutoTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import org.openide.util.NbBundle;

public class SimilarNameDialog
extends JFrame {
    SimilarNameSet similarName;
    SimilarTableModel tableModel;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonCopyToClipboard;
    private JButton jButtonDelete;
    private JButton jButtonOk;
    private JPanel jPaneTable;
    private JPanel jPanelButton;
    private JPanel jPanelToolbar;
    private JScrollPane jScrollPane1;
    private JTable jTableSimilar;

    public static void showSimilarFirstNamePanel() {
        SimilarNameDialog completionDialog = new SimilarNameDialog();
        completionDialog.initData(SimilarNameSet.getSimilarFirstName(), NbBundle.getMessage(SimilarNameDialog.class, (String)"SimilarNameDialog.firstNameTitle"), NbBundle.getMessage(SimilarNameDialog.class, (String)"SimilarNameDialog.firstNameColumn"), new NameCellEditor(false, true));
        completionDialog.setVisible(true);
    }

    public static void showSimilarLastNamePanel() {
        SimilarNameDialog completionDialog = new SimilarNameDialog();
        completionDialog.initData(SimilarNameSet.getSimilarLastName(), NbBundle.getMessage(SimilarNameDialog.class, (String)"SimilarNameDialog.lastNameTitle"), NbBundle.getMessage(SimilarNameDialog.class, (String)"SimilarNameDialog.lastNameColumn"), new NameCellEditor(true, false));
        completionDialog.setVisible(true);
    }

    private SimilarNameDialog() {
        this.initComponents();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screen.width - this.getWidth()) / 2, (screen.height - this.getHeight()) / 2, this.getWidth(), this.getHeight());
    }

    private void initData(SimilarNameSet similarName, String dialogTitle, String columnTitle1, NameCellEditor cellEditor) {
        this.setTitle(dialogTitle);
        String columnTitle2 = NbBundle.getMessage(SimilarNameDialog.class, (String)"SimilarNameDialog.similarColumn");
        this.similarName = similarName;
        this.tableModel = new SimilarTableModel(similarName, columnTitle1, columnTitle2);
        this.jTableSimilar.setModel(this.tableModel);
        this.jTableSimilar.getColumnModel().getColumn(0).setCellEditor(cellEditor);
        this.jTableSimilar.getColumnModel().getColumn(1).setCellEditor(cellEditor);
        this.jTableSimilar.setRowHeight(this.jTableSimilar.getRowHeight() + 4);
        this.jTableSimilar.setAutoCreateRowSorter(true);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        sortKeys.add(new RowSorter.SortKey(1, SortOrder.ASCENDING));
        this.jTableSimilar.getRowSorter().setSortKeys(sortKeys);
    }

    private void saveSimilar() {
        if (this.jTableSimilar.isEditing()) {
            this.jTableSimilar.getCellEditor().stopCellEditing();
        }
        int n = this.tableModel.getRowCount();
        HashMap<String, String> hashmap = new HashMap<String, String>();
        for (int i = 0; i < n; ++i) {
            if (this.tableModel.getValueAt(i, 0).isEmpty() || this.tableModel.getValueAt(i, 1).isEmpty()) continue;
            hashmap.put(this.tableModel.getValueAt(i, 0), this.tableModel.getValueAt(i, 1));
        }
        this.similarName.save(hashmap);
    }

    private void initComponents() {
        this.jPaneTable = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableSimilar = new JTable();
        this.jPanelButton = new JPanel();
        this.jButtonOk = new JButton();
        this.jButtonCancel = new JButton();
        this.jPanelToolbar = new JPanel();
        this.jButtonAdd = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonCopyToClipboard = new JButton();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                SimilarNameDialog.this.formWindowClosed(evt);
            }
        });
        this.jPaneTable.setPreferredSize(new Dimension(300, 400));
        this.jPaneTable.setLayout(new BorderLayout());
        this.jTableSimilar.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.jTableSimilar.setAutoResizeMode(4);
        this.jScrollPane1.setViewportView(this.jTableSimilar);
        this.jPaneTable.add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.jPaneTable, "Center");
        this.jPanelButton.setBorder(BorderFactory.createBevelBorder(0));
        this.jButtonOk.setText(NbBundle.getMessage(SimilarNameDialog.class, (String)"SimilarNameDialog.jButtonOk.text"));
        this.jButtonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimilarNameDialog.this.jButtonOkActionPerformed(evt);
            }
        });
        this.jPanelButton.add(this.jButtonOk);
        this.jButtonCancel.setText(NbBundle.getMessage(SimilarNameDialog.class, (String)"SimilarNameDialog.jButtonCancel.text"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimilarNameDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanelButton.add(this.jButtonCancel);
        this.getContentPane().add((Component)this.jPanelButton, "South");
        this.jButtonAdd.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/NewRecord.png")));
        this.jButtonAdd.setToolTipText(NbBundle.getMessage(SimilarNameDialog.class, (String)"SimilarNameDialog.jButtonAdd.toolTipText"));
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimilarNameDialog.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jPanelToolbar.add(this.jButtonAdd);
        this.jButtonDelete.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/DeleteRecord.png")));
        this.jButtonDelete.setToolTipText(NbBundle.getMessage(SimilarNameDialog.class, (String)"SimilarNameDialog.jButtonDelete.toolTipText"));
        this.jButtonDelete.setHorizontalAlignment(2);
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimilarNameDialog.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jPanelToolbar.add(this.jButtonDelete);
        this.jButtonCopyToClipboard.setText(NbBundle.getMessage(SimilarNameDialog.class, (String)"SimilarNameDialog.jButtonCopyToClipboard.text"));
        this.jButtonCopyToClipboard.setToolTipText(NbBundle.getMessage(SimilarNameDialog.class, (String)"SimilarNameDialog.jButtonCopyToClipboard.toolTipText"));
        this.jButtonCopyToClipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimilarNameDialog.this.jButtonCopyToClipboardActionPerformed(evt);
            }
        });
        this.jPanelToolbar.add(this.jButtonCopyToClipboard);
        this.getContentPane().add((Component)this.jPanelToolbar, "North");
        this.pack();
    }

    private void formWindowClosed(WindowEvent evt) {
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        int[] selectedRows;
        for (int row : selectedRows = this.jTableSimilar.getSelectedRows()) {
            this.tableModel.remove(this.jTableSimilar.convertRowIndexToModel(row));
        }
        this.tableModel.fireTableDataChanged();
        this.jTableSimilar.clearSelection();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        this.saveSimilar();
        this.dispose();
    }

    private void jButtonCopyToClipboardActionPerformed(ActionEvent evt) {
        int LINE_SEPARATOR = 10;
        int FIELD_SEPARATOR = 9;
        Clipboard CLIPBOARD = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringBuilder clipboardStr = new StringBuilder();
        clipboardStr.append(this.tableModel.getColumnName(0)).append('\t').append(this.tableModel.getColumnName(1)).append('\n');
        int n = this.tableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            clipboardStr.append(this.tableModel.getValueAt(i, 0)).append('\t').append(this.tableModel.getValueAt(i, 1)).append('\n');
        }
        StringSelection sel = new StringSelection(clipboardStr.toString());
        CLIPBOARD.setContents(sel, sel);
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        this.tableModel.add();
        this.tableModel.fireTableDataChanged();
        int currentRow = this.jTableSimilar.convertRowIndexToView(0);
        this.jTableSimilar.setRowSelectionInterval(currentRow, currentRow);
        this.jTableSimilar.requestFocus();
        this.jTableSimilar.editCellAt(0, 0);
    }

    private static class NameCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        Java2sAutoTextField jTextField = new Java2sAutoTextField(new ArrayList<String>());

        protected NameCellEditor(boolean setUpperAllChar, boolean setUpperAllFirstChar) {
            this.jTextField.setStrict(false);
            this.jTextField.setCaseSensitive(false);
            this.jTextField.setUpperAllFirstChar(setUpperAllFirstChar);
            this.jTextField.setUpperAllChar(setUpperAllChar);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
            this.jTextField.setStrict(false);
            this.jTextField.setCaseSensitive(false);
            this.jTextField.setUpperAllFirstChar(true);
            this.jTextField.setText(value.toString());
            return this.jTextField;
        }

        @Override
        public Object getCellEditorValue() {
            return this.jTextField.getText();
        }
    }

    private class SimilarTableModel
    extends AbstractTableModel {
        private final Class<?>[] columnClass = new Class[]{String.class, String.class};
        private final List<String> keys;
        private final List<String> values;
        String[] columnName = new String[]{"", ""};

        public SimilarTableModel(SimilarNameSet similarName, String columnName1, String columnName2) {
            this.keys = new ArrayList<String>(similarName.getKeys());
            this.values = new ArrayList<String>(similarName.getValues());
            this.columnName[0] = columnName1;
            this.columnName[1] = columnName2;
        }

        protected void add() {
            this.keys.add("");
            this.values.add("");
        }

        protected void remove(int row) {
            this.keys.remove(row);
            this.values.remove(row);
        }

        @Override
        public int getColumnCount() {
            return this.columnClass.length;
        }

        @Override
        public int getRowCount() {
            return this.values.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnName[col];
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return this.columnClass[col];
        }

        @Override
        public String getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.keys.get(row);
                }
                case 1: {
                    return this.values.get(row);
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            switch (col) {
                case 0: {
                    if (this.keys.contains(value.toString())) {
                        Toolkit.getDefaultToolkit().beep();
                        break;
                    }
                    this.keys.set(row, value.toString());
                    break;
                }
                case 1: {
                    this.values.set(row, value.toString());
                }
            }
            this.fireTableCellUpdated(row, col);
        }
    }
}

