/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.merge;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openide.util.NbPreferences;

public class SimilarNameSet {
    private static final String SimilarFirstNamePreference = "SimilarFirstNameList";
    private static final String SimilarLastNamePreference = "SimilarLastNameList";
    private static SimilarNameSet similarLastNameSet = null;
    private static SimilarNameSet similarFirstNameSet = null;
    private final HashMap<String, String> similarNames = new HashMap();
    private final String similarPreference;

    public static SimilarNameSet getSimilarFirstName() {
        if (similarFirstNameSet == null) {
            similarFirstNameSet = new SimilarNameSet(SimilarFirstNamePreference);
            similarFirstNameSet.loadPreferences();
        }
        return similarFirstNameSet;
    }

    public static SimilarNameSet getSimilarLastName() {
        if (similarLastNameSet == null) {
            similarLastNameSet = new SimilarNameSet(SimilarLastNamePreference);
            similarLastNameSet.loadPreferences();
        }
        return similarLastNameSet;
    }

    private SimilarNameSet(String similarPreference) {
        this.similarPreference = similarPreference;
    }

    public String getSimilarName(String inputName) {
        String similarName = this.similarNames.get(inputName);
        if (similarName != null) {
            return similarName;
        }
        return inputName;
    }

    public Set<String> getKeys() {
        return this.similarNames.keySet();
    }

    public Collection<String> getValues() {
        return this.similarNames.values();
    }

    public void save(Map<String, String> entries) {
        this.similarNames.clear();
        this.similarNames.putAll(entries);
        this.savePreferences();
    }

    protected void reset() {
        this.similarNames.clear();
        this.loadPreferences();
    }

    private void loadPreferences() {
        String[] values;
        String similarString = NbPreferences.forModule(SimilarNameSet.class).get(this.similarPreference, "");
        for (String value : values = similarString.split(";")) {
            if (value.isEmpty()) continue;
            String[] pairValue = value.split("=");
            this.similarNames.put(pairValue[0], pairValue[1]);
        }
    }

    private void savePreferences() {
        StringBuilder values = new StringBuilder();
        for (Map.Entry<String, String> entry : this.similarNames.entrySet()) {
            values.append(entry.getKey()).append("=").append(entry.getValue()).append(";");
        }
        NbPreferences.forModule(SimilarNameSet.class).put(this.similarPreference, values.toString());
    }
}

