/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.search;

import ancestris.modules.releve.search.SearchDialog;
import java.util.TreeMap;
import java.util.TreeSet;
import org.openide.util.NbBundle;

public class ResultBuffer {
    private final TreeSet<ResultItem> resultSet = new TreeSet();
    private final TreeMap<Integer, TreeMap<Integer, TreeSet<ResultItem>>> resultTree = new TreeMap();
    StringBuilder sb = new StringBuilder();

    public StringBuilder append(String message) {
        return this.sb.append(message);
    }

    public String getResult() {
        return this.sb.toString();
    }

    void addResult(int row, int col, String message) {
        TreeSet<ResultItem> colResults;
        ResultItem error = new ResultItem(row, col, message);
        this.resultSet.add(error);
        TreeMap<Integer, TreeSet<ResultItem>> rowResults = this.resultTree.get(row);
        if (rowResults == null) {
            rowResults = new TreeMap();
            this.resultTree.put(row, rowResults);
        }
        if ((colResults = rowResults.get(col)) == null) {
            colResults = new TreeSet();
            rowResults.put(col, colResults);
        }
        colResults.add(error);
    }

    public void removeAll() {
        this.resultSet.clear();
        this.resultTree.clear();
    }

    private int getResultCount() {
        return this.resultSet.size();
    }

    protected String getResultText() {
        return NbBundle.getMessage(SearchDialog.class, (String)"ResultBuffer.resultMsg.text", (Object)this.getResultCount());
    }

    ResultItem[] getResults() {
        return this.resultSet.toArray(new ResultItem[this.resultSet.size()]);
    }

    ResultItem[] getResult(int row, int col) {
        TreeMap<Integer, TreeSet<ResultItem>> rowErrors = this.resultTree.get(row);
        if (rowErrors != null) {
            TreeSet<ResultItem> colErrors = rowErrors.get(col);
            if (colErrors != null) {
                return colErrors.toArray(new ResultItem[colErrors.size()]);
            }
            return new ResultItem[0];
        }
        return new ResultItem[0];
    }

    boolean hasResult(int row) {
        return this.resultTree.get(row) != null;
    }

    public static String getLetter(int col) {
        int dizain = col / 26;
        int unit = col - dizain * 26;
        Object letter = "";
        if (dizain > 0) {
            letter = (String)letter + (char)(dizain + 64);
        }
        letter = (String)letter + (char)(unit + 65);
        return letter;
    }

    public static class ResultItem
    implements Comparable<ResultItem> {
        int row;
        int col;
        String message;

        public ResultItem(int row, int col, String message) {
            this.row = row;
            this.col = col;
            this.message = message;
        }

        public String toString() {
            String lineStr = NbBundle.getMessage(SearchDialog.class, (String)"ResultBuffer.line.text");
            String colStr = NbBundle.getMessage(SearchDialog.class, (String)"ResultBuffer.column.text");
            return lineStr + " " + (this.row + 1) + " " + colStr + ResultBuffer.getLetter(this.col) + " " + this.message;
        }

        @Override
        public int compareTo(ResultItem otherResultItem) {
            if (this.row == otherResultItem.row) {
                return this.col - otherResultItem.col;
            }
            return this.row - otherResultItem.row;
        }
    }
}

