/*
 * Decompiled with CFR 0.152.
 */
package org.geonames;

import org.geonames.BoundingBox;
import org.geonames.InvalidParameterException;
import org.geonames.Style;

public class PostalCodeSearchCriteria {
    private String postalCode;
    private String placeName;
    private String adminCode1;
    private String countryCode;
    private String countryBias;
    private Double latitude;
    private Double longitude;
    private double radius;
    private Style style;
    private int maxRows;
    private int startRow;
    private boolean isOROperator = false;
    private Boolean isReduced;
    private BoundingBox boundingBox;

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) throws InvalidParameterException {
        if (countryCode != null && countryCode.length() != 2) {
            throw new InvalidParameterException("invalid country code " + countryCode);
        }
        this.countryCode = countryCode;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) throws InvalidParameterException {
        if (latitude > 90.0 || latitude < -90.0) {
            throw new InvalidParameterException("invalid latitude " + latitude);
        }
        this.latitude = new Double(latitude);
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) throws InvalidParameterException {
        if (longitude > 180.0 || longitude < -180.0) {
            throw new InvalidParameterException("invalid longitude " + longitude);
        }
        this.longitude = new Double(longitude);
    }

    public String getPlaceName() {
        return this.placeName;
    }

    public void setPlaceName(String placeName) {
        this.placeName = placeName;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public void setOROperator(boolean isOROperator) {
        this.isOROperator = isOROperator;
    }

    public boolean isOROperator() {
        return this.isOROperator;
    }

    public String getAdminCode1() {
        return this.adminCode1;
    }

    public void setAdminCode1(String adminCode1) {
        this.adminCode1 = adminCode1;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public double getRadius() {
        return this.radius;
    }

    public String getCountryBias() {
        return this.countryBias;
    }

    public void setCountryBias(String countryBias) {
        this.countryBias = countryBias;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    public Boolean isReduced() {
        return this.isReduced;
    }

    public void setIsReduced(Boolean isReduced) {
        this.isReduced = isReduced;
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public void setBoundingBox(BoundingBox boundingBox) {
        this.boundingBox = boundingBox;
    }
}

