/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.genids;

import ancestris.modules.gedcom.genids.GenIDPanel;
import ancestris.modules.gedcom.genids.GenerateIDAction;
import ancestris.modules.gedcom.genids.GenerateIDTask;
import ancestris.util.TimingUtility;
import ancestris.util.Utilities;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class GenerateIDTaskFactory {
    public static GenerateIDTask create(Gedcom gedcom, GenIDPanel.Settings settings) {
        return new Impl(gedcom, settings);
    }

    private static class Impl
    implements GenerateIDTask {
        private static final Logger log = Logger.getLogger(GenerateIDTaskFactory.class.getName());
        private Gedcom gedcom = null;
        private GenIDPanel.Settings settings = null;
        private int counter = 0;
        private int maxCounter = 0;
        private boolean cancel = false;
        private String taskName = "";
        private String state = "";

        private Impl(Gedcom gedcom, GenIDPanel.Settings settings) {
            this.gedcom = gedcom;
            this.settings = settings;
            this.taskName = NbBundle.getMessage(GenerateIDTaskFactory.class, (String)"GenerateIDAction.AskParams");
        }

        @Override
        public void run() {
            this.maxCounter = 1;
            if (this.settings.isCat) {
                for (String tag : this.settings.entsTags) {
                    if (tag.isEmpty()) continue;
                    this.maxCounter += this.gedcom.getEntities(tag).size() * 3;
                }
            }
            if (this.generateIDs()) {
                WindowManager.getDefault().invokeWhenUIReady(() -> DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GenerateIDAction.class, (String)"GenerateIDAction.Done"), 1)));
            }
        }

        public void cancelTrackable() {
            this.cancel = true;
        }

        public int getProgress() {
            int progress = 100 * this.counter / this.maxCounter;
            if (progress % 5 == 0) {
                log.log(Level.FINE, "Time={0} - state = {1} - progress = {2}", new Object[]{TimingUtility.getInstance().getTime(), this.getState(), progress});
            }
            return progress;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public String getState() {
            return this.state;
        }

        private boolean generateIDs() {
            TimingUtility.getInstance().reset();
            this.counter = 0;
            if (this.settings.isCat) {
                int pad = 1;
                if (this.settings.len > 0 && this.settings.len < 11) {
                    pad = this.settings.len;
                }
                if (this.settings.len < 0) {
                    pad = 0;
                }
                if (this.settings.len > 11) {
                    pad = 11;
                }
                DecimalFormat formatNbrs = new DecimalFormat("000000000000".substring(0, pad));
                for (String tag : this.settings.entsTags) {
                    String newID;
                    Entity entity;
                    String oldID;
                    Iterator it;
                    String key;
                    if (this.cancel) {
                        return false;
                    }
                    if (tag.isEmpty()) continue;
                    this.state = Gedcom.getName((String)tag) + " 1/3";
                    Collection entities = this.gedcom.getEntities(tag);
                    String entityIDPrefix = this.gedcom.getNextAvailableID(tag).substring(0, 1);
                    TreeMap<String, Object> listID = new TreeMap<String, Object>();
                    for (Entity entity2 : entities) {
                        ++this.counter;
                        String ID = entity2.getId();
                        key = Utilities.removeDiacritics((String)entity2.toString());
                        listID.put(key, ID);
                    }
                    this.state = Gedcom.getName((String)tag) + " 2/3";
                    int iCounter = 0;
                    try {
                        it = listID.keySet().iterator();
                        while (it.hasNext()) {
                            if (this.cancel) {
                                return false;
                            }
                            ++this.counter;
                            key = (String)it.next();
                            oldID = (String)listID.get(key);
                            entity = this.gedcom.getEntity(oldID);
                            newID = entityIDPrefix + this.settings.prefix + "XYZAWZ" + ++iCounter + this.settings.suffix;
                            entity.setId(newID);
                            listID.put(key, newID);
                        }
                    }
                    catch (GedcomException e) {
                        Exceptions.printStackTrace((Throwable)e);
                        return false;
                    }
                    this.state = Gedcom.getName((String)tag) + " 3/3";
                    iCounter = 0;
                    try {
                        it = listID.keySet().iterator();
                        while (it.hasNext()) {
                            if (this.cancel) {
                                return false;
                            }
                            ++this.counter;
                            key = (String)it.next();
                            oldID = (String)listID.get(key);
                            entity = this.gedcom.getEntity(oldID);
                            newID = entityIDPrefix + this.settings.prefix + formatNbrs.format(++iCounter) + this.settings.suffix;
                            entity.setId(newID);
                        }
                    }
                    catch (GedcomException e) {
                        Exceptions.printStackTrace((Throwable)e);
                        return false;
                    }
                }
            } else {
                String letterTo;
                Entity entityFrom = this.gedcom.getEntity(this.settings.IDFrom);
                Entity entityTo = this.gedcom.getEntity(this.settings.IDTo);
                if (this.settings.IDFrom.isEmpty() || this.settings.IDTo.isEmpty() || entityFrom == null || entityTo != null) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GenerateIDAction.class, (String)"GenerateIDAction.IncorrectIDs"), 0));
                    return false;
                }
                String letterFrom = Gedcom.getEntityPrefix((String)entityFrom.getTag());
                if (!letterFrom.equals(letterTo = this.settings.IDTo.substring(0, 1)) && DialogManager.OK_OPTION != DialogManager.create((String)NbBundle.getMessage(GenerateIDAction.class, (String)"GenerateIDAction.TTL_ConfirmChange"), (String)NbBundle.getMessage(GenerateIDAction.class, (String)"GenerateIDAction.MSG_ConfirmChange", (Object)letterFrom, (Object)letterTo, (Object)this.settings.IDFrom, (Object)this.settings.IDTo, (Object[])new Object[0])).setMessageType(2).setOptionType(2).show()) {
                    return false;
                }
                try {
                    entityFrom.setId(this.settings.IDTo);
                }
                catch (GedcomException e) {
                    Exceptions.printStackTrace((Throwable)e);
                    return false;
                }
            }
            return true;
        }
    }
}

