/*
 * Decompiled with CFR 0.152.
 */
package org.miv.mbox.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import org.miv.mbox.net.MBoxLocator;
import org.miv.mbox.net.Packet;

public class Sender {
    protected SocketChannel socket;
    protected MBoxLocator locator;
    protected ObjectOutputStream objectOut;
    protected ByteArrayOutputStream byteArrayOut;
    protected boolean debug = false;
    protected int reset = 0;
    protected byte[] header = new byte[4];
    protected static final String LIGHT_GREEN = "\u001b[32;1m";
    protected static final String RESET = "\u001b[0m";

    public Sender(MBoxLocator locator) throws IOException, UnknownHostException {
        this(locator, false);
    }

    public Sender(MBoxLocator locator, boolean debug) throws IOException, UnknownHostException {
        this.locator = locator;
        this.debug = debug;
        InetSocketAddress addr = new InetSocketAddress(locator.getHostname(), locator.getPort());
        this.socket = SocketChannel.open();
        this.socket.connect(addr);
        this.socket.configureBlocking(true);
        this.socket.finishConnect();
        if (debug) {
            this.debug("connect from %s:%d to %s:%d", this.socket.socket().getLocalAddress(), this.socket.socket().getLocalPort(), this.socket.socket().getInetAddress(), this.socket.socket().getPort());
        }
        this.byteArrayOut = new ByteArrayOutputStream(4096);
        this.objectOut = new ObjectOutputStream(this.byteArrayOut);
        if (debug) {
            this.debug("ready", new Object[0]);
        }
    }

    public MBoxLocator getLocator() {
        return this.locator;
    }

    public void setDebugOn(boolean on) {
        this.debug = on;
    }

    public void send(String from, String to, Object ... messages) throws IOException {
        this.send(new Packet(from, to, messages));
    }

    public void send(Packet packet) throws IOException {
        if (this.reset >= 10240) {
            this.reset = 0;
            this.objectOut.reset();
        }
        this.objectOut.writeObject(packet);
        int size = this.byteArrayOut.size();
        OutputStream out = this.socket.socket().getOutputStream();
        this.header[0] = (byte)(size >> 24 & 0xFF);
        this.header[1] = (byte)(size >> 16 & 0xFF);
        this.header[2] = (byte)(size >> 8 & 0xFF);
        this.header[3] = (byte)(size & 0xFF);
        if (this.debug) {
            this.debug("send (%s -> %s)", packet.from, packet.to);
        }
        out.write(this.header);
        this.byteArrayOut.writeTo(out);
        if (this.debug) {
            this.debug("sent (%s -> %s)", packet.from, packet.to);
        }
        ++this.reset;
        this.byteArrayOut.reset();
    }

    protected void debug(String message, Object ... data) {
        System.err.print(LIGHT_GREEN);
        System.err.printf("[%s|", this.locator.toString());
        System.err.print(RESET);
        System.err.printf(message, data);
        System.err.print(LIGHT_GREEN);
        System.err.print("]");
        System.err.println(RESET);
    }
}

