/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.feedback;

import ancestris.api.core.Version;
import ancestris.app.App;
import ancestris.core.resources.Images;
import ancestris.modules.feedback.FeedBackOptionPanel;
import ancestris.modules.feedback.FeedBackPlugin;
import ancestris.modules.feedback.FeedbackPanel;
import ancestris.modules.feedback.SendMailWorker;
import ancestris.util.swing.DialogManager;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.netbeans.api.options.OptionsDisplayer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class SendAction
implements ActionListener {
    private final Preferences modulePreferences = NbPreferences.forModule(FeedBackPlugin.class);
    private static final String TEXTSEPARATOR = "\n=======================================\n";
    private FeedbackPanel fbPanel;

    private void saveDefaultValues(FeedbackPanel panel) {
        this.modulePreferences.put("mail.subject", panel.jtSubject.getText().trim());
        this.modulePreferences.put("mail.name", panel.jtName.getText().trim());
        this.modulePreferences.put("mail.body", panel.jtaText.getText().trim());
        this.modulePreferences.put("mail.attachment", panel.jtAttachment.getText().trim());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fbPanel = new FeedbackPanel();
        this.fbPanel.jtSubject.setText(this.modulePreferences.get("mail.subject", ""));
        this.fbPanel.jtName.setText(this.modulePreferences.get("mail.name", ""));
        this.fbPanel.jtaText.setText(this.modulePreferences.get("mail.body", ""));
        this.fbPanel.jtAttachment.setText(this.modulePreferences.get("mail.attachment", ""));
        this.fbPanel.jtaTechInfo.setText(SendAction.getSystemInfo());
        this.fbPanel.textLogFilePath.setText(SendAction.getLogPath());
        this.fbPanel.textMsgFilePath.setText(SendAction.getMsgPath());
        this.fbPanel.textConfFilePath.setText(SendAction.getConfPath());
        JButton mailtoButton = new JButton(NbBundle.getMessage(SendAction.class, (String)"SEND_MAILTO_BUTTON"));
        mailtoButton.setToolTipText(NbBundle.getMessage(SendAction.class, (String)"SEND_MAILTO_BUTTON_TIP"));
        mailtoButton.setIcon((Icon)Images.imgWeb);
        JButton mailButton = new JButton(NbBundle.getMessage(SendAction.class, (String)"SEND_EMAIL_BUTTON"));
        mailButton.setToolTipText(NbBundle.getMessage(SendAction.class, (String)"SEND_EMAIL_BUTTON_TIP"));
        mailButton.setIcon((Icon)Images.imgMail);
        JButton copyButton = new JButton(NbBundle.getMessage(SendAction.class, (String)"SEND_COPY_BUTTON"));
        copyButton.setToolTipText(NbBundle.getMessage(SendAction.class, (String)"SEND_COPY_BUTTON_TIP"));
        copyButton.setIcon((Icon)Images.imgCopy);
        Object o = DialogManager.create((String)NbBundle.getMessage(this.getClass(), (String)"FeedbackPanel.title"), (JComponent)this.fbPanel).setOptions(new Object[]{mailtoButton, mailButton, copyButton, DialogDescriptor.CANCEL_OPTION}).setDialogId(this.getClass()).show();
        this.saveDefaultValues(this.fbPanel);
        String name = this.fbPanel.jtName.getText().trim();
        String to = "support@ancestris.org";
        String TS = new SimpleDateFormat("yyyy-MM-dd @ HH:mm").format(new Date());
        String subject = "[" + NbBundle.getMessage(this.getClass(), (String)"fb.tag.subject") + " " + TS + "] ";
        subject = subject + this.fbPanel.jtSubject.getText().trim();
        String attachFilePath = this.fbPanel.attachmentFile != null ? this.fbPanel.attachmentFile.getAbsolutePath() : "";
        Object instructions = NbBundle.getMessage(this.getClass(), (String)"FeedbackPanel.filesInstructions", (Object)SendAction.getLogPath(), (Object)SendAction.getMsgPath(), (Object)SendAction.getConfPath());
        if (!attachFilePath.isBlank()) {
            instructions = (String)instructions + NbBundle.getMessage(this.getClass(), (String)"FeedbackPanel.filesInstructions2", (Object)attachFilePath);
        }
        Object messageBody = this.fbPanel.jtaText.getText().trim();
        messageBody = (String)messageBody + "\n\n--\n" + name + "\n\n";
        messageBody = (String)messageBody + "\n\n=======================================\n\n";
        messageBody = (String)messageBody + this.fbPanel.jtaTechInfo.getText().trim();
        messageBody = (String)messageBody + "\n\n=======================================\n\n";
        messageBody = (String)messageBody + (String)instructions;
        messageBody = (String)messageBody + "\n\n=======================================\n\n";
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append(NbBundle.getMessage(this.getClass(), (String)"FeedbackPanel.mailTO"));
        sb.append(": ");
        sb.append(to);
        sb.append("\n\n");
        sb.append(NbBundle.getMessage(this.getClass(), (String)"FeedbackPanel.mailSUBJECT"));
        sb.append(": ");
        sb.append(subject);
        sb.append("\n\n");
        sb.append(NbBundle.getMessage(this.getClass(), (String)"FeedbackPanel.mailMESSAGE_BODY"));
        sb.append(":\n\n");
        sb.append((String)messageBody);
        sb.append("\n");
        sb.append("\n");
        if (o.equals(copyButton)) {
            sb.append(NbBundle.getMessage(this.getClass(), (String)"FeedbackPanel.copyClipboardInstructions"));
            StringSelection selection = new StringSelection(sb.toString());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, selection);
            DialogManager.create((String)NbBundle.getMessage(SendAction.class, (String)"SEND_COPY_BUTTON"), (String)NbBundle.getMessage(this.getClass(), (String)"fb.msg.copied_to_clipboard")).setOptionType(10).setMessageType(1).show();
        } else if (o.equals(mailtoButton)) {
            messageBody = (String)messageBody + NbBundle.getMessage(this.getClass(), (String)"FeedbackPanel.mailtoInstructions");
            try {
                String subject_encoded = URLEncoder.encode(subject, "UTF-8").replace("+", "%20");
                String body_encoded = URLEncoder.encode((String)messageBody, "UTF-8").replace("+", "%20");
                String mailStr = String.format("mailto:%s?subject=%s&body=%s", to, subject_encoded, body_encoded);
                URI mailURI = URI.create(mailStr);
                Desktop.getDesktop().mail(mailURI);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else if (o.equals(mailButton)) {
            File attachedConf;
            File attachedMsg;
            String emailSMTPPort;
            String emailSMTPHost;
            String emailAddr = this.modulePreferences.get("mail.address", "");
            if (!this.isIvalid(emailAddr, emailSMTPHost = this.modulePreferences.get("mail.host", ""), emailSMTPPort = this.modulePreferences.get("mail.host.port", ""))) {
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(FeedBackOptionPanel.class, (String)"fb.msg.setParameters"), 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                OptionsDisplayer.getDefault().open("Extensions/FeedBack", true);
            }
            String from = this.modulePreferences.get("mail.address", "");
            messageBody = this.fbPanel.jtaText.getText().trim();
            messageBody = (String)messageBody + "\n\n=======================================\n\n";
            messageBody = (String)messageBody + this.fbPanel.jtaTechInfo.getText().trim();
            messageBody = (String)messageBody + "\n\n=======================================\n\n";
            File attachedLog = new File(SendAction.getLogPath());
            if (!attachedLog.exists()) {
                attachedLog = null;
            }
            if (!(attachedMsg = new File(SendAction.getMsgPath())).exists()) {
                attachedMsg = null;
            }
            if (!(attachedConf = new File(SendAction.getConfPath())).exists()) {
                attachedConf = null;
            }
            File attachedFile = null;
            if (this.fbPanel.attachmentFile != null) {
                attachedFile = this.fbPanel.attachmentFile;
            }
            Thread t = new Thread((Runnable)new SendMailWorker(name, from, to, subject, (String)messageBody, attachedLog, attachedMsg, attachedConf, attachedFile), "SendFeedback");
            t.start();
        }
    }

    public static String getSystemInfo() {
        Properties p = System.getProperties();
        StringBuilder sb = new StringBuilder();
        sb.append("Ancestris: ");
        sb.append(((Version)Lookup.getDefault().lookup(Version.class)).getBuildString());
        sb.append(" (");
        sb.append(Locale.getDefault());
        sb.append(")\n");
        sb.append("Java: ");
        sb.append(p.get("java.vendor"));
        sb.append(" ");
        sb.append(p.get("java.version"));
        sb.append(" - ");
        sb.append(p.get("java.home"));
        sb.append("\n");
        sb.append("OS : ");
        sb.append(p.get("os.name"));
        sb.append(" ");
        sb.append(p.get("os.version"));
        sb.append(" (");
        sb.append(p.get("os.arch"));
        sb.append(") - ");
        sb.append(p.get("user.name"));
        sb.append("\n");
        sb.append(NbBundle.getMessage(App.class, (String)"AboutPanel.jLabel8.text"));
        sb.append(" ");
        sb.append(SendAction.getUserDirStr());
        return sb.toString();
    }

    private static String getUserDirStr() {
        return new File(System.getProperty("user.home.ancestris")).getParent();
    }

    private static String getUserDir() {
        return new File(System.getProperty("user.home.ancestris")).getParent();
    }

    private static String getLogPath() {
        return SendAction.getUserDir() + "/ancestris/ancestris.log";
    }

    private static String getMsgPath() {
        return SendAction.getUserDir() + "/var/log/messages.log";
    }

    private static String getConfPath() {
        File conf;
        Object confPath = SendAction.getUserDir() + "/etc/ancestris.conf";
        File confFile = new File((String)confPath);
        if (!confFile.exists() && (conf = InstalledFileLocator.getDefault().locate("../etc/ancestris.conf", "org.netbeans.core.startup", false)) != null && conf.exists()) {
            confPath = conf.getAbsolutePath().replace("platform/../", "");
        }
        return confPath;
    }

    private boolean isIvalid(String emailAddr, String emailSMTPHost, String emailSMTPPort) {
        String regexPattern = "^(?=.{1,64}@)[\\p{L}0-9_-]+(\\.[\\p{L}0-9_-]+)*@[^-][\\p{L}0-9-]+(\\.[\\p{L}0-9-]+)*(\\.[\\p{L}]{2,})$";
        if (!Pattern.compile(regexPattern).matcher(emailAddr).matches()) {
            return false;
        }
        regexPattern = "([A-Za-z0-9-]+\\.){1,5}[A-Za-z]+";
        if (!Pattern.compile(regexPattern).matcher(emailSMTPHost).matches()) {
            return false;
        }
        if (emailSMTPHost.contains("gmail") && !emailSMTPHost.equals("smtp.gmail.com")) {
            return false;
        }
        if (emailSMTPHost.contains("free") && !emailSMTPHost.equals("smtp.free.fr")) {
            return false;
        }
        if (emailSMTPHost.contains("laposte") && !emailSMTPHost.equals("smtp.laposte.net")) {
            return false;
        }
        regexPattern = "(25|587|465|2525|[0-9]+)";
        return Pattern.compile(regexPattern).matcher(emailSMTPPort).matches();
    }
}

