/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.util.concurrent.ConcurrentHashMap;
import org.graphstream.stream.file.FileSink;
import org.graphstream.stream.file.FileSinkDGS;
import org.graphstream.stream.file.FileSinkDOT;
import org.graphstream.stream.file.FileSinkDynamicGML;
import org.graphstream.stream.file.FileSinkGEXF;
import org.graphstream.stream.file.FileSinkGML;
import org.graphstream.stream.file.FileSinkGraphML;
import org.graphstream.stream.file.FileSinkImages;
import org.graphstream.stream.file.FileSinkSVG;
import org.graphstream.stream.file.FileSinkTikZ;

public class FileSinkFactory {
    private static final ConcurrentHashMap<String, Class<? extends FileSink>> ext2sink = new ConcurrentHashMap();

    static {
        ext2sink.put("dgs", FileSinkDGS.class);
        ext2sink.put("dgsz", FileSinkDGS.class);
        ext2sink.put("dgml", FileSinkDynamicGML.class);
        ext2sink.put("gml", FileSinkGML.class);
        ext2sink.put("graphml", FileSinkGraphML.class);
        ext2sink.put("dot", FileSinkDOT.class);
        ext2sink.put("svg", FileSinkSVG.class);
        ext2sink.put("pgf", FileSinkTikZ.class);
        ext2sink.put("tikz", FileSinkTikZ.class);
        ext2sink.put("tex", FileSinkTikZ.class);
        ext2sink.put("gexf", FileSinkGEXF.class);
        ext2sink.put("xml", FileSinkGEXF.class);
        ext2sink.put("png", FileSinkImages.class);
        ext2sink.put("jpg", FileSinkImages.class);
    }

    public static FileSink sinkFor(String filename) {
        if (filename.lastIndexOf(46) > 0) {
            String ext = filename.substring(filename.lastIndexOf(46) + 1);
            if (ext2sink.containsKey(ext = ext.toLowerCase())) {
                Class<? extends FileSink> fsink = ext2sink.get(ext);
                try {
                    return fsink.newInstance();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }
}

