/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.HashSet;
import org.graphstream.stream.file.FileSourceBase;

public class FileSourceNCol
extends FileSourceBase {
    protected int edgeid = 0;
    protected HashSet<String> nodes;
    protected String graphName = "NCOL_";

    public FileSourceNCol() {
        this(false);
    }

    public FileSourceNCol(boolean declareNodes) {
        this.nodes = declareNodes ? new HashSet() : null;
    }

    @Override
    protected void continueParsingInInclude() throws IOException {
    }

    @Override
    public boolean nextEvents() throws IOException {
        String id1 = this.getWordOrNumberOrStringOrEolOrEof();
        if (!id1.equals("EOL")) {
            if (id1.equals("EOF")) {
                return false;
            }
            this.declareNode(id1);
            String id2 = this.getWordOrNumberOrStringOrEolOrEof();
            if (!id2.equals("EOL") && !id2.equals("EOF")) {
                if (!id1.equals(id2)) {
                    String weight = this.getWordOrNumberOrStringOrEolOrEof();
                    double w = 0.0;
                    if (weight.equals("EOL") || weight.equals("EOF")) {
                        weight = null;
                        this.pushBack();
                    } else {
                        try {
                            w = Double.parseDouble(weight);
                        }
                        catch (Exception e) {
                            throw new IOException(String.format("cannot transform weight %s into a number", weight));
                        }
                    }
                    String edgeId = Integer.toString(this.edgeid++);
                    this.declareNode(id2);
                    this.sendEdgeAdded(this.graphName, edgeId, id1, id2, false);
                    if (weight != null) {
                        this.sendEdgeAttributeAdded(this.graphName, edgeId, "weight", w);
                    }
                }
            } else {
                throw new IOException("unexpected EOL or EOF");
            }
        }
        return true;
    }

    protected void declareNode(String id) {
        if (this.nodes != null && !this.nodes.contains(id)) {
            this.sendNodeAdded(this.graphName, id);
            this.nodes.add(id);
        }
    }

    @Override
    public void begin(String filename) throws IOException {
        super.begin(filename);
        this.init();
    }

    @Override
    public void begin(URL url) throws IOException {
        super.begin(url);
        this.init();
    }

    @Override
    public void begin(InputStream stream) throws IOException {
        super.begin(stream);
        this.init();
    }

    @Override
    public void begin(Reader reader) throws IOException {
        super.begin(reader);
        this.init();
    }

    protected void init() throws IOException {
        this.st.eolIsSignificant(true);
        this.st.commentChar(35);
        this.graphName = String.format("%s_%d", this.graphName, System.currentTimeMillis() + (long)Math.random() * 10L);
    }

    @Override
    public boolean nextStep() throws IOException {
        return this.nextEvents();
    }

    @Override
    public void end() throws IOException {
        super.end();
    }
}

