/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file.gexf;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.LinkedList;
import javax.xml.stream.XMLStreamException;
import org.graphstream.stream.file.gexf.GEXF;
import org.graphstream.stream.file.gexf.GEXFAttValue;
import org.graphstream.stream.file.gexf.GEXFAttribute;
import org.graphstream.stream.file.gexf.GEXFElement;
import org.graphstream.stream.file.gexf.SmartXMLWriter;

public class GEXFAttValues
implements GEXFElement {
    GEXF root;
    HashMap<Integer, LinkedList<GEXFAttValue>> values;

    public GEXFAttValues(GEXF root) {
        this.root = root;
        this.values = new HashMap();
    }

    public void attributeUpdated(GEXFAttribute decl, Object value) {
        if (!this.values.containsKey(decl.id)) {
            this.values.put(decl.id, new LinkedList());
        }
        LinkedList<GEXFAttValue> attr = this.values.get(decl.id);
        if (value != null) {
            if (attr.size() > 0) {
                if (attr.getLast().start == this.root.step) {
                    attr.removeLast();
                } else {
                    attr.getLast().end = this.root.step;
                }
            }
            GEXFAttValue av = new GEXFAttValue(this.root, Integer.toString(decl.id), this.formatValue(value));
            attr.add(av);
        } else if (attr.size() > 0) {
            attr.getLast().end = this.root.step;
        }
    }

    String formatValue(Object o) {
        if (o == null) {
            return "<null>";
        }
        if (o.getClass().isArray()) {
            StringBuilder buffer = new StringBuilder();
            int i = 0;
            while (i < Array.getLength(o)) {
                Object ochild = Array.get(o, i);
                if (i > 0) {
                    buffer.append("|");
                }
                if (ochild != null) {
                    buffer.append(ochild.toString());
                }
                ++i;
            }
            o = buffer;
        }
        return o.toString();
    }

    @Override
    public void export(SmartXMLWriter stream) throws XMLStreamException {
        if (this.values.size() == 0) {
            return;
        }
        stream.startElement("attvalues");
        for (LinkedList<GEXFAttValue> attrValues : this.values.values()) {
            int i = 0;
            while (i < attrValues.size()) {
                attrValues.get(i).export(stream);
                ++i;
            }
        }
        stream.endElement();
    }
}

