/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.graphicGraph.stylesheet;

import java.util.ArrayList;
import java.util.HashMap;
import org.graphstream.ui.graphicGraph.stylesheet.Color;
import org.graphstream.ui.graphicGraph.stylesheet.Colors;
import org.graphstream.ui.graphicGraph.stylesheet.Rule;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.graphicGraph.stylesheet.Value;
import org.graphstream.ui.graphicGraph.stylesheet.Values;

public class Style
extends StyleConstants {
    protected Rule parent = null;
    protected HashMap<String, Object> values = null;
    protected HashMap<String, Rule> alternates = null;

    public Style() {
        this(null);
    }

    public Style(Rule parent) {
        this.parent = parent;
        this.values = new HashMap();
    }

    public Rule getParent() {
        return this.parent;
    }

    public Object getValue(String property, String ... events) {
        Object value;
        if (events != null && events.length > 0) {
            Object o = null;
            int i = events.length - 1;
            while ((o = this.getValueForEvent(property, events[i])) == null && --i >= 0) {
            }
            if (o != null) {
                return o;
            }
        }
        if ((value = this.values.get(property)) == null && this.parent != null) {
            return this.parent.style.getValue(property, events);
        }
        return value;
    }

    protected Object getValueForEvent(String property, String event) {
        if (this.alternates != null) {
            Object o;
            Rule rule = this.alternates.get(event);
            if (rule != null && (o = rule.getStyle().values.get(property)) != null) {
                return o;
            }
        } else if (this.parent != null) {
            return this.parent.style.getValueForEvent(property, event);
        }
        return null;
    }

    public boolean hasValue(String field, String ... events) {
        boolean hasValue = false;
        if (events != null && events.length > 0 && this.alternates != null) {
            String[] stringArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                String event = stringArray[n2];
                Rule rule = this.alternates.get(event);
                if (rule != null && rule.getStyle().hasValue(field, new String[0])) {
                    hasValue = true;
                    break;
                }
                ++n2;
            }
        }
        if (!hasValue) {
            hasValue = this.values.get(field) != null;
        }
        return hasValue;
    }

    public StyleConstants.FillMode getFillMode() {
        return (StyleConstants.FillMode)((Object)this.getValue("fill-mode", new String[0]));
    }

    public Colors getFillColors() {
        return (Colors)this.getValue("fill-color", new String[0]);
    }

    public int getFillColorCount() {
        Colors colors = (Colors)this.getValue("fill-color", new String[0]);
        if (colors != null) {
            return colors.size();
        }
        return 0;
    }

    public Color getFillColor(int i) {
        Colors colors = (Colors)this.getValue("fill-color", new String[0]);
        if (colors != null) {
            return (Color)colors.get(i);
        }
        return null;
    }

    public String getFillImage() {
        return (String)this.getValue("fill-image", new String[0]);
    }

    public StyleConstants.StrokeMode getStrokeMode() {
        return (StyleConstants.StrokeMode)((Object)this.getValue("stroke-mode", new String[0]));
    }

    public Colors getStrokeColor() {
        return (Colors)this.getValue("stroke-color", new String[0]);
    }

    public int getStrokeColorCount() {
        Colors colors = (Colors)this.getValue("stroke-color", new String[0]);
        if (colors != null) {
            return colors.size();
        }
        return 0;
    }

    public Color getStrokeColor(int i) {
        Colors colors = (Colors)this.getValue("stroke-color", new String[0]);
        if (colors != null) {
            return (Color)colors.get(i);
        }
        return null;
    }

    public Value getStrokeWidth() {
        return (Value)this.getValue("stroke-width", new String[0]);
    }

    public StyleConstants.ShadowMode getShadowMode() {
        return (StyleConstants.ShadowMode)((Object)this.getValue("shadow-mode", new String[0]));
    }

    public Colors getShadowColors() {
        return (Colors)this.getValue("shadow-color", new String[0]);
    }

    public int getShadowColorCount() {
        Colors colors = (Colors)this.getValue("shadow-color", new String[0]);
        if (colors != null) {
            return colors.size();
        }
        return 0;
    }

    public Color getShadowColor(int i) {
        Colors colors = (Colors)this.getValue("shadow-color", new String[0]);
        if (colors != null) {
            return (Color)colors.get(i);
        }
        return null;
    }

    public Value getShadowWidth() {
        return (Value)this.getValue("shadow-width", new String[0]);
    }

    public Values getShadowOffset() {
        return (Values)this.getValue("shadow-offset", new String[0]);
    }

    public Values getPadding() {
        return (Values)this.getValue("padding", new String[0]);
    }

    public StyleConstants.TextMode getTextMode() {
        return (StyleConstants.TextMode)((Object)this.getValue("text-mode", new String[0]));
    }

    public StyleConstants.TextVisibilityMode getTextVisibilityMode() {
        return (StyleConstants.TextVisibilityMode)((Object)this.getValue("text-visibility-mode", new String[0]));
    }

    public Values getTextVisibility() {
        return (Values)this.getValue("text-visibility", new String[0]);
    }

    public Colors getTextColor() {
        return (Colors)this.getValue("text-color", new String[0]);
    }

    public int getTextColorCount() {
        Colors colors = (Colors)this.getValue("text-color", new String[0]);
        if (colors != null) {
            return colors.size();
        }
        return 0;
    }

    public Color getTextColor(int i) {
        Colors colors = (Colors)this.getValue("text-color", new String[0]);
        if (colors != null) {
            return (Color)colors.get(i);
        }
        return null;
    }

    public StyleConstants.TextStyle getTextStyle() {
        return (StyleConstants.TextStyle)((Object)this.getValue("text-style", new String[0]));
    }

    public String getTextFont() {
        return (String)this.getValue("text-font", new String[0]);
    }

    public Value getTextSize() {
        return (Value)this.getValue("text-size", new String[0]);
    }

    public StyleConstants.IconMode getIconMode() {
        return (StyleConstants.IconMode)((Object)this.getValue("icon-mode", new String[0]));
    }

    public String getIcon() {
        return (String)this.getValue("icon", new String[0]);
    }

    public StyleConstants.VisibilityMode getVisibilityMode() {
        return (StyleConstants.VisibilityMode)((Object)this.getValue("visibility-mode", new String[0]));
    }

    public Values getVisibility() {
        return (Values)this.getValue("visibility", new String[0]);
    }

    public StyleConstants.SizeMode getSizeMode() {
        return (StyleConstants.SizeMode)((Object)this.getValue("size-mode", new String[0]));
    }

    public Values getSize() {
        return (Values)this.getValue("size", new String[0]);
    }

    public Values getShapePoints() {
        return (Values)this.getValue("shape-points", new String[0]);
    }

    public StyleConstants.TextAlignment getTextAlignment() {
        return (StyleConstants.TextAlignment)((Object)this.getValue("text-alignment", new String[0]));
    }

    public StyleConstants.TextBackgroundMode getTextBackgroundMode() {
        return (StyleConstants.TextBackgroundMode)((Object)this.getValue("text-background-mode", new String[0]));
    }

    public Colors getTextBackgroundColor() {
        return (Colors)this.getValue("text-background-color", new String[0]);
    }

    public Color getTextBackgroundColor(int i) {
        Colors colors = (Colors)this.getValue("text-background-color", new String[0]);
        if (colors != null) {
            return (Color)colors.get(i);
        }
        return null;
    }

    public Values getTextOffset() {
        return (Values)this.getValue("text-offset", new String[0]);
    }

    public Values getTextPadding() {
        return (Values)this.getValue("text-padding", new String[0]);
    }

    public StyleConstants.Shape getShape() {
        return (StyleConstants.Shape)((Object)this.getValue("shape", new String[0]));
    }

    public StyleConstants.JComponents getJComponent() {
        return (StyleConstants.JComponents)((Object)this.getValue("jcomponent", new String[0]));
    }

    public StyleConstants.SpriteOrientation getSpriteOrientation() {
        return (StyleConstants.SpriteOrientation)((Object)this.getValue("sprite-orientation", new String[0]));
    }

    public StyleConstants.ArrowShape getArrowShape() {
        return (StyleConstants.ArrowShape)((Object)this.getValue("arrow-shape", new String[0]));
    }

    public String getArrowImage() {
        return (String)this.getValue("arrow-image", new String[0]);
    }

    public Values getArrowSize() {
        return (Values)this.getValue("arrow-size", new String[0]);
    }

    public Colors getCanvasColor() {
        return (Colors)this.getValue("canvas-color", new String[0]);
    }

    public int getCanvasColorCount() {
        Colors colors = (Colors)this.getValue("canvas-color", new String[0]);
        if (colors != null) {
            return colors.size();
        }
        return 0;
    }

    public Color getCanvasColor(int i) {
        Colors colors = (Colors)this.getValue("canvas-color", new String[0]);
        if (colors != null) {
            return (Color)colors.get(i);
        }
        return null;
    }

    public Integer getZIndex() {
        return (Integer)this.getValue("z-index", new String[0]);
    }

    public void setDefaults() {
        Colors fillColor = new Colors();
        Colors strokeColor = new Colors();
        Colors shadowColor = new Colors();
        Colors textColor = new Colors();
        Colors canvasColor = new Colors();
        Colors textBgColor = new Colors();
        fillColor.add(Color.BLACK);
        strokeColor.add(Color.BLACK);
        shadowColor.add(Color.GRAY);
        textColor.add(Color.BLACK);
        canvasColor.add(Color.WHITE);
        textBgColor.add(Color.WHITE);
        this.values.put("z-index", new Integer(0));
        this.values.put("fill-mode", (Object)StyleConstants.FillMode.PLAIN);
        this.values.put("fill-color", fillColor);
        this.values.put("fill-image", null);
        this.values.put("stroke-mode", (Object)StyleConstants.StrokeMode.NONE);
        this.values.put("stroke-color", strokeColor);
        this.values.put("stroke-width", new Value(StyleConstants.Units.PX, 1.0));
        this.values.put("shadow-mode", (Object)StyleConstants.ShadowMode.NONE);
        this.values.put("shadow-color", shadowColor);
        this.values.put("shadow-width", new Value(StyleConstants.Units.PX, 3.0));
        this.values.put("shadow-offset", new Values(StyleConstants.Units.PX, 3.0, 3.0));
        this.values.put("padding", new Values(StyleConstants.Units.PX, 0.0, 0.0, 0.0));
        this.values.put("text-mode", (Object)StyleConstants.TextMode.NORMAL);
        this.values.put("text-visibility-mode", (Object)StyleConstants.TextVisibilityMode.NORMAL);
        this.values.put("text-visibility", null);
        this.values.put("text-color", textColor);
        this.values.put("text-style", (Object)StyleConstants.TextStyle.NORMAL);
        this.values.put("text-font", "default");
        this.values.put("text-size", new Value(StyleConstants.Units.PX, 10.0));
        this.values.put("text-alignment", (Object)StyleConstants.TextAlignment.CENTER);
        this.values.put("text-background-mode", (Object)StyleConstants.TextBackgroundMode.NONE);
        this.values.put("text-background-color", textBgColor);
        this.values.put("text-offset", new Values(StyleConstants.Units.PX, 0.0, 0.0));
        this.values.put("text-padding", new Values(StyleConstants.Units.PX, 0.0, 0.0));
        this.values.put("icon-mode", (Object)StyleConstants.IconMode.NONE);
        this.values.put("icon", null);
        this.values.put("visibility-mode", (Object)StyleConstants.VisibilityMode.NORMAL);
        this.values.put("visibility", null);
        this.values.put("size-mode", (Object)StyleConstants.SizeMode.NORMAL);
        this.values.put("size", new Values(StyleConstants.Units.PX, 10.0, 10.0, 10.0));
        this.values.put("shape", (Object)StyleConstants.Shape.CIRCLE);
        this.values.put("shape-points", null);
        this.values.put("jcomponent", null);
        this.values.put("sprite-orientation", (Object)StyleConstants.SpriteOrientation.NONE);
        this.values.put("arrow-shape", (Object)StyleConstants.ArrowShape.ARROW);
        this.values.put("arrow-size", new Values(StyleConstants.Units.PX, 8.0, 4.0));
        this.values.put("arrow-image", null);
        this.values.put("canvas-color", canvasColor);
    }

    public void augment(Style other) {
        if (other != this) {
            this.augmentField("z-index", other);
            this.augmentField("fill-mode", other);
            this.augmentField("fill-color", other);
            this.augmentField("fill-image", other);
            this.augmentField("stroke-mode", other);
            this.augmentField("stroke-color", other);
            this.augmentField("stroke-width", other);
            this.augmentField("shadow-mode", other);
            this.augmentField("shadow-color", other);
            this.augmentField("shadow-width", other);
            this.augmentField("shadow-offset", other);
            this.augmentField("padding", other);
            this.augmentField("text-mode", other);
            this.augmentField("text-visibility-mode", other);
            this.augmentField("text-visibility", other);
            this.augmentField("text-color", other);
            this.augmentField("text-style", other);
            this.augmentField("text-font", other);
            this.augmentField("text-size", other);
            this.augmentField("text-alignment", other);
            this.augmentField("text-background-mode", other);
            this.augmentField("text-background-color", other);
            this.augmentField("text-offset", other);
            this.augmentField("text-padding", other);
            this.augmentField("icon-mode", other);
            this.augmentField("icon", other);
            this.augmentField("visibility-mode", other);
            this.augmentField("visibility", other);
            this.augmentField("size-mode", other);
            this.augmentField("size", other);
            this.augmentField("shape", other);
            this.augmentField("shape-points", other);
            this.augmentField("jcomponent", other);
            this.augmentField("sprite-orientation", other);
            this.augmentField("arrow-shape", other);
            this.augmentField("arrow-size", other);
            this.augmentField("arrow-image", other);
            this.augmentField("canvas-color", other);
        }
    }

    protected void augmentField(String field, Style other) {
        Object value = other.values.get(field);
        if (value != null) {
            if (value instanceof Value) {
                this.setValue(field, new Value((Value)value));
            } else if (value instanceof Values) {
                this.setValue(field, new Values((Values)value));
            } else if (value instanceof Colors) {
                this.setValue(field, new Colors((Colors)value));
            } else {
                this.setValue(field, value);
            }
        }
    }

    public void reparent(Rule parent) {
        this.parent = parent;
    }

    public void addAlternateStyle(String event, Rule alternateStyle) {
        if (this.alternates == null) {
            this.alternates = new HashMap();
        }
        this.alternates.put(event, alternateStyle);
    }

    public void setValue(String field, Object value) {
        this.values.put(field, value);
    }

    public String toString() {
        return this.toString(-1);
    }

    public String toString(int level) {
        String res;
        StringBuilder builder = new StringBuilder();
        String prefix = "";
        String sprefix = "    ";
        if (level > 0) {
            int i = 0;
            while (i < level) {
                prefix = String.valueOf(prefix) + "    ";
                ++i;
            }
        }
        if (this.parent != null) {
            Rule p = this.parent;
            while (p != null) {
                builder.append(String.format(" -> %s", p.selector.toString()));
                p = p.getStyle().getParent();
            }
        }
        builder.append(String.format("%n", new Object[0]));
        for (String key : this.values.keySet()) {
            Object o = this.values.get(key);
            if (o instanceof ArrayList) {
                ArrayList array = (ArrayList)o;
                if (array.size() > 0) {
                    builder.append(String.format("%s%s%s%s: ", prefix, sprefix, sprefix, key));
                    for (Object p : array) {
                        builder.append(String.format("%s ", p.toString()));
                    }
                    builder.append(String.format("%n", new Object[0]));
                    continue;
                }
                builder.append(String.format("%s%s%s%s: <empty>%n", prefix, sprefix, sprefix, key));
                continue;
            }
            builder.append(String.format("%s%s%s%s: %s%n", prefix, sprefix, sprefix, key, o != null ? o.toString() : "<null>"));
        }
        if (this.alternates != null && this.alternates.size() > 0) {
            for (Rule rule : this.alternates.values()) {
                builder.append(rule.toString(level - 1));
            }
        }
        if ((res = builder.toString()).length() == 0) {
            return String.format("%s%s<empty>%n", prefix, prefix);
        }
        return res;
    }
}

