/*
 * Decompiled with CFR 0.152.
 */
package ancestris.util;

import ancestris.core.actions.CommonActions;
import ancestris.core.actions.SubMenuAction;
import genj.util.swing.ImageIcon;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JSeparator;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.ImageUtilities;

public class AUtilities {
    private AUtilities() {
    }

    public static List<Action> actionsForPath(String path) {
        ArrayList<Action> actions = new ArrayList<Action>();
        FileObject fo = FileUtil.getConfigFile((String)path);
        if (fo != null) {
            AUtilities.buildActions(fo, actions);
        }
        return actions;
    }

    private static void buildActions(FileObject fo, List<Action> actions) {
        DataObject[] childs;
        for (DataObject dob : childs = DataFolder.findFolder((FileObject)fo).getChildren()) {
            Object instanceObj;
            if (dob.getPrimaryFile().isFolder()) {
                Object iconResource;
                FileObject childFo = dob.getPrimaryFile();
                ArrayList<Action> subActions = new ArrayList<Action>();
                AUtilities.buildActions(childFo, subActions);
                if (subActions.isEmpty()) continue;
                SubMenuAction a = new SubMenuAction(dob.getNodeDelegate().getDisplayName());
                Object tip = childFo.getAttribute("shortDescription");
                if (tip != null) {
                    a.setTip(tip.toString());
                }
                if ((iconResource = childFo.getAttribute("iconBase")) != null) {
                    a.setImage(new ImageIcon(ImageUtilities.loadImage((String)iconResource.toString())));
                }
                a.addActions(subActions);
                actions.add(a);
                continue;
            }
            InstanceCookie ck = (InstanceCookie)dob.getCookie(InstanceCookie.class);
            try {
                instanceObj = ck.instanceCreate();
            }
            catch (Exception ex) {
                instanceObj = null;
            }
            if (instanceObj == null) continue;
            AUtilities.addActions(actions, instanceObj);
        }
    }

    private static void addActions(List<Action> actions, Object instanceObj) {
        if (instanceObj != null && !CommonActions.NOOP.equals(instanceObj)) {
            if (instanceObj instanceof JSeparator) {
                actions.add(null);
            } else if (instanceObj instanceof Action) {
                actions.add((Action)instanceObj);
            }
        }
    }
}

