/*
 * Decompiled with CFR 0.152.
 */
package ancestris.util;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Repository;
import genj.gedcom.Source;
import genj.gedcom.TagPath;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Image;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.rtf.RTFEditorKit;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class Utilities {
    private static final int MARGIN = 20;
    private static final String BIT = "...";
    private static final String[] textColors = new String[]{"#000000", "#ff0000", "#6400ff", "#0d6909", "#0000ff", "#ff00ff"};

    public static String getClassName(Object o) {
        return Utilities.getClassName(o.getClass());
    }

    public static String getClassName(Class c) {
        return c.getName().replace('.', '/');
    }

    public static Locale getLocaleFromString(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        str = str.replaceAll(":", "_");
        String[] locale = (str + "__").split("_", 3);
        return new Locale(locale[0], locale[1], locale[2]);
    }

    public static String ctxPropertiesDisplayName() {
        Collection properties = org.openide.util.Utilities.actionsGlobalContext().lookupAll(Property.class);
        Object result = "";
        if (properties != null) {
            result = "'" + Property.getPropertyNames(properties, 5) + "' (" + properties.size() + ")";
        }
        return result;
    }

    public static String ctxPropertyDisplayName() {
        Property prop = (Property)org.openide.util.Utilities.actionsGlobalContext().lookup(Property.class);
        Object result = "";
        if (prop != null) {
            result = Property.LABEL + " '" + TagPath.get(prop).getName() + "'";
        }
        return result;
    }

    public static String ctxEntityDisplayName() {
        Entity entity = (Entity)org.openide.util.Utilities.actionsGlobalContext().lookup(Entity.class);
        Object result = "";
        if (entity != null) {
            result = Gedcom.getName(entity.getTag(), false) + " '" + entity.getId() + "'";
        }
        return result;
    }

    public static String ctxGedcomDisplayName() {
        Property prop;
        Gedcom gedcom = (Gedcom)org.openide.util.Utilities.actionsGlobalContext().lookup(Gedcom.class);
        if (gedcom == null && (prop = (Property)org.openide.util.Utilities.actionsGlobalContext().lookup(Property.class)) != null) {
            gedcom = prop.getGedcom();
        }
        Object result = "";
        if (gedcom != null) {
            result = "Gedcom '" + gedcom.getName() + "'";
        }
        return result;
    }

    public static Image getDN() {
        Property prop = (Property)org.openide.util.Utilities.actionsGlobalContext().lookup(Property.class);
        if (prop != null) {
            return prop.getImage(false).getImage();
        }
        return null;
    }

    public static Gedcom getGedcomFromContext(Lookup lookup) {
        Property prop;
        Gedcom gedcom = (Gedcom)lookup.lookup(Gedcom.class);
        if (gedcom == null && (prop = (Property)lookup.lookup(Property.class)) != null) {
            gedcom = prop.getGedcom();
        }
        return gedcom;
    }

    public static String html2text(String html) {
        HTMLEditorKit kit = new HTMLEditorKit();
        Document doc = ((EditorKit)kit).createDefaultDocument();
        doc.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        try {
            StringReader reader = new StringReader(html);
            ((EditorKit)kit).read(reader, doc, 0);
            return doc.getText(0, doc.getLength());
        }
        catch (IOException | BadLocationException e) {
            return "";
        }
    }

    public static String rtf2text(String rtf) {
        RTFEditorKit kit = new RTFEditorKit();
        Document doc = ((EditorKit)kit).createDefaultDocument();
        doc.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        try {
            StringReader reader = new StringReader(rtf);
            ((EditorKit)kit).read(reader, doc, 0);
            return doc.getText(0, doc.getLength());
        }
        catch (IOException | BadLocationException e) {
            return "";
        }
    }

    public static String removeDiacritics(String input) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        String decomposed = Normalizer.normalize(input, Normalizer.Form.NFD);
        return decomposed.replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
    }

    public static String removeDiacriticsLower(String input) {
        return Utilities.removeDiacritics(input).toLowerCase(Locale.getDefault());
    }

    public static String removeDiacriticsUnderscore(String input) {
        return Utilities.removeDiacritics(input).replaceAll("\\W+", "_");
    }

    private static List<Integer> wordsMatchPos(String text, String wordsStr, boolean allWords) {
        text = Utilities.removeDiacritics(text);
        wordsStr = Utilities.removeDiacritics(wordsStr).replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").trim();
        ArrayList<MatchSequence> matchSequences = new ArrayList<MatchSequence>();
        if (text.length() != 0) {
            wordsStr = wordsStr.replaceAll(" +", " ");
            String[] words = wordsStr.split(" ");
            HashSet<String> wordSet = new HashSet<String>();
            wordSet.addAll(Arrays.asList(words));
            int counter = 0;
            try {
                for (String word : wordSet) {
                    Matcher matcher = Pattern.compile(word, 66).matcher(text);
                    if (!matcher.find()) continue;
                    matchSequences.add(new MatchSequence(matcher.start(), matcher.end()));
                    ++counter;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (allWords && words.length != counter) {
                matchSequences.clear();
            }
        }
        Collections.sort(matchSequences);
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (MatchSequence matchSequence : matchSequences) {
            ret.add(matchSequence.from);
            ret.add(matchSequence.to);
        }
        return ret;
    }

    public static boolean wordsMatch(String text, String wordsStr) {
        return !Utilities.wordsMatchPos(text = text.replaceAll("(\\n|\\r)", " ").trim(), wordsStr, true).isEmpty();
    }

    public static String getPhraseBit(String text, String wordsStr, String id) {
        int i;
        List<Integer> pos = Utilities.wordsMatchPos(text = text.replaceAll("(\\n|\\r)", " ").trim(), wordsStr, true);
        if (pos.isEmpty()) {
            return "";
        }
        int index = pos.get(0);
        int start = Math.max(index - 20, 0);
        int end = Math.min(text.length(), index + wordsStr.length() + 20);
        for (i = start; i >= 0; --i) {
            if (text.charAt(i) != ' ') continue;
            start = i + 1;
            break;
        }
        for (i = end; i < text.length(); ++i) {
            if (text.charAt(i) != ' ') continue;
            end = i;
            break;
        }
        return BIT + text.substring(start, end).replaceAll(id, "").trim() + "... (" + id + ")";
    }

    public static String createHtmlDisplayName(String response, String search, int index, String gedcomName) {
        Object ret = "<html>";
        if (index % 6 != 0) {
            ret = (String)ret + "<font color=" + textColors[index % 6] + ">";
        }
        ret = (String)ret + (String)(!gedcomName.isEmpty() ? gedcomName + " | " : "");
        response = response.replaceAll("(\\n|\\r)", " ").trim();
        List<Integer> wordmatches = Utilities.wordsMatchPos(response, search, false);
        int offset = 0;
        int to1 = 0;
        int to2 = 0;
        for (int i = 0; i < wordmatches.size(); ++i) {
            to1 = wordmatches.get(i);
            if (offset > to1) {
                to1 = offset;
            }
            if (to1 > (to2 = wordmatches.get(i + 1).intValue())) {
                to2 = to1;
            }
            String bit1 = response.substring(offset, to1);
            String bit2 = response.substring(to1, to2);
            String str = bit1 + "<b>" + bit2 + "</b>";
            ret = (String)ret + str;
            offset = to2;
            ++i;
        }
        ret = (String)ret + response.substring(offset);
        if (index % 6 != 0) {
            ret = (String)ret + "</font>";
        }
        ret = (String)ret + "</html>";
        return ret;
    }

    public static boolean setCursorWaiting(JPanel panel) {
        return Utilities.setCursor(Cursor.getPredefinedCursor(3), panel);
    }

    public static boolean setCursorNormal(JPanel panel) {
        return Utilities.setCursor(Cursor.getDefaultCursor(), panel);
    }

    private static boolean setCursor(Cursor cursor, JPanel panel) {
        boolean changed = false;
        for (Frame frame : Frame.getFrames()) {
            if (!(frame instanceof JFrame) || ((JFrame)frame).getCursor() == cursor) continue;
            ((JFrame)frame).setCursor(cursor);
            changed = true;
        }
        for (TopComponent tc : Lookup.getDefault().lookupAll(TopComponent.class)) {
            if (tc.getCursor() == cursor) continue;
            tc.setCursor(cursor);
            changed = true;
        }
        if (panel != null && panel.getCursor() != cursor) {
            panel.setCursor(cursor);
            changed = true;
        }
        return changed;
    }

    public static Set<Entity> getDependingEntitiesRecursively(Entity entity, Set<Indi> indis) {
        HashSet<Entity> entities = new HashSet<Entity>();
        HashSet<Entity> seen = new HashSet<Entity>();
        return Utilities.getDependingEntitiesRecursively(entity, indis, entities, seen);
    }

    private static Set<Entity> getDependingEntitiesRecursively(Entity entity, Set<Indi> indis, Set<Entity> entities, Set<Entity> seen) {
        if (seen.contains(entity)) {
            return entities;
        }
        seen.add(entity);
        entities.add(entity);
        for (PropertyXRef xref : entity.getProperties(PropertyXRef.class)) {
            Entity target;
            if (!xref.isValid() || !xref.getTargetEntity().isPresent() || entities.contains(target = xref.getTargetEntity().get()) || target instanceof Indi || entity instanceof Repository && target instanceof Source || !(entity instanceof Indi) && target instanceof Fam) continue;
            if (indis != null && !indis.isEmpty() && entity instanceof Indi && target instanceof Fam) {
                Fam fam = (Fam)target;
                Indi husb = fam.getHusband();
                Indi wife = fam.getWife();
                if (entity == husb && wife != null && !indis.contains(wife) || entity == wife && husb != null && !indis.contains(husb)) continue;
                if (entity != husb && entity != wife) {
                    boolean include = false;
                    if (husb != null && indis.contains(husb) || wife != null && indis.contains(wife)) {
                        include = true;
                    }
                    if (!include) continue;
                }
            }
            entities.add(target);
            entities.addAll(Utilities.getDependingEntitiesRecursively(target, indis, entities, seen));
        }
        return entities;
    }

    public static File getResourceAsFile(Class clazz, String resourcePath, String ext) {
        try {
            int bytesRead;
            InputStream in = clazz.getResourceAsStream(resourcePath);
            if (in == null) {
                return null;
            }
            File tempFile = File.createTempFile(String.valueOf(in.hashCode()), ext);
            tempFile.deleteOnExit();
            FileOutputStream out = new FileOutputStream(tempFile);
            byte[] buffer = new byte[1024];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            return tempFile;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void playSound(Class clazz, String sound) {
        WindowManager.getDefault().invokeWhenUIReady(() -> {
            try {
                InputStream is = clazz.getResourceAsStream(sound);
                AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(is);
                Clip clip = AudioSystem.getClip();
                clip.open(audioInputStream);
                clip.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    private static class MatchSequence
    implements Comparable<MatchSequence> {
        private int from = 0;
        private int to = 0;

        public MatchSequence(int from, int to) {
            this.from = from;
            this.to = to;
        }

        @Override
        public int compareTo(MatchSequence o) {
            return Integer.compare(this.from, o.from);
        }
    }
}

