/*
 * Decompiled with CFR 0.152.
 */
package genj.chart;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.TableXYDataset;

public class IndexedSeries {
    private String name;
    private float[] values;
    private int start;

    public IndexedSeries(String name, IndexedSeries template) {
        this(name, template.start, template.values.length);
    }

    public IndexedSeries(String name, int size) {
        this(name, 0, size);
    }

    public IndexedSeries(String name, int start, int size) {
        this.name = name;
        this.start = start;
        this.values = new float[size];
    }

    public void setName(String set) {
        this.name = set;
    }

    public String getName() {
        return this.name;
    }

    public float get(int i) {
        return this.values[i -= this.start];
    }

    public void set(int i, float val) {
        if ((i -= this.start) < 0 || i >= this.values.length) {
            return;
        }
        this.values[i] = val;
    }

    public void inc(int i) {
        if ((i -= this.start) < 0 || i >= this.values.length) {
            return;
        }
        int n = i;
        this.values[n] = this.values[n] + 1.0f;
    }

    public void dec(int i) {
        if ((i -= this.start) < 0 || i >= this.values.length) {
            return;
        }
        int n = i;
        this.values[n] = this.values[n] - 1.0f;
    }

    public static IndexedSeries[] toArray(Collection<IndexedSeries> c) {
        return (IndexedSeries[])c.toArray(IndexedSeries[]::new);
    }

    static PieDataset asPieDataset(IndexedSeries series, String[] categories) {
        return new PieDatasetImpl(series, categories);
    }

    static CategoryDataset asCategoryDataset(IndexedSeries[] series, String[] categories) {
        return new CategoryDatasetImpl(series, categories);
    }

    static TableXYDataset asTableXYDataset(IndexedSeries[] series) {
        return new TableXYDatasetImpl(series);
    }

    private static class PieDatasetImpl
    extends AbstractDataset
    implements PieDataset {
        private final IndexedSeries series;
        private final String[] categories;

        private PieDatasetImpl(IndexedSeries series, String[] categories) {
            this.series = series;
            this.categories = categories;
        }

        public Comparable getKey(int i) {
            return this.categories[i];
        }

        public int getIndex(Comparable key) {
            for (int i = 0; i < this.categories.length; ++i) {
                if (!this.categories[i].equals(key)) continue;
                return i;
            }
            throw new IllegalArgumentException();
        }

        public List getKeys() {
            return Arrays.asList(this.categories);
        }

        public Number getValue(Comparable cat) {
            return this.getValue(this.getIndex(cat));
        }

        public int getItemCount() {
            return this.categories.length;
        }

        public Number getValue(int i) {
            return Float.valueOf(this.series.get(i));
        }
    }

    private static class CategoryDatasetImpl
    extends AbstractDataset
    implements CategoryDataset {
        private final IndexedSeries[] series;
        private final String[] categories;

        private CategoryDatasetImpl(IndexedSeries[] series, String[] categories) {
            this.series = series;
            this.categories = categories;
            for (IndexedSeries serie : series) {
                if (serie.values.length == categories.length) continue;
                throw new IllegalArgumentException("series doesn't match categories");
            }
        }

        public Comparable getRowKey(int row) {
            return this.series[row].name;
        }

        public int getRowIndex(Comparable row) {
            for (int i = 0; i < this.series.length; ++i) {
                if (!this.series[i].name.equals(row)) continue;
                return i;
            }
            throw new IllegalArgumentException();
        }

        public List<String> getRowKeys() {
            ArrayList<String> result = new ArrayList<String>();
            for (IndexedSeries serie : this.series) {
                result.add(serie.name);
            }
            return result;
        }

        public Comparable getColumnKey(int col) {
            return this.categories[col];
        }

        public int getColumnIndex(Comparable col) {
            for (int i = 0; i < this.categories.length; ++i) {
                if (!this.categories[i].equals(col)) continue;
                return i;
            }
            throw new IllegalArgumentException();
        }

        public List<String> getColumnKeys() {
            return Arrays.asList(this.categories);
        }

        public Number getValue(Comparable row, Comparable col) {
            return this.getValue(this.getRowIndex(row), this.getColumnIndex(col));
        }

        public Number getValue(int row, int col) {
            return Float.valueOf(this.series[row].get(col));
        }

        public int getRowCount() {
            return this.series.length;
        }

        public int getColumnCount() {
            return this.categories.length;
        }
    }

    private static class TableXYDatasetImpl
    extends AbstractXYDataset
    implements TableXYDataset {
        private final IndexedSeries[] series;
        private int start;
        private int length;

        public TableXYDatasetImpl(IndexedSeries[] series) {
            this.series = series;
            if (series.length > 0) {
                this.start = series[0].start;
                this.length = series[0].values.length;
                for (int i = 1; i < series.length; ++i) {
                    if (series[i].start == this.start && series[i].values.length == this.length) continue;
                    throw new IllegalArgumentException("series can't be combined into table dataset");
                }
            }
        }

        public int getItemCount() {
            return this.length;
        }

        public int getSeriesCount() {
            return this.series.length;
        }

        public String getSeriesName(int s) {
            return this.series[s].name;
        }

        public int getItemCount(int s) {
            return this.length;
        }

        public Number getX(int s, int i) {
            return this.start + i;
        }

        public Number getY(int s, int i) {
            return Float.valueOf(this.series[s].get(this.start + i));
        }

        public Comparable getSeriesKey(int series) {
            return this.series[series].name;
        }
    }
}

