/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom.time;

import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;

public class GregorianCalendar
extends Calendar {
    protected static final String[] MONTHS = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
    protected static final String[] WEEKDAYS = new String[]{"SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT"};
    private static final int[] MONTH_LENGTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] LEAP_MONTH_LENGTH = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    protected GregorianCalendar() {
        this("@#DGREGORIAN@", "GREGORIAN", "gregorian", "images/Gregorian");
    }

    protected GregorianCalendar(String esc, String esca7, String key, String img) {
        super(esc, esca7, key, img, MONTHS, WEEKDAYS);
    }

    @Override
    public int getDays(int month, int year) {
        int[] length = this.isLeap(year) ? LEAP_MONTH_LENGTH : MONTH_LENGTH;
        return length[month];
    }

    protected boolean isLeap(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    @Override
    protected int toJulianDay(int day, int month, int year) {
        if (year < 0) {
            ++year;
        }
        int d = day + 1;
        int m = month + 1;
        int y = year;
        return 1461 * (y + 4800 + (m - 14) / 12) / 4 + 367 * (m - 2 - 12 * ((m - 14) / 12)) / 12 - 3 * ((y + 4900 + (m - 14) / 12) / 100) / 4 + d - 32075;
    }

    @Override
    protected PointInTime toPointInTime(int julianDay) {
        int l = julianDay + 68569;
        int n = 4 * l / 146097;
        int i = 4000 * ((l -= (146097 * n + 3) / 4) + 1) / 1461001;
        l = l - 1461 * i / 4 + 31;
        int j = 80 * l / 2447;
        int d = l - 2447 * j / 80;
        l = j / 11;
        int m = j + 2 - 12 * l;
        int y = 100 * (n - 49) + i + l;
        return new PointInTime(d - 1, m - 1, y <= 0 ? y - 1 : y, this);
    }
}

