/*
 * Decompiled with CFR 0.152.
 */
package genj.io;

import ancestris.util.swing.DialogManager;
import genj.io.GedcomIOException;
import genj.io.Options;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class BackupFile {
    private static Logger LOG = Logger.getLogger("ancestris.backupFile");
    private static final SimpleDateFormat ISO_FORMAT = new SimpleDateFormat("yyyyMMdd-HHmmss");

    public static boolean createBackup(File file) throws GedcomIOException {
        if (Options.getNbBackups() != 0 && file.exists()) {
            Pattern p = Pattern.compile(BackupFile.getBasename(file.getName()) + "_([0-9]{8}-[0-9]{6})" + BackupFile.getExtension(file.getName()));
            File bak = BackupFile.getBackupFile(file);
            LOG.fine("Starting backup steps...");
            BackupFile.log(bak);
            File backupDirectory = bak.getParentFile();
            if (backupDirectory == null) {
                BackupFile.severe(bak, NbBundle.getMessage(BackupFile.class, (String)"backup.invalidParentDirectory", (Object)file.getName()));
            }
            if (!backupDirectory.isDirectory()) {
                BackupFile.severe(bak, NbBundle.getMessage(BackupFile.class, (String)"backup.invalidDirectory", (Object)file.getName(), (Object)backupDirectory.getAbsolutePath()));
            }
            FilenameFilter filter = (dir, name) -> dir.equals(backupDirectory) && p.matcher(name).matches();
            LOG.fine("Checking previous backup files in backup directory...");
            Object[] backups = backupDirectory.listFiles(filter);
            if (backups == null) {
                BackupFile.severe(bak, NbBundle.getMessage(BackupFile.class, (String)"backup.noAccessToDirectory", (Object)file.getName(), (Object)backupDirectory.getAbsolutePath()));
            }
            Arrays.sort(backups);
            LOG.fine("Deleting old backups over the limit...");
            if (backups.length >= Options.getNbBackups()) {
                for (int i = 0; i <= backups.length - Options.getNbBackups(); ++i) {
                    if (((File)backups[i]).delete()) continue;
                    BackupFile.severe(bak, NbBundle.getMessage(BackupFile.class, (String)"backup.cannotDelete", (Object)((File)backups[0]).getName()));
                }
            }
            LOG.fine("Making sure backup file does not already exist...");
            if (bak.exists()) {
                BackupFile.severe(bak, NbBundle.getMessage(BackupFile.class, (String)"backup.duplicateName", (Object)bak.getName()));
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            LOG.fine("Finally saving file into backup file...");
            if (file.length() > 0L) {
                try {
                    Files.move(Paths.get(file.getAbsolutePath(), new String[0]), Paths.get(bak.getAbsolutePath(), new String[0]), new CopyOption[0]);
                    LOG.fine("Moved " + file.getAbsolutePath() + " to " + bak.getAbsolutePath());
                }
                catch (IOException ex) {
                    BackupFile.severe(bak, NbBundle.getMessage(BackupFile.class, (String)"backup.cannotMove", (Object)file.getName()));
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return true;
    }

    private static File getBackupFile(File file) {
        Object fileName = Options.getBackupDirectory();
        boolean isBackupDirectoryOption = false;
        if (fileName != null && !"".equals(fileName)) {
            isBackupDirectoryOption = true;
            fileName = (String)fileName + File.separator + file.getName();
        } else {
            fileName = file.getAbsolutePath();
        }
        File backupFile = new File(BackupFile.getBasename((String)fileName) + "_" + ISO_FORMAT.format(new Date()) + BackupFile.getExtension((String)fileName));
        if (isBackupDirectoryOption && (backupFile.getParentFile() == null || !backupFile.getParentFile().isDirectory())) {
            String badFolder = backupFile.getParent();
            fileName = file.getAbsolutePath();
            backupFile = new File(BackupFile.getBasename((String)fileName) + "_" + ISO_FORMAT.format(new Date()) + BackupFile.getExtension((String)fileName));
            String msg = NbBundle.getMessage(BackupFile.class, (String)"backup.invalidBackupFolder", (Object)badFolder, (Object)backupFile.getParent());
            String alert = NbBundle.getMessage(BackupFile.class, (String)"backup.noLongerShowAlert");
            if (Options.getBackupShowAlert()) {
                JLabel msgLabel = new JLabel(msg);
                JCheckBox showAlertcb = new JCheckBox(alert, false);
                JComponent[] components = new JComponent[]{msgLabel, new JLabel("<html> <br> <br></html>"), showAlertcb};
                DialogManager.create(NbBundle.getMessage(BackupFile.class, (String)"backup.title", (Object)file.getName()), components).setMessageType(2).setOptionType(10).show();
                Options.setBackupShowAlert(!showAlertcb.isSelected());
            }
            LOG.severe(msg);
            BackupFile.log(backupFile);
        }
        return backupFile;
    }

    private static String getExtension(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        return fileName.substring(index);
    }

    private static String getBasename(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return fileName;
        }
        return fileName.substring(0, index);
    }

    private static void severe(File bak, String msg) throws GedcomIOException {
        LOG.severe(msg);
        BackupFile.log(bak);
        throw new GedcomIOException(msg, -1);
    }

    private static void log(File bak) {
        LOG.fine("Backup directory=" + Options.getBackupDirectory());
        LOG.fine("Backup file to be written=" + bak.getAbsolutePath());
    }
}

