/*
 * Decompiled with CFR 0.152.
 */
package genj.io.input;

import genj.gedcom.GedcomOptions;
import genj.io.InputSource;
import genj.io.input.URLChecker;
import genj.renderer.MediaUtils;
import genj.util.EnvironmentChecker;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class URLInput
extends InputSource {
    private static final Logger LOG = Logger.getLogger("ancestris.URLInput");
    public static final String WEB = "web";
    private URL url;
    private String extension;
    private boolean isFound = true;

    public URLInput(URL theUrl) {
        this(theUrl.getFile(), theUrl);
    }

    public URLInput(String name, URL theUrl) {
        super(name);
        this.url = theUrl;
        this.setLocation(theUrl.toString());
    }

    public URL getURL() {
        return this.url;
    }

    public int hashCode() {
        return this.url.hashCode() * this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        URLInput other = (URLInput)obj;
        if (!Objects.equals(this.extension, other.extension)) {
            return false;
        }
        return Objects.equals(this.url, other.url);
    }

    public String toString() {
        return "file name=" + this.getName() + " url=" + this.url.toString();
    }

    @Override
    public InputStream open() throws IOException {
        URLChecker.CheckResult result = this.checkAvailability();
        if (!this.isFound || result == null || result.getInputStream() == null) {
            if (!this.isFound) {
                LOG.log(Level.WARNING, "Unable to open remote address {0}", this.url.toString());
            }
            return URLInput.unfoundInputStream();
        }
        return result.getInputStream();
    }

    private static InputStream unfoundInputStream() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)MediaUtils.IMG_WEB_LINK, "png", baos);
        return new ByteArrayInputStream(baos.toByteArray());
    }

    @Override
    public String getExtension() {
        if (this.extension == null) {
            this.extension = this.setExtension();
        }
        return this.extension;
    }

    private String setExtension() {
        URLChecker.CheckResult result = this.checkAvailability();
        if (result == null) {
            return WEB;
        }
        String type = result.getType();
        if (type == null) {
            return WEB;
        }
        LOG.log(Level.FINER, "Media {0} type from internet (checked) : {1}", new Object[]{this.getName(), type});
        if (type.startsWith("image/")) {
            String lExtension = type.substring(6);
            if ("jpeg".equals(lExtension)) {
                return "jpg";
            }
            return lExtension;
        }
        if (type.equals("application/pdf")) {
            return "pdf";
        }
        return WEB;
    }

    @Override
    public boolean isAvailable() {
        return this.isFound;
    }

    public boolean isAvailable(boolean force) {
        if (force) {
            this.checkAvailability();
        }
        return this.isFound;
    }

    private URLChecker.CheckResult checkAvailability() {
        if (!GedcomOptions.getInstance().isCheckRemote()) {
            this.isFound = true;
            return null;
        }
        if (!EnvironmentChecker.isConnected(true)) {
            this.isFound = false;
            return null;
        }
        URLChecker checker = URLChecker.createURLChecker(this.url, "", 0);
        URLChecker.CheckResult check = checker.run();
        this.isFound = check.getResult();
        if (this.isFound && check.getURL() != null) {
            this.url = check.getURL();
        }
        return check;
    }
}

